/************************************************************************
 *
 * Copyright (C) 2023-2024 IRCAD France
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

// This file was automatically generated by the '/lib/core/data/dicom/class_generator.py' script. DO NOT EDIT !
// Used arguments: 'Namespace(verbose=False, source_url='http://dicom.nema.org/medical/dicom/current/source/docbook',
// sop_list=None, mandatory_tags=[Tag(group='7FE0', element='0010'), Tag(group='0062', element='0002'),
// Tag(group='0066', element='0002'), Tag(group='0066', element='0011'), Tag(group='0070', element='031C')])'

#pragma once

#include <sight/data/config.hpp>

#include <cstdint>
#include <string_view>

// cspell: ignore Wundefined afterloader angio autorefraction autosequence boli bscan cadsr ciexy ctdi ctdivol decf
// cspell: ignore deidentification dermoscopic diconde dicos dvhroi exif fiducials fluence fnumber frameof gpsdop hicpp
// cspell: ignore hpgl imager inms inua inus iods isop ivol ivus keratoconus keratometer keratometric kerma lensometry
// cspell: ignore lookat meterset metersets mrfov multiway nmpet nmtomo nolintbegin nolintend octb octz oecf olink
// cspell: ignore postamble powerline prcs presaturation radiofluoroscopic relaxivity reprojection rgblut rtdvh rtroi
// cspell: ignore sddn sdhn sdvn softcopy soundpath stereometric stowrs tlhc tomo tomosynthesis tomotherapeutic toric
// cspell: ignore tractography xaxrf

// NOLINTBEGIN

namespace sight::data::dicom::sop
{

enum class Keyword : std::uint8_t
{
    INVALID = 0,
    ComputedRadiographyImageStorage,
    DigitalXRayImageStorageForPresentation,
    DigitalXRayImageStorageForProcessing,
    DigitalMammographyXRayImageStorageForPresentation,
    DigitalMammographyXRayImageStorageForProcessing,
    DigitalIntraOralXRayImageStorageForPresentation,
    DigitalIntraOralXRayImageStorageForProcessing,
    EncapsulatedPDFStorage,
    EncapsulatedCDAStorage,
    EncapsulatedSTLStorage,
    EncapsulatedOBJStorage,
    EncapsulatedMTLStorage,
    XRayAngiographicImageStorage,
    EnhancedXAImageStorage,
    XRayRadiofluoroscopicImageStorage,
    EnhancedXRFImageStorage,
    PositronEmissionTomographyImageStorage,
    LegacyConvertedEnhancedPETImageStorage,
    XRay3DAngiographicImageStorage,
    XRay3DCraniofacialImageStorage,
    BreastTomosynthesisImageStorage,
    BreastProjectionXRayImageStorageForPresentation,
    BreastProjectionXRayImageStorageForProcessing,
    EnhancedPETImageStorage,
    BasicStructuredDisplayStorage,
    IntravascularOpticalCoherenceTomographyImageStorageForPresentation,
    IntravascularOpticalCoherenceTomographyImageStorageForProcessing,
    CTImageStorage,
    EnhancedCTImageStorage,
    LegacyConvertedEnhancedCTImageStorage,
    NuclearMedicineImageStorage,
    UltrasoundMultiFrameImageStorage,
    ParametricMapStorage,
    MRImageStorage,
    EnhancedMRImageStorage,
    EnhancedMRColorImageStorage,
    LegacyConvertedEnhancedMRImageStorage,
    RTImageStorage,
    RTDoseStorage,
    EnhancedRTImageStorage,
    EnhancedContinuousRTImageStorage,
    UltrasoundImageStorage,
    EnhancedUSVolumeStorage,
    PhotoacousticImageStorage,
    SpatialFiducialsStorage,
    SegmentationStorage,
    SurfaceSegmentationStorage,
    SurfaceScanMeshStorage,
    SurfaceScanPointCloudStorage,
    SecondaryCaptureImageStorage,
    MultiFrameSingleBitSecondaryCaptureImageStorage,
    MultiFrameGrayscaleByteSecondaryCaptureImageStorage,
    MultiFrameGrayscaleWordSecondaryCaptureImageStorage,
    MultiFrameTrueColorSecondaryCaptureImageStorage,
    VLEndoscopicImageStorage,
    VideoEndoscopicImageStorage,
    VLMicroscopicImageStorage,
    VideoMicroscopicImageStorage,
    VLSlideCoordinatesMicroscopicImageStorage,
    VLPhotographicImageStorage,
    VideoPhotographicImageStorage,
    OphthalmicPhotography8BitImageStorage,
    OphthalmicPhotography16BitImageStorage,
    OphthalmicTomographyImageStorage,
    WideFieldOphthalmicPhotographyStereographicProjectionImageStorage,
    WideFieldOphthalmicPhotography3DCoordinatesImageStorage,
    OphthalmicOpticalCoherenceTomographyEnFaceImageStorage,
    OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage,
    VLWholeSlideMicroscopyImageStorage,
    DermoscopicPhotographyImageStorage,
    SpectaclePrescriptionReportStorage,
    MacularGridThicknessAndVolumeReportStorage,
    OphthalmicThicknessMapStorage,
    CornealTopographyMapStorage,
    BasicTextSRStorage,
    EnhancedSRStorage,
    ComprehensiveSRStorage,
    Comprehensive3DSRStorage,
    ExtensibleSRStorage,
    ProcedureLogStorage,
    MammographyCADSRStorage,
    KeyObjectSelectionDocumentStorage,
    ChestCADSRStorage,
    XRayRadiationDoseSRStorage,
    RadiopharmaceuticalRadiationDoseSRStorage,
    ColonCADSRStorage,
    ImplantationPlanSRStorage,
    AcquisitionContextSRStorage,
    SimplifiedAdultEchoSRStorage,
    PatientRadiationDoseSRStorage,
    PlannedImagingAgentAdministrationSRStorage,
    PerformedImagingAgentAdministrationSRStorage,
    EnhancedXRayRadiationDoseSRStorage,
    GenericImplantTemplateStorage,
    _SIZE
};

struct SIGHT_DATA_CLASS_API ISop
{
    constexpr ISop(
        const Keyword& keyword,
        const std::string_view& name,
        const std::string_view& iud,
        const std::string_view& iod
    ) noexcept :
        m_keyword(keyword),
        m_name(name),
        m_uid(iud),
        m_iod(iod)
    {
    }

    //------------------------------------------------------------------------------

    constexpr operator Keyword() const noexcept
    {
        return m_keyword;
    }

    //------------------------------------------------------------------------------

    constexpr auto operator==(const ISop& other) const noexcept
    {
        return m_keyword == other.m_keyword;
    }

    const Keyword& m_keyword;
    const std::string_view& m_name;
    const std::string_view& m_uid;
    const std::string_view& m_iod;
};

template<Keyword>
struct SIGHT_DATA_CLASS_API Sop final : public ISop
{
    constexpr Sop() noexcept :
        ISop(s_keyword, s_name, s_uid, s_iod)
    {
    }

    SIGHT_DATA_API static const Keyword s_keyword;
    SIGHT_DATA_API static const std::string_view s_name;
    SIGHT_DATA_API static const std::string_view s_uid;
    SIGHT_DATA_API static const std::string_view s_iod;
};

/// @return a static const reference to an Sop
/// @{
SIGHT_DATA_API const ISop& get(Keyword keyword);
SIGHT_DATA_API const ISop& get(const std::string_view& uid);
/// @}

/// convert a uid directly to a keyword
SIGHT_DATA_API const Keyword& keyword(const std::string_view& uid) noexcept;

} // namespace sight::data::dicom::sop

// NOLINTEND
