#define XERR
#include "tumor.ih"

void Tumor::reset()
{
    d_found = false;
    d_interval = false;

    d_present = false;                  // see 'characteristics()'
    d_volume = 0;
    d_diameter = 0;
    d_deathAge = 0;

    if (not tumorAge())
    {
        d_pSurvival = 1;
        d_startVolume = 0;              // see modifications (7)
        d_doublingDays = NO_TUMOR;
        d_doublingYears = NO_TUMOR;
//        d_selfDetect = 0;
        d_prePeriod = NO_TUMOR;
        d_detectableAge = NO_TUMOR;
        return;
    }

    uint16_t idx = ageGroup();

    Random &random = Random::instance();

    d_pSurvival = random.uniformCase();

    d_startVolume = volume(d_growth.start());

    AgeGroupVSD const &group = d_growth.ageGroupVSD(idx);

//xerr("idx: " << idx << ", value: " << group.value() << ", stdev = " <<
//group.stdDev());

    d_doublingDays = random.logNormal(group.value(), group.stdDev());

//xerr("doublingdays: " << d_doublingDays);


    d_doublingYears = d_doublingDays / N_YEARDAYS;

    double selfDetectDiam = random.logNormal(d_growth.selfMu().value(), 
                                             d_growth.selfSigma());

    d_prePeriod =   d_doublingDays *
                    log(
                        volume(selfDetectDiam) / 
                        volume(d_growth.start())
                    ) * s_log2YearInv;

    d_detectableAge = d_selfDetectAge - d_prePeriod;
}






