#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    src
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module SiSU_Doc
  require_relative 'src_shared'                         # scr_shared.rb
    include SiSU_Source
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  class Source < SiSU_Source::SiSUpodSource
    require_relative 'utils_response'                   # utils_response.rb
    def initialize(opt,build=nil,place=nil)
      super(opt,build,place)
      @zipfile=@opt.fno.gsub(/(?:\~\S{2,3})?(\.ss[tm])$/,'\1')
      unless @opt.act[:quiet][:set]==:on
        pthinfo="#{@file.output_path.sisupod.dir}/#{@zipfile}.txz"
        (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'Assemble source for sisu document',
            "#{@opt.fns} -> file://#{pthinfo}"
          ).cyan_hi_blue
        : SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'Assemble source for sisu document',
            pthinfo
          ).cyan_title_hi
      end
    end
    def sisupod_tar_xz
      begin
        FileUtils::mkdir_p(@file.output_path.sisupod.dir) \
          unless FileTest.directory?(@file.output_path.sisupod.dir)
        tree=((@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        && SiSU_Env::SystemCall.new.program_found?('tree')) \
        ? 'tree sisupod'
        : ''
        if FileTest.directory?(@path_pod[:fnb])
          Dir.chdir(@path_pod[:fnb])
          system(%{
            #{tree}
            tar -cJf #{@zipfile}.txz sisupod
            #echo "#{@file.place_file.sisupod.dir}"
          })
          FileUtils::mv("#{@zipfile}.txz",@file.place_file.sisupod.dir)
          Dir.chdir(@env.path.pwd)
          if (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            SiSU_Screen::Ansi.new('',"#{@opt.fns}.txz").blue_tab
          end
        else
          if (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            SiSU_Screen::Ansi.new('',"#{@opt.fns}.txz not built").blue_tab
          end
        end
      rescue
      ensure
      end
    end
  end
end
__END__
question?:                   should you permit the packing of multiple documents in single .xz ?

  open @opt.fns, parse file
    extract from file content:
      images and copy each image from whatever image source to _sisu/sisupod/sisu/_sisu/image

   remove previously existing contents of _/sisu/sisupod &
   make directory structure:

v3 -->
   _sisu
     sisupod
       doc
         manifest.txt
         en/content.sst                [file content]
         fr/content.sst
         _sisu
           conf
           image (ln -s ../../image)
           audio (ln -s ../../audio)
           video (ln -s ../../video)
       image                           [all images for specific document gathered here]
       audio
       video

v2 -->
   _sisu
     sisupod
       content.sst                     [file content]
       filename.sst                    [link to content.sst]
       _sisu/
         image/                        [all images for specific document gathered here]

sisu
  _sisu
    sisurc.yml
    convert/
    standard_terms/
    image
    processing
      ao/
      tex/
      texinfo/
      tune/
    sisupod

special case

composite file (master), e.g.
SiSU.ssm
