#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    misc
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Urls
  require_relative 'se_hub_particulars'                 # se_hub_particulars.rb
    include SiSU_Particulars
  require_relative 'se'                                 # se.rb
    include SiSU_Env; include SiSU_Screen
  class Source
    attr_reader :opt
    def initialize(opt)
      @opt=opt
    end
    def read
      begin
        SiSU_Urls::OutputUrls.new(@opt).songsheet if @opt.fnb
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
  end
  class OutputUrls
    attr_reader :fns,:fnb,:act,:dir,:m_regular,:u
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_env_md(opt)
      if @particulars.is_a?(NilClass)
        if @opt.act[:verbose_plus][:set]==:on \
        or @opt.act[:maintenance][:set]==:on
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
            mark("@particulars is NilClass, acceptable e.g. for --harvest")
        end
        exit
      end
      @selections=@opt.selections.str
      @act=@opt.act
      @md=@particulars.md
      @env=@particulars.env
      @fnb=@env.fnb
      fn_set_lang=SiSU_Env::StandardiseLanguage.new(@opt.lng).language
      @fnl=@env.i18n.lang_filename(fn_set_lang[:c])
      @fn=SiSU_Env::EnvCall.new(@opt.fns).lang(fn_set_lang[:c])
      @m_regular=/(.+?)\.(?:(?:-|ssm\.)?sst|ssm)$/
      @prog=@env.program
    end
    def songsheet
      begin
        (@opt.act[:urls_all][:set]==:on) \
        ? urls_all \
        : (urls_select unless @opt.act[:quiet][:set]==:on)
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def show
      def report(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}]",
          x[:cmd],
          x[:viewer] + ' ' \
          + x[:f_pth]
        ).result
      end
      def maintenance(x)
        if @opt.act[:maintenance][:set]==:on
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}]",
            x[:cmd],
            x[:p_pth]
          ).maintenance
        end
      end
      self
    end
    def report_info
      def dal
        {
          cmd: '--ao',
          p_pth: @env.processing_path.ao + '/' \
          + @opt.fns + '.meta',
          fn: 'ao',
         }
      end
      def hash_digests
        {
          cmd: '--hash-digests (sha512/sha256/md5)',
          viewer: @prog.web_browser,
          f_pth: @md.file.output_path.hash_digest.dir + '/' \
          + @md.file.base_filename.hash_digest,
          fn: @fn[:digest],
         }
      end
      def text
        def txt
          {
            cmd: '--txt',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.txt.dir + '/' \
            + @md.file.base_filename.txt,
            fn: @fn[:plain],
           }
        end
        def asciidoc
          {
            cmd: '--asciidoc',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.asciidoc.dir + '/' \
            + @md.file.base_filename.asciidoc,
            fn: @fn[:txt_asciidoc],
           }
        end
        def markdown
          {
            cmd: '--markdown',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.markdown.dir + '/' \
            + @md.file.base_filename.markdown,
            fn: @fn[:txt_markdown],
           }
        end
        def rst
          {
            cmd: '--rst',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.rst.dir + '/' \
            + @md.file.base_filename.rst,
            fn: @fn[:txt_rst],
           }
        end
        def textile
          {
            cmd: '--textile',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.textile.dir + '/' \
            + @md.file.base_filename.textile,
            fn: @fn[:txt_textile],
           }
        end
        def orgmode
          {
            cmd: '--orgmode',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.orgmode.dir + '/' \
            + @md.file.base_filename.orgmode,
            fn: @fn[:txt_orgmode],
           }
        end
        self
      end
      def html
        def seg
          {
            cmd: '--html-seg',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.html_seg.dir + '/' \
            + @md.file.base_filename.html_segtoc,
            p_pth: @env.processing_path.tune + '/' \
            + @md.fns + '.tune',
            fn: @fn[:toc],
           }
        end
        def scroll
          {
            cmd: '--html-scroll',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.html_scroll.dir + '/' \
            + @md.file.base_filename.html_scroll,
            p_pth: @env.processing_path.tune + '/' \
            + @md.fns + '.tune',
            fn: @fn[:doc],
           }
        end
        def concordance
          {
            cmd: '--concordance',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.html_concordance.dir + '/' \
            + @md.file.base_filename.html_concordance,
            fn: @fn[:concordance],
           }
        end
        self
      end
      def xhtml
        def xhtml
          {
            cmd: '--xhtml',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.xhtml.dir + '/' \
            + @md.file.base_filename.xhtml,
            p_pth: @env.processing_path.tune + '/' \
            + @md.fns + '.tune',
            fn: @fn[:xhtml],
           }
        end
        def epub
          {
            cmd: '--epub',
            viewer: @prog.epub_viewer,
            f_pth: @md.file.output_path.epub.dir + '/' \
            + @md.file.base_filename.epub,
            p_pth: @env.processing_path.epub + '/' \
            + Ep[:d_oebps] + '/' \
            + 'index.xhtml',
            fn: @fn[:epub],
           }
        end
        self
      end
      def xml
        def odt
          {
            cmd: '--odt (ODF:ODT)',
            viewer: @prog.odf_viewer,
            f_pth: @md.file.output_path.odt.dir + '/' \
            + @md.file.base_filename.odt,
            p_pth: @env.processing_path.odf + '/' \
            + @opt.fns + '/' \
            + 'odt/content.xml',
            fn: @fn[:odf],
           }
        end
        def docbook
          {
            cmd: '--docbook',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.xml_docbook_book.dir + '/' \
            + @md.file.base_filename.xml_docbook_book,
            fn: @fn[:xml_docbook_book],
           }
        end
        def fictionbook
          {
            cmd: '--fictionbook',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.xml_fictionbook.dir + '/' \
            + @md.file.base_filename.xml_fictionbook,
            fn: @fn[:xml_fictionbook],
           }
        end
        def sax
          {
            cmd: '--xml-sax',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.xml_sax.dir + '/' \
            + @md.file.base_filename.xml_sax,
            fn: @fn[:sax],
           }
        end
        def dom
          {
            cmd: '--xml-dom',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.xml_dom.dir + '/' \
            + @md.file.base_filename.xml_dom,
            fn: @fn[:dom],
           }
        end
        def scaffold_sisu
          {
            cmd: '--xml-scaffold-sisu',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.xml_scaffold_structure_sisu.dir + '/' \
            + @md.file.base_filename.xml_scaffold_structure_sisu,
            fn: @fn[:xml_scaffold_structure_sisu],
           }
        end
        def scaffold_collapse
          {
            cmd: '--xml-scaffold-collapse',
            viewer: @prog.web_browser,
            f_pth: @md.file.output_path.xml_scaffold_structure_collapse.dir + '/' \
            + @md.file.base_filename.xml_scaffold_structure_collapse,
            fn: @fn[:xml_scaffold_structure_collapse],
           }
        end
        self
      end
      def json
        {
          cmd: '--js (json)',
          viewer: @prog.web_browser,
          f_pth: @md.file.output_path.json.dir + '/' \
          + @md.file.base_filename.json,
          fn: @fn[:json],
        }
      end
      def pdf
        def landscape
          {
            cmd: '--pdf (landscape)',
            viewer: @prog.pdf_viewer,
            f_pth: @md.file.output_path.pdf.dir + '/' \
            + @md.file.base_filename.pdf_l \
            + @md.papersize_array[0] + '.pdf',
            p_pth: @env.processing_path.tex + '/' \
            + @opt.fns.gsub(/~/,'-') + '.' \
            + @md.papersize_array[0] \
            + '.landscape.tex',
            fn: @fn[:pdf_l],
           }
        end
        def portrait
          {
            cmd: '--pdf (portrait)',
            viewer: @prog.pdf_viewer,
            f_pth: @md.file.output_path.pdf.dir + '/' \
            + @md.file.base_filename.pdf_p \
            + @md.papersize_array[0] + '.pdf',
            p_pth: @env.processing_path.tex + '/' \
            + @opt.fns.gsub(/~/,'-') + '.' \
            + @md.papersize_array[0] \
            + '.tex',
            fn: @fn[:pdf_p],
           }
        end
        self
      end
      def manpage
        {
          cmd: '--manpage',
          viewer: @prog.manpage_viewer,
          f_pth: @md.file.output_path.manpage.dir + '/' \
          + @md.file.base_filename.manpage,
          fn: 'manpage',
         }
      end
      def texinfo
        {
          cmd: '--texinfo',
          viewer: '',
          f_pth: 'cd ' \
          + @md.file.output_path.texinfo.dir + ' && ' \
          + @env.program.texinfo + ' ' \
          + @md.file.base_filename.info \
          + '; cd -',
          fn: 'info',
         }
      end
      def db
        def psql
          {
            cmd: '--psql --update/--import',
            viewer: '',
            f_pth: @pwd_stub + '::' \
            + @opt.fns \
            + 'dbi psql',
            p_pth: @env.processing_path.postgresql + '/' \
            + @md.fns \
            + '.sql',
            fn: 'dbi psql',
           }
        end
        def sqlite
          {
            cmd: '--sqlite --update/--import',
            viewer: 'sqlite3 ',
            f_pth: @env.path.webserv + '/' \
            + @md.opt.f_pth[:pth_stub] + '/' \
            + 'sisu_sqlite.db',
            p_pth: @env.processing_path.sqlite + '/' \
            + @md.fns \
            + '.sql',
            fn: 'dbi sqlite3',
           }
        end
        def sqlite_discrete
          {
            cmd: '--sqlite',
            viewer: 'sqlite3 ',
            f_pth: @md.file.output_path.sqlite_discrete.dir + '/' \
            + @md.file.base_filename.sqlite_discrete,
            p_pth: @env.processing_path.sqlite + '/' \
            + @md.fns \
            + '.sql',
            fn: 'dbi sqlite3',
           }
        end
        self
      end
      def po4a
        def po
          {
            cmd: '--po4a/--pot',
            viewer: @prog.web_browser,
            f_pth: @prog.text_editor + ' ' \
            + @md.file.output_path.po.dir \
            + '/' + y,
            fn: @fn[:pot],
           }
        end
        def pot
          {
            cmd: '--po4a/--pot',
            viewer: @prog.web_browser,
            f_pth: @prog.text_editor + ' ' \
            + @md.file.output_path.pot.dir \
            + '/' + y,
            fn: @fn[:pot],
           }
        end
        self
      end
      def source
        {
          cmd: '--source (sisu markup)',
          viewer: @prog.text_editor,
          f_pth: @md.file.output_path.src.dir + '/' \
          + @opt.fno,
          p_pth: @md.file.output_path.src.dir + '/' \
          + @opt.fno,
          fn: @opt.fno,
         }
      end
      def sisupod
        {
          cmd: '--sisupod',
          viewer: '',
          f_pth: @md.file.output_path.sisupod.dir + '/' \
          + @opt.fno \
          + '.txz',
          p_pth: @md.file.output_path.sisupod.dir + '/' \
          + @opt.fno + '/' \
          + 'sisupod/',
          fn: @fn[:sisupod],
         }
      end
      def ruby_profile
        {
          cmd: '--profile (ruby profiler)',
          fn: 'profile',
         }
      end
      def qrcode
        {
          cmd: '--qrcode',
          viewer: @prog.web_browser,
          f_pth: @md.file.output_path.manifest.dir + '/' \
          + @md.file.base_filename.manifest,
          fn: @fn[:qrcode],
         }
      end
      def manifest
        {
          cmd: '--manifest',
          viewer: @prog.web_browser,
          f_pth: @md.file.output_path.manifest.dir + '/' \
          + @md.file.base_filename.manifest,
          fn: @fn[:manifest],
         }
      end
      def sitemap
        {
          cmd: '--sitemap',
          viewer: @prog.web_browser,
          f_pth: @md.file.output_path.sitemaps.dir + '/' \
          + @md.file.base_filename.sitemap,
          fn: @fn[:sitemap],
         }
      end
      self
    end
    def urls_select
      unless @opt.act[:quiet][:set]==:on
        i1='[' + @opt.f_pth[:lng_is] + ']'
        i2='file://' \
        + @md.file.output_path.manifest.dir + '/' \
        + @md.file.base_filename.manifest
        (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'URLs'
          ).green_title_hi
        : SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'URL (output manifest)',
            i1, i2
          ).grey_title_grey_blue
        if (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            i1, i2,
          ).flow
        end
      end
      m=/.+\/(?:src\/)?(\S+)/im
      @pwd_stub="#{@env.url.output_tell}"[m,1]
      unless @opt.act[:quiet][:set]==:on
        if @opt.fns =~ @m_regular
          if (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            if @opt.act[:txt][:set]==:on
              show.report(report_info.text.txt)
              #show.maintenance(report_info.text.txt)
            end
            if @opt.act[:txt_textile][:set]==:on
              show.report(report_info.text.textile)
              #show.maintenance(report_info.text.textile)
            end
            if @opt.act[:txt_asciidoc][:set]==:on
              show.report(report_info.text.asciidoc)
              #show.maintenance(report_info.text.asciidoc)
            end
            if @opt.act[:txt_markdown][:set]==:on
              show.report(report_info.text.markdown)
              #show.maintenance(report_info.text.markdown)
            end
            if @opt.act[:txt_rst][:set]==:on
              show.report(report_info.text.rst)
              #show.maintenance(report_info.text.rst)
            end
            if @opt.act[:txt_orgmode][:set]==:on
              show.report(report_info.text.orgmode)
              #show.maintenance(report_info.text.orgmode)
            end
            if (@opt.act[:html][:set]==:on \
            or @opt.act[:html_scroll][:set]==:on \
            or @opt.act[:html_seg][:set]==:on)
              if @opt.act[:html_scroll][:set]==:on
                show.report(report_info.html.scroll)
                show.maintenance(report_info.html.scroll)
              end
              if @opt.act[:html_seg][:set]==:on
                show.report(report_info.html.seg)
                show.maintenance(report_info.html.seg)
              end
            end
            if @opt.act[:concordance][:set]==:on
              show.report(report_info.html.concordance)
              #show.maintenance(report_info.html.concordance)
            end
            if @opt.act[:xhtml][:set]==:on
              show.report(report_info.xhtml.xhtml)
              show.maintenance(report_info.xhtml.xhtml)
            end
            if @opt.act[:epub][:set]==:on
              show.report(report_info.xhtml.epub)
              show.maintenance(report_info.xhtml.epub)
            end
            if @opt.act[:odt][:set]==:on
              show.report(report_info.xml.odt)
              show.maintenance(report_info.xml.odt)
            end
            if @opt.act[:xml_dom][:set]==:on
              show.report(report_info.xml.dom)
              #show.maintenance(report_info.xml.dom)
            end
            if @opt.act[:xml_sax][:set]==:on
              show.report(report_info.xml.sax)
              #show.maintenance(report_info.xml.sax)
            end
            if @opt.act[:xml_docbook_book][:set]==:on
              show.report(report_info.xml.docbook)
              #show.maintenance(report_info.xml.docbook)
            end
            if @opt.act[:xml_fictionbook][:set]==:on
              show.report(report_info.xml.fictionbook)
              #show.maintenance(report_info.xml.fictionbook)
            end
            if @opt.act[:xml_scaffold_structure_sisu][:set]==:on
              show.report(report_info.xml.scaffold_structure_sisu)
              #show.maintenance(report_info.xml.scaffold_structure_sisu)
            end
            if @opt.act[:xml_scaffold_structure_collapse][:set]==:on
              show.report(report_info.xml.scaffold_collapse)
              #show.maintenance(report_info.xml.scaffold_collapse)
            end
            if @opt.act[:json][:set]==:on
              show.report(report_info.json)
              #show.maintenance(report_info.json)
            end
            if (@opt.act[:pdf][:set]==:on \
            or @opt.act[:pdf_p][:set]==:on \
            or @opt.act[:pdf_l][:set]==:on)
              if @opt.act[:pdf_p][:set]==:on
                show.report(report_info.pdf.portrait)
                show.maintenance(report_info.pdf.portrait)
              end
              if @opt.act[:pdf_l][:set]==:on
                show.report(report_info.pdf.landscape)
                show.maintenance(report_info.pdf.landscape)
              end
            end
            if @opt.act[:psql][:set]==:on
              show.report(report_info.db.psql)
              show.maintenance(report_info.db.psql)
            end
            if @opt.act[:sqlite_discrete][:set]==:on
              show.report(report_info.db.sqlite_discrete)
              show.maintenance(report_info.db.sqlite_discrete)
            end
            if @opt.act[:sqlite][:set]==:on
              show.report(report_info.db.sqlite)
              show.maintenance(report_info.db.sqlite)
            end
            if @opt.act[:texinfo][:set]==:on
              show.report(report_info.texinfo)
              #show.maintenance(report_info.texinfo)
            end
            if @opt.act[:manpage][:set]==:on
              show.report(report_info.manpage)
              #show.maintenance(report_info.manpage)
            end
            if @opt.act[:hash_digests][:set]==:on
              show.report(report_info.hash_digests)
              #show.maintenance(report_info.hash_digests)
            end
            if @opt.act[:po4a_shelf][:set]==:on
              #if @opt.fns =~/\S+?~\S{2}(?:_\S{2})?\.ss[mt]/
              #else
              #end
            end
            if @opt.act[:share_source][:set]==:on
              show.report(report_info.source)
              show.maintenance(report_info.source)
            end
            if @opt.act[:sisupod][:set]==:on
              show.report(report_info.sisupod)
              show.maintenance(report_info.sisupod)
            end
            if @opt.act[:qrcode][:set]==:on
              show.report(report_info.qrcode)
              #show.maintenance(report_info.qrcode)
            end
            if @opt.act[:manifest][:set]==:on
              show.report(report_info.manifest)
              show.maintenance(report_info.manifest)
            end
          end
        end
      end
    end
    def urls_all
      i="(output manifest) [#{@opt.f_pth[:lng_is]}] #{@env.url.output_tell}/#{@fnb}/sisu_manifest.html"
      SiSU_Screen::Ansi.new(
        @opt.act[:color_state][:set],
        'URLs',
        i
      ).grey_title_hi
    end
  end
end
__END__
