#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    utils
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Response
  def available_selections_
    %{'yes', 'no', 'quit' or 'exit'; [ynqx]}
  end
  def response?(ask)
    response='redo'
    print ask + %{ [#{available_selections_}]: }
    response=File.new('/dev/tty').gets.strip
    case response
    when /^(?:y|yes)$/          then true
    when /^(?:n|no)$/           then false
    when /^(?:[qx]|quit|exit)$/ then exit
    else puts %{[please type: #{available_selections_}]}
      response?(ask)
    end
  end
  def query
    def selections_available_(selections=:strict)
      short_options=(selections == :strict) ? '' : '; [ynqx]'
      %{'yes', 'no', 'quit' or 'exit'#{short_options}}
    end
    def selection_options
      def response_strict(resp)
        case resp
        when /^(?:yes)$/          then true
        when /^(?:no)$/           then false
        when /^(?:quit|exit)$/    then exit
        else
          puts %{response was: #{resp}}
          puts %{[please type to select: #{selections_available_(:strict)}]}
          answer?('',:strict)
        end
      end
      def response_short(resp)
        case resp
        when /^(?:y|yes)$/          then true
        when /^(?:n|no)$/           then false
        when /^(?:[qx]|quit|exit)$/ then exit
        else
          puts %{response was: #{resp}}
          puts %{[please type to select: #{selections_available_(:short)}]}
          answer?('',:short)
        end
      end
      self
    end
    def answer?(ask,selections=:strict)
      resp='redo'
      print ask + %{PROCEED? [#{selections_available_(selections)}]: }
      resp=File.new('/dev/tty').gets.strip
      (selections==:strict) \
      ? selection_options.response_strict(resp)
      : selection_options.response_short(resp)
    end
    self
  end
end
__END__
