"""A list of ClickHouse keywords."""

# https://clickhouse.com/docs/en/sql-reference/syntax/#keywords
FORMAT_KEYWORDS = [
    "TabSeparated",
    "TabSeparatedRaw",
    "TabSeparatedWithNames",
    "TabSeparatedWithNamesAndTypes",
    "TabSeparatedRawWithNames",
    "TabSeparatedRawWithNamesAndTypes",
    "Template",
    "TemplateIgnoreSpaces",
    "CSV",
    "CSVWithNames",
    "CSVWithNamesAndTypes",
    "CustomSeparated",
    "CustomSeparatedWithNames",
    "CustomSeparatedWithNamesAndTypes",
    "SQLInsert",
    "Values",
    "Vertical",
    "JSON",
    "JSONAsString",
    "JSONAsObject",
    "JSONStrings",
    "JSONColumns",
    "JSONColumnsWithMetadata",
    "JSONCompact",
    "JSONCompactStrings",
    "JSONCompactColumns",
    "JSONEachRow",
    "PrettyJSONEachRow",
    "JSONEachRowWithProgress",
    "JSONStringsEachRow",
    "JSONStringsEachRowWithProgress",
    "JSONCompactEachRow",
    "JSONCompactEachRowWithNames",
    "JSONCompactEachRowWithNamesAndTypes",
    "JSONCompactStringsEachRow",
    "JSONCompactStringsEachRowWithNames",
    "JSONCompactStringsEachRowWithNamesAndTypes",
    "JSONObjectEachRow",
    "BSONEachRow",
    "TSKV",
    "Pretty",
    "PrettyNoEscapes",
    "PrettyMonoBlock",
    "PrettyNoEscapesMonoBlock",
    "PrettyCompact",
    "PrettyCompactNoEscapes",
    "PrettyCompactMonoBlock",
    "PrettyCompactNoEscapesMonoBlock",
    "PrettySpace",
    "PrettySpaceNoEscapes",
    "PrettySpaceMonoBlock",
    "PrettySpaceNoEscapesMonoBlock",
    "Prometheus",
    "Protobuf",
    "ProtobufSingle",
    "ProtobufList",
    "Avro",
    "AvroConfluent",
    "Parquet",
    "ParquetMetadata",
    "Arrow",
    "ArrowStream",
    "ORC",
    "One",
    "Npy",
    "RowBinary",
    "RowBinaryWithNames",
    "RowBinaryWithNamesAndTypes",
    "RowBinaryWithDefaults",
    "Native",
    "Null",
    "XML",
    "CapnProto",
    "LineAsString",
    "Regexp",
    "RawBLOB",
    "MsgPack",
    "MySQLDump",
    "DWARF",
    "Markdown",
    "Form",
]


UNRESERVED_KEYWORDS = [
    # All keywords are unreserved. They are only treated as reserved according to
    # context.
    # See: https://clickhouse.com/docs/en/sql-reference/syntax/#keywords
    # This means that, for example, using `join` or `select` as table identifiers
    # without quotes is allowed.
    "ADD",
    "AFTER",
    "ALIAS",
    "ALL",
    "ALTER",
    "AND",
    "ANTI",
    "ANY",
    "ARRAY",
    "AS",
    "ASCENDING",
    "ASOF",
    "AST",
    "ASYNC",
    "ATOMIC",
    "ATTACH",
    "BETWEEN",
    "BOTH",
    "BY",
    "CHECK",
    "CLEAR",
    "CLUSTER",
    "CODEC",
    "COLLATE",
    "COLUMN",
    "COMMENT",
    "CONSTRAINT",
    "CREATE",
    "CUBE",
    "DATABASE",
    "DATABASES",
    "DATE",
    "DATETIME32",
    "DATETIME64",
    "DAY",
    "DEDUPLICATE",
    "DEFAULT",
    "DELAY",
    "DELETE",
    "DESC",
    "DESCENDING",
    "DESCRIBE",
    "DETACH",
    "DICTIONARIES",
    "DICTIONARY",
    "DISK",
    "DISTINCT",
    "DISTRIBUTED",
    "DROP",
    "ELSE",
    "END",
    "ENGINE",
    "EPHEMERAL",
    "EVENTS",
    "EXCEPT",
    "EXISTS",
    "EXPLAIN",
    "EXPRESSION",
    "EXTRACT",
    "FETCHES",
    "FILE",
    "FILESYSTEM",
    "FILL",
    "FINAL",
    "FIRST",
    "FLUSH",
    "FOR",
    "FORMAT",
    "FREEZE",
    "FROM",
    "FUNCTION",
    "GLOBAL",
    "GRANULARITY",
    "GROUP",
    "HAVING",
    "HIERARCHICAL",
    "HOUR",
    "ID",
    "IDENTIFIED",
    "IF",
    "ILIKE",
    "IN",
    "INDEX",
    "INF",
    "INJECTIVE",
    "INSERT",
    "INTERVAL",
    "INTO",
    "IS",
    "IS_OBJECT_ID",
    "KEY",
    "KILL",
    "LAST",
    "LAYOUT",
    "LAZY",
    "LEADING",
    "LIFETIME",
    "LIKE",
    "LIMIT",
    "LIVE",
    "LOCAL",
    "LOGS",
    "MATERIALIZE",
    "MATERIALIZED",
    "MATERIALIZEDMYSQL",
    "MATERIALIZEDPOSTGRESQL",
    "MAX",
    "MERGES",
    "MIN",
    "MINUTE",
    "MODEL",
    "MODELS",
    "MODIFY",
    "MONTH",
    "MOVE",
    "MOVES",
    "MUTATION",
    "MYSQL",
    "NAN_SQL",
    "NO",
    "NOT",
    "NULLS",
    "NULL_SQL",
    "OFFSET",
    "OPTIMIZE",
    "OR",
    "OUTFILE",
    "OVERRIDE",
    "PART",
    "PASTE",
    "POPULATE",
    "POSTGRESQL",
    "PREWHERE",
    "PRIMARY",
    "PROFILE",
    "PROJECTION",
    "QUARTER",
    "QUERY",
    "QUOTA",
    "QUEUES",
    "RANGE",
    "RELOAD",
    "REMOVE",
    "RENAME",
    "REPLACE",
    "REPLICA",
    "REPLICATED",
    "REPLICATION",
    "ROLLUP",
    "SAMPLE",
    "SECOND",
    "SEMI",
    "SEND",
    "SENDS",
    "SETTINGS",
    "SHOW",
    "SOURCE",
    "SQLITE",
    "START",
    "STEP",
    "STOP",
    "SUBSTRING",
    "SYNC",
    "SYNTAX",
    "SYSTEM",
    "TABLE",
    "TABLES",
    "TEMPORARY",
    "TEST",
    "THEN",
    "TIES",
    "TIMEOUT",
    "TIMESTAMP",
    "TO",
    "TOP",
    "TOTALS",
    "TRAILING",
    "TRIM",
    "TRUNCATE",
    "TTL",
    "TUPLE",
    "TYPE",
    "UNFREEZE",
    "UPDATE",
    "USE",
    "UUID",
    "VALUES",
    "VIEW",
    "VOLUME",
    "WATCH",
    "WEEK",
    "WHEN",
    "WHERE",
    "WITH",
    "YEAR",
    "ZKPATH",
] + FORMAT_KEYWORDS
