"""A List of FlinkSQL keywords.

Based on Apache Flink SQL reference:
https://nightlies.apache.org/flink/flink-docs-release-1.18/docs/dev/table/sql/queries/
"""

# FlinkSQL Reserved Keywords
RESERVED_KEYWORDS = [
    "ALL",
    "AND",
    "ANY",
    "AS",
    "AUTHORIZATION",
    "BETWEEN",
    "BIGINT",
    "BINARY",
    "BOOLEAN",
    "BOTH",
    "BY",
    "CASE",
    "CAST",
    "CHAR",
    "CHARACTER",
    "CHECK",
    "COLLATE",
    "COLUMN",
    "CONSTRAINT",
    "CREATE",
    "CROSS",
    "CURRENT_DATE",
    "CURRENT_TIME",
    "CURRENT_TIMESTAMP",
    "CURRENT_USER",
    "CURSOR",
    "DATE",
    "DAY",
    "DECIMAL",
    "DECLARE",
    "DELETE",
    "DESC",
    "DISTINCT",
    "DOUBLE",
    "DROP",
    "ELSE",
    "END",
    "ESCAPE",
    "EXCEPT",
    "EXISTS",
    "EXTRACT",
    "FALSE",
    "FETCH",
    "FILTER",
    "FLOAT",
    "FOR",
    "FOREIGN",
    "FROM",
    "FULL",
    "FUNCTION",
    "GRANT",
    "GROUP",
    "HAVING",
    "HOUR",
    "IF",
    "IN",
    "INNER",
    "INSERT",
    "INT",
    "INTEGER",
    "INTERSECT",
    "INTERVAL",
    "INTO",
    "IS",
    "JOIN",
    "LEADING",
    "LEFT",
    "LIKE",
    "LIMIT",
    "LOCAL",
    "MINUTE",
    "MONTH",
    "NATURAL",
    "NOT",
    "NULL",
    "NUMERIC",
    "OF",
    "ON",
    "ONLY",
    "OR",
    "ORDER",
    "OUTER",
    "OVERLAPS",
    "OVERLAY",
    "PARTITION",
    "POSITION",
    "PRIMARY",
    "REAL",
    "REFERENCES",
    "RIGHT",
    "ROW",
    "SECOND",
    "SELECT",
    "SESSION_USER",
    "SET",
    "SMALLINT",
    "SOME",
    "SUBSTRING",
    "TABLE",
    "THEN",
    "TIME",
    "TIMESTAMP",
    "TINYINT",
    "TO",
    "TRAILING",
    "TRUE",
    "UNION",
    "UNIQUE",
    "UNKNOWN",
    "UPDATE",
    "USER",
    "USING",
    "VALUES",
    "VARCHAR",
    "WHEN",
    "WHERE",
    "WITH",
    "YEAR",
]

# FlinkSQL Unreserved Keywords
UNRESERVED_KEYWORDS = [
    "ADD",
    "AFTER",
    "ANALYZE",
    "APPEND",
    "ARRAY",
    "ASC",
    "AVRO_CONFLUENT",
    "AVRO",
    "BEGIN",
    "BIGQUERY",
    "BYTES",
    "CALL",
    "CANAL",
    "CANCEL",
    "CASSANDRA",
    "CATALOG",
    "CATALOGS",
    "CHANGELOG",
    "CHECKPOINT",
    "COMMENT",
    "COMPACTION",
    "COMPUTED",
    "CONNECTOR",
    "CSV",
    "CURRENT",
    "DATABASE",
    "DATABASES",
    "DEBEZIUM",
    "DESCRIBE",
    "DISTRIBUTED",
    "DISTRIBUTION",
    "ELASTIC",
    "ELASTICSEARCH",
    "ENFORCED",
    "EXCLUDING",
    "EXIT",
    "EXPLAIN",
    "EXTENDED",
    "FILESYSTEM",
    "FIRST",
    "FORMAT",
    "FUNCTIONS",
    "GENERATED",
    "HASH",
    "HBASE",
    "HELP",
    "HISTORY",
    "INCLUDING",
    "JARS",
    "JDBC",
    "JOBS",
    "JSON",
    "KAFKA",
    "KINESIS",
    "LAST",
    "LOAD",
    "MAP",
    "MAXWELL",
    "MERGE",
    "METADATA",
    "MODULES",
    "MULTISET",
    "OGG",
    "OPTION",
    "OPTIONS",
    "ORC",
    "OVERWRITING",
    "PARQUET",
    "PARTITIONED",
    "PARTITIONS",
    "PHYSICAL",
    "PLAN",
    "PROCEDURE",
    "PROCEDURES",
    "PROTOBUF_CONFLUENT",
    "PROTOBUF",
    "PULSAR",
    "QUIT",
    "RANGE",
    "RAW",
    "REDIS",
    "REPLACE",
    "RESET",
    "RESTART",
    "RESUME",
    "RETRACT",
    "SAVEPOINT",
    "SET",
    "SHOW",
    "SINK",
    "SOURCE",
    "START",
    "STOP",
    "SUSPEND",
    "SYSTEM",
    "TABLES",
    "TEMPORARY",
    "TIMESTAMP_LTZ",
    "TRUNCATE",
    "UNLOAD",
    "UPSERT",
    "USE",
    "VALUE",
    "VIRTUAL",
    "WATERMARK",
    "WATERMARKS",
    "YEAR",
    "ZONE",
]
