#!/usr/bin/env python
# Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.dev/sumo
# Copyright (C) 2009-2025 German Aerospace Center (DLR) and others.
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# https://www.eclipse.org/legal/epl-2.0/
# This Source Code may also be made available under the following Secondary
# Licenses when the conditions for such availability set forth in the Eclipse
# Public License 2.0 are satisfied: GNU General Public License, version 2
# or later which is available at
# https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
# SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later

# @file    test.py
# @author  Pablo Alvarez Lopez
# @date    2016-11-25

# import common functions for netedit tests
import os
import sys

sys.path.append(os.path.join(os.environ.get("SUMO_HOME", "."), "tools"))
import neteditTestFunctions as netedit  # noqa

# Open netedit
neteditProcess, referencePosition = netedit.setupAndStart()

# go to additional mode
netedit.changeMode("additional")

# select chargingStation
netedit.changeElement("additionalFrame", "chargingStation")

# set invalid chargeDelay (dummy)
netedit.modifyAttribute(netedit.attrs.chargingStation.create.chargeDelay, "dummyChargeDelay")

# try to create chargingStation in mode "Reference Left"
netedit.leftClick(referencePosition, netedit.positions.elements.edgeCenter1)

# set invalid chargeDelay (negative)
netedit.modifyAttribute(netedit.attrs.chargingStation.create.chargeDelay, "-50")

# try to create chargingStation in mode "Reference Left"
netedit.leftClick(referencePosition, netedit.positions.elements.edgeCenter0)

# set valid chargeDelay (double)
netedit.modifyAttribute(netedit.attrs.chargingStation.create.chargeDelay, "20.5")

# try to create chargingStation in mode "Reference Left"
netedit.leftClick(referencePosition, netedit.positions.elements.edgeCenter1)

# Check undo redo
netedit.checkUndoRedo(referencePosition)

# save netedit config
netedit.saveExistentFile("neteditConfig")

# quit netedit
netedit.quit(neteditProcess)
