/*
 * SRTM3Reader a DEMReader  abstract implementation to read and decode SRTM3 datasets
 */
package uk.co.mccombe.terrain;

import javax.swing.JComponent;

/**
 *
 * @author Mike McCombe
 */
public abstract class SRTM3Reader extends DEMReader {

    public SRTM3Reader(JComponent item) throws MissingDataFileException,DataFileException {
        super(item);
    }

    @Override
    public int recordlength() {
        return recordlength;
    }
    @Override
    public String extn() {
        return extn;
    }

    @Override
    public boolean littleendian() {
        return littleendian;
    }

    @Override
    public int missingValue() {
        return missingValue;
    }
    /**
     * Maximum latitude of SRTM3 dataset
     * Latitude must be less than 61.0
     * @return double 61.0
     */
    @Override
    public double maxLat() {
        return 61.0;
    }
     /**
     * Minimum latitude of SRTM3 dataset
     * Latitude must be greater or equal to -56.0
     * @return double -56.0
     */
    @Override
    public double minLat() {
        return -56.0 ;
    }
    protected static final boolean DOWNLOADABLE = false;
    protected static int recordlength = 3601;
    protected static String extn = ".zip";
    protected static boolean littleendian = false;
    protected static int missingValue = -32768;
}
