[comment {-*- tcl -*- doctools manpage}]
[vset VERSION 1.1.3]
[manpage_begin ico n [vset VERSION]]
[keywords dll]
[keywords entry]
[keywords exe]
[keywords ico]
[keywords icon]
[moddesc   {Windows ICO handling}]
[titledesc {Reading and writing windows icons}]
[require Tcl 8.4]
[require ico [opt [vset VERSION]]]
[description]

This package provides functions for reading and writing Windows icons
from ICO, EXE, DLL, ICL, and BMP files.

As used in this module an icon is a visual representation of an object.
An icon consists of one or more images usually with varying resolution
and color depth. Each icon and image has a resource identifier which
may be a text string or a positive integer value. Most commands use this
identifier to specify which icon or image to operate on.

[section API]

[list_begin definitions]

[call [cmd ::ico::icons] [arg file] [opt "[arg option] [arg value]..."]]

Returns a list of icons found in [arg file] where each element is the
name or numeric ID. Recognizes the following options:

[list_begin options]
[opt_def -type fileFormat]
[list_end]
[para]

[call [cmd ::ico::iconMembers] [arg file] [arg name] [opt "[arg option] [arg value]..."]]

Returns a list of images that make up the icon with ID [arg name]. Each element is itself a
sublist in the format {name width height bpp}. Recognizes the following options:

[list_begin options]
[opt_def -type fileFormat]
[list_end]
[para]

[call [cmd ::ico::getIcon] [arg file] [arg name] [opt "[arg option] [arg value]..."]]

Extracts the icon with ID [arg name] from [arg file].

The default [option -format] is [const image] which will return the
name of a Tk image containing the icon. The resolution and color depth
are selected with the [opt -res], [opt -bpp], and [opt -exact] options.

If -exact is specified and there is no exact match, an error is thrown.

Optionally [option -image] may be used to specify the name of the Tk
image that is created. If [option -format] is [const colors] then a
list of color names in the #RRGGBB format is returned. Each list element
is a horizontal row. Each horizontal row contains a list of colors for
all the pixels in that row from left to right. If [option -format] is
[const name] then the resource name of the image chosen is returned.
This is useful for calling writeIcon or getIconByName.

Recognizes the following [arg option]s.

[list_begin options]
[opt_def -type fileFormat]
[opt_def -format value]
[opt_def -image value]
[opt_def -res value]
[opt_def -bpp value]
[opt_def -exact value]
[list_end]
[para]

[call [cmd ::ico::getIconByName] [arg file] [arg name] [opt "[arg option] [arg value]..."]]

Extracts the image with ID [arg name] from [arg file]. This name should be the name of a
specific image as returned by [cmd ::ico::iconMembers], not an icon name returned from
[cmd ::ico::icons]. If there is no matching resource ID
in [arg file] an error is thrown. Recognizes the following options:

[list_begin options]
[opt_def -type fileFormat]
[opt_def -format value]
[list_end]
[para]

[call [cmd ::ico::getFileIcon] [arg file] [opt "[arg option] [arg value]..."]]

This command is only functional when running under Windows. It reads the Windows
registry to determine the display icon for [arg file] as it would appear in Explorer
or similar. [arg file] does not need to exist and may also be specified as a file
extension with a leading dot. If [arg file] is a directory or you specify the
special name [const Folder] then the icon representing a folder is returned. This
command takes the same arguments and usage as [cmd getIcon]:

[list_begin options]
[opt_def -format value]
[opt_def -image value]
[opt_def -res value]
[opt_def -bpp value]
[opt_def -exact value]
[list_end]
[para]

[call [cmd ::ico::writeIcon] [arg file] [arg name] [arg depth] [arg data] [opt "[arg option] [arg value]..."]]

Writes an image to [arg file]. [arg name] is the resource identifier of the
image in [arg file] to write.
When writing to an EXE, DLL, or ICL file you may only overwrite existing icons with an
icon of the same dimensions and color depth. No icons may be added to these file types.
[para]
When writing to BMP the name is ignored as this type can contain only one image. This means
if the file already existed it is completely overwritten.
[para]
When writing to an ICO or ICODATA file if the name
specified does not exist then an image is appended and will be named the next in sequence
(the specified name is ignored). Images in ICO and ICODATA files may be overwritten with differing
dimensions or color depths.

Note that you will get strange results when displaying icons if you fail to change every image
which makes up a given icon.

[list_begin arguments]
[arg_def integer depth in]

This argument must have a value of [const 1], [const 4], [const 8],
[const 24], or [const 32]. If [arg data] has more colors than the
color depth allows an error will be generated.

[arg_def options data in]

This argument is either a list of colors in the format returned by
[cmd {::ico::getIcon -format colors}] or the name of a Tk image.

[list_end]
[para]

Recognizes the following [arg option]s.

[list_begin options]
[opt_def -type fileFormat]
[list_end]
[para]

[call [cmd ::ico::copyIcon] [arg file] [arg index] [arg file2] [arg index2] [opt "[arg option] [arg value]..."]]

Copies the icon at [arg index] in [arg file] to [arg index2] in [arg file2].

[list_begin options]
[opt_def -fromtype fileFormat]
[opt_def -totype fileFormat]
[list_end]
[para]

[call [cmd ::ico::EXEtoICO] [arg file] [opt dir]]

Extracts all icons from the executable [arg file] to ICO files placed in [arg dir]. [opt dir] defaults to the directory [arg file] is located in. Icon files will be named in the form [arg file]-ID.ico where ID is the icon resource identifier.

[list_begin options]
[opt_def -type fileFormat]
[list_end]
[para]

[call [cmd ::ico::clearCache] [opt file]]

The [cmd ::ico::getIconList] command caches icon offsets inside EXE, DLL, ICL,
and ICO files in order to speed up extraction.  This command clears that
cache for the specific [opt file] or all files.

[call [cmd ::ico::transparentColor] [arg image] [arg color]]

If [arg image] is a single word it is assumed to be the name of a Tk image.
All pixels matching [arg color] in the [arg image] will be set transparent.
Alternatively, [arg image] may be a color list in which case a modified list
is returned.

[call [cmd ::ico::Show] [arg file] [opt "[arg option] [arg value]..."]]

Application level command which displays a window showing all the
icons in [arg file] and their name.

[list_begin options]
[opt_def -type fileFormat]
[opt_def -parent pathName]
[list_end]
[list_end]

[section EXAMPLE]

[example {
    button .explore -image [::ico::getIcon explorer.exe 0 -name explore -res 16 -bpp 8]

    set i [lsearch -inline [::ico::iconMembers tclkit.exe 0] {* 32 32 8}]
    set colorlist [::ico::getIconByName tclkit.exe [lindex $i 0] -format colors]
}]

[section LIMITATIONS]

Icons may not be added or removed from file types other than ICO. Icons in these files
may only be replaced with icons of the same dimensions and color depth.
[para]

Icons of 8bpp or lower must include black in the pallete, this means if your icon does
not have black in it, you will need to leave a color free so that it may be included by
writeIcon.
[para]

There is currently no way to read alpha channel information from 32bpp icons.
[para]

Tk images do not have an alpha channel so the only way to write a true 32bpp icon is from
a color list. writing a 32bpp icon from a Tkimage is identical to writing a 24bpp icon.
[vset CATEGORY ico]
[include ../../support/devel/doc/feedback.inc]
[manpage_end]
