struct rx_test rx_tests[] =
{
  {
    "posix-2.8.3.1-0",
    "a",
    0,
    0,
    "a",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-1",
    "\\.",
    0,
    0,
    ".",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-2",
    "\\[",
    0,
    0,
    "[",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-3",
    "\\\\",
    0,
    0,
    "\\",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-4",
    "\\*",
    0,
    0,
    "*",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-5",
    "\\^",
    0,
    0,
    "^",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-6",
    "\\$",
    0,
    0,
    "$",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-7",
    "\\",
    0,
    REG_EESCAPE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-8",
    "x\\.",
    0,
    0,
    "x.",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-9",
    "x\\[",
    0,
    0,
    "x[",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-10",
    "x\\\\",
    0,
    0,
    "x\\",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-11",
    "x\\*",
    0,
    0,
    "x*",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-12",
    "x\\^",
    0,
    0,
    "x^",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-13",
    "x\\$",
    0,
    0,
    "x$",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1-14",
    "x\\",
    0,
    REG_EESCAPE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1.3-0",
    ".",
    0,
    0,
    "a",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.1.3-1",
    ".",
    0,
    0,
    "\n",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-0",
    "[]x]",
    0,
    0,
    "]",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-0",
    "[]x]",
    REG_EXTENDED,
    0,
    "]",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-1",
    "[]x]",
    0,
    0,
    "x",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-1",
    "[]x]",
    REG_EXTENDED,
    0,
    "x",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-2",
    "[]",
    0,
    REG_EBRACK,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-2",
    "[]",
    REG_EXTENDED,
    REG_EBRACK,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-3",
    "[.]",
    0,
    0,
    ".",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-3",
    "[.]",
    REG_EXTENDED,
    0,
    ".",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-4",
    "[.]",
    0,
    0,
    "a",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-4",
    "[.]",
    REG_EXTENDED,
    0,
    "a",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-5",
    "[*]",
    0,
    0,
    "*",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-5",
    "[*]",
    REG_EXTENDED,
    0,
    "*",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-6",
    "[[]",
    0,
    0,
    "[",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-6",
    "[[]",
    REG_EXTENDED,
    0,
    "[",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-7",
    "[\\]",
    0,
    0,
    "\\",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-7",
    "[\\]",
    REG_EXTENDED,
    0,
    "\\",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-8",
    "[[.]",
    0,
    REG_ECOLLATE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-8",
    "[[.]",
    REG_EXTENDED,
    REG_ECOLLATE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-9",
    "[[=]",
    0,
    REG_ECOLLATE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-9",
    "[[=]",
    REG_EXTENDED,
    REG_ECOLLATE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-10",
    "[[:]",
    0,
    REG_ECTYPE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-10",
    "[[:]",
    REG_EXTENDED,
    REG_ECTYPE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-11",
    "[abc]",
    0,
    0,
    "a",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-11",
    "[abc]",
    REG_EXTENDED,
    0,
    "a",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-12",
    "[abc]",
    0,
    0,
    "b",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-12",
    "[abc]",
    REG_EXTENDED,
    0,
    "b",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-13",
    "[abc]",
    0,
    0,
    "c",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-13",
    "[abc]",
    REG_EXTENDED,
    0,
    "c",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-14",
    "[abc]",
    0,
    0,
    "d",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-14",
    "[abc]",
    REG_EXTENDED,
    0,
    "d",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-15",
    "x[abc]",
    0,
    0,
    "xa",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-15",
    "x[abc]",
    REG_EXTENDED,
    0,
    "xa",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-16",
    "x[abc]",
    0,
    0,
    "xb",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-16",
    "x[abc]",
    REG_EXTENDED,
    0,
    "xb",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-17",
    "x[abc]",
    0,
    0,
    "xc",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-17",
    "x[abc]",
    REG_EXTENDED,
    0,
    "xc",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-18",
    "x[abc]",
    0,
    0,
    "xd",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-18",
    "x[abc]",
    REG_EXTENDED,
    0,
    "xd",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-19",
    "[^abc]",
    0,
    0,
    "a",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-19",
    "[^abc]",
    REG_EXTENDED,
    0,
    "a",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-20",
    "[^abc]",
    0,
    0,
    "b",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-20",
    "[^abc]",
    REG_EXTENDED,
    0,
    "b",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-21",
    "[^abc]",
    0,
    0,
    "c",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-21",
    "[^abc]",
    REG_EXTENDED,
    0,
    "c",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-22",
    "[^abc]",
    0,
    0,
    "d",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-22",
    "[^abc]",
    REG_EXTENDED,
    0,
    "d",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-23",
    "x[^abc]",
    0,
    0,
    "xa",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-23",
    "x[^abc]",
    REG_EXTENDED,
    0,
    "xa",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-24",
    "x[^abc]",
    0,
    0,
    "xb",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-24",
    "x[^abc]",
    REG_EXTENDED,
    0,
    "xb",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-25",
    "x[^abc]",
    0,
    0,
    "xc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-25",
    "x[^abc]",
    REG_EXTENDED,
    0,
    "xc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-26",
    "x[^abc]",
    0,
    0,
    "xd",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-26",
    "x[^abc]",
    REG_EXTENDED,
    0,
    "xd",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-27",
    "[[:alnum:]][[:alnum:]]*",
    0,
    0,
    "%abc123890XYZ=",
    0,
    1,
    1,
    {{1, 13}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-27",
    "[[:alnum:]][[:alnum:]]*",
    REG_EXTENDED,
    0,
    "%abc123890XYZ=",
    0,
    1,
    1,
    {{1, 13}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-28",
    "[[:cntrl:]][[:cntrl:]]*",
    0,
    0,
    "%\n\t\015\f ",
    0,
    1,
    1,
    {{1, 5}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-28",
    "[[:cntrl:]][[:cntrl:]]*",
    REG_EXTENDED,
    0,
    "%\n\t\015\f ",
    0,
    1,
    1,
    {{1, 5}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-29",
    "[[:lower:]][[:lower:]]*",
    0,
    0,
    "AbcdE",
    0,
    1,
    1,
    {{1, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-29",
    "[[:lower:]][[:lower:]]*",
    REG_EXTENDED,
    0,
    "AbcdE",
    0,
    1,
    1,
    {{1, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-30",
    "[[:lower:]][[:lower:]]*",
    REG_ICASE,
    0,
    "AbcdE",
    0,
    1,
    1,
    {{0, 5}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-30",
    "[[:lower:]][[:lower:]]*",
    REG_EXTENDED | REG_ICASE,
    0,
    "AbcdE",
    0,
    1,
    1,
    {{0, 5}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-31",
    "[[:space:]][[:space:]]*",
    REG_ICASE,
    0,
    "x \t\f\nx",
    0,
    1,
    1,
    {{1, 5}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-31",
    "[[:space:]][[:space:]]*",
    REG_EXTENDED | REG_ICASE,
    0,
    "x \t\f\nx",
    0,
    1,
    1,
    {{1, 5}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-32",
    "[[:alpha:]][[:alpha:]]*",
    0,
    0,
    "%abC123890xyz=",
    0,
    1,
    1,
    {{1, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-32",
    "[[:alpha:]][[:alpha:]]*",
    REG_EXTENDED,
    0,
    "%abC123890xyz=",
    0,
    1,
    1,
    {{1, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-33",
    "[[:digit:]][[:digit:]]*",
    0,
    0,
    "%abC123890xyz=",
    0,
    1,
    1,
    {{4, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-33",
    "[[:digit:]][[:digit:]]*",
    REG_EXTENDED,
    0,
    "%abC123890xyz=",
    0,
    1,
    1,
    {{4, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-34",
    "[[:print:]][[:print:]]*",
    0,
    0,
    "\n %abC12\f",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-34",
    "[[:print:]][[:print:]]*",
    REG_EXTENDED,
    0,
    "\n %abC12\f",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-35",
    "[[:upper:]][[:upper:]]*",
    0,
    0,
    "\n aBCDEFGHIJKLMNOPQRSTUVWXYz",
    0,
    1,
    1,
    {{3, 27}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-35",
    "[[:upper:]][[:upper:]]*",
    REG_EXTENDED,
    0,
    "\n aBCDEFGHIJKLMNOPQRSTUVWXYz",
    0,
    1,
    1,
    {{3, 27}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-36",
    "[[:upper:]][[:upper:]]*",
    REG_ICASE,
    0,
    "\n aBCDEFGHIJKLMNOPQRSTUVWXYz",
    0,
    1,
    1,
    {{2, 28}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-36",
    "[[:upper:]][[:upper:]]*",
    REG_EXTENDED | REG_ICASE,
    0,
    "\n aBCDEFGHIJKLMNOPQRSTUVWXYz",
    0,
    1,
    1,
    {{2, 28}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-37",
    "[[:blank:]][[:blank:]]*",
    REG_ICASE,
    0,
    "\na \t b",
    0,
    1,
    1,
    {{2, 5}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-37",
    "[[:blank:]][[:blank:]]*",
    REG_EXTENDED | REG_ICASE,
    0,
    "\na \t b",
    0,
    1,
    1,
    {{2, 5}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-38",
    "[[:graph:]][[:graph:]]*",
    0,
    0,
    "\n %abC12\f",
    0,
    1,
    1,
    {{2, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-38",
    "[[:graph:]][[:graph:]]*",
    REG_EXTENDED,
    0,
    "\n %abC12\f",
    0,
    1,
    1,
    {{2, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-39",
    "[[:punct:]][[:punct:]]*",
    0,
    0,
    "a~!@#$%^&*()_+=-`[]{};':\"|\\,./?>< ",
    0,
    1,
    1,
    {{1, 33}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-39",
    "[[:punct:]][[:punct:]]*",
    REG_EXTENDED,
    0,
    "a~!@#$%^&*()_+=-`[]{};':\"|\\,./?>< ",
    0,
    1,
    1,
    {{1, 33}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-40",
    "[[:xdigit:]][[:xdigit:]]*",
    0,
    0,
    "-0123456789ABCDEFabcdef",
    0,
    1,
    1,
    {{1, 23}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-40",
    "[[:xdigit:]][[:xdigit:]]*",
    REG_EXTENDED,
    0,
    "-0123456789ABCDEFabcdef",
    0,
    1,
    1,
    {{1, 23}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-41",
    "[a-z][a-z]*",
    0,
    0,
    "ABCabcxyzABC",
    0,
    1,
    1,
    {{3, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-41",
    "[a-z][a-z]*",
    REG_EXTENDED,
    0,
    "ABCabcxyzABC",
    0,
    1,
    1,
    {{3, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-42",
    "[a-z][z-a]*",
    0,
    REG_ERANGE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-42",
    "[a-z][z-a]*",
    REG_EXTENDED,
    REG_ERANGE,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-43",
    "[a-a][a-a]*",
    0,
    0,
    "zaaaaab",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-43",
    "[a-a][a-a]*",
    REG_EXTENDED,
    0,
    "zaaaaab",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-44",
    "[a-a][a-a]*",
    REG_ICASE,
    0,
    "ZAAAAAB",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-44",
    "[a-a][a-a]*",
    REG_EXTENDED | REG_ICASE,
    0,
    "ZAAAAAB",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-45",
    "[--Z][--Z]*",
    0,
    0,
    "!ABC-./XYZ~",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-45",
    "[--Z][--Z]*",
    REG_EXTENDED,
    0,
    "!ABC-./XYZ~",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-46",
    "[*--Z][*--Z]*",
    0,
    0,
    "!+*,---ABC",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-46",
    "[*--Z][*--Z]*",
    REG_EXTENDED,
    0,
    "!+*,---ABC",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-47",
    "[a-][a-]*",
    0,
    0,
    "xa-a--a-ay",
    0,
    1,
    1,
    {{1, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-47",
    "[a-][a-]*",
    REG_EXTENDED,
    0,
    "xa-a--a-ay",
    0,
    1,
    1,
    {{1, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-48",
    "[a[.-.]z][a[.-.]z]*",
    0,
    0,
    "ba-a-a-zw",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-48",
    "[a[.-.]z][a[.-.]z]*",
    REG_EXTENDED,
    0,
    "ba-a-a-zw",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-49",
    "[[.a.]-[.z.]][[.a.]-z]*",
    0,
    0,
    "ABCabcxyzABC",
    0,
    1,
    1,
    {{3, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-49",
    "[[.a.]-[.z.]][[.a.]-z]*",
    REG_EXTENDED,
    0,
    "ABCabcxyzABC",
    0,
    1,
    1,
    {{3, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-50",
    "[[.a.]-[.a.]][[.a.]-[.a.]]*",
    0,
    0,
    "zaaaaab",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-50",
    "[[.a.]-[.a.]][[.a.]-[.a.]]*",
    REG_EXTENDED,
    0,
    "zaaaaab",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-51",
    "[a-[.a.]][[.a.]-a]*",
    REG_ICASE,
    0,
    "ZAAAAAB",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-51",
    "[a-[.a.]][[.a.]-a]*",
    REG_EXTENDED | REG_ICASE,
    0,
    "ZAAAAAB",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-52",
    "[[.-.]-[.Z.]][[.-.]-[.Z.]]*",
    0,
    0,
    "!ABC-./XYZ~",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-52",
    "[[.-.]-[.Z.]][[.-.]-[.Z.]]*",
    REG_EXTENDED,
    0,
    "!ABC-./XYZ~",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-53",
    "[*--Z][*-[.-.]Z]*",
    0,
    0,
    "!+*,---ZABC",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-53",
    "[*--Z][*-[.-.]Z]*",
    REG_EXTENDED,
    0,
    "!+*,---ZABC",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-54",
    "[[:digit:]a-z#$%][[:digit:]a-z#$%]*",
    0,
    0,
    "__abc#lmn012$x%yz789*",
    0,
    1,
    1,
    {{2, 20}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-54",
    "[[:digit:]a-z#$%][[:digit:]a-z#$%]*",
    REG_EXTENDED,
    0,
    "__abc#lmn012$x%yz789*",
    0,
    1,
    1,
    {{2, 20}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-55",
    "[[:digit:]a-z#$%][[:digit:]a-z#$%]*",
    REG_ICASE,
    0,
    "__abcLMN012x%#$yz789*",
    0,
    1,
    1,
    {{2, 20}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-55",
    "[[:digit:]a-z#$%][[:digit:]a-z#$%]*",
    REG_EXTENDED | REG_ICASE,
    0,
    "__abcLMN012x%#$yz789*",
    0,
    1,
    1,
    {{2, 20}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-56",
    "[^[:digit:]a-z#$%][^[:digit:]a-z#$%]*",
    0,
    0,
    "abc#lmn012$x%yz789--@*,abc",
    0,
    1,
    1,
    {{18, 23}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-56",
    "[^[:digit:]a-z#$%][^[:digit:]a-z#$%]*",
    REG_EXTENDED,
    0,
    "abc#lmn012$x%yz789--@*,abc",
    0,
    1,
    1,
    {{18, 23}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-57",
    "[^[:digit:]a-z#$%][^[:digit:]a-z#$%]*",
    REG_ICASE,
    0,
    "abC#LMn012$x%yz789--@*,abc",
    0,
    1,
    1,
    {{18, 23}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-57",
    "[^[:digit:]a-z#$%][^[:digit:]a-z#$%]*",
    REG_EXTENDED | REG_ICASE,
    0,
    "abC#LMn012$x%yz789--@*,abc",
    0,
    1,
    1,
    {{18, 23}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-58",
    "[^-][^-]*",
    0,
    0,
    "---afd*(&,ml---",
    0,
    1,
    1,
    {{3, 12}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-58",
    "[^-][^-]*",
    REG_EXTENDED,
    0,
    "---afd*(&,ml---",
    0,
    1,
    1,
    {{3, 12}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-59",
    "[^--Z][^--Z]*",
    0,
    0,
    "---AFD*(&,ml---",
    0,
    1,
    1,
    {{6, 12}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-59",
    "[^--Z][^--Z]*",
    REG_EXTENDED,
    0,
    "---AFD*(&,ml---",
    0,
    1,
    1,
    {{6, 12}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-60",
    "[^--Z][^--Z]*",
    REG_ICASE,
    0,
    "---AFD*(&,ml---",
    0,
    1,
    1,
    {{6, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.2-60",
    "[^--Z][^--Z]*",
    REG_EXTENDED | REG_ICASE,
    0,
    "---AFD*(&,ml---",
    0,
    1,
    1,
    {{6, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-0",
    "abc[def]ghi",
    0,
    0,
    "xabcdghiy",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-1",
    "abc\\(\\(de\\)\\(fg\\)\\)hi",
    0,
    0,
    "xabcdefghiy",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-2",
    "abc*def",
    0,
    0,
    "xabdefy",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-3",
    "abc*def",
    0,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-4",
    "abc*def",
    0,
    0,
    "xabcccccccdefy",
    0,
    1,
    1,
    {{1, 13}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-5",
    "abc\\(def\\)*ghi",
    0,
    0,
    "xabcghiy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-6",
    "abc\\(def\\)*ghi",
    0,
    0,
    "xabcdefghi",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-7",
    "abc\\(def\\)*ghi",
    0,
    0,
    "xabcdefdefdefghi",
    0,
    1,
    1,
    {{1, 16}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-8",
    "abc\\{0,1\\}def",
    0,
    0,
    "xabdefy",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-9",
    "abc\\{0,1\\}def",
    0,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-10",
    "abc\\{0,1\\}def",
    0,
    0,
    "xabccdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-11",
    "abc\\{1,3\\}def",
    0,
    0,
    "xabdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-12",
    "abc\\{1,3\\}def",
    0,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-13",
    "abc\\{1,3\\}def",
    0,
    0,
    "xabccdefy",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-14",
    "abc\\{1,3\\}def",
    0,
    0,
    "xabcccdefy",
    0,
    1,
    1,
    {{1, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-15",
    "abc\\{1,3\\}def",
    0,
    0,
    "xabccccdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-16",
    "abc\\{1,\\}def",
    0,
    0,
    "xabdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-17",
    "abc\\{1,\\}def",
    0,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-18",
    "abc\\{1,\\}def",
    0,
    0,
    "xabccdefy",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-19",
    "abc\\{1,\\}def",
    0,
    0,
    "xabcccdefy",
    0,
    1,
    1,
    {{1, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-20",
    "abc\\{1,\\}def",
    0,
    0,
    "xabccccdefy",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-21",
    "abc\\{3\\}def",
    0,
    0,
    "xabdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-22",
    "abc\\{3\\}def",
    0,
    0,
    "xabcdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-23",
    "abc\\{3\\}def",
    0,
    0,
    "xabccdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-24",
    "abc\\{3\\}def",
    0,
    0,
    "xabcccdefy",
    0,
    1,
    1,
    {{1, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-25",
    "abc\\{3\\}def",
    0,
    0,
    "xabccccdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-26",
    "abc\\{ 1,3\\}def",
    0,
    REG_BADBR,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-27",
    "abc\\{1 ,3\\}def",
    0,
    REG_BADBR,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-28",
    "abc\\{1, 3\\}def",
    0,
    REG_BADBR,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-29",
    "abc\\{1,3 \\}def",
    0,
    REG_BADBR,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-30",
    "\\(\\(a*\\)\\)*x\\2",
    0,
    0,
    "ax",
    0,
    1,
    3,
    {{0, 2}, {1, 1}, {1, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-31",
    "\\(\\(a*\\)\\)*x\\2",
    0,
    0,
    "axa",
    0,
    1,
    3,
    {{0, 3}, {0, 1}, {0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-32",
    "\\(\\(abc\\)*\\(abc\\)*\\)\\3",
    0,
    0,
    "abcabc",
    0,
    1,
    4,
    {{0, 6}, {0, 3}, {-1, -1}, {0, 3}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-33",
    "\\(\\(abc\\)\\{0,1\\}\\(abc\\)\\{0,1\\}\\)\\3",
    0,
    0,
    "abcabc",
    0,
    1,
    4,
    {{0, 6}, {0, 3}, {-1, -1}, {0, 3}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-34",
    "\\(\\(abc\\)\\{0,2\\}\\(abc\\)\\{0,2\\}\\)\\3",
    0,
    0,
    "abcabc",
    0,
    1,
    4,
    {{0, 6}, {0, 3}, {-1, -1}, {0, 3}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-35",
    "a\\(b\\)c\\2",
    0,
    REG_ESUBREG,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-36",
    "\\(abc\\)\\1",
    REG_ICASE,
    0,
    "abcabc",
    0,
    1,
    2,
    {{0, 6}, {0, 3}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.3-37",
    "\\(abc\\)\\1",
    REG_ICASE,
    0,
    "aBcAbC",
    0,
    1,
    2,
    {{0, 6}, {0, 3}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-0",
    "^abc",
    0,
    0,
    "abcdef",
    0,
    1,
    1,
    {{0, 3}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-1",
    "^abc",
    0,
    0,
    "xyzabcdef",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-2",
    "^abc",
    0,
    0,
    "\nabcdef",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-3",
    "abc$",
    0,
    0,
    "defabc",
    0,
    1,
    1,
    {{3, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-4",
    "abc$",
    0,
    0,
    "defabc\n",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-5",
    "^abc$",
    0,
    0,
    "abc",
    0,
    1,
    1,
    {{0, 3}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-6",
    "^abc$",
    0,
    0,
    "\nabc\n",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-7",
    "a\\{0,1\\}^bc",
    0,
    0,
    "bc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-8",
    "a\\{0,1\\}^bc",
    0,
    0,
    "^bc",
    0,
    1,
    1,
    {{0, 3}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-9",
    "a\\{0,1\\}^bc",
    0,
    0,
    "a^bc",
    0,
    1,
    1,
    {{0, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-10",
    "a^bc",
    0,
    0,
    "abc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-11",
    "a^bc",
    0,
    0,
    "a^bc",
    0,
    1,
    1,
    {{0, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-12",
    "ab$c\\{0,1\\}",
    0,
    0,
    "ab",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-13",
    "ab$c\\{0,1\\}",
    0,
    0,
    "ab$",
    0,
    1,
    1,
    {{0, 3}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-14",
    "ab$c\\{0,1\\}",
    0,
    0,
    "ab$c",
    0,
    1,
    1,
    {{0, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-15",
    "ab$c",
    0,
    0,
    "abc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-16",
    "ab$c",
    0,
    0,
    "ab\nc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-17",
    "ab$c",
    0,
    0,
    "ab$",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.3.5-18",
    "ab$c",
    0,
    0,
    "ab$c",
    0,
    1,
    1,
    {{0, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.1-0",
    "a",
    REG_EXTENDED,
    0,
    "a",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-0",
    "\\.",
    REG_EXTENDED,
    0,
    "a.b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-1",
    "\\[",
    REG_EXTENDED,
    0,
    "a[b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-2",
    "\\\\",
    REG_EXTENDED,
    0,
    "a\\b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-3",
    "\\(",
    REG_EXTENDED,
    0,
    "a(b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-4",
    "\\*",
    REG_EXTENDED,
    0,
    "a*b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-5",
    "\\+",
    REG_EXTENDED,
    0,
    "a+b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-6",
    "\\?",
    REG_EXTENDED,
    0,
    "a?b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-7",
    "\\|",
    REG_EXTENDED,
    0,
    "a|b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-8",
    "\\^",
    REG_EXTENDED,
    0,
    "a^b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.2-9",
    "\\$",
    REG_EXTENDED,
    0,
    "a$b",
    0,
    1,
    1,
    {{1, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.3-0",
    ".",
    REG_EXTENDED,
    0,
    "a",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.1.3-1",
    ".",
    REG_EXTENDED,
    0,
    "\n",
    0,
    1,
    1,
    {{0, 1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-0",
    "abc[def]ghi",
    REG_EXTENDED,
    0,
    "xabcdghiy",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-1",
    "abc((de)(fg))hi",
    REG_EXTENDED,
    0,
    "xabcdefghiy",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-2",
    "abc*def",
    REG_EXTENDED,
    0,
    "xabdefy",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-3",
    "abc*def",
    REG_EXTENDED,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-4",
    "abc*def",
    REG_EXTENDED,
    0,
    "xabcccccccdefy",
    0,
    1,
    1,
    {{1, 13}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-5",
    "abc(def)*ghi",
    REG_EXTENDED,
    0,
    "xabcghiy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-6",
    "abc(def)*ghi",
    REG_EXTENDED,
    0,
    "xabcdefghi",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-7",
    "abc(def)*ghi",
    REG_EXTENDED,
    0,
    "xabcdefdefdefghi",
    0,
    1,
    1,
    {{1, 16}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-8",
    "abc+def",
    REG_EXTENDED,
    0,
    "xabdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-9",
    "abc+def",
    REG_EXTENDED,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-10",
    "abc+def",
    REG_EXTENDED,
    0,
    "xabcccccccdefy",
    0,
    1,
    1,
    {{1, 13}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-11",
    "abc(def)+ghi",
    REG_EXTENDED,
    0,
    "xabcghiy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-12",
    "abc(def)+ghi",
    REG_EXTENDED,
    0,
    "xabcdefghi",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-13",
    "abc(def)+ghi",
    REG_EXTENDED,
    0,
    "xabcdefdefdefghi",
    0,
    1,
    1,
    {{1, 16}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-14",
    "abc?def",
    REG_EXTENDED,
    0,
    "xabdefy",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-15",
    "abc?def",
    REG_EXTENDED,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-16",
    "abc?def",
    REG_EXTENDED,
    0,
    "xabcccccccdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-17",
    "abc(def)?ghi",
    REG_EXTENDED,
    0,
    "xabcghiy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-18",
    "abc(def)?ghi",
    REG_EXTENDED,
    0,
    "xabcdefghi",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-19",
    "abc(def)?ghi",
    REG_EXTENDED,
    0,
    "xabcdefdefdefghi",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-20",
    "abc{0,1}def",
    REG_EXTENDED,
    0,
    "xabdefy",
    0,
    1,
    1,
    {{1, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-21",
    "abc{0,1}def",
    REG_EXTENDED,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-22",
    "abc{0,1}def",
    REG_EXTENDED,
    0,
    "xabccdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-23",
    "abc{1,3}def",
    REG_EXTENDED,
    0,
    "xabdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-24",
    "abc{1,3}def",
    REG_EXTENDED,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-25",
    "abc{1,3}def",
    REG_EXTENDED,
    0,
    "xabccdefy",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-26",
    "abc{1,3}def",
    REG_EXTENDED,
    0,
    "xabcccdefy",
    0,
    1,
    1,
    {{1, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-27",
    "abc{1,3}def",
    REG_EXTENDED,
    0,
    "xabccccdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-28",
    "abc{1,}def",
    REG_EXTENDED,
    0,
    "xabdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-29",
    "abc{1,}def",
    REG_EXTENDED,
    0,
    "xabcdefy",
    0,
    1,
    1,
    {{1, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-30",
    "abc{1,}def",
    REG_EXTENDED,
    0,
    "xabccdefy",
    0,
    1,
    1,
    {{1, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-31",
    "abc{1,}def",
    REG_EXTENDED,
    0,
    "xabcccdefy",
    0,
    1,
    1,
    {{1, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-32",
    "abc{1,}def",
    REG_EXTENDED,
    0,
    "xabccccdefy",
    0,
    1,
    1,
    {{1, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-33",
    "abc{3}def",
    REG_EXTENDED,
    0,
    "xabdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-34",
    "abc{3}def",
    REG_EXTENDED,
    0,
    "xabcdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-35",
    "abc{3}def",
    REG_EXTENDED,
    0,
    "xabccdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-36",
    "abc{3}def",
    REG_EXTENDED,
    0,
    "xabcccdefy",
    0,
    1,
    1,
    {{1, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-37",
    "abc{3}def",
    REG_EXTENDED,
    0,
    "xabccccdefy",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-38",
    "abc{ 1,3}def",
    REG_EXTENDED,
    REG_BADBR,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-39",
    "abc{1 ,3}def",
    REG_EXTENDED,
    REG_BADBR,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-40",
    "abc{1, 3}def",
    REG_EXTENDED,
    REG_BADBR,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-41",
    "abc{1,3 }def",
    REG_EXTENDED,
    REG_BADBR,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-42",
    "(wee|week)(night|knights)s*",
    REG_EXTENDED,
    0,
    "weeknights",
    0,
    1,
    3,
    {{0, 10}, {0, 3}, {3, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-43",
    "(a|aaa)*",
    REG_EXTENDED,
    0,
    "aaaa",
    0,
    1,
    2,
    {{0, 4}, {1, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-44",
    "(a|aaa){0,100}",
    REG_EXTENDED,
    0,
    "aaaa",
    0,
    1,
    2,
    {{0, 4}, {1, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-45",
    "(wee|week)(night|knights)(s*)",
    REG_EXTENDED,
    0,
    "weeknights",
    0,
    1,
    4,
    {{0, 10}, {0, 3}, {3, 10}, {10, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-46",
    "(week|wee)(knights|night)",
    REG_EXTENDED,
    0,
    "weeknights",
    0,
    1,
    3,
    {{0, 10}, {0, 3}, {3, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-47",
    "(aaa|a)+",
    REG_EXTENDED,
    0,
    "aaaa",
    0,
    1,
    2,
    {{0, 4}, {1, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-48",
    "(a*)*x\\1",
    REG_EXTENDED,
    0,
    "aaaax",
    0,
    1,
    2,
    {{0, 5}, {4, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-49",
    "(a*)*x\\1(a*)",
    REG_EXTENDED,
    0,
    "aaaaxaa",
    0,
    1,
    3,
    {{0, 7}, {2, 4}, {7, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-50",
    "(a*)*x(\\1a*)",
    REG_EXTENDED,
    0,
    "aaaaxaa",
    0,
    1,
    3,
    {{0, 7}, {2, 4}, {5, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-51",
    "(a*)*x(\\1x)*(.*)",
    REG_EXTENDED,
    0,
    "aaaaxxyy",
    0,
    1,
    4,
    {{0, 8}, {4, 4}, {5, 6}, {6, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-52",
    "(a{0,}){0,}x\\1",
    REG_EXTENDED,
    0,
    "aaaax",
    0,
    1,
    2,
    {{0, 5}, {4, 4}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-53",
    "(a{0,}){0,}x\\1(a{0,})",
    REG_EXTENDED,
    0,
    "aaaaxaa",
    0,
    1,
    3,
    {{0, 7}, {2, 4}, {7, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.3-54",
    "(a{0,}){0,}x(\\1x){0,}(.{0,})",
    REG_EXTENDED,
    0,
    "aaaaxxyy",
    0,
    1,
    4,
    {{0, 8}, {4, 4}, {5, 6}, {6, 8}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-0",
    "a{0,1}^bc",
    REG_EXTENDED,
    0,
    "bc",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-1",
    "a{0,1}^bc",
    REG_EXTENDED,
    0,
    "^bc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-2",
    "a{0,1}^bc",
    REG_EXTENDED,
    0,
    "a^bc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-3",
    "a^bc",
    REG_EXTENDED,
    0,
    "abc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-4",
    "a^bc",
    REG_EXTENDED,
    0,
    "a^bc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-5",
    "ab$c{0,1}",
    REG_EXTENDED,
    0,
    "ab",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-6",
    "ab$c{0,1}",
    REG_EXTENDED,
    0,
    "ab$",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-7",
    "ab$c{0,1}",
    REG_EXTENDED,
    0,
    "ab$c",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-8",
    "ab$c",
    REG_EXTENDED,
    0,
    "abc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-9",
    "ab$c",
    REG_EXTENDED,
    0,
    "ab\nc",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-10",
    "ab$c",
    REG_EXTENDED,
    0,
    "ab$",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-2.8.4.6-11",
    "ab$c",
    REG_EXTENDED,
    0,
    "ab$c",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-0",
    "xx",
    REG_ICASE,
    0,
    "xX",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-0",
    "xx",
    REG_EXTENDED | REG_ICASE,
    0,
    "xX",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-1",
    "xX",
    REG_ICASE,
    0,
    "xx",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-1",
    "xX",
    REG_EXTENDED | REG_ICASE,
    0,
    "xx",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-2",
    "x x",
    REG_ICASE,
    0,
    "x X",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-2",
    "x x",
    REG_EXTENDED | REG_ICASE,
    0,
    "x X",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-3",
    "x X",
    REG_ICASE,
    0,
    "x x",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-3",
    "x X",
    REG_EXTENDED | REG_ICASE,
    0,
    "x x",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-4",
    "x X",
    REG_ICASE,
    0,
    "x y x",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-case-4",
    "x X",
    REG_EXTENDED | REG_ICASE,
    0,
    "x y x",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-0",
    "^*x",
    REG_NOSUB,
    0,
    "*x",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-1",
    "\\(*x\\)",
    REG_NOSUB,
    0,
    "*x",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-3",
    "*x",
    REG_NOSUB,
    0,
    "*x",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-4",
    "a\\{2,5\\}",
    REG_NOSUB,
    0,
    "a",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-5",
    "a{2,5}",
    REG_EXTENDED | REG_NOSUB,
    0,
    "a",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-6",
    "a\\{2,5\\}",
    REG_NOSUB,
    0,
    "aa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-7",
    "a{2,5}",
    REG_EXTENDED | REG_NOSUB,
    0,
    "aa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-8",
    "a\\{2,5\\}",
    REG_NOSUB,
    0,
    "aaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-9",
    "a{2,5}",
    REG_EXTENDED | REG_NOSUB,
    0,
    "aaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-10",
    "a\\{2,5\\}",
    REG_NOSUB,
    0,
    "aaaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-11",
    "a{2,5}",
    REG_EXTENDED | REG_NOSUB,
    0,
    "aaaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-12",
    "a\\{2,5\\}",
    REG_NOSUB,
    0,
    "aaaaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-13",
    "a{2,5}",
    REG_EXTENDED | REG_NOSUB,
    0,
    "aaaaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-14",
    "a\\{2,5\\}",
    REG_NOSUB,
    0,
    "aaaaaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-15",
    "a{2,5}",
    REG_EXTENDED | REG_NOSUB,
    0,
    "aaaaaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-16",
    "(abcd){10,11}",
    REG_EXTENDED | REG_NOSUB,
    0,
    "abcd",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-nosub-17",
    "back-tracking oriented stream-of-solution functions",
    REG_EXTENDED | REG_NOSUB,
    0,
    "in the spec, and the back-tracking oriented stream-of-solution functions",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-0",
    "^abc",
    0,
    0,
    "abcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-0",
    "^abc",
    REG_EXTENDED,
    0,
    "abcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-1",
    "^abc",
    0,
    0,
    "xyz\nabcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-1",
    "^abc",
    REG_EXTENDED,
    0,
    "xyz\nabcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-2",
    "^abc",
    0,
    0,
    "xyzabcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-2",
    "^abc",
    REG_EXTENDED,
    0,
    "xyzabcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-3",
    "^abc",
    0,
    0,
    "\nabcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-3",
    "^abc",
    REG_EXTENDED,
    0,
    "\nabcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-4",
    "abc$",
    0,
    0,
    "defabc",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-4",
    "abc$",
    REG_EXTENDED,
    0,
    "defabc",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-5",
    "abc$",
    0,
    0,
    "defabc\nghi",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-5",
    "abc$",
    REG_EXTENDED,
    0,
    "defabc\nghi",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-6",
    "abc$",
    0,
    0,
    "defabc\n",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-6",
    "abc$",
    REG_EXTENDED,
    0,
    "defabc\n",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-7",
    "^abc$",
    0,
    0,
    "abc",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-7",
    "^abc$",
    REG_EXTENDED,
    0,
    "abc",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-8",
    "^abc$",
    0,
    0,
    "abc",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-8",
    "^abc$",
    REG_EXTENDED,
    0,
    "abc",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-9",
    "^abc$",
    0,
    0,
    "abc",
    REG_NOTBOL | REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-9",
    "^abc$",
    REG_EXTENDED,
    0,
    "abc",
    REG_NOTBOL | REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-10",
    "^abc$",
    0,
    0,
    "\nabc\n",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-10",
    "^abc$",
    REG_EXTENDED,
    0,
    "\nabc\n",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-11",
    "^abc$",
    0,
    0,
    "\nabc\n",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-11",
    "^abc$",
    REG_EXTENDED,
    0,
    "\nabc\n",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-12",
    "^abc$",
    0,
    0,
    "\nabc\n",
    REG_NOTBOL | REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-not_ol-12",
    "^abc$",
    REG_EXTENDED,
    0,
    "\nabc\n",
    REG_NOTBOL | REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-0",
    "^a(b)*c",
    REG_EXTENDED,
    0,
    "abcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-1",
    "^a(b)*c",
    REG_EXTENDED,
    0,
    "xyz\nabcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-2",
    "^a(b)*c",
    REG_EXTENDED,
    0,
    "xyzabcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-3",
    "^a(b)*c",
    REG_EXTENDED,
    0,
    "\nabcdef",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-4",
    "a(b)*c$",
    REG_EXTENDED,
    0,
    "defabc",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-5",
    "a(b)*c$",
    REG_EXTENDED,
    0,
    "defabc\nghi",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-6",
    "a(b)*c$",
    REG_EXTENDED,
    0,
    "defabc\n",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-7",
    "^a(b)*c$",
    REG_EXTENDED,
    0,
    "abc",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-8",
    "^a(b)*c$",
    REG_EXTENDED,
    0,
    "abc",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-9",
    "^a(b)*c$",
    REG_EXTENDED,
    0,
    "abc",
    REG_NOTBOL | REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-10",
    "^a(b)*c$",
    REG_EXTENDED,
    0,
    "\nabc\n",
    REG_NOTBOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-11",
    "^a(b)*c$",
    REG_EXTENDED,
    0,
    "\na(b)*c\n",
    REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-not_ol-12",
    "^a(b)*c$",
    REG_EXTENDED,
    0,
    "\nabc\n",
    REG_NOTBOL | REG_NOTEOL,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-0",
    ".",
    0,
    0,
    "\n",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-0",
    ".",
    REG_EXTENDED,
    0,
    "\n",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-1",
    ".",
    REG_NEWLINE,
    0,
    "\n",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-1",
    ".",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "\n",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-2",
    "^abc",
    REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    1,
    {{4, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-2",
    "^abc",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    1,
    {{4, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-3",
    "^abc",
    REG_NEWLINE,
    0,
    "xyz\nxabcdef\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-3",
    "^abc",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nxabcdef\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-4",
    "z$\nabc",
    REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-5",
    "z$\nabc",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    1,
    {{2, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-6",
    "^abc",
    REG_NEWLINE,
    0,
    "abc\nabcdef\nxyz",
    REG_NOTBOL,
    1,
    1,
    {{4, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-6",
    "^abc",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "abc\nabcdef\nxyz",
    REG_NOTBOL,
    1,
    1,
    {{4, 7}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-7",
    "def$",
    REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    1,
    {{7, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-7",
    "def$",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    1,
    {{7, 10}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-8",
    "def$",
    REG_NEWLINE,
    0,
    "xyz\nxabcdefx\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-8",
    "def$",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nxabcdefx\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-9",
    "def$\nx",
    REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-newline-10",
    "def$\nx",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    1,
    {{7, 12}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-newline-2",
    "^a(b)*c",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    2,
    {{4, 7}, {5, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-newline-3",
    "^a(b)*c",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nxabcdef\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-newline-4",
    "z$\na(b)*c",
    REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-newline-5",
    "z$\na(b)*c",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    2,
    {{2, 7}, {5, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-newline-6",
    "^a(b)*c",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "abc\nabcdef\nxyz",
    REG_NOTBOL,
    1,
    2,
    {{4, 7}, {5, 6}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-newline-7",
    "d(e)f$",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    2,
    {{7, 10}, {8, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-newline-8",
    "d(e)f$",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nxabcdefx\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-newline-9",
    "d(e)f$\nx",
    REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-complex-newline-10",
    "d(e)f$\nx",
    REG_EXTENDED | REG_NEWLINE,
    0,
    "xyz\nabcdef\nxyz",
    0,
    1,
    2,
    {{7, 12}, {8, 9}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-0",
    "^*x",
    0,
    0,
    "*x",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-1",
    "\\(*x\\)",
    0,
    0,
    "*x",
    0,
    1,
    2,
    {{0, 2}, {0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-2",
    "*x",
    0,
    0,
    "*x",
    0,
    1,
    1,
    {{0, 2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-3",
    "a\\{2,5\\}",
    0,
    0,
    "a",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-4",
    "a\\{2,5\\}",
    0,
    0,
    "aa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-5",
    "a\\{2,5\\}",
    0,
    0,
    "aaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-6",
    "a\\{2,5\\}",
    0,
    0,
    "aaaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-7",
    "a\\{2,5\\}",
    0,
    0,
    "aaaaa",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-8",
    "a\\{2,5\\}",
    0,
    0,
    "aaaaaa",
    0,
    1,
    1,
    {{0, 5}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-9",
    "(abcd){10,11}",
    REG_EXTENDED,
    0,
    "abcd",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-10",
    "(abcd){9223372036854775808}",
    REG_EXTENDED,
    REG_BADBR,
    "",
    0,
    0,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-11",
    "back-tracking oriented stream-of-solution functions",
    REG_EXTENDED,
    0,
    "in the spec, and the back-tracking oriented stream-of-solution functions",
    0,
    1,
    0,
    {{-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {
    "posix-check-13",
    "\\(\\([-[:alnum:]]*\\)\\([-[:alnum:]][-[:alnum:]][-[:alnum:]]*\\)\\)--.*--\\(\\3\\)",
    0,
    0,
    "abcq--xyz--cq--abcq--xyz--foo--aqbc--xyz--sdlfj--abcq--sdlfq",
    0,
    1,
    5,
    {{0, 53}, {0, 19}, {0, 15}, {15, 19}, {49, 53}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}}
  },
  {0, 0, 0, 0, 0, 0, 0, 0, {{0, 0}}}
};
