#include <iostream>
#include <ctype.h>

#include "PointConfiguration.hh"

int main(const int argc, const char** argv) {
  using namespace topcom;

  if (argc < 3) {
    MessageStreams::forced() << "usage: " << argv[0] << " n d" << std::endl;
    return 1;
  }
  size_type n = atoi(argv[1]);
  size_type d = atoi(argv[2]);
  if (n <= d) {
    MessageStreams::forced() << "n > d required" << std::endl;
    return 1;
  }
  PointConfiguration cyclic;
  for (size_type i = 0; i < n; ++i) {
    Vector column(d + 1);
    Field entry((long)(i));
    for (size_type j = 0; j < d; ++j) {
      column[j] = entry;
      entry *= i;
    }
    column[d] = FieldConstants::ONE;
    cyclic.push_back(column);
  }
  MessageStreams::result() << cyclic << std::endl;
  MessageStreams::result() << "[";
  if (d % 2 == 0) {
    MessageStreams::result() << "[" << n - 1 ;
    for (size_type i = 0; i < n - 1; ++i) {
      MessageStreams::result() << ',' << i;
    }
    MessageStreams::result() << "],";
  }
  MessageStreams::result() << "[";
  for (size_type i = 0; i < n - 1; ++i) {
    MessageStreams::result() << n - i - 1 << ',';
  }
  MessageStreams::result() << "0]]" << std::endl;
  return 0;
}

// eof cyclic.cc
