#include <iostream>

#include "CommandlineOptions.hh"

#include "PointConfiguration.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing the volume of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  PointConfiguration points;
  if (std::cin >> points) {
    if ((points.no() < 2) || (points.rank() < 2)) {
      MessageStreams::forced() << "no of points and rank must be at least two." << std::endl;
      return 1;
    }
    if (points.rank() > points.no()) {
      MessageStreams::forced() << "rank must not be larger than no of points." << std::endl;
      return 1;
    }
    MessageStreams::result() << points.volume() << std::endl;
    return 0;
  }
  else {
    MessageStreams::forced() << "points2volume: error while reading point configuration."
			     << std::endl;
    return 1;
  }
}

// eof points2volume.cc
