// Code generated by 'go generate'; DO NOT EDIT.

package iphlpapi

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return nil
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modiphlpapi = windows.NewLazySystemDLL("iphlpapi.dll")

	procAddIPAddress    = modiphlpapi.NewProc("AddIPAddress")
	procDeleteIPAddress = modiphlpapi.NewProc("DeleteIPAddress")
)

func AddIPAddress(Address uint32, IpMask uint32, IfIndex uint32, NTEContext *uint32, NTEInstance *uint32) (errcode error) {
	r0, _, _ := syscall.Syscall6(procAddIPAddress.Addr(), 5, uintptr(Address), uintptr(IpMask), uintptr(IfIndex), uintptr(unsafe.Pointer(NTEContext)), uintptr(unsafe.Pointer(NTEInstance)), 0)
	if r0 != 0 {
		errcode = syscall.Errno(r0)
	}
	return
}

func DeleteIPAddress(NTEContext uint32) (errcode error) {
	r0, _, _ := syscall.Syscall(procDeleteIPAddress.Addr(), 1, uintptr(NTEContext), 0, 0)
	if r0 != 0 {
		errcode = syscall.Errno(r0)
	}
	return
}
