/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_DESCRIPTOR_UPDATE_TEMPLATE_H
#define VN_PROTOCOL_RENDERER_DESCRIPTOR_UPDATE_TEMPLATE_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/* struct VkDescriptorUpdateTemplateEntry */

static inline void
vn_decode_VkDescriptorUpdateTemplateEntry_temp(struct vn_cs_decoder *dec, VkDescriptorUpdateTemplateEntry *val)
{
    vn_decode_uint32_t(dec, &val->dstBinding);
    vn_decode_uint32_t(dec, &val->dstArrayElement);
    vn_decode_uint32_t(dec, &val->descriptorCount);
    vn_decode_VkDescriptorType(dec, &val->descriptorType);
    vn_decode_size_t(dec, &val->offset);
    vn_decode_size_t(dec, &val->stride);
}

static inline void
vn_replace_VkDescriptorUpdateTemplateEntry_handle(VkDescriptorUpdateTemplateEntry *val)
{
    /* skip val->dstBinding */
    /* skip val->dstArrayElement */
    /* skip val->descriptorCount */
    /* skip val->descriptorType */
    /* skip val->offset */
    /* skip val->stride */
}

/* struct VkDescriptorUpdateTemplateCreateInfo chain */

static inline void *
vn_decode_VkDescriptorUpdateTemplateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDescriptorUpdateTemplateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDescriptorUpdateTemplateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->descriptorUpdateEntryCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->descriptorUpdateEntryCount);
        val->pDescriptorUpdateEntries = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDescriptorUpdateEntries) * iter_count);
        if (!val->pDescriptorUpdateEntries) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDescriptorUpdateTemplateEntry_temp(dec, &((VkDescriptorUpdateTemplateEntry *)val->pDescriptorUpdateEntries)[i]);
    } else {
        vn_decode_array_size(dec, val->descriptorUpdateEntryCount);
        val->pDescriptorUpdateEntries = NULL;
    }
    vn_decode_VkDescriptorUpdateTemplateType(dec, &val->templateType);
    vn_decode_VkDescriptorSetLayout_lookup(dec, &val->descriptorSetLayout);
    vn_decode_VkPipelineBindPoint(dec, &val->pipelineBindPoint);
    vn_decode_VkPipelineLayout_lookup(dec, &val->pipelineLayout);
    vn_decode_uint32_t(dec, &val->set);
}

static inline void
vn_decode_VkDescriptorUpdateTemplateCreateInfo_temp(struct vn_cs_decoder *dec, VkDescriptorUpdateTemplateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDescriptorUpdateTemplateCreateInfo_pnext_temp(dec);
    vn_decode_VkDescriptorUpdateTemplateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDescriptorUpdateTemplateCreateInfo_handle_self(VkDescriptorUpdateTemplateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->descriptorUpdateEntryCount */
    if (val->pDescriptorUpdateEntries) {
       for (uint32_t i = 0; i < val->descriptorUpdateEntryCount; i++)
            vn_replace_VkDescriptorUpdateTemplateEntry_handle(&((VkDescriptorUpdateTemplateEntry *)val->pDescriptorUpdateEntries)[i]);
    }
    /* skip val->templateType */
    vn_replace_VkDescriptorSetLayout_handle(&val->descriptorSetLayout);
    /* skip val->pipelineBindPoint */
    vn_replace_VkPipelineLayout_handle(&val->pipelineLayout);
    /* skip val->set */
}

static inline void
vn_replace_VkDescriptorUpdateTemplateCreateInfo_handle(VkDescriptorUpdateTemplateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO:
            vn_replace_VkDescriptorUpdateTemplateCreateInfo_handle_self((VkDescriptorUpdateTemplateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkCreateDescriptorUpdateTemplate_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateDescriptorUpdateTemplate *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfo));
        if (!args->pCreateInfo) return;
        vn_decode_VkDescriptorUpdateTemplateCreateInfo_temp(dec, (VkDescriptorUpdateTemplateCreateInfo *)args->pCreateInfo);
    } else {
        args->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pDescriptorUpdateTemplate = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDescriptorUpdateTemplate));
        if (!args->pDescriptorUpdateTemplate) return;
        vn_decode_VkDescriptorUpdateTemplate(dec, args->pDescriptorUpdateTemplate);
    } else {
        args->pDescriptorUpdateTemplate = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCreateDescriptorUpdateTemplate_args_handle(struct vn_command_vkCreateDescriptorUpdateTemplate *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCreateInfo)
        vn_replace_VkDescriptorUpdateTemplateCreateInfo_handle((VkDescriptorUpdateTemplateCreateInfo *)args->pCreateInfo);
    /* skip args->pAllocator */
    /* skip args->pDescriptorUpdateTemplate */
}

static inline void vn_encode_vkCreateDescriptorUpdateTemplate_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateDescriptorUpdateTemplate *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateDescriptorUpdateTemplate_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCreateInfo */
    /* skip args->pAllocator */
    if (vn_encode_simple_pointer(enc, args->pDescriptorUpdateTemplate))
        vn_encode_VkDescriptorUpdateTemplate(enc, args->pDescriptorUpdateTemplate);
}

static inline void vn_decode_vkDestroyDescriptorUpdateTemplate_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyDescriptorUpdateTemplate *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkDescriptorUpdateTemplate_lookup(dec, &args->descriptorUpdateTemplate);
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyDescriptorUpdateTemplate_args_handle(struct vn_command_vkDestroyDescriptorUpdateTemplate *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkDescriptorUpdateTemplate_handle(&args->descriptorUpdateTemplate);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyDescriptorUpdateTemplate_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyDescriptorUpdateTemplate *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyDescriptorUpdateTemplate_EXT});

    /* skip args->device */
    /* skip args->descriptorUpdateTemplate */
    /* skip args->pAllocator */
}

static inline void vn_dispatch_vkCreateDescriptorUpdateTemplate(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateDescriptorUpdateTemplate args;

    if (!ctx->dispatch_vkCreateDescriptorUpdateTemplate) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateDescriptorUpdateTemplate_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateDescriptorUpdateTemplate(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateDescriptorUpdateTemplate returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCreateDescriptorUpdateTemplate_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDestroyDescriptorUpdateTemplate(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyDescriptorUpdateTemplate args;

    if (!ctx->dispatch_vkDestroyDescriptorUpdateTemplate) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyDescriptorUpdateTemplate_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyDescriptorUpdateTemplate(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkDestroyDescriptorUpdateTemplate_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_DESCRIPTOR_UPDATE_TEMPLATE_H */
