// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(cmp)                       \
  M(mov)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  int32_t immediate;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] = {{{vc, r1, 111}, true, vc, "vc r1 111", "vc_r1_111"},
                           {{ne, r1, 134}, true, ne, "ne r1 134", "ne_r1_134"},
                           {{ne, r5, 21}, true, ne, "ne r5 21", "ne_r5_21"},
                           {{cs, r6, 221}, true, cs, "cs r6 221", "cs_r6_221"},
                           {{cs, r3, 100}, true, cs, "cs r3 100", "cs_r3_100"},
                           {{le, r2, 209}, true, le, "le r2 209", "le_r2_209"},
                           {{ls, r7, 8}, true, ls, "ls r7 8", "ls_r7_8"},
                           {{cs, r7, 201}, true, cs, "cs r7 201", "cs_r7_201"},
                           {{ne, r3, 112}, true, ne, "ne r3 112", "ne_r3_112"},
                           {{lt, r4, 152}, true, lt, "lt r4 152", "lt_r4_152"},
                           {{mi, r4, 165}, true, mi, "mi r4 165", "mi_r4_165"},
                           {{eq, r6, 175}, true, eq, "eq r6 175", "eq_r6_175"},
                           {{hi, r3, 187}, true, hi, "hi r3 187", "hi_r3_187"},
                           {{ne, r0, 192}, true, ne, "ne r0 192", "ne_r0_192"},
                           {{vc, r7, 207}, true, vc, "vc r7 207", "vc_r7_207"},
                           {{vs, r3, 135}, true, vs, "vs r3 135", "vs_r3_135"},
                           {{cs, r4, 204}, true, cs, "cs r4 204", "cs_r4_204"},
                           {{gt, r0, 122}, true, gt, "gt r0 122", "gt_r0_122"},
                           {{lt, r4, 185}, true, lt, "lt r4 185", "lt_r4_185"},
                           {{eq, r2, 187}, true, eq, "eq r2 187", "eq_r2_187"},
                           {{ne, r5, 226}, true, ne, "ne r5 226", "ne_r5_226"},
                           {{ge, r1, 250}, true, ge, "ge r1 250", "ge_r1_250"},
                           {{lt, r7, 97}, true, lt, "lt r7 97", "lt_r7_97"},
                           {{cs, r4, 21}, true, cs, "cs r4 21", "cs_r4_21"},
                           {{vc, r0, 217}, true, vc, "vc r0 217", "vc_r0_217"},
                           {{mi, r1, 81}, true, mi, "mi r1 81", "mi_r1_81"},
                           {{cc, r5, 156}, true, cc, "cc r5 156", "cc_r5_156"},
                           {{ne, r7, 171}, true, ne, "ne r7 171", "ne_r7_171"},
                           {{vs, r2, 252}, true, vs, "vs r2 252", "vs_r2_252"},
                           {{lt, r4, 103}, true, lt, "lt r4 103", "lt_r4_103"},
                           {{ge, r6, 203}, true, ge, "ge r6 203", "ge_r6_203"},
                           {{ne, r4, 234}, true, ne, "ne r4 234", "ne_r4_234"},
                           {{mi, r2, 27}, true, mi, "mi r2 27", "mi_r2_27"},
                           {{ne, r4, 224}, true, ne, "ne r4 224", "ne_r4_224"},
                           {{gt, r3, 124}, true, gt, "gt r3 124", "gt_r3_124"},
                           {{lt, r4, 49}, true, lt, "lt r4 49", "lt_r4_49"},
                           {{gt, r1, 201}, true, gt, "gt r1 201", "gt_r1_201"},
                           {{ge, r4, 133}, true, ge, "ge r4 133", "ge_r4_133"},
                           {{hi, r4, 176}, true, hi, "hi r4 176", "hi_r4_176"},
                           {{pl, r3, 94}, true, pl, "pl r3 94", "pl_r3_94"},
                           {{le, r2, 69}, true, le, "le r2 69", "le_r2_69"},
                           {{hi, r0, 145}, true, hi, "hi r0 145", "hi_r0_145"},
                           {{ne, r1, 119}, true, ne, "ne r1 119", "ne_r1_119"},
                           {{hi, r0, 124}, true, hi, "hi r0 124", "hi_r0_124"},
                           {{vc, r6, 221}, true, vc, "vc r6 221", "vc_r6_221"},
                           {{cs, r2, 71}, true, cs, "cs r2 71", "cs_r2_71"},
                           {{eq, r0, 87}, true, eq, "eq r0 87", "eq_r0_87"},
                           {{cc, r3, 42}, true, cc, "cc r3 42", "cc_r3_42"},
                           {{cs, r7, 98}, true, cs, "cs r7 98", "cs_r7_98"},
                           {{vc, r3, 28}, true, vc, "vc r3 28", "vc_r3_28"},
                           {{eq, r4, 94}, true, eq, "eq r4 94", "eq_r4_94"},
                           {{gt, r7, 84}, true, gt, "gt r7 84", "gt_r7_84"},
                           {{hi, r3, 101}, true, hi, "hi r3 101", "hi_r3_101"},
                           {{pl, r5, 197}, true, pl, "pl r5 197", "pl_r5_197"},
                           {{pl, r6, 214}, true, pl, "pl r6 214", "pl_r6_214"},
                           {{hi, r7, 32}, true, hi, "hi r7 32", "hi_r7_32"},
                           {{ge, r7, 217}, true, ge, "ge r7 217", "ge_r7_217"},
                           {{cc, r3, 21}, true, cc, "cc r3 21", "cc_r3_21"},
                           {{le, r2, 216}, true, le, "le r2 216", "le_r2_216"},
                           {{le, r5, 199}, true, le, "le r5 199", "le_r5_199"},
                           {{cc, r3, 162}, true, cc, "cc r3 162", "cc_r3_162"},
                           {{cs, r5, 39}, true, cs, "cs r5 39", "cs_r5_39"},
                           {{cc, r5, 204}, true, cc, "cc r5 204", "cc_r5_204"},
                           {{ge, r1, 182}, true, ge, "ge r1 182", "ge_r1_182"},
                           {{ne, r5, 12}, true, ne, "ne r5 12", "ne_r5_12"},
                           {{lt, r4, 39}, true, lt, "lt r4 39", "lt_r4_39"},
                           {{vc, r5, 205}, true, vc, "vc r5 205", "vc_r5_205"},
                           {{cc, r7, 36}, true, cc, "cc r7 36", "cc_r7_36"},
                           {{pl, r1, 121}, true, pl, "pl r1 121", "pl_r1_121"},
                           {{lt, r3, 206}, true, lt, "lt r3 206", "lt_r3_206"},
                           {{ne, r5, 130}, true, ne, "ne r5 130", "ne_r5_130"},
                           {{pl, r2, 84}, true, pl, "pl r2 84", "pl_r2_84"},
                           {{pl, r5, 180}, true, pl, "pl r5 180", "pl_r5_180"},
                           {{ne, r1, 126}, true, ne, "ne r1 126", "ne_r1_126"},
                           {{ge, r5, 91}, true, ge, "ge r5 91", "ge_r5_91"},
                           {{pl, r6, 48}, true, pl, "pl r6 48", "pl_r6_48"},
                           {{mi, r3, 241}, true, mi, "mi r3 241", "mi_r3_241"},
                           {{le, r3, 197}, true, le, "le r3 197", "le_r3_197"},
                           {{gt, r3, 154}, true, gt, "gt r3 154", "gt_r3_154"},
                           {{vc, r1, 31}, true, vc, "vc r1 31", "vc_r1_31"},
                           {{ls, r4, 218}, true, ls, "ls r4 218", "ls_r4_218"},
                           {{ne, r0, 237}, true, ne, "ne r0 237", "ne_r0_237"},
                           {{ge, r0, 171}, true, ge, "ge r0 171", "ge_r0_171"},
                           {{cc, r7, 102}, true, cc, "cc r7 102", "cc_r7_102"},
                           {{ge, r5, 245}, true, ge, "ge r5 245", "ge_r5_245"},
                           {{ne, r4, 28}, true, ne, "ne r4 28", "ne_r4_28"},
                           {{cs, r7, 186}, true, cs, "cs r7 186", "cs_r7_186"},
                           {{ls, r0, 30}, true, ls, "ls r0 30", "ls_r0_30"},
                           {{ge, r1, 17}, true, ge, "ge r1 17", "ge_r1_17"},
                           {{cc, r5, 92}, true, cc, "cc r5 92", "cc_r5_92"},
                           {{mi, r1, 71}, true, mi, "mi r1 71", "mi_r1_71"},
                           {{vs, r4, 250}, true, vs, "vs r4 250", "vs_r4_250"},
                           {{le, r3, 170}, true, le, "le r3 170", "le_r3_170"},
                           {{mi, r3, 64}, true, mi, "mi r3 64", "mi_r3_64"},
                           {{ls, r2, 177}, true, ls, "ls r2 177", "ls_r2_177"},
                           {{vs, r5, 70}, true, vs, "vs r5 70", "vs_r5_70"},
                           {{vs, r4, 51}, true, vs, "vs r4 51", "vs_r4_51"},
                           {{vs, r3, 176}, true, vs, "vs r3 176", "vs_r3_176"},
                           {{le, r1, 101}, true, le, "le r1 101", "le_r1_101"},
                           {{ne, r3, 74}, true, ne, "ne r3 74", "ne_r3_74"},
                           {{ge, r0, 210}, true, ge, "ge r0 210", "ge_r0_210"},
                           {{gt, r1, 181}, true, gt, "gt r1 181", "gt_r1_181"},
                           {{eq, r7, 223}, true, eq, "eq r7 223", "eq_r7_223"},
                           {{ge, r3, 175}, true, ge, "ge r3 175", "ge_r3_175"},
                           {{eq, r3, 106}, true, eq, "eq r3 106", "eq_r3_106"},
                           {{ge, r5, 127}, true, ge, "ge r5 127", "ge_r5_127"},
                           {{cc, r5, 59}, true, cc, "cc r5 59", "cc_r5_59"},
                           {{cs, r4, 0}, true, cs, "cs r4 0", "cs_r4_0"},
                           {{gt, r6, 133}, true, gt, "gt r6 133", "gt_r6_133"},
                           {{ls, r1, 56}, true, ls, "ls r1 56", "ls_r1_56"},
                           {{le, r3, 25}, true, le, "le r3 25", "le_r3_25"},
                           {{vc, r1, 24}, true, vc, "vc r1 24", "vc_r1_24"},
                           {{eq, r2, 59}, true, eq, "eq r2 59", "eq_r2_59"},
                           {{eq, r3, 35}, true, eq, "eq r3 35", "eq_r3_35"},
                           {{ls, r1, 68}, true, ls, "ls r1 68", "ls_r1_68"},
                           {{hi, r5, 240}, true, hi, "hi r5 240", "hi_r5_240"},
                           {{ls, r1, 58}, true, ls, "ls r1 58", "ls_r1_58"},
                           {{cc, r7, 207}, true, cc, "cc r7 207", "cc_r7_207"},
                           {{ls, r6, 138}, true, ls, "ls r6 138", "ls_r6_138"},
                           {{lt, r5, 192}, true, lt, "lt r5 192", "lt_r5_192"},
                           {{ne, r7, 210}, true, ne, "ne r7 210", "ne_r7_210"},
                           {{eq, r3, 82}, true, eq, "eq r3 82", "eq_r3_82"},
                           {{gt, r3, 174}, true, gt, "gt r3 174", "gt_r3_174"},
                           {{ge, r6, 10}, true, ge, "ge r6 10", "ge_r6_10"},
                           {{vs, r3, 113}, true, vs, "vs r3 113", "vs_r3_113"},
                           {{hi, r2, 102}, true, hi, "hi r2 102", "hi_r2_102"},
                           {{le, r1, 81}, true, le, "le r1 81", "le_r1_81"},
                           {{vc, r3, 8}, true, vc, "vc r3 8", "vc_r3_8"},
                           {{mi, r4, 60}, true, mi, "mi r4 60", "mi_r4_60"},
                           {{pl, r7, 133}, true, pl, "pl r7 133", "pl_r7_133"},
                           {{le, r0, 41}, true, le, "le r0 41", "le_r0_41"},
                           {{vc, r6, 4}, true, vc, "vc r6 4", "vc_r6_4"},
                           {{ls, r7, 243}, true, ls, "ls r7 243", "ls_r7_243"},
                           {{mi, r3, 129}, true, mi, "mi r3 129", "mi_r3_129"},
                           {{eq, r6, 3}, true, eq, "eq r6 3", "eq_r6_3"},
                           {{ge, r0, 28}, true, ge, "ge r0 28", "ge_r0_28"},
                           {{pl, r3, 129}, true, pl, "pl r3 129", "pl_r3_129"},
                           {{ne, r6, 202}, true, ne, "ne r6 202", "ne_r6_202"},
                           {{gt, r0, 84}, true, gt, "gt r0 84", "gt_r0_84"},
                           {{hi, r7, 3}, true, hi, "hi r7 3", "hi_r7_3"},
                           {{vs, r1, 14}, true, vs, "vs r1 14", "vs_r1_14"},
                           {{eq, r3, 107}, true, eq, "eq r3 107", "eq_r3_107"},
                           {{pl, r1, 57}, true, pl, "pl r1 57", "pl_r1_57"},
                           {{pl, r0, 138}, true, pl, "pl r0 138", "pl_r0_138"},
                           {{cs, r6, 158}, true, cs, "cs r6 158", "cs_r6_158"},
                           {{ne, r2, 120}, true, ne, "ne r2 120", "ne_r2_120"},
                           {{ge, r1, 132}, true, ge, "ge r1 132", "ge_r1_132"},
                           {{hi, r6, 204}, true, hi, "hi r6 204", "hi_r6_204"},
                           {{ge, r5, 228}, true, ge, "ge r5 228", "ge_r5_228"},
                           {{gt, r5, 55}, true, gt, "gt r5 55", "gt_r5_55"},
                           {{vc, r7, 55}, true, vc, "vc r7 55", "vc_r7_55"},
                           {{ge, r3, 90}, true, ge, "ge r3 90", "ge_r3_90"},
                           {{vs, r7, 252}, true, vs, "vs r7 252", "vs_r7_252"},
                           {{le, r5, 168}, true, le, "le r5 168", "le_r5_168"},
                           {{vc, r6, 9}, true, vc, "vc r6 9", "vc_r6_9"},
                           {{eq, r7, 153}, true, eq, "eq r7 153", "eq_r7_153"},
                           {{cs, r2, 129}, true, cs, "cs r2 129", "cs_r2_129"},
                           {{eq, r4, 232}, true, eq, "eq r4 232", "eq_r4_232"},
                           {{le, r3, 86}, true, le, "le r3 86", "le_r3_86"},
                           {{vs, r1, 138}, true, vs, "vs r1 138", "vs_r1_138"},
                           {{vs, r6, 107}, true, vs, "vs r6 107", "vs_r6_107"},
                           {{gt, r0, 59}, true, gt, "gt r0 59", "gt_r0_59"},
                           {{mi, r3, 81}, true, mi, "mi r3 81", "mi_r3_81"},
                           {{le, r5, 74}, true, le, "le r5 74", "le_r5_74"},
                           {{le, r6, 207}, true, le, "le r6 207", "le_r6_207"},
                           {{vs, r0, 64}, true, vs, "vs r0 64", "vs_r0_64"},
                           {{le, r7, 146}, true, le, "le r7 146", "le_r7_146"},
                           {{cc, r4, 160}, true, cc, "cc r4 160", "cc_r4_160"},
                           {{vs, r5, 10}, true, vs, "vs r5 10", "vs_r5_10"},
                           {{gt, r2, 126}, true, gt, "gt r2 126", "gt_r2_126"},
                           {{le, r0, 94}, true, le, "le r0 94", "le_r0_94"},
                           {{ne, r6, 168}, true, ne, "ne r6 168", "ne_r6_168"},
                           {{cc, r4, 34}, true, cc, "cc r4 34", "cc_r4_34"},
                           {{hi, r5, 197}, true, hi, "hi r5 197", "hi_r5_197"},
                           {{eq, r0, 103}, true, eq, "eq r0 103", "eq_r0_103"},
                           {{cs, r4, 32}, true, cs, "cs r4 32", "cs_r4_32"},
                           {{hi, r7, 221}, true, hi, "hi r7 221", "hi_r7_221"},
                           {{mi, r0, 0}, true, mi, "mi r0 0", "mi_r0_0"},
                           {{pl, r0, 163}, true, pl, "pl r0 163", "pl_r0_163"},
                           {{cc, r2, 167}, true, cc, "cc r2 167", "cc_r2_167"},
                           {{gt, r4, 37}, true, gt, "gt r4 37", "gt_r4_37"},
                           {{mi, r5, 35}, true, mi, "mi r5 35", "mi_r5_35"},
                           {{cc, r7, 131}, true, cc, "cc r7 131", "cc_r7_131"},
                           {{pl, r4, 187}, true, pl, "pl r4 187", "pl_r4_187"},
                           {{ls, r2, 26}, true, ls, "ls r2 26", "ls_r2_26"},
                           {{mi, r7, 10}, true, mi, "mi r7 10", "mi_r7_10"},
                           {{le, r2, 113}, true, le, "le r2 113", "le_r2_113"},
                           {{vc, r2, 26}, true, vc, "vc r2 26", "vc_r2_26"},
                           {{vs, r1, 255}, true, vs, "vs r1 255", "vs_r1_255"},
                           {{ls, r5, 238}, true, ls, "ls r5 238", "ls_r5_238"},
                           {{ge, r0, 86}, true, ge, "ge r0 86", "ge_r0_86"},
                           {{gt, r0, 104}, true, gt, "gt r0 104", "gt_r0_104"},
                           {{eq, r2, 78}, true, eq, "eq r2 78", "eq_r2_78"},
                           {{cc, r1, 102}, true, cc, "cc r1 102", "cc_r1_102"},
                           {{cc, r0, 16}, true, cc, "cc r0 16", "cc_r0_16"},
                           {{mi, r4, 48}, true, mi, "mi r4 48", "mi_r4_48"},
                           {{cc, r2, 210}, true, cc, "cc r2 210", "cc_r2_210"},
                           {{hi, r5, 184}, true, hi, "hi r5 184", "hi_r5_184"},
                           {{vs, r5, 156}, true, vs, "vs r5 156", "vs_r5_156"},
                           {{cc, r2, 241}, true, cc, "cc r2 241", "cc_r2_241"},
                           {{le, r5, 169}, true, le, "le r5 169", "le_r5_169"},
                           {{pl, r5, 114}, true, pl, "pl r5 114", "pl_r5_114"},
                           {{eq, r6, 200}, true, eq, "eq r6 200", "eq_r6_200"},
                           {{vs, r4, 174}, true, vs, "vs r4 174", "vs_r4_174"},
                           {{vc, r5, 233}, true, vc, "vc r5 233", "vc_r5_233"},
                           {{hi, r2, 233}, true, hi, "hi r2 233", "hi_r2_233"},
                           {{ne, r5, 210}, true, ne, "ne r5 210", "ne_r5_210"},
                           {{le, r1, 109}, true, le, "le r1 109", "le_r1_109"},
                           {{eq, r7, 188}, true, eq, "eq r7 188", "eq_r7_188"},
                           {{hi, r2, 66}, true, hi, "hi r2 66", "hi_r2_66"},
                           {{le, r7, 109}, true, le, "le r7 109", "le_r7_109"},
                           {{ge, r6, 175}, true, ge, "ge r6 175", "ge_r6_175"},
                           {{mi, r2, 25}, true, mi, "mi r2 25", "mi_r2_25"},
                           {{pl, r2, 137}, true, pl, "pl r2 137", "pl_r2_137"},
                           {{pl, r0, 249}, true, pl, "pl r0 249", "pl_r0_249"},
                           {{lt, r1, 139}, true, lt, "lt r1 139", "lt_r1_139"},
                           {{cs, r2, 165}, true, cs, "cs r2 165", "cs_r2_165"},
                           {{ne, r6, 174}, true, ne, "ne r6 174", "ne_r6_174"},
                           {{le, r7, 90}, true, le, "le r7 90", "le_r7_90"},
                           {{gt, r5, 67}, true, gt, "gt r5 67", "gt_r5_67"},
                           {{gt, r0, 175}, true, gt, "gt r0 175", "gt_r0_175"},
                           {{hi, r3, 81}, true, hi, "hi r3 81", "hi_r3_81"},
                           {{le, r4, 144}, true, le, "le r4 144", "le_r4_144"},
                           {{vs, r4, 23}, true, vs, "vs r4 23", "vs_r4_23"},
                           {{eq, r7, 85}, true, eq, "eq r7 85", "eq_r7_85"},
                           {{eq, r7, 202}, true, eq, "eq r7 202", "eq_r7_202"},
                           {{cs, r1, 201}, true, cs, "cs r1 201", "cs_r1_201"},
                           {{lt, r4, 67}, true, lt, "lt r4 67", "lt_r4_67"},
                           {{pl, r2, 206}, true, pl, "pl r2 206", "pl_r2_206"},
                           {{vc, r0, 87}, true, vc, "vc r0 87", "vc_r0_87"},
                           {{lt, r1, 35}, true, lt, "lt r1 35", "lt_r1_35"},
                           {{pl, r7, 192}, true, pl, "pl r7 192", "pl_r7_192"},
                           {{cc, r5, 213}, true, cc, "cc r5 213", "cc_r5_213"},
                           {{vs, r5, 86}, true, vs, "vs r5 86", "vs_r5_86"},
                           {{ls, r1, 182}, true, ls, "ls r1 182", "ls_r1_182"},
                           {{vc, r0, 227}, true, vc, "vc r0 227", "vc_r0_227"},
                           {{cs, r1, 206}, true, cs, "cs r1 206", "cs_r1_206"},
                           {{vs, r7, 194}, true, vs, "vs r7 194", "vs_r7_194"},
                           {{gt, r1, 242}, true, gt, "gt r1 242", "gt_r1_242"},
                           {{le, r3, 222}, true, le, "le r3 222", "le_r3_222"},
                           {{mi, r2, 194}, true, mi, "mi r2 194", "mi_r2_194"},
                           {{vs, r2, 19}, true, vs, "vs r2 19", "vs_r2_19"},
                           {{cs, r6, 230}, true, cs, "cs r6 230", "cs_r6_230"},
                           {{ls, r1, 141}, true, ls, "ls r1 141", "ls_r1_141"},
                           {{le, r1, 144}, true, le, "le r1 144", "le_r1_144"},
                           {{ls, r1, 184}, true, ls, "ls r1 184", "ls_r1_184"},
                           {{pl, r0, 175}, true, pl, "pl r0 175", "pl_r0_175"},
                           {{cs, r3, 0}, true, cs, "cs r3 0", "cs_r3_0"},
                           {{cs, r0, 142}, true, cs, "cs r0 142", "cs_r0_142"},
                           {{le, r4, 5}, true, le, "le r4 5", "le_r4_5"},
                           {{pl, r4, 123}, true, pl, "pl r4 123", "pl_r4_123"},
                           {{cs, r3, 128}, true, cs, "cs r3 128", "cs_r3_128"},
                           {{pl, r7, 112}, true, pl, "pl r7 112", "pl_r7_112"},
                           {{vs, r2, 186}, true, vs, "vs r2 186", "vs_r2_186"},
                           {{pl, r6, 200}, true, pl, "pl r6 200", "pl_r6_200"},
                           {{ne, r7, 200}, true, ne, "ne r7 200", "ne_r7_200"},
                           {{le, r6, 223}, true, le, "le r6 223", "le_r6_223"},
                           {{vs, r4, 117}, true, vs, "vs r4 117", "vs_r4_117"},
                           {{cs, r4, 6}, true, cs, "cs r4 6", "cs_r4_6"},
                           {{ls, r6, 86}, true, ls, "ls r6 86", "ls_r6_86"},
                           {{cc, r2, 37}, true, cc, "cc r2 37", "cc_r2_37"},
                           {{ge, r6, 28}, true, ge, "ge r6 28", "ge_r6_28"},
                           {{ls, r3, 247}, true, ls, "ls r3 247", "ls_r3_247"},
                           {{ge, r4, 193}, true, ge, "ge r4 193", "ge_r4_193"},
                           {{le, r4, 108}, true, le, "le r4 108", "le_r4_108"},
                           {{vc, r0, 106}, true, vc, "vc r0 106", "vc_r0_106"},
                           {{gt, r0, 64}, true, gt, "gt r0 64", "gt_r0_64"},
                           {{pl, r0, 247}, true, pl, "pl r0 247", "pl_r0_247"},
                           {{eq, r0, 88}, true, eq, "eq r0 88", "eq_r0_88"},
                           {{mi, r4, 88}, true, mi, "mi r4 88", "mi_r4_88"},
                           {{ne, r6, 118}, true, ne, "ne r6 118", "ne_r6_118"},
                           {{vc, r2, 79}, true, vc, "vc r2 79", "vc_r2_79"},
                           {{vc, r0, 104}, true, vc, "vc r0 104", "vc_r0_104"},
                           {{vs, r3, 128}, true, vs, "vs r3 128", "vs_r3_128"},
                           {{pl, r1, 129}, true, pl, "pl r1 129", "pl_r1_129"},
                           {{mi, r6, 149}, true, mi, "mi r6 149", "mi_r6_149"},
                           {{mi, r4, 226}, true, mi, "mi r4 226", "mi_r4_226"},
                           {{pl, r5, 232}, true, pl, "pl r5 232", "pl_r5_232"},
                           {{hi, r1, 88}, true, hi, "hi r1 88", "hi_r1_88"},
                           {{mi, r3, 13}, true, mi, "mi r3 13", "mi_r3_13"},
                           {{vs, r1, 44}, true, vs, "vs r1 44", "vs_r1_44"},
                           {{le, r3, 88}, true, le, "le r3 88", "le_r3_88"},
                           {{pl, r7, 224}, true, pl, "pl r7 224", "pl_r7_224"},
                           {{eq, r2, 117}, true, eq, "eq r2 117", "eq_r2_117"},
                           {{cc, r5, 94}, true, cc, "cc r5 94", "cc_r5_94"},
                           {{gt, r3, 43}, true, gt, "gt r3 43", "gt_r3_43"},
                           {{vs, r4, 159}, true, vs, "vs r4 159", "vs_r4_159"},
                           {{mi, r7, 205}, true, mi, "mi r7 205", "mi_r7_205"},
                           {{eq, r6, 161}, true, eq, "eq r6 161", "eq_r6_161"},
                           {{le, r6, 150}, true, le, "le r6 150", "le_r6_150"},
                           {{ls, r2, 144}, true, ls, "ls r2 144", "ls_r2_144"},
                           {{le, r2, 240}, true, le, "le r2 240", "le_r2_240"},
                           {{pl, r1, 11}, true, pl, "pl r1 11", "pl_r1_11"},
                           {{pl, r2, 116}, true, pl, "pl r2 116", "pl_r2_116"},
                           {{ne, r3, 122}, true, ne, "ne r3 122", "ne_r3_122"},
                           {{cs, r7, 146}, true, cs, "cs r7 146", "cs_r7_146"},
                           {{eq, r5, 21}, true, eq, "eq r5 21", "eq_r5_21"},
                           {{ge, r0, 49}, true, ge, "ge r0 49", "ge_r0_49"},
                           {{gt, r2, 170}, true, gt, "gt r2 170", "gt_r2_170"},
                           {{mi, r3, 208}, true, mi, "mi r3 208", "mi_r3_208"},
                           {{le, r4, 47}, true, le, "le r4 47", "le_r4_47"},
                           {{ne, r4, 176}, true, ne, "ne r4 176", "ne_r4_176"},
                           {{le, r1, 153}, true, le, "le r1 153", "le_r1_153"},
                           {{cs, r3, 136}, true, cs, "cs r3 136", "cs_r3_136"},
                           {{le, r7, 166}, true, le, "le r7 166", "le_r7_166"},
                           {{vc, r2, 148}, true, vc, "vc r2 148", "vc_r2_148"},
                           {{ge, r6, 226}, true, ge, "ge r6 226", "ge_r6_226"},
                           {{mi, r7, 224}, true, mi, "mi r7 224", "mi_r7_224"},
                           {{le, r0, 88}, true, le, "le r0 88", "le_r0_88"},
                           {{lt, r3, 131}, true, lt, "lt r3 131", "lt_r3_131"},
                           {{gt, r6, 70}, true, gt, "gt r6 70", "gt_r6_70"},
                           {{cc, r5, 212}, true, cc, "cc r5 212", "cc_r5_212"},
                           {{pl, r7, 184}, true, pl, "pl r7 184", "pl_r7_184"},
                           {{gt, r0, 170}, true, gt, "gt r0 170", "gt_r0_170"},
                           {{ne, r7, 227}, true, ne, "ne r7 227", "ne_r7_227"},
                           {{cs, r7, 129}, true, cs, "cs r7 129", "cs_r7_129"},
                           {{lt, r2, 214}, true, lt, "lt r2 214", "lt_r2_214"},
                           {{le, r3, 68}, true, le, "le r3 68", "le_r3_68"},
                           {{cs, r1, 174}, true, cs, "cs r1 174", "cs_r1_174"},
                           {{mi, r6, 224}, true, mi, "mi r6 224", "mi_r6_224"},
                           {{gt, r3, 107}, true, gt, "gt r3 107", "gt_r3_107"},
                           {{pl, r6, 62}, true, pl, "pl r6 62", "pl_r6_62"},
                           {{mi, r2, 173}, true, mi, "mi r2 173", "mi_r2_173"},
                           {{cs, r3, 208}, true, cs, "cs r3 208", "cs_r3_208"},
                           {{cc, r3, 214}, true, cc, "cc r3 214", "cc_r3_214"},
                           {{lt, r5, 20}, true, lt, "lt r5 20", "lt_r5_20"},
                           {{vs, r2, 9}, true, vs, "vs r2 9", "vs_r2_9"},
                           {{le, r1, 55}, true, le, "le r1 55", "le_r1_55"},
                           {{vc, r3, 14}, true, vc, "vc r3 14", "vc_r3_14"},
                           {{eq, r5, 74}, true, eq, "eq r5 74", "eq_r5_74"},
                           {{cs, r0, 40}, true, cs, "cs r0 40", "cs_r0_40"},
                           {{ge, r6, 98}, true, ge, "ge r6 98", "ge_r6_98"},
                           {{cs, r3, 79}, true, cs, "cs r3 79", "cs_r3_79"},
                           {{ne, r0, 199}, true, ne, "ne r0 199", "ne_r0_199"},
                           {{lt, r0, 163}, true, lt, "lt r0 163", "lt_r0_163"},
                           {{cs, r6, 42}, true, cs, "cs r6 42", "cs_r6_42"},
                           {{eq, r6, 32}, true, eq, "eq r6 32", "eq_r6_32"},
                           {{vs, r1, 64}, true, vs, "vs r1 64", "vs_r1_64"},
                           {{hi, r4, 91}, true, hi, "hi r4 91", "hi_r4_91"},
                           {{ls, r3, 79}, true, ls, "ls r3 79", "ls_r3_79"},
                           {{gt, r3, 68}, true, gt, "gt r3 68", "gt_r3_68"},
                           {{eq, r0, 133}, true, eq, "eq r0 133", "eq_r0_133"},
                           {{vs, r4, 8}, true, vs, "vs r4 8", "vs_r4_8"},
                           {{cs, r2, 248}, true, cs, "cs r2 248", "cs_r2_248"},
                           {{cs, r2, 153}, true, cs, "cs r2 153", "cs_r2_153"},
                           {{cc, r1, 21}, true, cc, "cc r1 21", "cc_r1_21"},
                           {{mi, r3, 171}, true, mi, "mi r3 171", "mi_r3_171"},
                           {{gt, r6, 126}, true, gt, "gt r6 126", "gt_r6_126"},
                           {{hi, r0, 155}, true, hi, "hi r0 155", "hi_r0_155"},
                           {{cs, r0, 224}, true, cs, "cs r0 224", "cs_r0_224"},
                           {{cc, r2, 38}, true, cc, "cc r2 38", "cc_r2_38"},
                           {{lt, r3, 127}, true, lt, "lt r3 127", "lt_r3_127"},
                           {{gt, r6, 21}, true, gt, "gt r6 21", "gt_r6_21"},
                           {{gt, r4, 39}, true, gt, "gt r4 39", "gt_r4_39"},
                           {{ge, r4, 40}, true, ge, "ge r4 40", "ge_r4_40"},
                           {{hi, r4, 228}, true, hi, "hi r4 228", "hi_r4_228"},
                           {{le, r6, 51}, true, le, "le r6 51", "le_r6_51"},
                           {{ge, r3, 3}, true, ge, "ge r3 3", "ge_r3_3"},
                           {{ge, r5, 24}, true, ge, "ge r5 24", "ge_r5_24"},
                           {{ge, r0, 52}, true, ge, "ge r0 52", "ge_r0_52"},
                           {{vs, r6, 84}, true, vs, "vs r6 84", "vs_r6_84"},
                           {{gt, r7, 238}, true, gt, "gt r7 238", "gt_r7_238"},
                           {{pl, r2, 118}, true, pl, "pl r2 118", "pl_r2_118"},
                           {{cc, r0, 96}, true, cc, "cc r0 96", "cc_r0_96"},
                           {{gt, r1, 241}, true, gt, "gt r1 241", "gt_r1_241"},
                           {{lt, r5, 231}, true, lt, "lt r5 231", "lt_r5_231"},
                           {{vs, r0, 223}, true, vs, "vs r0 223", "vs_r0_223"},
                           {{vc, r6, 85}, true, vc, "vc r6 85", "vc_r6_85"},
                           {{vs, r4, 171}, true, vs, "vs r4 171", "vs_r4_171"},
                           {{hi, r7, 34}, true, hi, "hi r7 34", "hi_r7_34"},
                           {{hi, r4, 243}, true, hi, "hi r4 243", "hi_r4_243"},
                           {{cc, r6, 16}, true, cc, "cc r6 16", "cc_r6_16"},
                           {{cs, r2, 179}, true, cs, "cs r2 179", "cs_r2_179"},
                           {{cs, r5, 128}, true, cs, "cs r5 128", "cs_r5_128"},
                           {{lt, r6, 43}, true, lt, "lt r6 43", "lt_r6_43"},
                           {{lt, r1, 116}, true, lt, "lt r1 116", "lt_r1_116"},
                           {{mi, r4, 176}, true, mi, "mi r4 176", "mi_r4_176"},
                           {{hi, r3, 158}, true, hi, "hi r3 158", "hi_r3_158"},
                           {{cs, r6, 21}, true, cs, "cs r6 21", "cs_r6_21"},
                           {{ge, r5, 114}, true, ge, "ge r5 114", "ge_r5_114"},
                           {{vs, r3, 109}, true, vs, "vs r3 109", "vs_r3_109"},
                           {{ne, r4, 249}, true, ne, "ne r4 249", "ne_r4_249"},
                           {{ls, r5, 96}, true, ls, "ls r5 96", "ls_r5_96"},
                           {{hi, r0, 135}, true, hi, "hi r0 135", "hi_r0_135"},
                           {{vc, r2, 63}, true, vc, "vc r2 63", "vc_r2_63"},
                           {{le, r0, 169}, true, le, "le r0 169", "le_r0_169"},
                           {{vc, r4, 230}, true, vc, "vc r4 230", "vc_r4_230"},
                           {{gt, r3, 181}, true, gt, "gt r3 181", "gt_r3_181"},
                           {{eq, r6, 202}, true, eq, "eq r6 202", "eq_r6_202"},
                           {{mi, r4, 57}, true, mi, "mi r4 57", "mi_r4_57"},
                           {{lt, r7, 220}, true, lt, "lt r7 220", "lt_r7_220"},
                           {{lt, r3, 43}, true, lt, "lt r3 43", "lt_r3_43"},
                           {{pl, r3, 210}, true, pl, "pl r3 210", "pl_r3_210"},
                           {{cc, r4, 182}, true, cc, "cc r4 182", "cc_r4_182"},
                           {{vc, r5, 105}, true, vc, "vc r5 105", "vc_r5_105"},
                           {{ls, r4, 150}, true, ls, "ls r4 150", "ls_r4_150"},
                           {{ls, r0, 2}, true, ls, "ls r0 2", "ls_r0_2"},
                           {{eq, r0, 0}, true, eq, "eq r0 0", "eq_r0_0"},
                           {{cc, r6, 204}, true, cc, "cc r6 204", "cc_r6_204"},
                           {{lt, r4, 226}, true, lt, "lt r4 226", "lt_r4_226"},
                           {{pl, r2, 37}, true, pl, "pl r2 37", "pl_r2_37"},
                           {{ge, r3, 208}, true, ge, "ge r3 208", "ge_r3_208"},
                           {{mi, r1, 75}, true, mi, "mi r1 75", "mi_r1_75"},
                           {{hi, r7, 249}, true, hi, "hi r7 249", "hi_r7_249"},
                           {{vc, r6, 61}, true, vc, "vc r6 61", "vc_r6_61"},
                           {{eq, r1, 185}, true, eq, "eq r1 185", "eq_r1_185"},
                           {{vs, r5, 55}, true, vs, "vs r5 55", "vs_r5_55"},
                           {{pl, r2, 243}, true, pl, "pl r2 243", "pl_r2_243"},
                           {{eq, r0, 111}, true, eq, "eq r0 111", "eq_r0_111"},
                           {{cc, r5, 75}, true, cc, "cc r5 75", "cc_r5_75"},
                           {{mi, r1, 103}, true, mi, "mi r1 103", "mi_r1_103"},
                           {{mi, r5, 201}, true, mi, "mi r5 201", "mi_r5_201"},
                           {{eq, r6, 13}, true, eq, "eq r6 13", "eq_r6_13"},
                           {{le, r1, 117}, true, le, "le r1 117", "le_r1_117"},
                           {{le, r4, 245}, true, le, "le r4 245", "le_r4_245"},
                           {{vc, r5, 253}, true, vc, "vc r5 253", "vc_r5_253"},
                           {{vc, r1, 245}, true, vc, "vc r1 245", "vc_r1_245"},
                           {{hi, r0, 160}, true, hi, "hi r0 160", "hi_r0_160"},
                           {{ne, r6, 139}, true, ne, "ne r6 139", "ne_r6_139"},
                           {{cc, r3, 71}, true, cc, "cc r3 71", "cc_r3_71"},
                           {{lt, r0, 155}, true, lt, "lt r0 155", "lt_r0_155"},
                           {{ls, r4, 100}, true, ls, "ls r4 100", "ls_r4_100"},
                           {{vs, r5, 117}, true, vs, "vs r5 117", "vs_r5_117"},
                           {{gt, r7, 9}, true, gt, "gt r7 9", "gt_r7_9"},
                           {{lt, r5, 30}, true, lt, "lt r5 30", "lt_r5_30"},
                           {{pl, r6, 32}, true, pl, "pl r6 32", "pl_r6_32"},
                           {{mi, r1, 105}, true, mi, "mi r1 105", "mi_r1_105"},
                           {{hi, r1, 34}, true, hi, "hi r1 34", "hi_r1_34"},
                           {{cs, r7, 213}, true, cs, "cs r7 213", "cs_r7_213"},
                           {{le, r7, 218}, true, le, "le r7 218", "le_r7_218"},
                           {{pl, r3, 131}, true, pl, "pl r3 131", "pl_r3_131"},
                           {{cs, r6, 117}, true, cs, "cs r6 117", "cs_r6_117"},
                           {{cc, r1, 177}, true, cc, "cc r1 177", "cc_r1_177"},
                           {{cs, r1, 74}, true, cs, "cs r1 74", "cs_r1_74"},
                           {{ls, r7, 176}, true, ls, "ls r7 176", "ls_r7_176"},
                           {{lt, r7, 208}, true, lt, "lt r7 208", "lt_r7_208"},
                           {{ge, r2, 252}, true, ge, "ge r2 252", "ge_r2_252"},
                           {{gt, r7, 135}, true, gt, "gt r7 135", "gt_r7_135"},
                           {{cs, r4, 128}, true, cs, "cs r4 128", "cs_r4_128"},
                           {{le, r6, 44}, true, le, "le r6 44", "le_r6_44"},
                           {{cs, r5, 184}, true, cs, "cs r5 184", "cs_r5_184"},
                           {{cc, r5, 17}, true, cc, "cc r5 17", "cc_r5_17"},
                           {{le, r1, 48}, true, le, "le r1 48", "le_r1_48"},
                           {{vs, r7, 152}, true, vs, "vs r7 152", "vs_r7_152"},
                           {{cs, r3, 236}, true, cs, "cs r3 236", "cs_r3_236"},
                           {{cc, r1, 68}, true, cc, "cc r1 68", "cc_r1_68"},
                           {{cs, r6, 179}, true, cs, "cs r6 179", "cs_r6_179"},
                           {{eq, r5, 35}, true, eq, "eq r5 35", "eq_r5_35"},
                           {{le, r5, 220}, true, le, "le r5 220", "le_r5_220"},
                           {{pl, r1, 63}, true, pl, "pl r1 63", "pl_r1_63"},
                           {{vs, r5, 255}, true, vs, "vs r5 255", "vs_r5_255"},
                           {{pl, r5, 193}, true, pl, "pl r5 193", "pl_r5_193"},
                           {{gt, r3, 165}, true, gt, "gt r3 165", "gt_r3_165"},
                           {{le, r0, 120}, true, le, "le r0 120", "le_r0_120"},
                           {{cc, r0, 21}, true, cc, "cc r0 21", "cc_r0_21"},
                           {{ge, r3, 203}, true, ge, "ge r3 203", "ge_r3_203"},
                           {{ne, r0, 25}, true, ne, "ne r0 25", "ne_r0_25"},
                           {{mi, r6, 6}, true, mi, "mi r6 6", "mi_r6_6"},
                           {{ne, r7, 194}, true, ne, "ne r7 194", "ne_r7_194"},
                           {{lt, r6, 20}, true, lt, "lt r6 20", "lt_r6_20"},
                           {{ls, r3, 94}, true, ls, "ls r3 94", "ls_r3_94"},
                           {{gt, r6, 222}, true, gt, "gt r6 222", "gt_r6_222"},
                           {{cc, r1, 247}, true, cc, "cc r1 247", "cc_r1_247"},
                           {{cc, r0, 127}, true, cc, "cc r0 127", "cc_r0_127"},
                           {{mi, r2, 252}, true, mi, "mi r2 252", "mi_r2_252"},
                           {{ge, r0, 150}, true, ge, "ge r0 150", "ge_r0_150"},
                           {{mi, r4, 18}, true, mi, "mi r4 18", "mi_r4_18"},
                           {{vs, r5, 182}, true, vs, "vs r5 182", "vs_r5_182"},
                           {{pl, r1, 125}, true, pl, "pl r1 125", "pl_r1_125"},
                           {{pl, r6, 159}, true, pl, "pl r6 159", "pl_r6_159"},
                           {{le, r3, 218}, true, le, "le r3 218", "le_r3_218"},
                           {{hi, r2, 163}, true, hi, "hi r2 163", "hi_r2_163"},
                           {{mi, r7, 246}, true, mi, "mi r7 246", "mi_r7_246"},
                           {{lt, r7, 1}, true, lt, "lt r7 1", "lt_r7_1"},
                           {{pl, r4, 82}, true, pl, "pl r4 82", "pl_r4_82"},
                           {{le, r2, 115}, true, le, "le r2 115", "le_r2_115"},
                           {{vc, r0, 74}, true, vc, "vc r0 74", "vc_r0_74"},
                           {{gt, r3, 11}, true, gt, "gt r3 11", "gt_r3_11"},
                           {{cs, r7, 225}, true, cs, "cs r7 225", "cs_r7_225"},
                           {{gt, r2, 245}, true, gt, "gt r2 245", "gt_r2_245"},
                           {{lt, r4, 13}, true, lt, "lt r4 13", "lt_r4_13"},
                           {{le, r3, 83}, true, le, "le r3 83", "le_r3_83"},
                           {{eq, r7, 83}, true, eq, "eq r7 83", "eq_r7_83"},
                           {{vc, r6, 86}, true, vc, "vc r6 86", "vc_r6_86"},
                           {{le, r2, 99}, true, le, "le r2 99", "le_r2_99"},
                           {{hi, r0, 139}, true, hi, "hi r0 139", "hi_r0_139"},
                           {{gt, r6, 122}, true, gt, "gt r6 122", "gt_r6_122"},
                           {{cs, r2, 190}, true, cs, "cs r2 190", "cs_r2_190"},
                           {{pl, r0, 97}, true, pl, "pl r0 97", "pl_r0_97"},
                           {{ls, r7, 41}, true, ls, "ls r7 41", "ls_r7_41"},
                           {{pl, r2, 111}, true, pl, "pl r2 111", "pl_r2_111"},
                           {{ls, r5, 239}, true, ls, "ls r5 239", "ls_r5_239"},
                           {{le, r3, 104}, true, le, "le r3 104", "le_r3_104"},
                           {{gt, r3, 29}, true, gt, "gt r3 29", "gt_r3_29"},
                           {{ge, r7, 247}, true, ge, "ge r7 247", "ge_r7_247"},
                           {{le, r6, 1}, true, le, "le r6 1", "le_r6_1"},
                           {{hi, r0, 161}, true, hi, "hi r0 161", "hi_r0_161"},
                           {{vs, r1, 143}, true, vs, "vs r1 143", "vs_r1_143"},
                           {{cs, r7, 14}, true, cs, "cs r7 14", "cs_r7_14"},
                           {{gt, r3, 80}, true, gt, "gt r3 80", "gt_r3_80"},
                           {{ls, r6, 207}, true, ls, "ls r6 207", "ls_r6_207"},
                           {{vs, r1, 187}, true, vs, "vs r1 187", "vs_r1_187"},
                           {{ne, r6, 193}, true, ne, "ne r6 193", "ne_r6_193"},
                           {{le, r5, 202}, true, le, "le r5 202", "le_r5_202"},
                           {{vs, r3, 23}, true, vs, "vs r3 23", "vs_r3_23"},
                           {{mi, r2, 141}, true, mi, "mi r2 141", "mi_r2_141"},
                           {{mi, r1, 145}, true, mi, "mi r1 145", "mi_r1_145"},
                           {{lt, r0, 176}, true, lt, "lt r0 176", "lt_r0_176"},
                           {{hi, r2, 18}, true, hi, "hi r2 18", "hi_r2_18"},
                           {{gt, r4, 247}, true, gt, "gt r4 247", "gt_r4_247"},
                           {{lt, r1, 144}, true, lt, "lt r1 144", "lt_r1_144"},
                           {{cc, r5, 174}, true, cc, "cc r5 174", "cc_r5_174"},
                           {{ge, r6, 66}, true, ge, "ge r6 66", "ge_r6_66"},
                           {{vc, r0, 223}, true, vc, "vc r0 223", "vc_r0_223"},
                           {{cc, r7, 211}, true, cc, "cc r7 211", "cc_r7_211"},
                           {{le, r1, 186}, true, le, "le r1 186", "le_r1_186"},
                           {{ne, r4, 73}, true, ne, "ne r4 73", "ne_r4_73"},
                           {{ls, r4, 64}, true, ls, "ls r4 64", "ls_r4_64"},
                           {{cc, r3, 100}, true, cc, "cc r3 100", "cc_r3_100"},
                           {{ls, r7, 83}, true, ls, "ls r7 83", "ls_r7_83"},
                           {{ge, r7, 253}, true, ge, "ge r7 253", "ge_r7_253"},
                           {{lt, r1, 190}, true, lt, "lt r1 190", "lt_r1_190"},
                           {{hi, r0, 132}, true, hi, "hi r0 132", "hi_r0_132"},
                           {{cc, r1, 172}, true, cc, "cc r1 172", "cc_r1_172"},
                           {{cs, r4, 24}, true, cs, "cs r4 24", "cs_r4_24"},
                           {{vs, r0, 183}, true, vs, "vs r0 183", "vs_r0_183"},
                           {{eq, r3, 231}, true, eq, "eq r3 231", "eq_r3_231"},
                           {{cc, r4, 6}, true, cc, "cc r4 6", "cc_r4_6"},
                           {{le, r6, 151}, true, le, "le r6 151", "le_r6_151"},
                           {{eq, r4, 123}, true, eq, "eq r4 123", "eq_r4_123"},
                           {{lt, r2, 110}, true, lt, "lt r2 110", "lt_r2_110"},
                           {{vc, r2, 39}, true, vc, "vc r2 39", "vc_r2_39"},
                           {{gt, r5, 45}, true, gt, "gt r5 45", "gt_r5_45"},
                           {{eq, r2, 120}, true, eq, "eq r2 120", "eq_r2_120"},
                           {{ge, r0, 6}, true, ge, "ge r0 6", "ge_r0_6"},
                           {{vs, r3, 54}, true, vs, "vs r3 54", "vs_r3_54"},
                           {{cc, r0, 164}, true, cc, "cc r0 164", "cc_r0_164"},
                           {{eq, r6, 198}, true, eq, "eq r6 198", "eq_r6_198"},
                           {{cc, r0, 254}, true, cc, "cc r0 254", "cc_r0_254"},
                           {{ne, r1, 167}, true, ne, "ne r1 167", "ne_r1_167"},
                           {{hi, r7, 89}, true, hi, "hi r7 89", "hi_r7_89"},
                           {{mi, r6, 220}, true, mi, "mi r6 220", "mi_r6_220"},
                           {{vs, r5, 199}, true, vs, "vs r5 199", "vs_r5_199"},
                           {{ls, r4, 166}, true, ls, "ls r4 166", "ls_r4_166"},
                           {{le, r2, 139}, true, le, "le r2 139", "le_r2_139"},
                           {{vs, r5, 112}, true, vs, "vs r5 112", "vs_r5_112"},
                           {{cs, r3, 13}, true, cs, "cs r3 13", "cs_r3_13"},
                           {{gt, r3, 95}, true, gt, "gt r3 95", "gt_r3_95"},
                           {{pl, r2, 94}, true, pl, "pl r2 94", "pl_r2_94"},
                           {{ne, r2, 227}, true, ne, "ne r2 227", "ne_r2_227"},
                           {{ne, r7, 251}, true, ne, "ne r7 251", "ne_r7_251"},
                           {{ge, r5, 97}, true, ge, "ge r5 97", "ge_r5_97"},
                           {{gt, r5, 253}, true, gt, "gt r5 253", "gt_r5_253"},
                           {{hi, r7, 95}, true, hi, "hi r7 95", "hi_r7_95"},
                           {{gt, r3, 253}, true, gt, "gt r3 253", "gt_r3_253"},
                           {{le, r7, 162}, true, le, "le r7 162", "le_r7_162"},
                           {{gt, r4, 36}, true, gt, "gt r4 36", "gt_r4_36"},
                           {{ne, r3, 58}, true, ne, "ne r3 58", "ne_r3_58"},
                           {{vs, r0, 25}, true, vs, "vs r0 25", "vs_r0_25"},
                           {{ne, r7, 116}, true, ne, "ne r7 116", "ne_r7_116"},
                           {{cs, r1, 198}, true, cs, "cs r1 198", "cs_r1_198"},
                           {{cc, r0, 122}, true, cc, "cc r0 122", "cc_r0_122"},
                           {{le, r4, 57}, true, le, "le r4 57", "le_r4_57"},
                           {{vc, r3, 150}, true, vc, "vc r3 150", "vc_r3_150"},
                           {{eq, r1, 54}, true, eq, "eq r1 54", "eq_r1_54"},
                           {{ge, r1, 146}, true, ge, "ge r1 146", "ge_r1_146"},
                           {{vc, r1, 124}, true, vc, "vc r1 124", "vc_r1_124"},
                           {{ne, r6, 165}, true, ne, "ne r6 165", "ne_r6_165"},
                           {{vc, r6, 54}, true, vc, "vc r6 54", "vc_r6_54"},
                           {{hi, r3, 226}, true, hi, "hi r3 226", "hi_r3_226"},
                           {{eq, r1, 167}, true, eq, "eq r1 167", "eq_r1_167"},
                           {{mi, r3, 162}, true, mi, "mi r3 162", "mi_r3_162"},
                           {{mi, r5, 8}, true, mi, "mi r5 8", "mi_r5_8"},
                           {{mi, r3, 67}, true, mi, "mi r3 67", "mi_r3_67"},
                           {{ge, r6, 113}, true, ge, "ge r6 113", "ge_r6_113"},
                           {{lt, r2, 51}, true, lt, "lt r2 51", "lt_r2_51"},
                           {{vc, r2, 131}, true, vc, "vc r2 131", "vc_r2_131"},
                           {{ne, r4, 196}, true, ne, "ne r4 196", "ne_r4_196"},
                           {{mi, r5, 189}, true, mi, "mi r5 189", "mi_r5_189"},
                           {{cs, r1, 62}, true, cs, "cs r1 62", "cs_r1_62"},
                           {{hi, r4, 142}, true, hi, "hi r4 142", "hi_r4_142"},
                           {{ne, r5, 91}, true, ne, "ne r5 91", "ne_r5_91"},
                           {{eq, r3, 38}, true, eq, "eq r3 38", "eq_r3_38"},
                           {{ls, r3, 155}, true, ls, "ls r3 155", "ls_r3_155"},
                           {{le, r5, 0}, true, le, "le r5 0", "le_r5_0"},
                           {{vc, r1, 106}, true, vc, "vc r1 106", "vc_r1_106"},
                           {{lt, r0, 212}, true, lt, "lt r0 212", "lt_r0_212"},
                           {{lt, r1, 87}, true, lt, "lt r1 87", "lt_r1_87"},
                           {{mi, r2, 62}, true, mi, "mi r2 62", "mi_r2_62"},
                           {{vc, r0, 2}, true, vc, "vc r0 2", "vc_r0_2"},
                           {{ls, r7, 24}, true, ls, "ls r7 24", "ls_r7_24"},
                           {{ls, r3, 12}, true, ls, "ls r3 12", "ls_r3_12"},
                           {{pl, r0, 181}, true, pl, "pl r0 181", "pl_r0_181"},
                           {{gt, r2, 43}, true, gt, "gt r2 43", "gt_r2_43"},
                           {{cc, r5, 130}, true, cc, "cc r5 130", "cc_r5_130"},
                           {{eq, r6, 170}, true, eq, "eq r6 170", "eq_r6_170"},
                           {{hi, r4, 208}, true, hi, "hi r4 208", "hi_r4_208"},
                           {{cc, r2, 196}, true, cc, "cc r2 196", "cc_r2_196"},
                           {{lt, r4, 131}, true, lt, "lt r4 131", "lt_r4_131"},
                           {{vs, r7, 122}, true, vs, "vs r7 122", "vs_r7_122"},
                           {{cs, r0, 212}, true, cs, "cs r0 212", "cs_r0_212"},
                           {{eq, r2, 50}, true, eq, "eq r2 50", "eq_r2_50"},
                           {{gt, r3, 202}, true, gt, "gt r3 202", "gt_r3_202"},
                           {{eq, r4, 197}, true, eq, "eq r4 197", "eq_r4_197"},
                           {{cc, r3, 7}, true, cc, "cc r3 7", "cc_r3_7"},
                           {{vs, r5, 206}, true, vs, "vs r5 206", "vs_r5_206"},
                           {{lt, r6, 137}, true, lt, "lt r6 137", "lt_r6_137"},
                           {{cs, r4, 154}, true, cs, "cs r4 154", "cs_r4_154"},
                           {{hi, r0, 16}, true, hi, "hi r0 16", "hi_r0_16"},
                           {{le, r1, 110}, true, le, "le r1 110", "le_r1_110"},
                           {{ge, r5, 67}, true, ge, "ge r5 67", "ge_r5_67"},
                           {{lt, r2, 58}, true, lt, "lt r2 58", "lt_r2_58"},
                           {{gt, r4, 45}, true, gt, "gt r4 45", "gt_r4_45"},
                           {{gt, r7, 227}, true, gt, "gt r7 227", "gt_r7_227"},
                           {{lt, r6, 143}, true, lt, "lt r6 143", "lt_r6_143"},
                           {{cs, r5, 168}, true, cs, "cs r5 168", "cs_r5_168"},
                           {{hi, r5, 74}, true, hi, "hi r5 74", "hi_r5_74"},
                           {{gt, r6, 165}, true, gt, "gt r6 165", "gt_r6_165"},
                           {{le, r2, 191}, true, le, "le r2 191", "le_r2_191"},
                           {{pl, r3, 212}, true, pl, "pl r3 212", "pl_r3_212"},
                           {{lt, r2, 108}, true, lt, "lt r2 108", "lt_r2_108"},
                           {{gt, r4, 225}, true, gt, "gt r4 225", "gt_r4_225"},
                           {{cc, r3, 181}, true, cc, "cc r3 181", "cc_r3_181"},
                           {{ge, r7, 39}, true, ge, "ge r7 39", "ge_r7_39"},
                           {{gt, r2, 212}, true, gt, "gt r2 212", "gt_r2_212"},
                           {{cc, r2, 32}, true, cc, "cc r2 32", "cc_r2_32"},
                           {{vs, r1, 92}, true, vs, "vs r1 92", "vs_r1_92"},
                           {{cs, r0, 64}, true, cs, "cs r0 64", "cs_r0_64"},
                           {{mi, r3, 195}, true, mi, "mi r3 195", "mi_r3_195"},
                           {{ne, r7, 168}, true, ne, "ne r7 168", "ne_r7_168"},
                           {{vc, r2, 84}, true, vc, "vc r2 84", "vc_r2_84"},
                           {{hi, r1, 105}, true, hi, "hi r1 105", "hi_r1_105"},
                           {{vc, r4, 91}, true, vc, "vc r4 91", "vc_r4_91"},
                           {{pl, r0, 103}, true, pl, "pl r0 103", "pl_r0_103"},
                           {{cc, r7, 122}, true, cc, "cc r7 122", "cc_r7_122"},
                           {{vs, r7, 228}, true, vs, "vs r7 228", "vs_r7_228"},
                           {{ls, r4, 154}, true, ls, "ls r4 154", "ls_r4_154"},
                           {{mi, r5, 159}, true, mi, "mi r5 159", "mi_r5_159"},
                           {{gt, r6, 207}, true, gt, "gt r6 207", "gt_r6_207"},
                           {{lt, r0, 75}, true, lt, "lt r0 75", "lt_r0_75"},
                           {{gt, r4, 106}, true, gt, "gt r4 106", "gt_r4_106"},
                           {{gt, r0, 236}, true, gt, "gt r0 236", "gt_r0_236"},
                           {{le, r7, 127}, true, le, "le r7 127", "le_r7_127"},
                           {{vs, r0, 138}, true, vs, "vs r0 138", "vs_r0_138"},
                           {{vs, r3, 145}, true, vs, "vs r3 145", "vs_r3_145"},
                           {{cs, r1, 70}, true, cs, "cs r1 70", "cs_r1_70"},
                           {{cs, r3, 69}, true, cs, "cs r3 69", "cs_r3_69"},
                           {{hi, r3, 28}, true, hi, "hi r3 28", "hi_r3_28"},
                           {{le, r5, 122}, true, le, "le r5 122", "le_r5_122"},
                           {{cc, r7, 212}, true, cc, "cc r7 212", "cc_r7_212"},
                           {{mi, r4, 186}, true, mi, "mi r4 186", "mi_r4_186"},
                           {{ne, r1, 171}, true, ne, "ne r1 171", "ne_r1_171"},
                           {{vs, r4, 205}, true, vs, "vs r4 205", "vs_r4_205"},
                           {{ls, r1, 26}, true, ls, "ls r1 26", "ls_r1_26"},
                           {{le, r5, 58}, true, le, "le r5 58", "le_r5_58"},
                           {{gt, r2, 140}, true, gt, "gt r2 140", "gt_r2_140"},
                           {{pl, r5, 121}, true, pl, "pl r5 121", "pl_r5_121"},
                           {{vc, r3, 183}, true, vc, "vc r3 183", "vc_r3_183"},
                           {{vs, r5, 110}, true, vs, "vs r5 110", "vs_r5_110"},
                           {{ls, r2, 89}, true, ls, "ls r2 89", "ls_r2_89"},
                           {{vc, r3, 173}, true, vc, "vc r3 173", "vc_r3_173"},
                           {{le, r7, 57}, true, le, "le r7 57", "le_r7_57"},
                           {{eq, r5, 111}, true, eq, "eq r5 111", "eq_r5_111"},
                           {{mi, r4, 180}, true, mi, "mi r4 180", "mi_r4_180"},
                           {{vs, r1, 252}, true, vs, "vs r1 252", "vs_r1_252"},
                           {{le, r2, 168}, true, le, "le r2 168", "le_r2_168"},
                           {{ne, r7, 240}, true, ne, "ne r7 240", "ne_r7_240"},
                           {{hi, r5, 177}, true, hi, "hi r5 177", "hi_r5_177"},
                           {{cc, r7, 156}, true, cc, "cc r7 156", "cc_r7_156"},
                           {{ls, r0, 140}, true, ls, "ls r0 140", "ls_r0_140"},
                           {{vc, r2, 206}, true, vc, "vc r2 206", "vc_r2_206"},
                           {{ge, r3, 198}, true, ge, "ge r3 198", "ge_r3_198"},
                           {{pl, r1, 154}, true, pl, "pl r1 154", "pl_r1_154"},
                           {{eq, r5, 118}, true, eq, "eq r5 118", "eq_r5_118"},
                           {{le, r7, 173}, true, le, "le r7 173", "le_r7_173"},
                           {{mi, r6, 174}, true, mi, "mi r6 174", "mi_r6_174"},
                           {{pl, r2, 159}, true, pl, "pl r2 159", "pl_r2_159"},
                           {{lt, r0, 97}, true, lt, "lt r0 97", "lt_r0_97"},
                           {{ge, r2, 145}, true, ge, "ge r2 145", "ge_r2_145"},
                           {{cc, r5, 196}, true, cc, "cc r5 196", "cc_r5_196"},
                           {{vs, r3, 152}, true, vs, "vs r3 152", "vs_r3_152"},
                           {{le, r3, 85}, true, le, "le r3 85", "le_r3_85"},
                           {{le, r7, 155}, true, le, "le r7 155", "le_r7_155"},
                           {{cc, r1, 160}, true, cc, "cc r1 160", "cc_r1_160"},
                           {{gt, r2, 195}, true, gt, "gt r2 195", "gt_r2_195"},
                           {{vc, r3, 67}, true, vc, "vc r3 67", "vc_r3_67"},
                           {{lt, r0, 119}, true, lt, "lt r0 119", "lt_r0_119"},
                           {{ne, r3, 123}, true, ne, "ne r3 123", "ne_r3_123"},
                           {{le, r5, 23}, true, le, "le r5 23", "le_r5_23"},
                           {{lt, r6, 208}, true, lt, "lt r6 208", "lt_r6_208"},
                           {{cc, r5, 245}, true, cc, "cc r5 245", "cc_r5_245"},
                           {{vs, r4, 111}, true, vs, "vs r4 111", "vs_r4_111"},
                           {{pl, r4, 75}, true, pl, "pl r4 75", "pl_r4_75"},
                           {{le, r6, 59}, true, le, "le r6 59", "le_r6_59"},
                           {{pl, r6, 70}, true, pl, "pl r6 70", "pl_r6_70"},
                           {{vc, r1, 191}, true, vc, "vc r1 191", "vc_r1_191"},
                           {{le, r2, 125}, true, le, "le r2 125", "le_r2_125"},
                           {{ls, r4, 249}, true, ls, "ls r4 249", "ls_r4_249"},
                           {{vs, r2, 41}, true, vs, "vs r2 41", "vs_r2_41"},
                           {{pl, r4, 199}, true, pl, "pl r4 199", "pl_r4_199"},
                           {{cc, r3, 180}, true, cc, "cc r3 180", "cc_r3_180"},
                           {{ls, r0, 225}, true, ls, "ls r0 225", "ls_r0_225"},
                           {{ne, r2, 93}, true, ne, "ne r2 93", "ne_r2_93"},
                           {{cc, r3, 16}, true, cc, "cc r3 16", "cc_r3_16"},
                           {{pl, r1, 223}, true, pl, "pl r1 223", "pl_r1_223"},
                           {{ge, r0, 129}, true, ge, "ge r0 129", "ge_r0_129"},
                           {{lt, r5, 34}, true, lt, "lt r5 34", "lt_r5_34"},
                           {{vc, r5, 156}, true, vc, "vc r5 156", "vc_r5_156"},
                           {{hi, r0, 29}, true, hi, "hi r0 29", "hi_r0_29"},
                           {{eq, r5, 228}, true, eq, "eq r5 228", "eq_r5_228"},
                           {{ls, r5, 86}, true, ls, "ls r5 86", "ls_r5_86"},
                           {{cs, r5, 99}, true, cs, "cs r5 99", "cs_r5_99"},
                           {{eq, r4, 217}, true, eq, "eq r4 217", "eq_r4_217"},
                           {{ne, r0, 15}, true, ne, "ne r0 15", "ne_r0_15"},
                           {{ls, r2, 17}, true, ls, "ls r2 17", "ls_r2_17"},
                           {{cs, r3, 70}, true, cs, "cs r3 70", "cs_r3_70"},
                           {{ge, r0, 60}, true, ge, "ge r0 60", "ge_r0_60"},
                           {{cc, r0, 107}, true, cc, "cc r0 107", "cc_r0_107"},
                           {{gt, r3, 192}, true, gt, "gt r3 192", "gt_r3_192"},
                           {{ne, r1, 175}, true, ne, "ne r1 175", "ne_r1_175"},
                           {{le, r1, 88}, true, le, "le r1 88", "le_r1_88"},
                           {{mi, r5, 216}, true, mi, "mi r5 216", "mi_r5_216"},
                           {{pl, r4, 149}, true, pl, "pl r4 149", "pl_r4_149"},
                           {{cs, r6, 28}, true, cs, "cs r6 28", "cs_r6_28"},
                           {{vs, r1, 65}, true, vs, "vs r1 65", "vs_r1_65"},
                           {{vs, r2, 169}, true, vs, "vs r2 169", "vs_r2_169"},
                           {{eq, r3, 108}, true, eq, "eq r3 108", "eq_r3_108"},
                           {{eq, r5, 127}, true, eq, "eq r5 127", "eq_r5_127"},
                           {{vc, r1, 23}, true, vc, "vc r1 23", "vc_r1_23"},
                           {{pl, r7, 132}, true, pl, "pl r7 132", "pl_r7_132"},
                           {{vc, r3, 90}, true, vc, "vc r3 90", "vc_r3_90"},
                           {{pl, r3, 195}, true, pl, "pl r3 195", "pl_r3_195"},
                           {{ne, r7, 28}, true, ne, "ne r7 28", "ne_r7_28"},
                           {{vs, r2, 233}, true, vs, "vs r2 233", "vs_r2_233"},
                           {{ge, r5, 3}, true, ge, "ge r5 3", "ge_r5_3"},
                           {{ge, r3, 231}, true, ge, "ge r3 231", "ge_r3_231"},
                           {{pl, r2, 10}, true, pl, "pl r2 10", "pl_r2_10"},
                           {{le, r1, 56}, true, le, "le r1 56", "le_r1_56"},
                           {{eq, r5, 232}, true, eq, "eq r5 232", "eq_r5_232"},
                           {{mi, r5, 124}, true, mi, "mi r5 124", "mi_r5_124"},
                           {{vc, r2, 198}, true, vc, "vc r2 198", "vc_r2_198"},
                           {{lt, r5, 86}, true, lt, "lt r5 86", "lt_r5_86"},
                           {{eq, r1, 199}, true, eq, "eq r1 199", "eq_r1_199"},
                           {{eq, r2, 21}, true, eq, "eq r2 21", "eq_r2_21"},
                           {{mi, r4, 194}, true, mi, "mi r4 194", "mi_r4_194"},
                           {{ge, r1, 235}, true, ge, "ge r1 235", "ge_r1_235"},
                           {{gt, r6, 164}, true, gt, "gt r6 164", "gt_r6_164"},
                           {{ne, r0, 132}, true, ne, "ne r0 132", "ne_r0_132"},
                           {{mi, r2, 188}, true, mi, "mi r2 188", "mi_r2_188"},
                           {{ls, r7, 136}, true, ls, "ls r7 136", "ls_r7_136"},
                           {{mi, r3, 248}, true, mi, "mi r3 248", "mi_r3_248"},
                           {{pl, r1, 248}, true, pl, "pl r1 248", "pl_r1_248"},
                           {{gt, r1, 4}, true, gt, "gt r1 4", "gt_r1_4"},
                           {{eq, r3, 171}, true, eq, "eq r3 171", "eq_r3_171"},
                           {{ge, r5, 75}, true, ge, "ge r5 75", "ge_r5_75"},
                           {{ne, r6, 115}, true, ne, "ne r6 115", "ne_r6_115"},
                           {{mi, r1, 218}, true, mi, "mi r1 218", "mi_r1_218"},
                           {{pl, r6, 160}, true, pl, "pl r6 160", "pl_r6_160"},
                           {{ls, r3, 69}, true, ls, "ls r3 69", "ls_r3_69"},
                           {{hi, r3, 73}, true, hi, "hi r3 73", "hi_r3_73"},
                           {{cc, r2, 248}, true, cc, "cc r2 248", "cc_r2_248"},
                           {{le, r0, 1}, true, le, "le r0 1", "le_r0_1"},
                           {{gt, r0, 43}, true, gt, "gt r0 43", "gt_r0_43"},
                           {{pl, r7, 202}, true, pl, "pl r7 202", "pl_r7_202"},
                           {{le, r3, 8}, true, le, "le r3 8", "le_r3_8"},
                           {{ls, r1, 235}, true, ls, "ls r1 235", "ls_r1_235"},
                           {{cs, r5, 223}, true, cs, "cs r5 223", "cs_r5_223"},
                           {{le, r7, 89}, true, le, "le r7 89", "le_r7_89"},
                           {{ls, r5, 45}, true, ls, "ls r5 45", "ls_r5_45"},
                           {{pl, r6, 206}, true, pl, "pl r6 206", "pl_r6_206"},
                           {{ne, r3, 12}, true, ne, "ne r3 12", "ne_r3_12"},
                           {{vc, r3, 37}, true, vc, "vc r3 37", "vc_r3_37"},
                           {{cs, r3, 112}, true, cs, "cs r3 112", "cs_r3_112"},
                           {{cs, r3, 10}, true, cs, "cs r3 10", "cs_r3_10"},
                           {{cs, r0, 206}, true, cs, "cs r0 206", "cs_r0_206"},
                           {{vs, r2, 215}, true, vs, "vs r2 215", "vs_r2_215"},
                           {{hi, r2, 171}, true, hi, "hi r2 171", "hi_r2_171"},
                           {{ge, r3, 117}, true, ge, "ge r3 117", "ge_r3_117"},
                           {{vc, r7, 211}, true, vc, "vc r7 211", "vc_r7_211"},
                           {{hi, r6, 147}, true, hi, "hi r6 147", "hi_r6_147"},
                           {{gt, r4, 64}, true, gt, "gt r4 64", "gt_r4_64"},
                           {{ge, r2, 17}, true, ge, "ge r2 17", "ge_r2_17"},
                           {{lt, r0, 242}, true, lt, "lt r0 242", "lt_r0_242"},
                           {{ls, r5, 144}, true, ls, "ls r5 144", "ls_r5_144"},
                           {{cc, r7, 44}, true, cc, "cc r7 44", "cc_r7_44"},
                           {{vs, r7, 214}, true, vs, "vs r7 214", "vs_r7_214"},
                           {{ge, r3, 132}, true, ge, "ge r3 132", "ge_r3_132"},
                           {{hi, r4, 36}, true, hi, "hi r4 36", "hi_r4_36"},
                           {{cs, r1, 5}, true, cs, "cs r1 5", "cs_r1_5"},
                           {{mi, r6, 194}, true, mi, "mi r6 194", "mi_r6_194"},
                           {{ge, r1, 134}, true, ge, "ge r1 134", "ge_r1_134"},
                           {{ls, r2, 90}, true, ls, "ls r2 90", "ls_r2_90"},
                           {{vc, r1, 207}, true, vc, "vc r1 207", "vc_r1_207"},
                           {{cc, r7, 13}, true, cc, "cc r7 13", "cc_r7_13"},
                           {{cc, r6, 117}, true, cc, "cc r6 117", "cc_r6_117"},
                           {{mi, r2, 113}, true, mi, "mi r2 113", "mi_r2_113"},
                           {{vc, r0, 107}, true, vc, "vc r0 107", "vc_r0_107"},
                           {{mi, r6, 156}, true, mi, "mi r6 156", "mi_r6_156"},
                           {{hi, r0, 193}, true, hi, "hi r0 193", "hi_r0_193"},
                           {{gt, r5, 5}, true, gt, "gt r5 5", "gt_r5_5"},
                           {{cc, r5, 137}, true, cc, "cc r5 137", "cc_r5_137"},
                           {{vs, r1, 60}, true, vs, "vs r1 60", "vs_r1_60"},
                           {{ge, r5, 156}, true, ge, "ge r5 156", "ge_r5_156"},
                           {{hi, r5, 246}, true, hi, "hi r5 246", "hi_r5_246"},
                           {{pl, r1, 228}, true, pl, "pl r1 228", "pl_r1_228"},
                           {{mi, r6, 214}, true, mi, "mi r6 214", "mi_r6_214"},
                           {{ls, r1, 39}, true, ls, "ls r1 39", "ls_r1_39"},
                           {{ge, r2, 201}, true, ge, "ge r2 201", "ge_r2_201"},
                           {{ls, r5, 250}, true, ls, "ls r5 250", "ls_r5_250"},
                           {{mi, r2, 40}, true, mi, "mi r2 40", "mi_r2_40"},
                           {{cc, r4, 225}, true, cc, "cc r4 225", "cc_r4_225"},
                           {{ne, r1, 96}, true, ne, "ne r1 96", "ne_r1_96"},
                           {{ge, r5, 162}, true, ge, "ge r5 162", "ge_r5_162"},
                           {{eq, r5, 176}, true, eq, "eq r5 176", "eq_r5_176"},
                           {{lt, r1, 246}, true, lt, "lt r1 246", "lt_r1_246"},
                           {{ls, r4, 44}, true, ls, "ls r4 44", "ls_r4_44"},
                           {{lt, r2, 96}, true, lt, "lt r2 96", "lt_r2_96"},
                           {{ge, r5, 54}, true, ge, "ge r5 54", "ge_r5_54"},
                           {{lt, r6, 13}, true, lt, "lt r6 13", "lt_r6_13"},
                           {{mi, r5, 106}, true, mi, "mi r5 106", "mi_r5_106"},
                           {{vs, r5, 62}, true, vs, "vs r5 62", "vs_r5_62"},
                           {{vs, r5, 235}, true, vs, "vs r5 235", "vs_r5_235"},
                           {{hi, r1, 49}, true, hi, "hi r1 49", "hi_r1_49"},
                           {{cs, r5, 32}, true, cs, "cs r5 32", "cs_r5_32"},
                           {{cc, r7, 43}, true, cc, "cc r7 43", "cc_r7_43"},
                           {{pl, r6, 122}, true, pl, "pl r6 122", "pl_r6_122"},
                           {{eq, r7, 87}, true, eq, "eq r7 87", "eq_r7_87"},
                           {{cc, r1, 250}, true, cc, "cc r1 250", "cc_r1_250"},
                           {{vc, r1, 236}, true, vc, "vc r1 236", "vc_r1_236"},
                           {{pl, r1, 83}, true, pl, "pl r1 83", "pl_r1_83"},
                           {{gt, r2, 228}, true, gt, "gt r2 228", "gt_r2_228"},
                           {{mi, r1, 41}, true, mi, "mi r1 41", "mi_r1_41"},
                           {{hi, r1, 42}, true, hi, "hi r1 42", "hi_r1_42"},
                           {{hi, r0, 242}, true, hi, "hi r0 242", "hi_r0_242"},
                           {{ne, r7, 9}, true, ne, "ne r7 9", "ne_r7_9"},
                           {{lt, r3, 0}, true, lt, "lt r3 0", "lt_r3_0"},
                           {{pl, r0, 183}, true, pl, "pl r0 183", "pl_r0_183"},
                           {{hi, r2, 117}, true, hi, "hi r2 117", "hi_r2_117"},
                           {{hi, r0, 77}, true, hi, "hi r0 77", "hi_r0_77"},
                           {{ls, r3, 159}, true, ls, "ls r3 159", "ls_r3_159"},
                           {{cc, r4, 5}, true, cc, "cc r4 5", "cc_r4_5"},
                           {{vc, r4, 244}, true, vc, "vc r4 244", "vc_r4_244"},
                           {{hi, r2, 121}, true, hi, "hi r2 121", "hi_r2_121"},
                           {{le, r3, 90}, true, le, "le r3 90", "le_r3_90"},
                           {{vc, r6, 10}, true, vc, "vc r6 10", "vc_r6_10"},
                           {{cs, r5, 150}, true, cs, "cs r5 150", "cs_r5_150"},
                           {{vc, r7, 117}, true, vc, "vc r7 117", "vc_r7_117"},
                           {{cs, r7, 211}, true, cs, "cs r7 211", "cs_r7_211"},
                           {{cs, r0, 18}, true, cs, "cs r0 18", "cs_r0_18"},
                           {{ne, r2, 60}, true, ne, "ne r2 60", "ne_r2_60"},
                           {{ge, r0, 223}, true, ge, "ge r0 223", "ge_r0_223"},
                           {{lt, r1, 176}, true, lt, "lt r1 176", "lt_r1_176"},
                           {{eq, r6, 15}, true, eq, "eq r6 15", "eq_r6_15"},
                           {{vs, r7, 74}, true, vs, "vs r7 74", "vs_r7_74"},
                           {{ne, r5, 68}, true, ne, "ne r5 68", "ne_r5_68"},
                           {{ne, r7, 49}, true, ne, "ne r7 49", "ne_r7_49"},
                           {{le, r0, 139}, true, le, "le r0 139", "le_r0_139"},
                           {{ge, r3, 218}, true, ge, "ge r3 218", "ge_r3_218"},
                           {{ge, r2, 25}, true, ge, "ge r2 25", "ge_r2_25"},
                           {{mi, r5, 117}, true, mi, "mi r5 117", "mi_r5_117"},
                           {{pl, r7, 57}, true, pl, "pl r7 57", "pl_r7_57"},
                           {{gt, r7, 7}, true, gt, "gt r7 7", "gt_r7_7"},
                           {{ne, r4, 55}, true, ne, "ne r4 55", "ne_r4_55"},
                           {{ne, r7, 56}, true, ne, "ne r7 56", "ne_r7_56"},
                           {{cc, r5, 55}, true, cc, "cc r5 55", "cc_r5_55"},
                           {{cc, r7, 84}, true, cc, "cc r7 84", "cc_r7_84"},
                           {{cs, r5, 229}, true, cs, "cs r5 229", "cs_r5_229"},
                           {{ne, r1, 205}, true, ne, "ne r1 205", "ne_r1_205"},
                           {{ge, r1, 133}, true, ge, "ge r1 133", "ge_r1_133"},
                           {{vc, r0, 25}, true, vc, "vc r0 25", "vc_r0_25"},
                           {{ge, r0, 114}, true, ge, "ge r0 114", "ge_r0_114"},
                           {{le, r5, 135}, true, le, "le r5 135", "le_r5_135"},
                           {{pl, r3, 145}, true, pl, "pl r3 145", "pl_r3_145"},
                           {{le, r5, 197}, true, le, "le r5 197", "le_r5_197"},
                           {{vc, r0, 14}, true, vc, "vc r0 14", "vc_r0_14"},
                           {{vc, r3, 113}, true, vc, "vc r3 113", "vc_r3_113"},
                           {{le, r3, 224}, true, le, "le r3 224", "le_r3_224"},
                           {{le, r1, 99}, true, le, "le r1 99", "le_r1_99"},
                           {{le, r6, 222}, true, le, "le r6 222", "le_r6_222"},
                           {{vc, r6, 15}, true, vc, "vc r6 15", "vc_r6_15"},
                           {{ge, r5, 59}, true, ge, "ge r5 59", "ge_r5_59"},
                           {{mi, r2, 187}, true, mi, "mi r2 187", "mi_r2_187"},
                           {{ls, r0, 107}, true, ls, "ls r0 107", "ls_r0_107"},
                           {{le, r6, 111}, true, le, "le r6 111", "le_r6_111"},
                           {{hi, r7, 58}, true, hi, "hi r7 58", "hi_r7_58"},
                           {{le, r1, 143}, true, le, "le r1 143", "le_r1_143"},
                           {{cs, r7, 181}, true, cs, "cs r7 181", "cs_r7_181"},
                           {{hi, r4, 235}, true, hi, "hi r4 235", "hi_r4_235"},
                           {{vs, r3, 69}, true, vs, "vs r3 69", "vs_r3_69"},
                           {{ls, r1, 100}, true, ls, "ls r1 100", "ls_r1_100"},
                           {{ne, r7, 93}, true, ne, "ne r7 93", "ne_r7_93"},
                           {{pl, r5, 10}, true, pl, "pl r5 10", "pl_r5_10"},
                           {{eq, r0, 158}, true, eq, "eq r0 158", "eq_r0_158"},
                           {{pl, r5, 8}, true, pl, "pl r5 8", "pl_r5_8"},
                           {{vc, r5, 172}, true, vc, "vc r5 172", "vc_r5_172"},
                           {{ne, r6, 0}, true, ne, "ne r6 0", "ne_r6_0"},
                           {{mi, r0, 106}, true, mi, "mi r0 106", "mi_r0_106"},
                           {{vs, r7, 229}, true, vs, "vs r7 229", "vs_r7_229"},
                           {{ne, r6, 75}, true, ne, "ne r6 75", "ne_r6_75"},
                           {{cc, r7, 247}, true, cc, "cc r7 247", "cc_r7_247"},
                           {{ne, r0, 171}, true, ne, "ne r0 171", "ne_r0_171"},
                           {{lt, r6, 76}, true, lt, "lt r6 76", "lt_r6_76"},
                           {{ls, r6, 20}, true, ls, "ls r6 20", "ls_r6_20"},
                           {{ne, r3, 79}, true, ne, "ne r3 79", "ne_r3_79"},
                           {{lt, r4, 214}, true, lt, "lt r4 214", "lt_r4_214"},
                           {{gt, r1, 108}, true, gt, "gt r1 108", "gt_r1_108"},
                           {{ls, r0, 149}, true, ls, "ls r0 149", "ls_r0_149"},
                           {{vc, r5, 218}, true, vc, "vc r5 218", "vc_r5_218"},
                           {{hi, r3, 65}, true, hi, "hi r3 65", "hi_r3_65"},
                           {{ge, r4, 9}, true, ge, "ge r4 9", "ge_r4_9"},
                           {{ls, r2, 252}, true, ls, "ls r2 252", "ls_r2_252"},
                           {{vs, r1, 107}, true, vs, "vs r1 107", "vs_r1_107"},
                           {{le, r7, 32}, true, le, "le r7 32", "le_r7_32"},
                           {{cs, r7, 22}, true, cs, "cs r7 22", "cs_r7_22"},
                           {{le, r1, 145}, true, le, "le r1 145", "le_r1_145"},
                           {{ne, r2, 144}, true, ne, "ne r2 144", "ne_r2_144"},
                           {{mi, r4, 79}, true, mi, "mi r4 79", "mi_r4_79"},
                           {{ne, r5, 240}, true, ne, "ne r5 240", "ne_r5_240"},
                           {{lt, r7, 251}, true, lt, "lt r7 251", "lt_r7_251"},
                           {{le, r0, 118}, true, le, "le r0 118", "le_r0_118"},
                           {{eq, r0, 199}, true, eq, "eq r0 199", "eq_r0_199"},
                           {{hi, r3, 105}, true, hi, "hi r3 105", "hi_r3_105"},
                           {{cs, r3, 215}, true, cs, "cs r3 215", "cs_r3_215"},
                           {{ge, r7, 19}, true, ge, "ge r7 19", "ge_r7_19"},
                           {{le, r4, 94}, true, le, "le r4 94", "le_r4_94"},
                           {{hi, r4, 100}, true, hi, "hi r4 100", "hi_r4_100"},
                           {{cc, r7, 116}, true, cc, "cc r7 116", "cc_r7_116"},
                           {{ls, r4, 168}, true, ls, "ls r4 168", "ls_r4_168"},
                           {{lt, r5, 5}, true, lt, "lt r5 5", "lt_r5_5"},
                           {{vc, r4, 121}, true, vc, "vc r4 121", "vc_r4_121"},
                           {{ls, r2, 235}, true, ls, "ls r2 235", "ls_r2_235"},
                           {{gt, r2, 65}, true, gt, "gt r2 65", "gt_r2_65"},
                           {{le, r0, 153}, true, le, "le r0 153", "le_r0_153"},
                           {{ge, r2, 92}, true, ge, "ge r2 92", "ge_r2_92"},
                           {{cs, r7, 183}, true, cs, "cs r7 183", "cs_r7_183"},
                           {{vs, r7, 90}, true, vs, "vs r7 90", "vs_r7_90"},
                           {{ge, r7, 83}, true, ge, "ge r7 83", "ge_r7_83"},
                           {{vc, r6, 170}, true, vc, "vc r6 170", "vc_r6_170"},
                           {{vs, r7, 13}, true, vs, "vs r7 13", "vs_r7_13"},
                           {{cc, r2, 26}, true, cc, "cc r2 26", "cc_r2_26"},
                           {{ls, r3, 118}, true, ls, "ls r3 118", "ls_r3_118"},
                           {{vc, r4, 78}, true, vc, "vc r4 78", "vc_r4_78"},
                           {{vc, r1, 222}, true, vc, "vc r1 222", "vc_r1_222"},
                           {{ls, r7, 16}, true, ls, "ls r7 16", "ls_r7_16"},
                           {{vs, r4, 41}, true, vs, "vs r4 41", "vs_r4_41"},
                           {{lt, r3, 21}, true, lt, "lt r3 21", "lt_r3_21"},
                           {{gt, r5, 73}, true, gt, "gt r5 73", "gt_r5_73"},
                           {{vs, r2, 21}, true, vs, "vs r2 21", "vs_r2_21"},
                           {{gt, r6, 212}, true, gt, "gt r6 212", "gt_r6_212"},
                           {{ge, r0, 217}, true, ge, "ge r0 217", "ge_r0_217"},
                           {{ge, r3, 163}, true, ge, "ge r3 163", "ge_r3_163"},
                           {{hi, r4, 180}, true, hi, "hi r4 180", "hi_r4_180"},
                           {{cs, r3, 163}, true, cs, "cs r3 163", "cs_r3_163"},
                           {{hi, r3, 3}, true, hi, "hi r3 3", "hi_r3_3"},
                           {{gt, r3, 121}, true, gt, "gt r3 121", "gt_r3_121"},
                           {{cs, r0, 82}, true, cs, "cs r0 82", "cs_r0_82"},
                           {{cc, r1, 204}, true, cc, "cc r1 204", "cc_r1_204"},
                           {{cc, r2, 16}, true, cc, "cc r2 16", "cc_r2_16"},
                           {{le, r4, 152}, true, le, "le r4 152", "le_r4_152"},
                           {{ls, r6, 168}, true, ls, "ls r6 168", "ls_r6_168"},
                           {{cs, r4, 85}, true, cs, "cs r4 85", "cs_r4_85"},
                           {{lt, r7, 175}, true, lt, "lt r7 175", "lt_r7_175"},
                           {{cs, r7, 165}, true, cs, "cs r7 165", "cs_r7_165"},
                           {{ge, r1, 6}, true, ge, "ge r1 6", "ge_r1_6"},
                           {{cs, r3, 59}, true, cs, "cs r3 59", "cs_r3_59"},
                           {{ne, r1, 223}, true, ne, "ne r1 223", "ne_r1_223"},
                           {{vs, r1, 222}, true, vs, "vs r1 222", "vs_r1_222"},
                           {{cs, r0, 102}, true, cs, "cs r0 102", "cs_r0_102"},
                           {{ls, r0, 62}, true, ls, "ls r0 62", "ls_r0_62"},
                           {{vs, r6, 97}, true, vs, "vs r6 97", "vs_r6_97"},
                           {{gt, r6, 60}, true, gt, "gt r6 60", "gt_r6_60"},
                           {{mi, r7, 144}, true, mi, "mi r7 144", "mi_r7_144"},
                           {{vs, r4, 0}, true, vs, "vs r4 0", "vs_r4_0"},
                           {{hi, r5, 62}, true, hi, "hi r5 62", "hi_r5_62"},
                           {{le, r1, 49}, true, le, "le r1 49", "le_r1_49"},
                           {{le, r4, 178}, true, le, "le r4 178", "le_r4_178"},
                           {{lt, r3, 149}, true, lt, "lt r3 149", "lt_r3_149"},
                           {{vs, r7, 64}, true, vs, "vs r7 64", "vs_r7_64"},
                           {{ne, r3, 202}, true, ne, "ne r3 202", "ne_r3_202"},
                           {{ne, r2, 164}, true, ne, "ne r2 164", "ne_r2_164"},
                           {{gt, r3, 193}, true, gt, "gt r3 193", "gt_r3_193"},
                           {{le, r7, 164}, true, le, "le r7 164", "le_r7_164"},
                           {{eq, r6, 151}, true, eq, "eq r6 151", "eq_r6_151"},
                           {{hi, r3, 38}, true, hi, "hi r3 38", "hi_r3_38"},
                           {{gt, r7, 191}, true, gt, "gt r7 191", "gt_r7_191"},
                           {{ge, r6, 42}, true, ge, "ge r6 42", "ge_r6_42"},
                           {{vc, r6, 247}, true, vc, "vc r6 247", "vc_r6_247"},
                           {{hi, r5, 236}, true, hi, "hi r5 236", "hi_r5_236"},
                           {{hi, r5, 234}, true, hi, "hi r5 234", "hi_r5_234"},
                           {{le, r4, 126}, true, le, "le r4 126", "le_r4_126"},
                           {{gt, r7, 241}, true, gt, "gt r7 241", "gt_r7_241"},
                           {{hi, r7, 116}, true, hi, "hi r7 116", "hi_r7_116"},
                           {{cs, r7, 119}, true, cs, "cs r7 119", "cs_r7_119"},
                           {{ge, r3, 148}, true, ge, "ge r3 148", "ge_r3_148"},
                           {{gt, r7, 88}, true, gt, "gt r7 88", "gt_r7_88"},
                           {{vc, r6, 58}, true, vc, "vc r6 58", "vc_r6_58"},
                           {{mi, r6, 157}, true, mi, "mi r6 157", "mi_r6_157"},
                           {{cs, r0, 129}, true, cs, "cs r0 129", "cs_r0_129"},
                           {{vc, r1, 161}, true, vc, "vc r1 161", "vc_r1_161"},
                           {{mi, r0, 34}, true, mi, "mi r0 34", "mi_r0_34"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rdlow-operand-imm8-in-it-block-cmp-t32.h"
#include "aarch32/traces/assembler-cond-rdlow-operand-imm8-in-it-block-mov-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    int32_t immediate = kTests[i].operands.immediate;
    Operand op(immediate);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RDLOW_OPERAND_IMM8_IN_IT_BLOCK_" #mnemonic    \
      "_T32",                                                               \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
