// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UMLSL_4S_TRACE_AARCH64_H_
#define VIXL_SIM_UMLSL_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_umlsl_4S[] = {
  0xffffc1fc, 0xffffc100, 0xf5c2a3d9, 0xe38e71e7,
  0xffffc17e, 0xffe699b4, 0xeeef1113, 0xd556801f,
  0xffe6cce6, 0xffd5aad6, 0xe667199b, 0xd5562aca,
  0xffd6002a, 0xffc0817e, 0xe666e668, 0xd555d575,
  0xffc1017a, 0xffc080ff, 0xe666b335, 0x00000020,
  0xffc100fc, 0xffc08080, 0x00000002, 0xffffaacb,
  0xffc1007e, 0x00000001, 0xffffcccf, 0xffff5576,
  0x00000000, 0xffffff82, 0xffff999c, 0xfffaaad0,
  0xffffff82, 0xffffff03, 0xfffcccd2, 0xffd6559f,
  0xffffff04, 0xfffff811, 0xffe7001b, 0xffd6004a,
  0xfffff820, 0xffffc1fe, 0xffe6cce8, 0xffd5aaf5,
  0xffffc27a, 0xffffc17f, 0xffe699b5, 0xeeef1131,
  0xffffc1fc, 0xffffc100, 0xf5c2a3d9, 0xe38e71e7,
  0xffffc17e, 0xffe699b4, 0xeeef1113, 0xd556801f,
  0xffe6cce6, 0xffd5aad6, 0xe667199b, 0xd5562aca,
  0xffd6002a, 0xffc0817e, 0xe666e668, 0xd555d575,
  0xffc1017a, 0xffc080ff, 0xe666b335, 0xd5558020,
  0xffc100fc, 0xffc08080, 0xe6668002, 0xd5552acb,
  0xffc1007e, 0xffc08001, 0xe6664ccf, 0xc71ce3ae,
  0xffc10000, 0xffc07f82, 0xddde2224, 0xbbbc4464,
  0xffc0ff82, 0xffab55ab, 0xd70a8f5e, 0xaad5aaa0,
  0xffac0054, 0xff9a66cd, 0xcce69982, 0xaad5554b,
  0xff9b3398, 0xff813f81, 0xcce6664f, 0xaad4fff6,
  0xff823f00, 0xff813f02, 0xcce6331c, 0xaad4aaa1,
  0xff813f01, 0xcce6331b, 0xaad4aa83, 0x800afff0,
  0xff813e82, 0xcce5ffe8, 0xaab05552, 0x80048017,
  0xff813e03, 0xccd03331, 0xaaac0001, 0x8004001a,
  0xff8107f0, 0xcccd999a, 0xaaabaaac, 0x8003801d,
  0xff81017d, 0xcccd6667, 0xaaab5557, 0x00000020,
  0xff8100fe, 0xcccd3334, 0x00000002, 0xffff8023,
  0xff81007f, 0x00000001, 0xffffaaad, 0xffff0026,
  0x00000000, 0xffffccce, 0xffff5558, 0xfff80050,
  0xffffff81, 0xffff999b, 0xfffaaab2, 0xffc18197,
  0xffffff02, 0xfffcccd1, 0xffd65581, 0xffc1019a,
  0xfffff810, 0xffe7001a, 0xffd6002c, 0xffc0819d,
  0xffffc1fd, 0xffe6cce7, 0xffd5aad7, 0xe66719b9,
  0xffffc17e, 0xffe699b4, 0xeeef1113, 0xd556801f,
  0xffffc0ff, 0xf5c2a3d8, 0xe38e71c9, 0xc0030017,
  0xffe699b3, 0xeeef1112, 0xd5568001, 0xc002801a,
  0xffd5aad5, 0xe667199a, 0xd5562aac, 0xc002001d,
  0xffc0817d, 0xe666e667, 0xd555d557, 0xc0018020,
  0xffc080fe, 0xe666b334, 0xd5558002, 0xc0010023,
  0xffc0807f, 0xe6668001, 0xd5552aad, 0xaaad001e,
  0xffc08000, 0xe6664cce, 0xc71ce390, 0x999c6684,
  0xffc07f81, 0xddde2223, 0xbbbc4446, 0x8042fea0,
  0xffab55aa, 0xd70a8f5d, 0xaad5aa82, 0x80427ea3,
  0xff9a66cc, 0xcce69981, 0xaad5552d, 0x8041fea6,
  0xff813f80, 0xcce6664e, 0xaad4ffd8, 0x80417ea9,
  0xcce6664d, 0xaad4ffd7, 0x80417e8b, 0x800a0000,
  0xcce6331a, 0xaad4aa82, 0x800affd2, 0x8003801a,
  0xcce5ffe7, 0xaab05551, 0x80047ff9, 0x8003001c,
  0xccd03330, 0xaaac0000, 0x8003fffc, 0x8002801e,
  0xcccd9999, 0xaaabaaab, 0x80037fff, 0x00000020,
  0xcccd6666, 0xaaab5556, 0x00000002, 0xffff8022,
  0xcccd3333, 0x00000001, 0xffff8005, 0xffff0024,
  0x00000000, 0xffffaaac, 0xffff0008, 0xfff80040,
  0xffffcccd, 0xffff5557, 0xfff80032, 0xffc1811a,
  0xffff999a, 0xfffaaab1, 0xffc18179, 0xffc1011c,
  0xfffcccd0, 0xffd65580, 0xffc1017c, 0xffc0811e,
  0xffe70019, 0xffd6002b, 0xffc0817f, 0xe666e686,
  0xffe6cce6, 0xffd5aad6, 0xe667199b, 0xd5562aca,
  0xffe699b3, 0xeeef1112, 0xd5568001, 0xc002801a,
  0xf5c2a3d7, 0xe38e71c8, 0xc002fff9, 0xc002001c,
  0xeeef1111, 0xd5568000, 0xc0027ffc, 0xc001801e,
  0xe6671999, 0xd5562aab, 0xc001ffff, 0xc0010020,
  0xe666e666, 0xd555d556, 0xc0018002, 0xc0008022,
  0xe666b333, 0xd5558001, 0xc0010005, 0xaaac5574,
  0xe6668000, 0xd5552aac, 0xaaad0000, 0x999b99b8,
  0xe6664ccd, 0xc71ce38f, 0x999c6666, 0x8041ff20,
  0xddde2222, 0xbbbc4445, 0x8042fe82, 0x80417f22,
  0xd70a8f5c, 0xaad5aa81, 0x80427e85, 0x8040ff24,
  0xcce69980, 0xaad5552c, 0x8041fe88, 0x80407f26,
  0xaad5552b, 0x8041fe87, 0x80407f08, 0x80090010,
  0xaad4ffd6, 0x80417e8a, 0x8009ffe2, 0x8002801d,
  0xaad4aa81, 0x800affd1, 0x80037ffc, 0x8002001e,
  0xaab05550, 0x80047ff8, 0x8002fffe, 0x8001801f,
  0xaaabffff, 0x8003fffb, 0x80028000, 0x00000020,
  0xaaabaaaa, 0x80037ffe, 0x00000002, 0xffff8021,
  0xaaab5555, 0x00000001, 0xffff8004, 0xffff0022,
  0x00000000, 0xffff8004, 0xffff0006, 0xfff80030,
  0xffffaaab, 0xffff0007, 0xfff80022, 0xffc1809d,
  0xffff5556, 0xfff80031, 0xffc180fc, 0xffc1009e,
  0xfffaaab0, 0xffc18178, 0xffc100fe, 0xffc0809f,
  0xffd6557f, 0xffc1017b, 0xffc08100, 0xe666b353,
  0xffd6002a, 0xffc0817e, 0xe666e668, 0xd555d575,
  0xffd5aad5, 0xe667199a, 0xd5562aac, 0xc002001d,
  0xeeef1111, 0xd5568000, 0xc0027ffc, 0xc001801e,
  0xe38e71c7, 0xc002fff8, 0xc001fffe, 0xc001001f,
  0xd5567fff, 0xc0027ffb, 0xc0018000, 0xc0008020,
  0xd5562aaa, 0xc001fffe, 0xc0010002, 0xc0000021,
  0xd555d555, 0xc0018001, 0xc0008004, 0xaaabaaca,
  0xd5558000, 0xc0010004, 0xaaac5556, 0x999accec,
  0xd5552aab, 0xaaacffff, 0x999b999a, 0x8040ffa0,
  0xc71ce38e, 0x999c6665, 0x8041ff02, 0x80407fa1,
  0xbbbc4444, 0x8042fe81, 0x80417f04, 0x803fffa2,
  0xaad5aa80, 0x80427e84, 0x8040ff06, 0x803f7fa3,
  0x80427e83, 0x8040ff05, 0x803f7f85, 0x00000020,
  0x8041fe86, 0x80407f07, 0x8008fff2, 0x00000020,
  0x80417e89, 0x8009ffe1, 0x80027fff, 0x00000020,
  0x800affd0, 0x80037ffb, 0x80020000, 0x00000020,
  0x80047ff7, 0x8002fffd, 0x80018001, 0x00000020,
  0x8003fffa, 0x80027fff, 0x00000002, 0x00000020,
  0x80037ffd, 0x00000001, 0xffff8003, 0x00000020,
  0x00000000, 0xffff8003, 0xffff0004, 0x00000020,
  0xffff8003, 0xffff0005, 0xfff80012, 0x00000020,
  0xffff0006, 0xfff80021, 0xffc1807f, 0x00000020,
  0xfff80030, 0xffc180fb, 0xffc10080, 0x00000020,
  0xffc18177, 0xffc100fd, 0xffc08081, 0x00000020,
  0xffc1017a, 0xffc080ff, 0xe666b335, 0x00000020,
  0xffc0817d, 0xe666e667, 0xd555d557, 0x00000020,
  0xe6671999, 0xd5562aab, 0xc001ffff, 0x00000020,
  0xd5567fff, 0xc0027ffb, 0xc0018000, 0x00000020,
  0xc002fff7, 0xc001fffd, 0xc0010001, 0x00000020,
  0xc0027ffa, 0xc0017fff, 0xc0008002, 0x00000020,
  0xc001fffd, 0xc0010001, 0xc0000003, 0x00000020,
  0xc0018000, 0xc0008003, 0xaaabaaac, 0x00000020,
  0xc0010003, 0xaaac5555, 0x999accce, 0x00000020,
  0xaaacfffe, 0x999b9999, 0x8040ff82, 0x00000020,
  0x999c6664, 0x8041ff01, 0x80407f83, 0x00000020,
  0x8042fe80, 0x80417f03, 0x803fff84, 0x00000020,
  0x80417f02, 0x803fff83, 0x00000002, 0xffff0030,
  0x8040ff04, 0x803f7f84, 0x00000002, 0xffff0023,
  0x80407f06, 0x8008fff1, 0x00000002, 0xffff0022,
  0x8009ffe0, 0x80027ffe, 0x00000002, 0xffff0021,
  0x80037ffa, 0x8001ffff, 0x00000002, 0x00000020,
  0x8002fffc, 0x80018000, 0x00000002, 0x0000001f,
  0x80027ffe, 0x00000001, 0x00000002, 0x0000001e,
  0x00000000, 0xffff8002, 0x00000002, 0x00000010,
  0xffff8002, 0xffff0003, 0x00000002, 0xffffffa3,
  0xffff0004, 0xfff80011, 0x00000002, 0xffffffa2,
  0xfff80020, 0xffc1807e, 0x00000002, 0xffffffa1,
  0xffc180fa, 0xffc1007f, 0x00000002, 0xffffcced,
  0xffc100fc, 0xffc08080, 0x00000002, 0xffffaacb,
  0xffc080fe, 0xe666b334, 0x00000002, 0xffff8023,
  0xe666e666, 0xd555d556, 0x00000002, 0xffff8022,
  0xd5562aaa, 0xc001fffe, 0x00000002, 0xffff8021,
  0xc0027ffa, 0xc0017fff, 0x00000002, 0xffff8020,
  0xc001fffc, 0xc0010000, 0x00000002, 0xffff801f,
  0xc0017ffe, 0xc0008001, 0x00000002, 0xffff5576,
  0xc0010000, 0xc0000002, 0x00000002, 0xffff3354,
  0xc0008002, 0xaaabaaab, 0x00000002, 0xffff00a0,
  0xaaac5554, 0x999acccd, 0x00000002, 0xffff009f,
  0x999b9998, 0x8040ff81, 0x00000002, 0xffff009e,
  0x8041ff00, 0x80407f82, 0x00000002, 0xffff009d,
  0x80407f81, 0x00000001, 0xffff007f, 0xfffe0040,
  0x803fff82, 0x00000001, 0xffff0012, 0xfffe0026,
  0x803f7f83, 0x00000001, 0xffff0005, 0xfffe0024,
  0x8008fff0, 0x00000001, 0xffff0004, 0xfffe0022,
  0x80027ffd, 0x00000001, 0xffff0003, 0x00000020,
  0x8001fffe, 0x00000001, 0x00000002, 0x0000001e,
  0x80017fff, 0x00000001, 0x00000001, 0x0000001c,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0xffff8001, 0x00000001, 0xfffffff2, 0xffffff26,
  0xffff0002, 0x00000001, 0xffffff85, 0xffffff24,
  0xfff80010, 0x00000001, 0xffffff84, 0xffffff22,
  0xffc1807d, 0x00000001, 0xffffff83, 0xffff99ba,
  0xffc1007e, 0x00000001, 0xffffcccf, 0xffff5576,
  0xffc0807f, 0x00000001, 0xffffaaad, 0xffff0026,
  0xe666b333, 0x00000001, 0xffff8005, 0xffff0024,
  0xd555d555, 0x00000001, 0xffff8004, 0xffff0022,
  0xc001fffd, 0x00000001, 0xffff8003, 0xffff0020,
  0xc0017ffe, 0x00000001, 0xffff8002, 0xffff001e,
  0xc000ffff, 0x00000001, 0xffff8001, 0xfffeaacc,
  0xc0008000, 0x00000001, 0xffff5558, 0xfffe6688,
  0xc0000001, 0x00000001, 0xffff3336, 0xfffe0120,
  0xaaabaaaa, 0x00000001, 0xffff0082, 0xfffe011e,
  0x999acccc, 0x00000001, 0xffff0081, 0xfffe011c,
  0x8040ff80, 0x00000001, 0xffff0080, 0xfffe011a,
  0x00000000, 0xffff007f, 0xfffe00fc, 0xfff00120,
  0x00000000, 0xffff007e, 0xfffe0022, 0xfff00050,
  0x00000000, 0xffff0011, 0xfffe0008, 0xfff00040,
  0x00000000, 0xffff0004, 0xfffe0006, 0xfff00030,
  0x00000000, 0xffff0003, 0xfffe0004, 0x00000020,
  0x00000000, 0xffff0002, 0x00000002, 0x00000010,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0xfffffffe, 0xffffff20,
  0x00000000, 0xffffffff, 0xffffffe2, 0xfffff850,
  0x00000000, 0xfffffff1, 0xffffff08, 0xfffff840,
  0x00000000, 0xffffff84, 0xffffff06, 0xfffff830,
  0x00000000, 0xffffff83, 0xffffff04, 0xfffcccf0,
  0x00000000, 0xffffff82, 0xffff999c, 0xfffaaad0,
  0x00000000, 0xffffccce, 0xffff5558, 0xfff80050,
  0x00000000, 0xffffaaac, 0xffff0008, 0xfff80040,
  0x00000000, 0xffff8004, 0xffff0006, 0xfff80030,
  0x00000000, 0xffff8003, 0xffff0004, 0xfff80020,
  0x00000000, 0xffff8002, 0xffff0002, 0xfff80010,
  0x00000000, 0xffff8001, 0xffff0000, 0xfff55580,
  0x00000000, 0xffff8000, 0xfffeaaae, 0xfff33360,
  0x00000000, 0xffff5557, 0xfffe666a, 0xfff00820,
  0x00000000, 0xffff3335, 0xfffe0102, 0xfff00810,
  0x00000000, 0xffff0081, 0xfffe0100, 0xfff00800,
  0x00000000, 0xffff0080, 0xfffe00fe, 0xfff007f0,
  0xffff007f, 0xfffe00fd, 0xfff007d2, 0xff8307f0,
  0xffff007e, 0xfffe00fb, 0xfff00102, 0xff830197,
  0xffff007d, 0xfffe0021, 0xfff00032, 0xff83011a,
  0xffff0010, 0xfffe0007, 0xfff00022, 0xff83009d,
  0xffff0003, 0xfffe0005, 0xfff00012, 0x00000020,
  0xffff0002, 0xfffe0003, 0x00000002, 0xffffffa3,
  0xffff0001, 0x00000001, 0xfffffff2, 0xffffff26,
  0x00000000, 0xffffffff, 0xffffffe2, 0xfffff850,
  0xffffffff, 0xfffffffd, 0xffffff02, 0xffffc317,
  0xfffffffe, 0xffffffe1, 0xfffff832, 0xffffc29a,
  0xfffffff0, 0xffffff07, 0xfffff822, 0xffffc21d,
  0xffffff83, 0xffffff05, 0xfffff812, 0xffe70039,
  0xffffff82, 0xffffff03, 0xfffcccd2, 0xffd6559f,
  0xffffff81, 0xffff999b, 0xfffaaab2, 0xffc18197,
  0xffffcccd, 0xffff5557, 0xfff80032, 0xffc1811a,
  0xffffaaab, 0xffff0007, 0xfff80022, 0xffc1809d,
  0xffff8003, 0xffff0005, 0xfff80012, 0xffc18020,
  0xffff8002, 0xffff0003, 0xfff80002, 0xffc17fa3,
  0xffff8001, 0xffff0001, 0xfff7fff2, 0xffacab1e,
  0xffff8000, 0xfffeffff, 0xfff55562, 0xff9c0084,
  0xffff7fff, 0xfffeaaad, 0xfff33342, 0xff833ea0,
  0xffff5556, 0xfffe6669, 0xfff00802, 0xff833e23,
  0xffff3334, 0xfffe0101, 0xfff007f2, 0xff833da6,
  0xffff0080, 0xfffe00ff, 0xfff007e2, 0xff833d29,
  0xfffe00fe, 0xfff007e1, 0xff833d0b, 0xff820800,
  0xfffe00fc, 0xfff007d1, 0xff8307d2, 0xff82019a,
  0xfffe00fa, 0xfff00101, 0xff830179, 0xff82011c,
  0xfffe0020, 0xfff00031, 0xff8300fc, 0xff82009e,
  0xfffe0006, 0xfff00021, 0xff83007f, 0x00000020,
  0xfffe0004, 0xfff00011, 0x00000002, 0xffffffa2,
  0xfffe0002, 0x00000001, 0xffffff85, 0xffffff24,
  0x00000000, 0xfffffff1, 0xffffff08, 0xfffff840,
  0xfffffffe, 0xffffffe1, 0xfffff832, 0xffffc29a,
  0xfffffffc, 0xffffff01, 0xffffc2f9, 0xffffc21c,
  0xffffffe0, 0xfffff831, 0xffffc27c, 0xffffc19e,
  0xffffff06, 0xfffff821, 0xffffc1ff, 0xffe6cd06,
  0xffffff04, 0xfffff811, 0xffe7001b, 0xffd6004a,
  0xffffff02, 0xfffcccd1, 0xffd65581, 0xffc1019a,
  0xffff999a, 0xfffaaab1, 0xffc18179, 0xffc1011c,
  0xffff5556, 0xfff80031, 0xffc180fc, 0xffc1009e,
  0xffff0006, 0xfff80021, 0xffc1807f, 0xffc10020,
  0xffff0004, 0xfff80011, 0xffc18002, 0xffc0ffa2,
  0xffff0002, 0xfff80001, 0xffc17f85, 0xffac0074,
  0xffff0000, 0xfff7fff1, 0xffacab00, 0xff9b33b8,
  0xfffefffe, 0xfff55561, 0xff9c0066, 0xff823f20,
  0xfffeaaac, 0xfff33341, 0xff833e82, 0xff823ea2,
  0xfffe6668, 0xfff00801, 0xff833e05, 0xff823e24,
  0xfffe0100, 0xfff007f1, 0xff833d88, 0xff823da6,
  0xfff007f0, 0xff833d87, 0xff823d88, 0xff810810,
  0xfff007e0, 0xff833d0a, 0xff8207e2, 0xff81019d,
  0xfff007d0, 0xff8307d1, 0xff82017c, 0xff81011e,
  0xfff00100, 0xff830178, 0xff8200fe, 0xff81009f,
  0xfff00030, 0xff8300fb, 0xff820080, 0x00000020,
  0xfff00020, 0xff83007e, 0x00000002, 0xffffffa1,
  0xfff00010, 0x00000001, 0xffffff84, 0xffffff22,
  0x00000000, 0xffffff84, 0xffffff06, 0xfffff830,
  0xfffffff0, 0xffffff07, 0xfffff822, 0xffffc21d,
  0xffffffe0, 0xfffff831, 0xffffc27c, 0xffffc19e,
  0xffffff00, 0xffffc2f8, 0xffffc1fe, 0xffffc11f,
  0xfffff830, 0xffffc27b, 0xffffc180, 0xffe699d3,
  0xfffff820, 0xffffc1fe, 0xffe6cce8, 0xffd5aaf5,
  0xfffff810, 0xffe7001a, 0xffd6002c, 0xffc0819d,
  0xfffcccd0, 0xffd65580, 0xffc1017c, 0xffc0811e,
  0xfffaaab0, 0xffc18178, 0xffc100fe, 0xffc0809f,
  0xfff80030, 0xffc180fb, 0xffc10080, 0xffc08020,
  0xfff80020, 0xffc1807e, 0xffc10002, 0xffc07fa1,
  0xfff80010, 0xffc18001, 0xffc0ff84, 0xffab55ca,
  0xfff80000, 0xffc17f84, 0xffac0056, 0xff9a66ec,
  0xfff7fff0, 0xffacaaff, 0xff9b339a, 0xff813fa0,
  0xfff55560, 0xff9c0065, 0xff823f02, 0xff813f21,
  0xfff33340, 0xff833e81, 0xff823e84, 0xff813ea2,
  0xfff00800, 0xff833e04, 0xff823e06, 0xff813e23,
  0xff833e03, 0xff823e05, 0xff813e05, 0xccd03350,
  0xff833d86, 0xff823d87, 0xff8107f2, 0xcccd99b9,
  0xff833d09, 0xff8207e1, 0xff81017f, 0xcccd6686,
  0xff8307d0, 0xff82017b, 0xff810100, 0xcccd3353,
  0xff830177, 0xff8200fd, 0xff810081, 0x00000020,
  0xff8300fa, 0xff82007f, 0x00000002, 0xffffcced,
  0xff83007d, 0x00000001, 0xffffff83, 0xffff99ba,
  0x00000000, 0xffffff83, 0xffffff04, 0xfffcccf0,
  0xffffff83, 0xffffff05, 0xfffff812, 0xffe70039,
  0xffffff06, 0xfffff821, 0xffffc1ff, 0xffe6cd06,
  0xfffff830, 0xffffc27b, 0xffffc180, 0xffe699d3,
  0xffffc2f7, 0xffffc1fd, 0xffffc101, 0xf5c2a3f7,
  0xffffc27a, 0xffffc17f, 0xffe699b5, 0xeeef1131,
  0xffffc1fd, 0xffe6cce7, 0xffd5aad7, 0xe66719b9,
  0xffe70019, 0xffd6002b, 0xffc0817f, 0xe666e686,
  0xffd6557f, 0xffc1017b, 0xffc08100, 0xe666b353,
  0xffc18177, 0xffc100fd, 0xffc08081, 0xe6668020,
  0xffc180fa, 0xffc1007f, 0xffc08002, 0xe6664ced,
  0xffc1807d, 0xffc10001, 0xffc07f83, 0xddde2242,
  0xffc18000, 0xffc0ff83, 0xffab55ac, 0xd70a8f7c,
  0xffc17f83, 0xffac0055, 0xff9a66ce, 0xcce699a0,
  0xffacaafe, 0xff9b3399, 0xff813f82, 0xcce6666d,
  0xff9c0064, 0xff823f01, 0xff813f03, 0xcce6333a,
  0xff833e80, 0xff823e83, 0xff813e84, 0xcce60007,
  0xff823e82, 0xff813e83, 0xcce5ffe9, 0xaab05570,
  0xff823e04, 0xff813e04, 0xccd03332, 0xaaac001f,
  0xff823d86, 0xff8107f1, 0xcccd999b, 0xaaabaaca,
  0xff8207e0, 0xff81017e, 0xcccd6668, 0xaaab5575,
  0xff82017a, 0xff8100ff, 0xcccd3335, 0x00000020,
  0xff8200fc, 0xff810080, 0x00000002, 0xffffaacb,
  0xff82007e, 0x00000001, 0xffffcccf, 0xffff5576,
  0x00000000, 0xffffff82, 0xffff999c, 0xfffaaad0,
  0xffffff82, 0xffffff03, 0xfffcccd2, 0xffd6559f,
  0xffffff04, 0xfffff811, 0xffe7001b, 0xffd6004a,
  0xfffff820, 0xffffc1fe, 0xffe6cce8, 0xffd5aaf5,
  0xffffc27a, 0xffffc17f, 0xffe699b5, 0xeeef1131,
  0xffffc1fc, 0xffffc100, 0xf5c2a3d9, 0xe38e71e7,
  0xffffc17e, 0xffe699b4, 0xeeef1113, 0xd556801f,
  0xffe6cce6, 0xffd5aad6, 0xe667199b, 0xd5562aca,
  0xffd6002a, 0xffc0817e, 0xe666e668, 0xd555d575,
  0xffc1017a, 0xffc080ff, 0xe666b335, 0xd5558020,
  0xffc100fc, 0xffc08080, 0xe6668002, 0xd5552acb,
  0xffc1007e, 0xffc08001, 0xe6664ccf, 0xc71ce3ae,
  0xffc10000, 0xffc07f82, 0xddde2224, 0xbbbc4464,
  0xffc0ff82, 0xffab55ab, 0xd70a8f5e, 0xaad5aaa0,
  0xffac0054, 0xff9a66cd, 0xcce69982, 0xaad5554b,
  0xff9b3398, 0xff813f81, 0xcce6664f, 0xaad4fff6,
  0xff823f00, 0xff813f02, 0xcce6331c, 0xaad4aaa1,
  0xff813f01, 0xcce6331b, 0xaad4aa83, 0x800afff0,
  0xff813e82, 0xcce5ffe8, 0xaab05552, 0x80048017,
  0xff813e03, 0xccd03331, 0xaaac0001, 0x8004001a,
  0xff8107f0, 0xcccd999a, 0xaaabaaac, 0x8003801d,
  0xff81017d, 0xcccd6667, 0xaaab5557, 0x00000020,
  0xff8100fe, 0xcccd3334, 0x00000002, 0xffff8023,
  0xff81007f, 0x00000001, 0xffffaaad, 0xffff0026,
  0x00000000, 0xffffccce, 0xffff5558, 0xfff80050,
  0xffffff81, 0xffff999b, 0xfffaaab2, 0xffc18197,
  0xffffff02, 0xfffcccd1, 0xffd65581, 0xffc1019a,
  0xfffff810, 0xffe7001a, 0xffd6002c, 0xffc0819d,
  0xffffc1fd, 0xffe6cce7, 0xffd5aad7, 0xe66719b9,
  0xffffc17e, 0xffe699b4, 0xeeef1113, 0xd556801f,
  0xffffc0ff, 0xf5c2a3d8, 0xe38e71c9, 0xc0030017,
  0xffe699b3, 0xeeef1112, 0xd5568001, 0xc002801a,
  0xffd5aad5, 0xe667199a, 0xd5562aac, 0xc002001d,
  0xffc0817d, 0xe666e667, 0xd555d557, 0xc0018020,
  0xffc080fe, 0xe666b334, 0xd5558002, 0xc0010023,
  0xffc0807f, 0xe6668001, 0xd5552aad, 0xaaad001e,
  0xffc08000, 0xe6664cce, 0xc71ce390, 0x999c6684,
  0xffc07f81, 0xddde2223, 0xbbbc4446, 0x8042fea0,
  0xffab55aa, 0xd70a8f5d, 0xaad5aa82, 0x80427ea3,
  0xff9a66cc, 0xcce69981, 0xaad5552d, 0x8041fea6,
  0xff813f80, 0xcce6664e, 0xaad4ffd8, 0x80417ea9,
  0xcce6664d, 0xaad4ffd7, 0x80417e8b, 0x800a0000,
  0xcce6331a, 0xaad4aa82, 0x800affd2, 0x8003801a,
  0xcce5ffe7, 0xaab05551, 0x80047ff9, 0x8003001c,
  0xccd03330, 0xaaac0000, 0x8003fffc, 0x8002801e,
  0xcccd9999, 0xaaabaaab, 0x80037fff, 0x00000020,
  0xcccd6666, 0xaaab5556, 0x00000002, 0xffff8022,
  0xcccd3333, 0x00000001, 0xffff8005, 0xffff0024,
  0x00000000, 0xffffaaac, 0xffff0008, 0xfff80040,
  0xffffcccd, 0xffff5557, 0xfff80032, 0xffc1811a,
  0xffff999a, 0xfffaaab1, 0xffc18179, 0xffc1011c,
  0xfffcccd0, 0xffd65580, 0xffc1017c, 0xffc0811e,
  0xffe70019, 0xffd6002b, 0xffc0817f, 0xe666e686,
  0xffe6cce6, 0xffd5aad6, 0xe667199b, 0xd5562aca,
  0xffe699b3, 0xeeef1112, 0xd5568001, 0xc002801a,
  0xf5c2a3d7, 0xe38e71c8, 0xc002fff9, 0xc002001c,
  0xeeef1111, 0xd5568000, 0xc0027ffc, 0xc001801e,
  0xe6671999, 0xd5562aab, 0xc001ffff, 0xc0010020,
  0xe666e666, 0xd555d556, 0xc0018002, 0xc0008022,
  0xe666b333, 0xd5558001, 0xc0010005, 0xaaac5574,
  0xe6668000, 0xd5552aac, 0xaaad0000, 0x999b99b8,
  0xe6664ccd, 0xc71ce38f, 0x999c6666, 0x8041ff20,
  0xddde2222, 0xbbbc4445, 0x8042fe82, 0x80417f22,
  0xd70a8f5c, 0xaad5aa81, 0x80427e85, 0x8040ff24,
  0xcce69980, 0xaad5552c, 0x8041fe88, 0x80407f26,
  0xaad5552b, 0x8041fe87, 0x80407f08, 0x80090010,
  0xaad4ffd6, 0x80417e8a, 0x8009ffe2, 0x8002801d,
  0xaad4aa81, 0x800affd1, 0x80037ffc, 0x8002001e,
  0xaab05550, 0x80047ff8, 0x8002fffe, 0x8001801f,
  0xaaabffff, 0x8003fffb, 0x80028000, 0x00000020,
  0xaaabaaaa, 0x80037ffe, 0x00000002, 0xffff8021,
  0xaaab5555, 0x00000001, 0xffff8004, 0xffff0022,
  0x00000000, 0xffff8004, 0xffff0006, 0xfff80030,
  0xffffaaab, 0xffff0007, 0xfff80022, 0xffc1809d,
  0xffff5556, 0xfff80031, 0xffc180fc, 0xffc1009e,
  0xfffaaab0, 0xffc18178, 0xffc100fe, 0xffc0809f,
  0xffd6557f, 0xffc1017b, 0xffc08100, 0xe666b353,
  0xffd6002a, 0xffc0817e, 0xe666e668, 0xd555d575,
  0xffd5aad5, 0xe667199a, 0xd5562aac, 0xc002001d,
  0xeeef1111, 0xd5568000, 0xc0027ffc, 0xc001801e,
  0xe38e71c7, 0xc002fff8, 0xc001fffe, 0xc001001f,
  0xd5567fff, 0xc0027ffb, 0xc0018000, 0xc0008020,
  0xd5562aaa, 0xc001fffe, 0xc0010002, 0xc0000021,
  0xd555d555, 0xc0018001, 0xc0008004, 0xaaabaaca,
  0xd5558000, 0xc0010004, 0xaaac5556, 0x999accec,
  0xd5552aab, 0xaaacffff, 0x999b999a, 0x8040ffa0,
  0xc71ce38e, 0x999c6665, 0x8041ff02, 0x80407fa1,
  0xbbbc4444, 0x8042fe81, 0x80417f04, 0x803fffa2,
  0xaad5aa80, 0x80427e84, 0x8040ff06, 0x803f7fa3,
  0x80427e83, 0x8040ff05, 0x803f7f85, 0x80080020,
  0x8041fe86, 0x80407f07, 0x8008fff2, 0x80018020,
  0x80417e89, 0x8009ffe1, 0x80027fff, 0x80010020,
  0x800affd0, 0x80037ffb, 0x80020000, 0x80008020,
  0x80047ff7, 0x8002fffd, 0x80018001, 0x00000020,
  0x8003fffa, 0x80027fff, 0x00000002, 0xffff8020,
  0x80037ffd, 0x00000001, 0xffff8003, 0xffff0020,
  0x00000000, 0xffff8003, 0xffff0004, 0xfff80020,
  0xffff8003, 0xffff0005, 0xfff80012, 0xffc18020,
  0xffff0006, 0xfff80021, 0xffc1807f, 0xffc10020,
  0xfff80030, 0xffc180fb, 0xffc10080, 0xffc08020,
  0xffc18177, 0xffc100fd, 0xffc08081, 0xe6668020,
  0xffc1017a, 0xffc080ff, 0xe666b335, 0xd5558020,
  0xffc0817d, 0xe666e667, 0xd555d557, 0xc0018020,
  0xe6671999, 0xd5562aab, 0xc001ffff, 0xc0010020,
  0xd5567fff, 0xc0027ffb, 0xc0018000, 0xc0008020,
  0xc002fff7, 0xc001fffd, 0xc0010001, 0xc0000020,
  0xc0027ffa, 0xc0017fff, 0xc0008002, 0xbfff8020,
  0xc001fffd, 0xc0010001, 0xc0000003, 0xaaab0020,
  0xc0018000, 0xc0008003, 0xaaabaaac, 0x999a0020,
  0xc0010003, 0xaaac5555, 0x999accce, 0x80400020,
  0xaaacfffe, 0x999b9999, 0x8040ff82, 0x803f8020,
  0x999c6664, 0x8041ff01, 0x80407f83, 0x803f0020,
  0x8042fe80, 0x80417f03, 0x803fff84, 0x803e8020,
  0x80417f02, 0x803fff83, 0x803e8002, 0x80070030,
  0x8040ff04, 0x803f7f84, 0x80080002, 0x80008023,
  0x80407f06, 0x8008fff1, 0x80018002, 0x80000022,
  0x8009ffe0, 0x80027ffe, 0x80010002, 0x7fff8021,
  0x80037ffa, 0x8001ffff, 0x80008002, 0x00000020,
  0x8002fffc, 0x80018000, 0x00000002, 0xffff801f,
  0x80027ffe, 0x00000001, 0xffff8002, 0xffff001e,
  0x00000000, 0xffff8002, 0xffff0002, 0xfff80010,
  0xffff8002, 0xffff0003, 0xfff80002, 0xffc17fa3,
  0xffff0004, 0xfff80011, 0xffc18002, 0xffc0ffa2,
  0xfff80020, 0xffc1807e, 0xffc10002, 0xffc07fa1,
  0xffc180fa, 0xffc1007f, 0xffc08002, 0xe6664ced,
  0xffc100fc, 0xffc08080, 0xe6668002, 0xd5552acb,
  0xffc080fe, 0xe666b334, 0xd5558002, 0xc0010023,
  0xe666e666, 0xd555d556, 0xc0018002, 0xc0008022,
  0xd5562aaa, 0xc001fffe, 0xc0010002, 0xc0000021,
  0xc0027ffa, 0xc0017fff, 0xc0008002, 0xbfff8020,
  0xc001fffc, 0xc0010000, 0xc0000002, 0xbfff001f,
  0xc0017ffe, 0xc0008001, 0xbfff8002, 0xaaaa5576,
  0xc0010000, 0xc0000002, 0xaaab0002, 0x99993354,
  0xc0008002, 0xaaabaaab, 0x999a0002, 0x803f00a0,
  0xaaac5554, 0x999acccd, 0x80400002, 0x803e809f,
  0x999b9998, 0x8040ff81, 0x803f8002, 0x803e009e,
  0x8041ff00, 0x80407f82, 0x803f0002, 0x803d809d,
  0x80407f81, 0x803f0001, 0x803d807f, 0x5560aac0,
  0x803fff82, 0x803e8001, 0x80070012, 0x5558001e,
  0x803f7f83, 0x80080001, 0x80008005, 0x55575574,
  0x8008fff0, 0x80018001, 0x80000004, 0x5556aaca,
  0x80027ffd, 0x80010001, 0x7fff8003, 0x00000020,
  0x8001fffe, 0x80008001, 0x00000002, 0xffff5576,
  0x80017fff, 0x00000001, 0xffff8001, 0xfffeaacc,
  0x00000000, 0xffff8001, 0xffff0000, 0xfff55580,
  0xffff8001, 0xffff0001, 0xfff7fff2, 0xffacab1e,
  0xffff0002, 0xfff80001, 0xffc17f85, 0xffac0074,
  0xfff80010, 0xffc18001, 0xffc0ff84, 0xffab55ca,
  0xffc1807d, 0xffc10001, 0xffc07f83, 0xddde2242,
  0xffc1007e, 0xffc08001, 0xe6664ccf, 0xc71ce3ae,
  0xffc0807f, 0xe6668001, 0xd5552aad, 0xaaad001e,
  0xe666b333, 0xd5558001, 0xc0010005, 0xaaac5574,
  0xd555d555, 0xc0018001, 0xc0008004, 0xaaabaaca,
  0xc001fffd, 0xc0010001, 0xc0000003, 0xaaab0020,
  0xc0017ffe, 0xc0008001, 0xbfff8002, 0xaaaa5576,
  0xc000ffff, 0xc0000001, 0xbfff0001, 0x8e39c73c,
  0xc0008000, 0xbfff8001, 0xaaaa5558, 0x777888a8,
  0xc0000001, 0xaaab0001, 0x99993336, 0x55ab5520,
  0xaaabaaaa, 0x999a0001, 0x803f0082, 0x55aaaa76,
  0x999acccc, 0x80400001, 0x803e8081, 0x55a9ffcc,
  0x8040ff80, 0x803f8001, 0x803e0080, 0x55a95522,
  0x803f8000, 0x803e007f, 0x55a95504, 0x3340cce0,
  0x803f0000, 0x803d807e, 0x5560aaa2, 0x33366684,
  0x803e8000, 0x80070011, 0x55580000, 0x333599b8,
  0x80080000, 0x80008004, 0x55575556, 0x3334ccec,
  0x80018000, 0x80000003, 0x5556aaac, 0x00000020,
  0x80010000, 0x7fff8002, 0x00000002, 0xffff3354,
  0x80008000, 0x00000001, 0xffff5558, 0xfffe6688,
  0x00000000, 0xffff8000, 0xfffeaaae, 0xfff33360,
  0xffff8000, 0xfffeffff, 0xfff55562, 0xff9c0084,
  0xffff0000, 0xfff7fff1, 0xffacab00, 0xff9b33b8,
  0xfff80000, 0xffc17f84, 0xffac0056, 0xff9a66ec,
  0xffc18000, 0xffc0ff83, 0xffab55ac, 0xd70a8f7c,
  0xffc10000, 0xffc07f82, 0xddde2224, 0xbbbc4464,
  0xffc08000, 0xe6664cce, 0xc71ce390, 0x999c6684,
  0xe6668000, 0xd5552aac, 0xaaad0000, 0x999b99b8,
  0xd5558000, 0xc0010004, 0xaaac5556, 0x999accec,
  0xc0018000, 0xc0008003, 0xaaabaaac, 0x999a0020,
  0xc0010000, 0xc0000002, 0xaaab0002, 0x99993354,
  0xc0008000, 0xbfff8001, 0xaaaa5558, 0x777888a8,
  0xc0000000, 0xbfff0000, 0x8e39c71e, 0x5c2a3d90,
  0xbfff8000, 0xaaaa5557, 0x7778888a, 0x339a6620,
  0xaaab0000, 0x99993335, 0x55ab5502, 0x33999954,
  0x999a0000, 0x803f0081, 0x55aaaa58, 0x3398cc88,
  0x80400000, 0x803e8080, 0x55a9ffae, 0x3397ffbc,
  0x803e807f, 0x55a9ffad, 0x3397ff9e, 0x008ff820,
  0x803e007e, 0x55a95503, 0x3340ccc2, 0x0082fea0,
  0x803d807d, 0x5560aaa1, 0x33366666, 0x0081ff20,
  0x80070010, 0x5557ffff, 0x3335999a, 0x0080ffa0,
  0x80008003, 0x55575555, 0x3334ccce, 0x00000020,
  0x80000002, 0x5556aaab, 0x00000002, 0xffff00a0,
  0x7fff8001, 0x00000001, 0xffff3336, 0xfffe0120,
  0x00000000, 0xffff5557, 0xfffe666a, 0xfff00820,
  0xffff7fff, 0xfffeaaad, 0xfff33342, 0xff833ea0,
  0xfffefffe, 0xfff55561, 0xff9c0066, 0xff823f20,
  0xfff7fff0, 0xffacaaff, 0xff9b339a, 0xff813fa0,
  0xffc17f83, 0xffac0055, 0xff9a66ce, 0xcce699a0,
  0xffc0ff82, 0xffab55ab, 0xd70a8f5e, 0xaad5aaa0,
  0xffc07f81, 0xddde2223, 0xbbbc4446, 0x8042fea0,
  0xe6664ccd, 0xc71ce38f, 0x999c6666, 0x8041ff20,
  0xd5552aab, 0xaaacffff, 0x999b999a, 0x8040ffa0,
  0xc0010003, 0xaaac5555, 0x999accce, 0x80400020,
  0xc0008002, 0xaaabaaab, 0x999a0002, 0x803f00a0,
  0xc0000001, 0xaaab0001, 0x99993336, 0x55ab5520,
  0xbfff8000, 0xaaaa5557, 0x7778888a, 0x339a6620,
  0xbffeffff, 0x8e39c71d, 0x5c2a3d72, 0x00ffc020,
  0xaaaa5556, 0x77788889, 0x339a6602, 0x00fec0a0,
  0x99993334, 0x55ab5501, 0x33999936, 0x00fdc120,
  0x803f0080, 0x55aaaa57, 0x3398cc6a, 0x00fcc1a0,
  0x55aaaa56, 0x3398cc69, 0x00fcc182, 0x008ef830,
  0x55a9ffac, 0x3397ff9d, 0x008ff802, 0x0081fea3,
  0x55a95502, 0x3340ccc1, 0x0082fe82, 0x0080ff22,
  0x5560aaa0, 0x33366665, 0x0081ff02, 0x007fffa1,
  0x5557fffe, 0x33359999, 0x0080ff82, 0x00000020,
  0x55575554, 0x3334cccd, 0x00000002, 0xffff009f,
  0x5556aaaa, 0x00000001, 0xffff0082, 0xfffe011e,
  0x00000000, 0xffff3335, 0xfffe0102, 0xfff00810,
  0xffff5556, 0xfffe6669, 0xfff00802, 0xff833e23,
  0xfffeaaac, 0xfff33341, 0xff833e82, 0xff823ea2,
  0xfff55560, 0xff9c0065, 0xff823f02, 0xff813f21,
  0xffacaafe, 0xff9b3399, 0xff813f82, 0xcce6666d,
  0xffac0054, 0xff9a66cd, 0xcce69982, 0xaad5554b,
  0xffab55aa, 0xd70a8f5d, 0xaad5aa82, 0x80427ea3,
  0xddde2222, 0xbbbc4445, 0x8042fe82, 0x80417f22,
  0xc71ce38e, 0x999c6665, 0x8041ff02, 0x80407fa1,
  0xaaacfffe, 0x999b9999, 0x8040ff82, 0x803f8020,
  0xaaac5554, 0x999acccd, 0x80400002, 0x803e809f,
  0xaaabaaaa, 0x999a0001, 0x803f0082, 0x55aaaa76,
  0xaaab0000, 0x99993335, 0x55ab5502, 0x33999954,
  0xaaaa5556, 0x77788889, 0x339a6602, 0x00fec0a0,
  0x8e39c71c, 0x5c2a3d71, 0x00ffc002, 0x00fdc11f,
  0x77788888, 0x339a6601, 0x00fec082, 0x00fcc19e,
  0x55ab5500, 0x33999935, 0x00fdc102, 0x00fbc21d,
  0x33999934, 0x00fdc101, 0x00fbc1ff, 0x008df840,
  0x3398cc68, 0x00fcc181, 0x008ef812, 0x0080fea6,
  0x3397ff9c, 0x008ff801, 0x0081fe85, 0x007fff24,
  0x3340ccc0, 0x0082fe81, 0x0080ff04, 0x007effa2,
  0x33366664, 0x0081ff01, 0x007fff83, 0x00000020,
  0x33359998, 0x0080ff81, 0x00000002, 0xffff009e,
  0x3334cccc, 0x00000001, 0xffff0081, 0xfffe011c,
  0x00000000, 0xffff0081, 0xfffe0100, 0xfff00800,
  0xffff3334, 0xfffe0101, 0xfff007f2, 0xff833da6,
  0xfffe6668, 0xfff00801, 0xff833e05, 0xff823e24,
  0xfff33340, 0xff833e81, 0xff823e84, 0xff813ea2,
  0xff9c0064, 0xff823f01, 0xff813f03, 0xcce6333a,
  0xff9b3398, 0xff813f81, 0xcce6664f, 0xaad4fff6,
  0xff9a66cc, 0xcce69981, 0xaad5552d, 0x8041fea6,
  0xd70a8f5c, 0xaad5aa81, 0x80427e85, 0x8040ff24,
  0xbbbc4444, 0x8042fe81, 0x80417f04, 0x803fffa2,
  0x999c6664, 0x8041ff01, 0x80407f83, 0x803f0020,
  0x999b9998, 0x8040ff81, 0x803f8002, 0x803e009e,
  0x999acccc, 0x80400001, 0x803e8081, 0x55a9ffcc,
  0x999a0000, 0x803f0081, 0x55aaaa58, 0x3398cc88,
  0x99993334, 0x55ab5501, 0x33999936, 0x00fdc120,
  0x77788888, 0x339a6601, 0x00fec082, 0x00fcc19e,
  0x5c2a3d70, 0x00ffc001, 0x00fdc101, 0x00fbc21c,
  0x339a6600, 0x00fec081, 0x00fcc180, 0x00fac29a,
  0x00fec080, 0x00fcc17f, 0x00fac27c, 0x008cf850,
  0x00fdc100, 0x00fbc1fe, 0x008df822, 0x007ffea9,
  0x00fcc180, 0x008ef811, 0x0080fe88, 0x007eff26,
  0x008ff800, 0x0081fe84, 0x007fff06, 0x007dffa3,
  0x0082fe80, 0x0080ff03, 0x007eff84, 0x00000020,
  0x0081ff00, 0x007fff82, 0x00000002, 0xffff009d,
  0x0080ff80, 0x00000001, 0xffff0080, 0xfffe011a,
  0x00000000, 0xffff0080, 0xfffe00fe, 0xfff007f0,
  0xffff0080, 0xfffe00ff, 0xfff007e2, 0xff833d29,
  0xfffe0100, 0xfff007f1, 0xff833d88, 0xff823da6,
  0xfff00800, 0xff833e04, 0xff823e06, 0xff813e23,
  0xff833e80, 0xff823e83, 0xff813e84, 0xcce60007,
  0xff823f00, 0xff813f02, 0xcce6331c, 0xaad4aaa1,
  0xff813f80, 0xcce6664e, 0xaad4ffd8, 0x80417ea9,
  0xcce69980, 0xaad5552c, 0x8041fe88, 0x80407f26,
  0xaad5aa80, 0x80427e84, 0x8040ff06, 0x803f7fa3,
  0x8042fe80, 0x80417f03, 0x803fff84, 0x803e8020,
  0x8041ff00, 0x80407f82, 0x803f0002, 0x803d809d,
  0x8040ff80, 0x803f8001, 0x803e0080, 0x55a95522,
  0x80400000, 0x803e8080, 0x55a9ffae, 0x3397ffbc,
  0x803f0080, 0x55aaaa57, 0x3398cc6a, 0x00fcc1a0,
  0x55ab5500, 0x33999935, 0x00fdc102, 0x00fbc21d,
  0x339a6600, 0x00fec081, 0x00fcc180, 0x00fac29a,
  0x00ffc000, 0x00fdc100, 0x00fbc1fe, 0x00f9c317,
};
const unsigned kExpectedCount_NEON_umlsl_4S = 576;

#endif  // VIXL_SIM_UMLSL_4S_TRACE_AARCH64_H_
