#include "alternatives.ih"

Alternatives::ViableResult Alternatives::generalizedGlob(string initial,
                                                         GlobContext &context)
{
        // create the command consisting of all cmd line args
    string searchCmd = d_command.accumulate();

    ViableResult vr = searchCmd.length() == 0 ?
                            ONLY_CD
                        :
                            RECEIVED_ALTERNATIVES;

    if (vr == RECEIVED_ALTERNATIVES)
        searchCmd.resize(searchCmd.length() - 1);       // remove trailing /


    if (searchCmd.empty())
        imsg << "No merged search command\n";
    else
        imsg << "Merged search command: `" << searchCmd << "'\n";

    imsg << "Searching starts at `" << initial << '\'' << endl;

    globHead(initial, searchCmd, context);

    return vr;
}
