/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: intro.c,v 1.3 2000/03/12 12:58:54 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include <GL/gl.h>

#include "xracer.h"
#include "xracer-mode.h"
#include "xracer-menu.h"
#include "xracer-video.h"
#include "xracer-log.h"

#define VIDEO_FILE "video/intro.mpeg"

int xrHaveIntroSequence = 0;

/* Program-level initializations. */
void
xrIntroModeInit ()
{
#ifndef DISABLE_VIDEO

  /* See if we can find and load the MPEG file. */
  if (xrVideoLoadFile (VIDEO_FILE) < 0)
    {
      xrHaveIntroSequence = 0;
    }
  else
    {
      xrHaveIntroSequence = 1;
    }

#else /* DISABLE_VIDEO == 1 */
  xrHaveIntroSequence = 0;
#endif
}

/* Start the mode. */
static void
start_mode (const void *vargs)
{
  /* Nothing for now. */
}

/* End the mode. */
static void
end_mode ()
{
  /* Nothing. */
}

/* Display the next frame in the clip, or if we have reached the
 * end, cycle back to the beginning.
 */
static void
display ()
{
  int r;

  /* No need to clear the buffer because we always fill it, so save
   * some time by not clearing it.
   */
  /* glClear (GL_COLOR_BUFFER_BIT); */

  /* Display the next frame. */
  r = xrVideoDisplayNextFrame ();
  if (r == 0)			/* End of sequence. */
    {
      xrLog (LOG_DEBUG, "End of video sequence");
      xrVideoUnloadFile ();
      if (xrVideoLoadFile (VIDEO_FILE) < 0)
	{
	  xrLogPerror ("open: " VIDEO_FILE);
	  xrHaveIntroSequence = 0;
	  xrEnterMenu (&xrStartMenu, 0);
	}
    }
  else if (r < 0)		/* Unrecoverable error. */
    {
      xrLog (LOG_ERROR, "Unrecoverable error in video sequence");
      xrVideoUnloadFile ();
      xrHaveIntroSequence = 0;
      xrEnterMenu (&xrStartMenu, 0);
    }
}

/* Any keyboard action causes us to go to the main menu. */
static int
keyboard (unsigned char key, int x, int y)
{
  xrVideoUnloadFile ();
  if (xrVideoLoadFile (VIDEO_FILE) < 0)
    {
      xrLogPerror ("open: " VIDEO_FILE);
      xrHaveIntroSequence = 0;
    }

  xrEnterMenu (&xrStartMenu, 0);

  return 1;
}

struct xrMode xrIntroMode =
{
  name: "intro",

  start_mode: start_mode,
  end_mode: end_mode,

  display: display,
  keyboard: keyboard
};
