module $__XILINX_BLOCKRAM_TDP_ (...);

parameter INIT = 0;
parameter OPTION_MODE = "FULL";
parameter OPTION_HAS_RDFIRST = 0;

parameter PORT_A_RD_WIDTH = 1;
parameter PORT_A_WR_WIDTH = 1;
parameter PORT_A_WR_EN_WIDTH = 1;
parameter PORT_A_RD_USED = 1;
parameter PORT_A_WR_USED = 1;
parameter PORT_A_OPTION_WRITE_MODE = "NO_CHANGE";
parameter PORT_A_RD_INIT_VALUE = 0;
parameter PORT_A_RD_SRST_VALUE = 1;

parameter PORT_B_RD_WIDTH = 1;
parameter PORT_B_WR_WIDTH = 1;
parameter PORT_B_WR_EN_WIDTH = 1;
parameter PORT_B_RD_USED = 0;
parameter PORT_B_WR_USED = 0;
parameter PORT_B_OPTION_WRITE_MODE = "NO_CHANGE";
parameter PORT_B_RD_INIT_VALUE = 0;
parameter PORT_B_RD_SRST_VALUE = 0;

input CLK_C;

input PORT_A_CLK;
input PORT_A_CLK_EN;
input [15:0] PORT_A_ADDR;
input [PORT_A_WR_WIDTH-1:0] PORT_A_WR_DATA;
input [PORT_A_WR_EN_WIDTH-1:0] PORT_A_WR_EN;
output [PORT_A_RD_WIDTH-1:0] PORT_A_RD_DATA;
input PORT_A_RD_SRST;

input PORT_B_CLK;
input PORT_B_CLK_EN;
input [15:0] PORT_B_ADDR;
input [PORT_B_WR_WIDTH-1:0] PORT_B_WR_DATA;
input [PORT_B_WR_EN_WIDTH-1:0] PORT_B_WR_EN;
output [PORT_B_RD_WIDTH-1:0] PORT_B_RD_DATA;
input PORT_B_RD_SRST;

`include "brams_defs.vh"

`define PARAMS_COMMON \
	.WRITE_MODE_A(PORT_A_OPTION_WRITE_MODE), \
	.WRITE_MODE_B(PORT_B_OPTION_WRITE_MODE), \
	.READ_WIDTH_A(PORT_A_RD_USED ? PORT_A_RD_WIDTH : 0), \
	.READ_WIDTH_B(PORT_B_RD_USED ? PORT_B_RD_WIDTH : 0), \
	.WRITE_WIDTH_A(PORT_A_WR_USED ? PORT_A_WR_WIDTH : 0), \
	.WRITE_WIDTH_B(PORT_B_WR_USED ? PORT_B_WR_WIDTH : 0), \
	.DOA_REG(0), \
	.DOB_REG(0), \
	.INIT_A(ival(PORT_A_RD_WIDTH, PORT_A_RD_INIT_VALUE)), \
	.INIT_B(ival(PORT_B_RD_WIDTH, PORT_B_RD_INIT_VALUE)), \
	.SRVAL_A(ival(PORT_A_RD_WIDTH, PORT_A_RD_SRST_VALUE)), \
	.SRVAL_B(ival(PORT_B_RD_WIDTH, PORT_B_RD_SRST_VALUE)), \
	.RAM_MODE("TDP"),

`define PORTS_COMMON \
	.DOADO(DO_A), \
	.DOPADOP(DOP_A), \
	.DIADI(DI_A), \
	.DIPADIP(DIP_A), \
	.DOBDO(DO_B), \
	.DOPBDOP(DOP_B), \
	.DIBDI(DI_B), \
	.DIPBDIP(DIP_B), \
	.CLKARDCLK(PORT_A_CLK), \
	.CLKBWRCLK(PORT_B_CLK), \
	.ENARDEN(PORT_A_CLK_EN), \
	.ENBWREN(PORT_B_CLK_EN), \
	.REGCEAREGCE(1'b0), \
	.REGCEB(1'b0), \
	.RSTRAMARSTRAM(PORT_A_RD_SRST), \
	.RSTRAMB(PORT_B_RD_SRST), \
	.RSTREGARSTREG(1'b0), \
	.RSTREGB(1'b0), \
	.WEA(WE_A), \
	.WEBWE(WE_B),

`MAKE_DI(DI_A, DIP_A, PORT_A_WR_DATA)
`MAKE_DI(DI_B, DIP_B, PORT_B_WR_DATA)
`MAKE_DO(DO_A, DOP_A, PORT_A_RD_DATA)
`MAKE_DO(DO_B, DOP_B, PORT_B_RD_DATA)

wire [3:0] WE_A = {4{PORT_A_WR_EN}};
wire [3:0] WE_B = {4{PORT_B_WR_EN}};

generate

if (OPTION_MODE == "HALF") begin
	RAMB18E1 #(
		`PARAMS_INIT_18
		`PARAMS_INITP_18
		`PARAMS_COMMON
	) _TECHMAP_REPLACE_ (
		`PORTS_COMMON
		.ADDRARDADDR(PORT_A_ADDR[13:0]),
		.ADDRBWRADDR(PORT_B_ADDR[13:0]),
	);
end else if (OPTION_MODE == "FULL") begin
	RAMB36E1 #(
		`PARAMS_INIT_36
		`PARAMS_INITP_36
		`PARAMS_COMMON
		.RAM_EXTENSION_A("NONE"),
		.RAM_EXTENSION_B("NONE"),
	) _TECHMAP_REPLACE_ (
		`PORTS_COMMON
		.ADDRARDADDR({1'b1, PORT_A_ADDR[14:0]}),
		.ADDRBWRADDR({1'b1, PORT_B_ADDR[14:0]}),
	);
end else begin
	wire CAS_A, CAS_B;
	RAMB36E1 #(
		`PARAMS_INIT_36
		`PARAMS_COMMON
		.RAM_EXTENSION_A("LOWER"),
		.RAM_EXTENSION_B("LOWER"),
	) lower (
		.DIADI(DI_A),
		.DIBDI(DI_B),
		.CLKARDCLK(PORT_A_CLK),
		.CLKBWRCLK(PORT_B_CLK),
		.ENARDEN(PORT_A_CLK_EN),
		.ENBWREN(PORT_B_CLK_EN),
		.REGCEAREGCE(1'b0),
		.REGCEB(1'b0),
		.RSTRAMARSTRAM(PORT_A_RD_SRST),
		.RSTRAMB(PORT_B_RD_SRST),
		.RSTREGARSTREG(1'b0),
		.RSTREGB(1'b0),
		.WEA(WE_A),
		.WEBWE(WE_B),
		.ADDRARDADDR(PORT_A_ADDR),
		.ADDRBWRADDR(PORT_B_ADDR),
		.CASCADEOUTA(CAS_A),
		.CASCADEOUTB(CAS_B),
	);
	RAMB36E1 #(
		`PARAMS_INIT_36_U
		`PARAMS_COMMON
		.RAM_EXTENSION_A("UPPER"),
		.RAM_EXTENSION_B("UPPER"),
	) upper (
		.DOADO(DO_A),
		.DIADI(DI_A),
		.DOBDO(DO_B),
		.DIBDI(DI_B),
		.CLKARDCLK(PORT_A_CLK),
		.CLKBWRCLK(PORT_B_CLK),
		.ENARDEN(PORT_A_CLK_EN),
		.ENBWREN(PORT_B_CLK_EN),
		.REGCEAREGCE(1'b0),
		.REGCEB(1'b0),
		.RSTRAMARSTRAM(PORT_A_RD_SRST),
		.RSTRAMB(PORT_B_RD_SRST),
		.RSTREGARSTREG(1'b0),
		.RSTREGB(1'b0),
		.WEA(WE_A),
		.WEBWE(WE_B),
		.ADDRARDADDR(PORT_A_ADDR),
		.ADDRBWRADDR(PORT_B_ADDR),
		.CASCADEINA(CAS_A),
		.CASCADEINB(CAS_B),
	);
end

endgenerate

endmodule


module $__XILINX_BLOCKRAM_SDP_ (...);

parameter INIT = 0;
parameter OPTION_MODE = "FULL";
parameter OPTION_WRITE_MODE = "READ_FIRST";

parameter PORT_W_WIDTH = 1;
parameter PORT_W_WR_EN_WIDTH = 1;
parameter PORT_W_USED = 1;

parameter PORT_R_WIDTH = 1;
parameter PORT_R_USED = 0;
parameter PORT_R_RD_INIT_VALUE = 0;
parameter PORT_R_RD_SRST_VALUE = 0;

input CLK_C;

input PORT_W_CLK;
input PORT_W_CLK_EN;
input [15:0] PORT_W_ADDR;
input [PORT_W_WIDTH-1:0] PORT_W_WR_DATA;
input [PORT_W_WR_EN_WIDTH-1:0] PORT_W_WR_EN;

input PORT_R_CLK;
input PORT_R_CLK_EN;
input [15:0] PORT_R_ADDR;
output [PORT_R_WIDTH-1:0] PORT_R_RD_DATA;
input PORT_R_RD_SRST;

`include "brams_defs.vh"

`define PARAMS_COMMON \
	.WRITE_MODE_A(OPTION_WRITE_MODE), \
	.WRITE_MODE_B(OPTION_WRITE_MODE), \
	.READ_WIDTH_A(PORT_R_USED ? PORT_R_WIDTH : 0), \
	.READ_WIDTH_B(0), \
	.WRITE_WIDTH_A(0), \
	.WRITE_WIDTH_B(PORT_W_USED ? PORT_W_WIDTH : 0), \
	.DOA_REG(0), \
	.DOB_REG(0), \
	.RAM_MODE("SDP"),

`define PORTS_COMMON \
	.CLKBWRCLK(PORT_W_CLK), \
	.CLKARDCLK(PORT_R_CLK), \
	.ENBWREN(PORT_W_CLK_EN), \
	.ENARDEN(PORT_R_CLK_EN), \
	.REGCEAREGCE(1'b0), \
	.REGCEB(1'b0), \
	.RSTRAMARSTRAM(PORT_R_RD_SRST), \
	.RSTRAMB(1'b0), \
	.RSTREGARSTREG(1'b0), \
	.RSTREGB(1'b0), \
	.WEA(0), \
	.WEBWE(PORT_W_WR_EN),

`MAKE_DI(DI, DIP, PORT_W_WR_DATA)
`MAKE_DO(DO, DOP, PORT_R_RD_DATA)

generate

if (OPTION_MODE == "HALF") begin
	RAMB18E1 #(
		`PARAMS_INIT_18
		`PARAMS_INITP_18
		`PARAMS_COMMON
		.INIT_A(PORT_R_WIDTH == 36 ? ival(18, PORT_R_RD_INIT_VALUE[17:0]) : ival(PORT_R_WIDTH, PORT_R_RD_INIT_VALUE)),
		.INIT_B(PORT_R_WIDTH == 36 ? ival(18, PORT_R_RD_INIT_VALUE[35:18]) : 0),
		.SRVAL_A(PORT_R_WIDTH == 36 ? ival(18, PORT_R_RD_SRST_VALUE[17:0]) : ival(PORT_R_WIDTH, PORT_R_RD_SRST_VALUE)),
		.SRVAL_B(PORT_R_WIDTH == 36 ? ival(18, PORT_R_RD_SRST_VALUE[35:18]) : 0),
	) _TECHMAP_REPLACE_ (
		`PORTS_COMMON
		.ADDRARDADDR(PORT_R_ADDR[13:0]),
		.ADDRBWRADDR(PORT_W_ADDR[13:0]),
		.DOADO(DO[15:0]),
		.DOBDO(DO[31:16]),
		.DOPADOP(DOP[1:0]),
		.DOPBDOP(DOP[3:2]),
		.DIADI(DI[15:0]),
		.DIBDI(PORT_W_WIDTH == 36 ? DI[31:16] : DI[15:0]),
		.DIPADIP(DIP[1:0]),
		.DIPBDIP(PORT_W_WIDTH == 36 ? DIP[3:2] : DIP[1:0]),
	);
end else if (OPTION_MODE == "FULL") begin
	RAMB36E1 #(
		`PARAMS_INIT_36
		`PARAMS_INITP_36
		`PARAMS_COMMON
		.INIT_A(PORT_R_WIDTH == 72 ? ival(36, PORT_R_RD_INIT_VALUE[35:0]) : ival(PORT_R_WIDTH, PORT_R_RD_INIT_VALUE)),
		.INIT_B(PORT_R_WIDTH == 72 ? ival(36, PORT_R_RD_INIT_VALUE[71:36]) : 0),
		.SRVAL_A(PORT_R_WIDTH == 72 ? ival(36, PORT_R_RD_SRST_VALUE[35:0]) : ival(PORT_R_WIDTH, PORT_R_RD_SRST_VALUE)),
		.SRVAL_B(PORT_R_WIDTH == 72 ? ival(36, PORT_R_RD_SRST_VALUE[71:36]) : 0),
	) _TECHMAP_REPLACE_ (
		`PORTS_COMMON
		.ADDRARDADDR({1'b1, PORT_R_ADDR}),
		.ADDRBWRADDR({1'b1, PORT_W_ADDR}),
		.DOADO(DO[31:0]),
		.DOBDO(DO[63:32]),
		.DOPADOP(DOP[3:0]),
		.DOPBDOP(DOP[7:4]),
		.DIADI(DI[31:0]),
		.DIBDI(PORT_W_WIDTH == 72 ? DI[63:32] : DI[31:0]),
		.DIPADIP(DIP[3:0]),
		.DIPBDIP(PORT_W_WIDTH == 71 ? DIP[7:4] : DIP[3:0]),
	);
end

endgenerate

endmodule
