// ---------------------------------------------------------------------------|
// Test Harness includes
// ---------------------------------------------------------------------------|
#include "test/support/checkers/checker-group.h"

// ---------------------------------------------------------------------------|
// Standard includes
// ---------------------------------------------------------------------------|

// ---------------------------------------------------------------------------|
// Boost Test Framework
// ---------------------------------------------------------------------------|

// ---------------------------------------------------------------------------|
// Boost 
// ---------------------------------------------------------------------------|
#include <boost/foreach.hpp>

// ---------------------------------------------------------------------------|
// Global namespace usage
// ---------------------------------------------------------------------------|
using namespace std;

// ---------------------------------------------------------------------------|
namespace YumaTest
{

// ---------------------------------------------------------------------------|
CheckerGroup::CheckerGroup() : checkers_()
{
}

// ---------------------------------------------------------------------------|
CheckerGroup::~CheckerGroup() 
{
}

// ---------------------------------------------------------------------------|
void CheckerGroup::operator()( const string& str )
{
    BOOST_FOREACH( CheckSignature_T& chk, checkers_ )
    {
        chk( str );
    }
}

// ---------------------------------------------------------------------------|
CheckerGroup& CheckerGroup::registerChecker( CheckSignature_T& checker )
{
    checkers_.push_back( checker );
    return *this;
}

// ---------------------------------------------------------------------------|
CheckerGroup& CheckerGroup::operator()( CheckSignature_T& checker )
{
    checkers_.push_back( checker );
    return *this;
}

}

