package ONVIF::Device::Types::PTZNodeExtension;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %SupportedPresetTour_of :ATTR(:get<SupportedPresetTour>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        SupportedPresetTour
        Extension

    ) ],
    {
        'SupportedPresetTour' => \%SupportedPresetTour_of,
        'Extension' => \%Extension_of,
    },
    {
        'SupportedPresetTour' => 'ONVIF::Device::Types::PTZPresetTourSupported',
        'Extension' => 'ONVIF::Device::Types::PTZNodeExtension2',
    },
    {

        'SupportedPresetTour' => 'SupportedPresetTour',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::PTZNodeExtension

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PTZNodeExtension from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * SupportedPresetTour


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::PTZNodeExtension
   SupportedPresetTour =>  { # ONVIF::Device::Types::PTZPresetTourSupported
     MaximumNumberOfPresetTours =>  $some_value, # int
     PTZPresetTourOperation => $some_value, # PTZPresetTourOperation
     Extension =>  { # ONVIF::Device::Types::PTZPresetTourSupportedExtension
     },
   },
   Extension =>  { # ONVIF::Device::Types::PTZNodeExtension2
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

