/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.plaf.basic.BasicJideOptionPaneUI;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class JideOptionPane
extends JOptionPane {
    private static final long serialVersionUID = 1916857052448620771L;
    private Object _title;
    private Object _details;
    public static final String DETAILS_PROPERTY = "details";
    public static final String TITLE_PROPERTY = "title";
    public static final int CLOSE_OPTION = 3;

    public JideOptionPane() {
        this.initComponents();
    }

    public JideOptionPane(Object message) {
        super(message);
        this.initComponents();
    }

    public JideOptionPane(Object message, int messageType) {
        super(message, messageType);
        this.initComponents();
    }

    public JideOptionPane(Object message, int messageType, int optionType) {
        super(message, messageType, optionType);
        this.initComponents();
    }

    public JideOptionPane(Object message, int messageType, int optionType, Icon icon) {
        super(message, messageType, optionType, icon);
        this.initComponents();
    }

    public JideOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options) {
        super(message, messageType, optionType, icon, options);
        this.initComponents();
    }

    public JideOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
        super(message, messageType, optionType, icon, options, initialValue);
        this.initComponents();
    }

    protected void initComponents() {
    }

    @Override
    public void setOptionType(int newType) {
        if (newType != -1 && newType != 0 && newType != 1 && newType != 2 && newType != 3) {
            throw new RuntimeException("JOptionPane: option type must be one of JOptionPane.DEFAULT_OPTION, JOptionPane.YES_NO_OPTION, JOptionPane.YES_NO_CANCEL_OPTION or JOptionPane.OK_CANCEL_OPTION");
        }
        int oldType = this.optionType;
        this.optionType = newType;
        this.firePropertyChange("optionType", oldType, this.optionType);
    }

    public void setDetails(Object details) {
        Object oldDetails = this._details;
        this._details = details;
        this.firePropertyChange(DETAILS_PROPERTY, oldDetails, this._details);
    }

    public Object getDetails() {
        return this._details;
    }

    public Object getTitle() {
        return this._title;
    }

    public void setTitle(Object title) {
        Object old = this._title;
        this._title = title;
        this.firePropertyChange(TITLE_PROPERTY, old, this._title);
    }

    public void setDetailsVisible(boolean visible) {
        ((BasicJideOptionPaneUI)this.getUI()).setDetailsVisible(visible);
    }

    public String getResourceString(String key) {
        return ButtonResources.getResourceBundle(this.getLocale()).getString(key);
    }

    public boolean isDetailsVisible() {
        return ((BasicJideOptionPaneUI)this.getUI()).isDetailsVisible();
    }

    @Override
    public void setLocale(Locale l) {
        if (!JideSwingUtilities.equals(l, this.getLocale())) {
            super.setLocale(l);
            this.updateUI();
        }
    }

    public static String showInputDialog(Object message) throws HeadlessException {
        return JideOptionPane.showInputDialog(null, message);
    }

    public static String showInputDialog(Object message, Object initialSelectionValue) {
        return JideOptionPane.showInputDialog(null, message, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, Object message) throws HeadlessException {
        return JideOptionPane.showInputDialog(parentComponent, message, UIManager.getString("OptionPane.inputDialogTitle"), 3);
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        return (String)JideOptionPane.showInputDialog(parentComponent, message, UIManager.getString("OptionPane.inputDialogTitle"), 3, null, null, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        return (String)JideOptionPane.showInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        JideOptionPane pane = new JideOptionPane(message, messageType, 2, icon, null, null);
        if (parentComponent != null) {
            pane.setLocale(parentComponent.getLocale());
        }
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.setComponentOrientation((parentComponent == null ? JideOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        int style = JideOptionPane.styleFromMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title, style);
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.dispose();
        Object value = pane.getInputValue();
        if (value == UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    public static void showMessageDialog(Component parentComponent, Object message) throws HeadlessException {
        JideOptionPane.showMessageDialog(parentComponent, message, UIManager.getString("OptionPane.messageDialogTitle"), 1);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        JideOptionPane.showMessageDialog(parentComponent, message, title, messageType, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) throws HeadlessException {
        JideOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, icon, null, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message) throws HeadlessException {
        return JideOptionPane.showConfirmDialog(parentComponent, message, UIManager.getString("OptionPane.titleText"), 1);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        return JideOptionPane.showConfirmDialog(parentComponent, message, title, optionType, 3);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        return JideOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) throws HeadlessException {
        return JideOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, null, null);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        JideOptionPane pane = new JideOptionPane(message, messageType, optionType, icon, options, initialValue);
        if (parentComponent != null) {
            pane.setLocale(parentComponent.getLocale());
        }
        pane.setInitialValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? JideOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        int style = JideOptionPane.styleFromMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title, style);
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    @Override
    public JDialog createDialog(Component parentComponent, String title) throws HeadlessException {
        int style = JideOptionPane.styleFromMessageType(this.getMessageType());
        return this.createDialog(parentComponent, title, style);
    }

    @Override
    public JDialog createDialog(String title) throws HeadlessException {
        int style = JideOptionPane.styleFromMessageType(this.getMessageType());
        JDialog dialog = new JDialog((Dialog)null, title, true);
        this.initDialog(dialog, style, null);
        return dialog;
    }

    private JDialog createDialog(Component parentComponent, String title, int style) throws HeadlessException {
        Window window = JideOptionPane.getWindowForComponent(parentComponent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        this.initDialog(dialog, style, parentComponent);
        return dialog;
    }

    private void initDialog(final JDialog dialog, int style, Component parentComponent) {
        boolean supportsWindowDecorations;
        dialog.setComponentOrientation(this.getComponentOrientation());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dialog.setResizable(false);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(style);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                JideOptionPane.this.setValue(null);
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    JideOptionPane.this.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        dialog.addWindowListener(adapter);
        dialog.addWindowFocusListener(adapter);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                JideOptionPane.this.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == JideOptionPane.this && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    dialog.setVisible(false);
                }
            }
        });
    }

    public static Frame getFrameForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JideOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame) {
            return (Frame)parentComponent;
        }
        return JOptionPane.getFrameForComponent(parentComponent.getParent());
    }

    static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JideOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return JideOptionPane.getWindowForComponent(parentComponent.getParent());
    }
}

