/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingInvocationUnit;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.ProgramClassOptimizationInfo;
import proguard.optimize.info.ReferenceEscapeChecker;

public class EscapingClassMarker
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ClassVisitor {
    private static final boolean DEBUG = false;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private final ReferenceEscapeChecker referenceEscapeChecker;
    private final boolean runReferenceEscapeChecker;

    public EscapingClassMarker() {
        this(new TypedReferenceValueFactory());
    }

    public EscapingClassMarker(ValueFactory valueFactory) {
        this(valueFactory, new ReferenceTracingValueFactory(valueFactory));
    }

    public EscapingClassMarker(ValueFactory valueFactory, ReferenceTracingValueFactory referenceTracingValueFactory) {
        this(new PartialEvaluator(referenceTracingValueFactory, new ReferenceTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory)), true, referenceTracingValueFactory), true);
    }

    public EscapingClassMarker(PartialEvaluator partialEvaluator, boolean bl) {
        this(partialEvaluator, bl, new ReferenceEscapeChecker(partialEvaluator, false), true);
    }

    public EscapingClassMarker(PartialEvaluator partialEvaluator, boolean bl, ReferenceEscapeChecker referenceEscapeChecker, boolean bl2) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = bl;
        this.referenceEscapeChecker = referenceEscapeChecker;
        this.runReferenceEscapeChecker = bl2;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (this.runReferenceEscapeChecker) {
            this.referenceEscapeChecker.visitCodeAttribute(clazz, method, codeAttribute);
        }
        codeAttribute.instructionsAccept(clazz, method, this.partialEvaluator.tracedInstructionFilter(this));
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        Clazz clazz2;
        ReferenceValue referenceValue;
        TracedStack tracedStack;
        Value value;
        if (instruction.stackPushCount(clazz) == 1 && (this.referenceEscapeChecker.isInstanceEscaping(n) || this.referenceEscapeChecker.isInstanceReturned(n)) && (value = (tracedStack = this.partialEvaluator.getStackAfter(n)).getTop(0)).computationalType() == 5 && (referenceValue = value.referenceValue()).isNull() != 1 && !ClassUtil.isInternalArrayType(referenceValue.getType()) && (clazz2 = referenceValue.getReferencedClass()) != null) {
            clazz2.hierarchyAccept(true, true, true, false, this);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.markClassEscaping(programClass);
    }

    private void markClassEscaping(Clazz clazz) {
        ClassOptimizationInfo classOptimizationInfo = ProgramClassOptimizationInfo.getClassOptimizationInfo(clazz);
        if (classOptimizationInfo instanceof ProgramClassOptimizationInfo) {
            ((ProgramClassOptimizationInfo)classOptimizationInfo).setEscaping();
        }
    }

    public static boolean isClassEscaping(Clazz clazz) {
        return ClassOptimizationInfo.getClassOptimizationInfo(clazz).isEscaping();
    }
}

