/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectReader;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.dscache.DataSetFromCache;
import org.eclipse.birt.data.engine.executor.dscache.DataSetToCache;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class OdiAdapter {
    private ResultSet odaResultSet;
    private DataSetToCache datasetToCache;
    private ICustomDataSet customDataSet;
    private IResultIterator resultIterator;
    boolean riStarted = false;
    private ResultSetCache resultSetCache;
    private ResultObjectReader roReader;
    private IDataSetPopulator populator;
    private DataSetFromCache datasetFromCache;
    private IResultClass resultClass;
    private Set columnIndexListForTypeConvert = null;

    public OdiAdapter(ResultSet odaResultSet, IResultClass resultClass) {
        assert (odaResultSet != null);
        this.odaResultSet = odaResultSet;
        this.resultClass = resultClass;
        int i = 1;
        while (i <= resultClass.getFieldCount()) {
            try {
                if (resultClass.getFieldMetaData(i).getDriverProvidedDataType() == null || resultClass.getFieldMetaData(i).getDataType() != resultClass.getFieldMetaData(i).getDriverProvidedDataType()) {
                    if (this.columnIndexListForTypeConvert == null) {
                        this.columnIndexListForTypeConvert = new HashSet();
                    }
                    this.columnIndexListForTypeConvert.add(i);
                }
            }
            catch (DataException dataException) {}
            ++i;
        }
    }

    public OdiAdapter(DataSetToCache datasetToCache) {
        assert (datasetToCache != null);
        this.datasetToCache = datasetToCache;
    }

    public OdiAdapter(DataSetFromCache datasetFromCache) {
        assert (datasetFromCache != null);
        this.datasetFromCache = datasetFromCache;
    }

    public OdiAdapter(ICustomDataSet customDataSet) {
        assert (customDataSet != null);
        this.customDataSet = customDataSet;
    }

    OdiAdapter(ResultSetCache resultSetCache) {
        assert (resultSetCache != null);
        this.resultSetCache = resultSetCache;
    }

    public OdiAdapter(IResultIterator resultSetCache) {
        assert (resultSetCache != null);
        this.resultIterator = resultSetCache;
    }

    OdiAdapter(ResultObjectReader roReader) {
        assert (roReader != null);
        this.roReader = roReader;
    }

    public OdiAdapter(IDataSetPopulator populator) {
        assert (populator != null);
        this.populator = populator;
    }

    private IResultObject getConvertedResultObject(IResultObject resultObject) throws DataException {
        if (resultObject == null) {
            return null;
        }
        if (this.columnIndexListForTypeConvert == null) {
            return resultObject;
        }
        Object[] obj = new Object[this.resultClass.getFieldCount()];
        int i = 1;
        while (i <= this.resultClass.getFieldCount()) {
            if (this.columnIndexListForTypeConvert.contains(i)) {
                try {
                    obj[i - 1] = DataTypeUtil.convert((Object)resultObject.getFieldValue(i), (int)DataTypeUtil.toApiDataType((Class)this.resultClass.getFieldMetaData(i).getDataType()));
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
            } else {
                obj[i - 1] = resultObject.getFieldValue(i);
            }
            ++i;
        }
        ResultObject result = new ResultObject(this.resultClass, obj);
        return result;
    }

    IResultObject fetch() throws DataException {
        if (this.odaResultSet != null) {
            return this.getConvertedResultObject(this.odaResultSet.fetch());
        }
        if (this.datasetToCache != null) {
            return this.datasetToCache.fetch();
        }
        if (this.datasetFromCache != null) {
            return this.datasetFromCache.fetch();
        }
        if (this.customDataSet != null) {
            return this.customDataSet.fetch();
        }
        if (this.resultIterator != null) {
            if (!this.riStarted) {
                this.riStarted = true;
            } else {
                this.resultIterator.next();
            }
            return this.resultIterator.getCurrentResult();
        }
        if (this.roReader != null) {
            return this.roReader.fetch();
        }
        if (this.populator != null) {
            return this.populator.next();
        }
        return this.resultSetCache.fetch();
    }
}

