/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import java.text.NumberFormat;
import java.util.Locale;

public class ByteSizeFormatter {
    protected String format = null;
    protected long divisor = 1L;
    protected final Base base;
    protected static NumberFormat formatter = NumberFormat.getInstance(Locale.ENGLISH);

    public ByteSizeFormatter(Base base) {
        this.base = base;
    }

    public ByteSizeFormatter(Base base, long size) {
        this(base);
        this.initFormat(size);
    }

    private void initFormat(long value) {
        int factor = this.base.getFactor();
        if (value < (long)factor) {
            this.format = this.base.getBFormat();
            this.divisor = 1L;
        } else if (value < (long)(factor * factor)) {
            this.format = this.base.getKBFormat();
            this.divisor = factor;
        } else if (value < (long)(factor * factor * factor)) {
            this.format = this.base.getMBFormat();
            this.divisor = factor * factor;
        } else {
            this.format = this.base.getGBFormat();
            this.divisor = factor * factor * factor;
        }
    }

    public String format(long size) {
        return this.format(size, true);
    }

    public String format(long size, boolean group) {
        return this.format(size, group, 3);
    }

    public String format(long size, boolean group, int fractionDigits) {
        if (this.format == null) {
            this.initFormat(size);
        }
        formatter.setGroupingUsed(group);
        formatter.setMaximumFractionDigits(fractionDigits);
        double fsize = (double)size / (double)this.divisor;
        return String.valueOf(formatter.format(fsize)) + " " + this.format;
    }

    public static enum Base {
        KILOBYTE,
        KIBIBYTE,
        KILOBIT,
        KIBIBIT;


        private int getFactor() {
            return KILOBYTE.equals((Object)this) || KILOBIT.equals((Object)this) ? 1000 : 1024;
        }

        private String getRateString() {
            return KILOBYTE.equals((Object)this) || KIBIBYTE.equals((Object)this) ? "B" : "bit";
        }

        private String getBFormat() {
            return this.getRateString();
        }

        private String getKBFormat() {
            String prefix = KILOBYTE.equals((Object)this) || KILOBIT.equals((Object)this) ? "k" : "Ki";
            return String.valueOf(prefix) + this.getRateString();
        }

        private String getMBFormat() {
            String prefix = KILOBYTE.equals((Object)this) || KILOBIT.equals((Object)this) ? "M" : "Mi";
            return String.valueOf(prefix) + this.getRateString();
        }

        private String getGBFormat() {
            String prefix = KILOBYTE.equals((Object)this) || KILOBIT.equals((Object)this) ? "G" : "Gi";
            return String.valueOf(prefix) + this.getRateString();
        }
    }
}

