/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.EventManager;
import com.nvidia.viper.MetricManager;
import com.nvidia.viper.MultiProcessPDMManager;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityAPI;
import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.activity.CuptiActivityContext;
import com.nvidia.viper.activity.CuptiActivityDevice;
import com.nvidia.viper.activity.CuptiActivityDeviceAttribute;
import com.nvidia.viper.activity.CuptiActivityEnvironment;
import com.nvidia.viper.activity.CuptiActivityEvent;
import com.nvidia.viper.activity.CuptiActivityExternalCorrelation;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivityInstructionCorrelation;
import com.nvidia.viper.activity.CuptiActivityKernel;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityMarker;
import com.nvidia.viper.activity.CuptiActivityMarkerData;
import com.nvidia.viper.activity.CuptiActivityMemcpy;
import com.nvidia.viper.activity.CuptiActivityMemcpyP2p;
import com.nvidia.viper.activity.CuptiActivityMemory;
import com.nvidia.viper.activity.CuptiActivityMemset;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.activity.CuptiActivityModule;
import com.nvidia.viper.activity.CuptiActivityName;
import com.nvidia.viper.activity.CuptiActivityNvLink;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.activity.CuptiActivityOpenAcc;
import com.nvidia.viper.activity.CuptiActivityOpenMP;
import com.nvidia.viper.activity.CuptiActivityOverhead;
import com.nvidia.viper.activity.CuptiActivityPCSampling;
import com.nvidia.viper.activity.CuptiActivityPCSamplingRecordInfo;
import com.nvidia.viper.activity.CuptiActivitySourceLevelResultBase;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.activity.CuptiActivityUvmCounter;
import com.nvidia.viper.activity.CuptiActivityUvmCounterKind;
import com.nvidia.viper.activity.CuptiDevType;
import com.nvidia.viper.activity.CuptiExternalCorrelationKind;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.activity.PThreadActivity;
import com.nvidia.viper.analysis.AnalysisResultNVLink;
import com.nvidia.viper.jni.CUptiResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.jni.NativePThreadActivityDB;
import com.nvidia.viper.model.ContainerState;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.OpenAccSummary;
import com.nvidia.viper.model.OpenMPSummary;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineContext;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalAPI;
import com.nvidia.viper.model.TimelineIntervalFactory;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalNvlink;
import com.nvidia.viper.model.TimelineIntervalOpenAcc;
import com.nvidia.viper.model.TimelineIntervalUVM;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineMemcpy;
import com.nvidia.viper.model.TimelineNvlink;
import com.nvidia.viper.model.TimelineOverhead;
import com.nvidia.viper.model.TimelineProcess;
import com.nvidia.viper.model.TimelineStream;
import com.nvidia.viper.model.TimelineThread;
import com.nvidia.viper.model.TimelineUVM;
import com.nvidia.viper.model.UniqueActivityID;
import com.nvidia.viper.model.UvmManager;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.gef.Disposable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class TimelineFactory
implements Disposable {
    private EventDataState eventDataState;
    private long eventDataActivityId;
    private long kernelDataActivityId;
    private int pdmVersion;
    private Map<Integer, ProcessTL> processes;
    private Map<Integer, DeviceTL> devices;
    private Map<Integer, List<ITimelineInterval>> correlationsMap;
    private Map<Long, ITimelineInterval> gridIdIntervalMap;
    private MultiProcessPDMManager multiProcessManager;
    private List<ProfileDataModel> timelinePdms;
    private Set<ProfileDataModel> mergedPdms;
    private Set<Timeline> allTimelines;
    private Map<Long, Long> pthreadIdMap;
    private Session session;
    private long sessionStart;
    private long sessionEnd;
    private int droppedRecords;
    private boolean needSessionStartUpdate;

    public TimelineFactory(ProfileDataModel pdm, Session session, boolean isTimelinePdm) throws ViperException {
        block2: {
            this.eventDataState = EventDataState.EVENT_DATA_NONE;
            this.eventDataActivityId = 0L;
            this.kernelDataActivityId = 0L;
            this.pdmVersion = -1;
            this.processes = new HashMap<Integer, ProcessTL>();
            this.devices = new HashMap<Integer, DeviceTL>();
            this.timelinePdms = new LinkedList<ProfileDataModel>();
            this.mergedPdms = new HashSet<ProfileDataModel>();
            this.allTimelines = new HashSet<Timeline>();
            this.sessionStart = -1L;
            this.sessionEnd = -1L;
            this.needSessionStartUpdate = false;
            this.init();
            this.timelinePdms.add(pdm);
            this.session = session;
            try {
                this.initStartEnd(pdm);
            }
            catch (CuptiException e) {
                this.needSessionStartUpdate = true;
                if (!session.isEnableTimeRange() && !session.isUVMSegmentEnabled()) break block2;
                this.resetTimelineOptions(session, e);
            }
        }
        this.parsePdm(pdm, session, true, isTimelinePdm);
    }

    public TimelineFactory(ProfileDataModel[] pdms, Session session, boolean isTimelinePdm) throws ViperException {
        this.eventDataState = EventDataState.EVENT_DATA_NONE;
        this.eventDataActivityId = 0L;
        this.kernelDataActivityId = 0L;
        this.pdmVersion = -1;
        this.processes = new HashMap<Integer, ProcessTL>();
        this.devices = new HashMap<Integer, DeviceTL>();
        this.timelinePdms = new LinkedList<ProfileDataModel>();
        this.mergedPdms = new HashSet<ProfileDataModel>();
        this.allTimelines = new HashSet<Timeline>();
        this.sessionStart = -1L;
        this.sessionEnd = -1L;
        this.needSessionStartUpdate = false;
        this.session = session;
        this.multiProcessManager = new MultiProcessPDMManager();
        this.init();
        int count = 0;
        ProfileDataModel[] profileDataModelArray = pdms;
        int n = pdms.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                ProfileDataModel pdm = profileDataModelArray[n2];
                this.manageMultipleProcesses(pdm);
                this.timelinePdms.add(pdm);
                try {
                    if (count == 0) {
                        this.initStartEnd(pdm);
                    } else {
                        long duration;
                        long[] ranges = NativeCupti.cuptiPDMGetTimestampRange(pdm.getNativeHandle());
                        if (session.isNormalizeIndependently()) {
                            session.setTimeRange(ranges[0], ranges[1], pdm);
                        }
                        if (ranges[0] < this.sessionStart) {
                            this.sessionStart = ranges[0];
                        }
                        if (ranges[1] > this.sessionEnd) {
                            this.sessionEnd = ranges[1];
                        }
                        if ((duration = ranges[1] - ranges[0]) > this.multiProcessManager.getMaxDuration()) {
                            this.multiProcessManager.setMaxDuration(duration);
                        }
                    }
                }
                catch (CuptiException e) {
                    this.needSessionStartUpdate = true;
                    if (!session.isEnableTimeRange() && !session.isUVMSegmentEnabled()) break block10;
                    this.resetTimelineOptions(session, e);
                }
            }
            ++count;
            ++n2;
        }
        int i = 0;
        while (i < pdms.length) {
            ProfileDataModel pdm = pdms[i];
            boolean isLastPdm = i == pdms.length - 1;
            this.parsePdm(pdm, session, isLastPdm, isTimelinePdm);
            ++i;
        }
    }

    public long getMaxDurationAcrossPdm() {
        return this.multiProcessManager != null ? this.multiProcessManager.getMaxDuration() : -1L;
    }

    private void resetTimelineOptions(Session session, CuptiException e) {
        session.setEnableTimeRange(false);
        session.setIsUVMSegmentEnabled(false);
        if (e != null) {
            if (e.getCuptiResult().equals((Object)CUptiResult.CUPTI_ERROR_API_NOT_IMPLEMENTED)) {
                this.openWarning(ViperMessages.TimelineOptions_NotSupported_Label, ViperMessages.TimelineOptions_NotSupported_Error);
            } else {
                this.openWarning(ViperMessages.TimelineOptions_NotSupported_Label, ViperMessages.TimelineOptions_NotEnabled_Error);
            }
        }
    }

    private void init() {
        this.correlationsMap = new HashMap<Integer, List<ITimelineInterval>>();
        this.gridIdIntervalMap = new HashMap<Long, ITimelineInterval>();
        this.pthreadIdMap = new HashMap<Long, Long>();
        this.droppedRecords = 0;
    }

    private void initStartEnd(ProfileDataModel pdm) throws CuptiException {
        if (this.sessionStart == -1L || this.sessionEnd == -1L) {
            long[] ranges = NativeCupti.cuptiPDMGetTimestampRange(pdm.getNativeHandle());
            if (ranges != null) {
                this.sessionStart = ranges[0];
                this.sessionEnd = ranges[1];
                if (this.session.isNormalizeIndependently()) {
                    this.session.setTimeRange(ranges[0], ranges[1], pdm);
                }
            } else {
                this.resetTimelineOptions(this.session, null);
            }
            long duration = ranges[1] - ranges[0];
            if (this.multiProcessManager != null && duration > this.multiProcessManager.getMaxDuration()) {
                this.multiProcessManager.setMaxDuration(duration);
            }
        }
    }

    public List<ProfileDataModel> getTimelinePdms() {
        return this.timelinePdms;
    }

    public List<ProfileDataModel> getAnalysisPdms() {
        return new ArrayList<ProfileDataModel>(this.mergedPdms);
    }

    public void addAnalysisPdm(ProfileDataModel pdm) {
        this.mergedPdms.add(pdm);
    }

    private void manageMultipleProcesses(ProfileDataModel pdm) {
        try {
            ICuptiActivity activity;
            long hIterator = pdm.getIterator();
            this.multiProcessManager.startPreProcessing(pdm);
            while ((activity = pdm.getNextActivity(hIterator)) != null) {
                if (!activity.isValid()) continue;
                this.multiProcessManager.preProcessActivity(activity, pdm);
            }
            pdm.deleteIterator(hIterator);
            this.multiProcessManager.finishPreProcessing(pdm);
        }
        catch (CuptiException cuptiException) {
            ViperExceptionHandler.logError("unable to read pdm");
        }
        catch (ViperException viperException) {
            ViperExceptionHandler.logError("unable to read pdm");
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
    }

    private boolean checkAndUpdateTimestamps(ICuptiActivity activity, ProfileDataModel pdm) {
        long end;
        long start;
        switch (activity.getKind()) {
            case CUPTI_ACTIVITY_KIND_RUNTIME: {
                if (this.session.isTimelineDisabled(TimelineKind.RUNTIME)) {
                    return false;
                }
                CuptiActivityAPI api = (CuptiActivityAPI)activity;
                start = api.start;
                end = api.end;
                break;
            }
            case CUPTI_ACTIVITY_KIND_DRIVER: {
                if (this.session.isTimelineDisabled(TimelineKind.DRIVER)) {
                    return false;
                }
                CuptiActivityAPI api = (CuptiActivityAPI)activity;
                start = api.start;
                end = api.end;
                break;
            }
            case CUPTI_ACTIVITY_KIND_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CDP_KERNEL: {
                if (this.session.isTimelineDisabled(TimelineKind.KERNELS)) {
                    return false;
                }
                CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                start = kernel.start;
                end = kernel.end;
                break;
            }
            case CUPTI_ACTIVITY_KIND_ENVIRONMENT: {
                CuptiActivityEnvironment env = (CuptiActivityEnvironment)activity;
                start = end = env.timestamp;
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMSET: {
                if (this.session.isTimelineDisabled(TimelineKind.KERNELS)) {
                    return false;
                }
                CuptiActivityMemset memset = (CuptiActivityMemset)activity;
                start = memset.start;
                end = memset.end;
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMCPY: {
                CuptiActivityMemcpy memcpy = (CuptiActivityMemcpy)activity;
                if (memcpy.isTimelineDisabled(this.session)) {
                    return false;
                }
                start = memcpy.start;
                end = memcpy.end;
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMCPY2: {
                CuptiActivityMemcpyP2p memcpy2 = (CuptiActivityMemcpyP2p)activity;
                if (memcpy2.isTimelineDisabled(this.session)) {
                    return false;
                }
                start = memcpy2.start;
                end = memcpy2.end;
                break;
            }
            case CUPTI_ACTIVITY_KIND_MARKER: {
                if (this.session.isTimelineDisabled(TimelineKind.MARKER)) {
                    return false;
                }
                CuptiActivityMarker marker = (CuptiActivityMarker)activity;
                start = end = marker.timestamp;
                break;
            }
            case CUPTI_ACTIVITY_KIND_OVERHEAD: {
                if (this.session.isTimelineDisabled(TimelineKind.OVERHEADS)) {
                    return false;
                }
                CuptiActivityOverhead overhead = (CuptiActivityOverhead)activity;
                start = overhead.start;
                end = overhead.end;
                break;
            }
            case CUPTI_ACTIVITY_KIND_UVM_COUNTER: {
                CuptiActivityUvmCounter uvm = (CuptiActivityUvmCounter)activity;
                if (uvm.isTimelineDisabled(this.session)) {
                    return false;
                }
                if (uvm.isNew()) {
                    start = uvm.start;
                    end = uvm.end;
                    break;
                }
                start = end = uvm.timestamp;
                break;
            }
            case CUPTI_ACTIVITY_KIND_OPENACC_DATA: 
            case CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH: 
            case CUPTI_ACTIVITY_KIND_OPENACC_OTHER: {
                if (this.session.isTimelineDisabled(TimelineKind.OPENACC)) {
                    return false;
                }
                CuptiActivityOpenAcc oacc = (CuptiActivityOpenAcc)activity;
                start = oacc.start;
                end = oacc.end;
                break;
            }
            case CUPTI_ACTIVITY_KIND_PTHREAD: {
                if (this.session.isTimelineDisabled(TimelineKind.PTHREAD)) {
                    return false;
                }
                PThreadActivity pthread = (PThreadActivity)activity;
                start = pthread.start;
                end = pthread.end;
                break;
            }
            case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT: 
            case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE: {
                CuptiActivityEvent event = (CuptiActivityEvent)activity;
                start = end = event.timestamp;
                break;
            }
            case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC: 
            case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE: {
                CuptiActivityMetric metric = (CuptiActivityMetric)activity;
                start = end = metric.timestamp;
                break;
            }
            case CUPTI_ACTIVITY_KIND_OPENMP: {
                CuptiActivityOpenMP omp = (CuptiActivityOpenMP)activity;
                start = omp.start;
                end = omp.end;
                break;
            }
            default: {
                return true;
            }
        }
        this.session.setTimeRange(start, end, pdm);
        if (this.needSessionStartUpdate && (this.sessionStart == -1L || this.sessionStart > start)) {
            this.sessionStart = start;
        }
        return true;
    }

    public ArrayList<Timeline> createAndReturnTimelines(ICuptiActivity activity, String customName) throws ViperException {
        ArrayList<Timeline> result = new ArrayList<Timeline>();
        switch (activity.getKind()) {
            case CUPTI_ACTIVITY_KIND_RUNTIME: {
                CuptiActivityAPI runtime = (CuptiActivityAPI)activity;
                ProcessTL process = this.getProcess(runtime.processId);
                ThreadTL thread = process.getThread(runtime.processId, runtime.threadId);
                Timeline tl = thread.getTimelineForIntervalKind(TimelineIntervalKind.RUNTIME, true);
                result.add(tl);
                break;
            }
            case CUPTI_ACTIVITY_KIND_DRIVER: {
                CuptiActivityAPI driver = (CuptiActivityAPI)activity;
                ProcessTL process = this.getProcess(driver.processId);
                ThreadTL thread = process.getThread(driver.processId, driver.threadId);
                Timeline tl = thread.getTimelineForIntervalKind(TimelineIntervalKind.DRIVER, true);
                result.add(tl);
                break;
            }
            case CUPTI_ACTIVITY_KIND_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CDP_KERNEL: {
                CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                DeviceTL device = this.getDevice(kernel.deviceId, null, null, false);
                ContextTL context = device.getContext(kernel.contextId, null, null);
                List<Timeline> timelines = context.getTimelinesForInterval(TimelineIntervalKind.KERNEL, kernel.deviceId, kernel.contextId, kernel.streamId, customName, kernel.parentGridId != 0L);
                Timeline t = (Timeline)context.timelineMap.get(kernel.getID());
                if (t == null) {
                    t = context.defaultKernelTimeline;
                }
                if (t != null) {
                    result.add(t);
                }
                result.addAll(timelines);
                break;
            }
            case CUPTI_ACTIVITY_KIND_ENVIRONMENT: {
                CuptiActivityEnvironment envAct = (CuptiActivityEnvironment)activity;
                DeviceTL device = this.getDevice(envAct.deviceId, null, null, false);
                result.add(device.tl);
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMSET: {
                CuptiActivityMemset memset = (CuptiActivityMemset)activity;
                DeviceTL device = this.getDevice(memset.deviceId, null, null, false);
                ContextTL context = device.getContext(memset.contextId, null, null);
                TimelineKernel t = (TimelineKernel)context.memsetTimelineMap.get(memset.value);
                if (t == null) {
                    t = new TimelineKernel(new String("memset (" + memset.value + ")"));
                    context.memsetTimelineMap.put(memset.value, t);
                    this.allTimelines.add(t);
                }
                result.add(t);
                List<Timeline> timelines = context.getTimelinesForInterval(TimelineIntervalKind.MEMSET, memset.deviceId, memset.contextId, memset.streamId, customName, false);
                result.addAll(timelines);
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMCPY: {
                CuptiActivityMemcpy memcpy = (CuptiActivityMemcpy)activity;
                TimelineIntervalKind kind = this.getIntervalKindFromActivity(memcpy);
                if (kind == TimelineIntervalKind.UNKNOWN) break;
                DeviceTL device = this.getDevice(memcpy.deviceId, null, null, false);
                ContextTL context = device.getContext(memcpy.contextId, null, null);
                List<Timeline> timelines = context.getTimelinesForInterval(kind, memcpy.deviceId, memcpy.contextId, memcpy.streamId, customName, false);
                result.addAll(timelines);
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMCPY2: {
                CuptiActivityMemcpyP2p memcpy2 = (CuptiActivityMemcpyP2p)activity;
                DeviceTL device = this.getDevice(memcpy2.srcDeviceId, null, null, false);
                ContextTL context = device.getContext(memcpy2.srcContextId, null, null);
                List<Timeline> timelines = context.getTimelinesForInterval(TimelineIntervalKind.MEMCPY_PTOP, memcpy2.srcDeviceId, memcpy2.srcContextId, -1, customName, false);
                result.addAll(timelines);
                device = this.getDevice(memcpy2.dstDeviceId, null, null, false);
                context = device.getContext(memcpy2.dstContextId, null, null);
                timelines = context.getTimelinesForInterval(TimelineIntervalKind.MEMCPY_PTOP, memcpy2.dstDeviceId, memcpy2.dstContextId, -1, customName, false);
                result.addAll(timelines);
                device = this.getDevice(memcpy2.deviceId, null, null, false);
                context = device.getContext(memcpy2.contextId, null, null);
                context.getTimelineForKind(TimelineKind.STREAMS, true);
                TimelineStream stl = context.getTimelineForStream(memcpy2.deviceId, memcpy2.contextId, memcpy2.streamId, customName, true);
                if (stl == null) break;
                result.add(stl);
                break;
            }
            case CUPTI_ACTIVITY_KIND_MARKER: {
                ProcessTL process;
                ThreadTL thread;
                Timeline tl;
                CuptiActivityMarker marker = (CuptiActivityMarker)activity;
                if (!CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS.isSet(marker.flags) && !CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_START.isSet(marker.flags) || (tl = (thread = (process = this.getProcess(marker.objectProcessId)).getThread(marker.objectProcessId, marker.objectThreadId)).getTimelineForIntervalKind(TimelineIntervalKind.MARKER, false)) == null) break;
                result.add(tl);
                break;
            }
            case CUPTI_ACTIVITY_KIND_OVERHEAD: {
                CuptiActivityOverhead overhead = (CuptiActivityOverhead)activity;
                if (CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_PROCESS.equals((Object)overhead.getObjectKind()) || CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_THREAD.equals((Object)overhead.getObjectKind())) {
                    ProcessTL process = this.getProcess(overhead.objectProcessId);
                    Timeline tl = process.getOverheadTimeline();
                    result.add(tl);
                    break;
                }
                ViperExceptionHandler.logError("dropping unexpected overhead association with " + overhead.objectKind);
                break;
            }
            case CUPTI_ACTIVITY_KIND_UVM_COUNTER: {
                ProcessTL process;
                UVMTL uvm;
                List<Timeline> tls;
                CuptiActivityUvmCounter uvmCounter = (CuptiActivityUvmCounter)activity;
                for (int deviceId : uvmCounter.getDeviceIDList()) {
                    CuptiActivityUvmCounterKind uvmCounterKind;
                    DeviceTL device = this.getDevice(deviceId, null, null, false);
                    UVMTL uvm2 = device.uvm;
                    List<Timeline> tls2 = this.getTimelinesForUvm(uvm2, uvmCounterKind = uvmCounter.getUvmCounterKind());
                    if (tls2 == null) continue;
                    result.addAll(tls2);
                }
                if (!uvmCounter.isCpu() || (tls = this.getTimelinesForUvm(uvm = (process = this.getProcess(uvmCounter.processId)).uvm, uvmCounter.getUvmCounterKind())) == null) break;
                result.addAll(tls);
                break;
            }
            case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE: {
                break;
            }
            case CUPTI_ACTIVITY_KIND_OPENACC_DATA: 
            case CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH: 
            case CUPTI_ACTIVITY_KIND_OPENACC_OTHER: {
                CuptiActivityOpenAcc oacc = (CuptiActivityOpenAcc)activity;
                ProcessTL process = this.getProcess(oacc.cuProcessId);
                ThreadTL thread = process.getThread(oacc.cuProcessId, oacc.cuThreadId);
                Timeline tl = thread.getTimelineForIntervalKind(TimelineIntervalKind.OPENACC, true);
                result.add(tl);
                break;
            }
            case CUPTI_ACTIVITY_KIND_PTHREAD: {
                PThreadActivity pthread = (PThreadActivity)activity;
                ProcessTL process = this.getProcess(pthread.pid);
                ThreadTL thread = process.getThread(pthread.pid, pthread.tid);
                Timeline tl = thread.getTimelineForIntervalKind(TimelineIntervalKind.PTHREAD, true);
                result.add(tl);
                break;
            }
            case CUPTI_ACTIVITY_KIND_OPENMP: {
                CuptiActivityOpenMP omp = (CuptiActivityOpenMP)activity;
                ProcessTL process = this.getProcess(omp.cuProcessId);
                ThreadTL thread = process.getThread(omp.cuProcessId, omp.cuThreadId);
                Timeline tl = thread.getTimelineForIntervalKind(TimelineIntervalKind.OPENMP, true);
                result.add(tl);
                break;
            }
        }
        return result;
    }

    private List<Timeline> getTimelinesForUvm(UVMTL uvm, CuptiActivityUvmCounterKind cuptiActivityUvmCounterKind) {
        ArrayList<Timeline> tls = new ArrayList<Timeline>();
        switch (cuptiActivityUvmCounterKind) {
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH: {
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_MEMCPY_DTOH, true));
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD: {
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_MEMCPY_HTOD, true));
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOD: {
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_MEMCPY_DTOD, true));
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT: {
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_PAGE_FAULT, true));
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_GPU_PAGE_FAULT_COUNT: {
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_GPU_PAGE_FAULT, true));
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING: {
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_THRASHING, true));
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_THRASHING_THROTTLING, true));
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING: {
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_PAGE_THROTTLING, true));
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_THRASHING_THROTTLING, true));
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP: {
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_REMOTE_MAP, true));
                tls.add(uvm.getTimelineForKind(TimelineKind.UVM_THRASHING_THROTTLING, true));
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_UNKNOWN: {
                break;
            }
        }
        return tls;
    }

    private void addAnalysisCorrelation(ProfileDataModel pdm, int correlation, long id) {
        pdm.addUniqueID(correlation, id);
    }

    private void addEventData(Long activityId) {
        if (activityId == null) {
            return;
        }
        switch (this.eventDataState) {
            case EVENT_DATA_NONE: {
                this.eventDataState = EventDataState.EVENT_DATA_SINGLE;
                this.eventDataActivityId = activityId;
                break;
            }
            case EVENT_DATA_SINGLE: {
                if (activityId == this.eventDataActivityId) break;
                this.eventDataState = EventDataState.EVENT_DATA_MULTIPLE;
                break;
            }
        }
    }

    private void addKernelData(Long activityId) {
        if (activityId == null) {
            return;
        }
        this.kernelDataActivityId = activityId;
    }

    public long getPThreadIntervalId(long pthreadId) throws ViperException {
        Long result = this.pthreadIdMap.get(pthreadId);
        if (result != null) {
            return result;
        }
        throw new ViperException("PThread id cannot be converted");
    }

    private void parsePThreadData(ProfileDataModel pdm, Session session, long maxActivityId, long start, long end, boolean addToTimeline) throws ViperException, InterruptedException {
        long nextActivityId = maxActivityId;
        long dbHandle = NativePThreadActivityDB.pthreadDBOpen(pdm.getPdmFilePath(), NativePThreadActivityDB.AccessMode.AccessModeOpen.getCode());
        if (dbHandle != 0L) {
            long iterHandle = NativePThreadActivityDB.pthreadDBCreateRangeIterator(dbHandle, start, end);
            if (iterHandle != 0L) {
                PThreadActivity ptActivity;
                while ((ptActivity = NativePThreadActivityDB.pthreadDBGetNextActivity(iterHandle)) != null) {
                    ITimelineInterval interval;
                    boolean check;
                    if (!addToTimeline && !(check = this.checkAndUpdateTimestamps(ptActivity, pdm))) continue;
                    ArrayList<Timeline> timelines = this.createAndReturnTimelines(ptActivity, null);
                    if (addToTimeline) {
                        ptActivity.setID(this.pthreadIdMap.get(ptActivity.id));
                        interval = this.loadIntervalFromActivity(ptActivity, timelines.size() > 0 ? timelines.get(0) : null, true);
                        if (interval != null) {
                            this.addIntervalToTimelines(interval, timelines);
                        }
                    } else {
                        this.pthreadIdMap.put(ptActivity.id, ++nextActivityId);
                        ptActivity.setID(nextActivityId);
                        interval = this.loadIntervalFromActivity(ptActivity, null, true);
                        if (interval != null) {
                            for (Timeline timeline : timelines) {
                                timeline.addIntervalMin(interval.getID(), interval.getStart(), interval.getEnd(), interval.getExtendedEnd(), interval.getKind());
                            }
                        }
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    NativePThreadActivityDB.pthreadDBDestroyIterator(iterHandle);
                    NativePThreadActivityDB.pthreadDBClose(dbHandle);
                    throw new InterruptedException();
                }
                if (!addToTimeline) {
                    for (Timeline tl : this.allTimelines) {
                        if (!tl.getKind().equals((Object)TimelineKind.PTHREAD)) continue;
                        tl.processIntervalMins();
                    }
                }
                NativePThreadActivityDB.pthreadDBDestroyIterator(iterHandle);
            }
            NativePThreadActivityDB.pthreadDBClose(dbHandle);
        }
    }

    private void parsePdm(ProfileDataModel pdm, Session session, boolean isLastTimelinePdm, boolean isTimelinePdm) throws ViperException {
        HashSet<CuptiActivityModule> modules = new HashSet<CuptiActivityModule>();
        HashSet<CuptiActivityFunction> functions = new HashSet<CuptiActivityFunction>();
        HashSet<CuptiActivityInstructionCorrelation> instructionCorrelations = new HashSet<CuptiActivityInstructionCorrelation>();
        int droppedNames = 0;
        long maxActivityId = 0L;
        LinkedList<CuptiActivityMarker> markers = new LinkedList<CuptiActivityMarker>();
        HashMap<Integer, CuptiActivityMarkerData> markerDatas = new HashMap<Integer, CuptiActivityMarkerData>();
        HashMap<Integer, Long> correlationMap = new HashMap<Integer, Long>();
        long hIterator = 0L;
        try {
            int invalidRecords = 0;
            long hPdm = pdm.getNativeHandle();
            int version = NativeCupti.cuptiPDMGetVersion(hPdm);
            if (this.pdmVersion == -1) {
                this.pdmVersion = version;
            } else if (version != this.pdmVersion) {
                throw new ViperException("pdm version mismatch");
            }
            EnumSet<CuptiActivityKind> loadedKinds = EnumSet.noneOf(CuptiActivityKind.class);
            for (CuptiActivityKind activityKind : TimelineKind.getOptimalTraversingOrder(session)) {
                hIterator = !session.isEnableTimeRange() ? pdm.getIteratorTypeMask(1L << activityKind.getCode()) : (session.isNormalizeIndependently() ? pdm.getIteratorTypeMaskTimeRange(1L << activityKind.getCode(), session.getEarliestTime(pdm) + session.getTimelineStart(), session.getEarliestTime(pdm) + session.getTimelineEnd(), true) : pdm.getIteratorTypeMaskTimeRange(1L << activityKind.getCode(), this.sessionStart + session.getTimelineStart(), this.sessionStart + session.getTimelineEnd(), true));
                block36: while (true) {
                    ITimelineInterval interval;
                    boolean check;
                    if (Thread.currentThread().getName().equals("LoadPdm") && Thread.currentThread().isInterrupted()) {
                        pdm.deleteIterator(hIterator);
                        throw new ViperException("LoadPdmCancel");
                    }
                    ICuptiActivity activity = pdm.getNextActivity(hIterator);
                    if (activity == null) break;
                    if (!activity.isValid()) {
                        ++invalidRecords;
                        continue;
                    }
                    if (activity.getKind().isAnalysisKind()) {
                        pdm.setHasAnalysisData();
                    }
                    String customName = null;
                    if (this.multiProcessManager != null) {
                        customName = this.multiProcessManager.processActivity(activity, pdm);
                    }
                    if (activity.getID() > maxActivityId) {
                        maxActivityId = activity.getID();
                    }
                    if (isTimelinePdm && !(check = this.checkAndUpdateTimestamps(activity, pdm))) continue;
                    ArrayList<Timeline> timelines = this.createAndReturnTimelines(activity, customName);
                    if (activity.getKind() != CuptiActivityKind.CUPTI_ACTIVITY_KIND_UVM_COUNTER && activity.getKind() != CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER && (interval = this.loadIntervalFromActivity(activity, null, isTimelinePdm)) != null) {
                        for (Timeline timeline : timelines) {
                            timeline.addIntervalMin(interval.getID(), interval.getStart(), interval.getEnd(), interval.getExtendedEnd(), interval.getKind());
                        }
                    }
                    switch (activity.getKind()) {
                        case CUPTI_ACTIVITY_KIND_KERNEL: 
                        case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: 
                        case CUPTI_ACTIVITY_KIND_CDP_KERNEL: {
                            CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                            DeviceTL device = this.getDevice(kernel.deviceId, null, null, false);
                            ContextTL context = device.getContext(kernel.contextId, null, null);
                            context.addKernelNode(kernel.correlationId, kernel.gridId, kernel.parentGridId, kernel.getID(), kernel.start, kernel.end, kernel.name);
                            correlationMap.put(kernel.correlationId, kernel.getID());
                            if (isTimelinePdm) continue block36;
                            this.addKernelData(kernel.getID());
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_MEMSET: {
                            CuptiActivityMemset memset = (CuptiActivityMemset)activity;
                            DeviceTL device = this.getDevice(memset.deviceId, null, null, false);
                            device.getContext(memset.contextId, null, null);
                            correlationMap.put(memset.correlationId, memset.getID());
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_MEMCPY: {
                            CuptiActivityMemcpy memcpy = (CuptiActivityMemcpy)activity;
                            for (Timeline tl : timelines) {
                                if (!(tl instanceof TimelineMemcpy)) continue;
                                ((TimelineMemcpy)tl).prepareInterval(memcpy.getID(), memcpy.start, memcpy.end, memcpy.bytes);
                            }
                            correlationMap.put(memcpy.correlationId, memcpy.getID());
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_MEMCPY2: {
                            CuptiActivityMemcpyP2p memcpy2 = (CuptiActivityMemcpyP2p)activity;
                            for (Timeline tl : timelines) {
                                if (!(tl instanceof TimelineMemcpy)) continue;
                                ((TimelineMemcpy)tl).prepareInterval(memcpy2.getID(), memcpy2.start, memcpy2.end, memcpy2.bytes);
                            }
                            correlationMap.put(memcpy2.correlationId, memcpy2.getID());
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_DEVICE: {
                            CuptiActivityDevice device = (CuptiActivityDevice)activity;
                            this.getDevice(device.id, device, customName, false);
                            pdm.devices.add(device);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_CONTEXT: {
                            CuptiActivityContext context = (CuptiActivityContext)activity;
                            this.getContext(context.contextId, context, customName);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_MARKER: {
                            CuptiActivityMarker marker = (CuptiActivityMarker)activity;
                            markers.add(marker);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_MARKER_DATA: {
                            CuptiActivityMarkerData data = (CuptiActivityMarkerData)activity;
                            markerDatas.put(data.id, data);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_NAME: {
                            if (this.setName((CuptiActivityName)activity)) continue block36;
                            ++droppedNames;
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE: {
                            CuptiActivityDeviceAttribute da = (CuptiActivityDeviceAttribute)activity;
                            DeviceTL device = this.getDevice(da.deviceId, null, null, false);
                            device.addAttribute(da);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_MODULE: {
                            CuptiActivityModule module = (CuptiActivityModule)activity;
                            modules.add(module);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_FUNCTION: {
                            CuptiActivityFunction function = (CuptiActivityFunction)activity;
                            functions.add(function);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR: {
                            CuptiActivitySourceLocator source = (CuptiActivitySourceLocator)activity;
                            this.addSourceLocator(source, pdm);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_UVM_COUNTER: {
                            CuptiActivityUvmCounter uvmCounter = (CuptiActivityUvmCounter)activity;
                            if (uvmCounter.isStartOnly()) {
                                uvmCounter.end = uvmCounter.start;
                            }
                            this.addUVMCounter(uvmCounter);
                            this.addUvmCounterToManager(uvmCounter);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION: {
                            CuptiActivityInstructionCorrelation instructionCorrelation = (CuptiActivityInstructionCorrelation)activity;
                            instructionCorrelations.add(instructionCorrelation);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_EVENT: 
                        case CUPTI_ACTIVITY_KIND_EVENT_INSTANCE: {
                            CuptiActivityEvent eventActivity = (CuptiActivityEvent)activity;
                            Event event = EventManager.getEvent(eventActivity.domain, eventActivity.id);
                            if (event != null) {
                                session.addEvent(event);
                            }
                            this.addAnalysisCorrelation(pdm, eventActivity.correlationId, activity.getID());
                            this.addEventData((Long)correlationMap.get(eventActivity.correlationId));
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_METRIC: 
                        case CUPTI_ACTIVITY_KIND_METRIC_INSTANCE: {
                            CuptiActivityMetric metricActivity = (CuptiActivityMetric)activity;
                            Metric metric = MetricManager.getMetric(metricActivity.id);
                            if (metric != null && metricActivity.getInstance() == -1) {
                                session.addAggregatedMetric(metric);
                            }
                            this.addAnalysisCorrelation(pdm, metricActivity.correlationId, activity.getID());
                            this.addEventData((Long)correlationMap.get(metricActivity.correlationId));
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS: 
                        case CUPTI_ACTIVITY_KIND_BRANCH: 
                        case CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION: 
                        case CUPTI_ACTIVITY_KIND_SHARED_ACCESS: 
                        case CUPTI_ACTIVITY_KIND_PC_SAMPLING: {
                            int corrId;
                            CuptiActivityBase sourceLevel;
                            if (activity.getKind() == CuptiActivityKind.CUPTI_ACTIVITY_KIND_PC_SAMPLING) {
                                sourceLevel = (CuptiActivityPCSampling)activity;
                                corrId = ((CuptiActivityPCSampling)sourceLevel).getCorrelationId();
                                this.addEventData((Long)correlationMap.get(corrId));
                            } else {
                                sourceLevel = (CuptiActivitySourceLevelResultBase)activity;
                                corrId = ((CuptiActivitySourceLevelResultBase)sourceLevel).getCorrelationId();
                                this.addEventData((Long)correlationMap.get(corrId));
                            }
                            corrId = sourceLevel.getCorrelationId();
                            this.addAnalysisCorrelation(pdm, corrId, activity.getID());
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO: {
                            CuptiActivityPCSamplingRecordInfo pcSamplingRecordInfo = (CuptiActivityPCSamplingRecordInfo)activity;
                            this.addAnalysisCorrelation(pdm, pcSamplingRecordInfo.correlationId, activity.getID());
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_NVLINK: {
                            CuptiActivityNvLink link = (CuptiActivityNvLink)activity;
                            pdm.nvLinks.add(link);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT: 
                        case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE: {
                            CuptiActivityEvent event = (CuptiActivityEvent)activity;
                            session.addInstantaneousEvent(event);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC: {
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE: {
                            CuptiActivityMetric metric = (CuptiActivityMetric)activity;
                            session.addInstantaneousMetric(metric);
                            String metricName = MetricManager.getMetric(metric.id).getName();
                            TimelineIntervalKind intervalKind = TimelineIntervalKind.UNKNOWN;
                            if (metricName.equals("nvlink_transmit_throughput")) {
                                intervalKind = TimelineIntervalKind.NVLINK_TRANSMIT;
                            } else if (metricName.equals("nvlink_receive_throughput")) {
                                intervalKind = TimelineIntervalKind.NVLINK_RECEIVE;
                            }
                            if (intervalKind == TimelineIntervalKind.UNKNOWN) continue block36;
                            DeviceTL deviceTL = this.getDevice(metric.deviceId, null, null, false);
                            deviceTL.addNvlink(metric, pdm.nvLinks, pdm.devices, intervalKind);
                            continue block36;
                        }
                        case CUPTI_ACTIVITY_KIND_MEMORY: {
                            CuptiActivityMemory memory = (CuptiActivityMemory)activity;
                            this.addMemoryActivityToManager(memory);
                            continue block36;
                        }
                    }
                }
                if (!isLastTimelinePdm) continue;
                loadedKinds.add(activityKind);
                for (Timeline tl : this.allTimelines) {
                    EnumSet<CuptiActivityKind> requiredKinds = tl.getKind().getRequiredActivityKinds();
                    if (requiredKinds == null || !loadedKinds.containsAll(requiredKinds)) continue;
                    tl.processIntervalMins();
                }
            }
            long oaccStart = 0L;
            long oaccEnd = 0L;
            hIterator = pdm.getIteratorTypeMaskOrdered(1L << (CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_DATA.getCode() | CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH.getCode() | CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_OTHER.getCode()));
            OpenAccSummary summaryOpenAcc = null;
            block41: while (true) {
                if (Thread.currentThread().getName().equals("LoadPdm") && Thread.currentThread().isInterrupted()) {
                    pdm.deleteIterator(hIterator);
                    throw new ViperException("LoadPdmCancel");
                }
                ICuptiActivity activity = pdm.getNextActivity(hIterator);
                if (activity == null) break;
                switch (activity.getKind()) {
                    case CUPTI_ACTIVITY_KIND_OPENACC_DATA: 
                    case CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH: 
                    case CUPTI_ACTIVITY_KIND_OPENACC_OTHER: {
                        CuptiActivityOpenAcc openAcc = (CuptiActivityOpenAcc)activity;
                        summaryOpenAcc = session.getOpenAccSummary(openAcc.cuProcessId);
                        summaryOpenAcc.findAggregate(openAcc);
                        if (oaccStart == 0L) {
                            oaccStart = openAcc.start;
                        }
                        oaccEnd = openAcc.end;
                        continue block41;
                    }
                }
            }
            if (summaryOpenAcc != null) {
                summaryOpenAcc.finishCalculatingOpenAccExclusiveTime();
                summaryOpenAcc.setTotalTime(oaccEnd - oaccStart);
            }
            pdm.deleteIterator(hIterator);
            hIterator = pdm.getIteratorTypeMaskOrdered(1L << CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENMP.getCode());
            OpenMPSummary summaryOpenMP = null;
            long ompStart = 0L;
            long ompEnd = 0L;
            block42: while (true) {
                if (Thread.currentThread().getName().equals("LoadPdm") && Thread.currentThread().isInterrupted()) {
                    pdm.deleteIterator(hIterator);
                    throw new ViperException("LoadPdmCancel");
                }
                ICuptiActivity activity = pdm.getNextActivity(hIterator);
                if (activity == null) break;
                switch (activity.getKind()) {
                    case CUPTI_ACTIVITY_KIND_OPENMP: {
                        Iterator<Integer> omp = (CuptiActivityOpenMP)activity;
                        summaryOpenMP = session.getOpenMPSummary(((CuptiActivityOpenMP)((Object)omp)).cuProcessId);
                        summaryOpenMP.findAggregate((CuptiActivityOpenMP)((Object)omp));
                        if (ompStart == 0L) {
                            ompStart = ((CuptiActivityOpenMP)((Object)omp)).start;
                        }
                        ompEnd = ((CuptiActivityOpenMP)((Object)omp)).end;
                        summaryOpenMP.setTotalTime(ompEnd - ompStart);
                        continue block42;
                    }
                }
            }
            pdm.deleteIterator(hIterator);
            if (isTimelinePdm) {
                this.parsePThreadData(pdm, session, maxActivityId, 0L, Long.MAX_VALUE, false);
                for (int correlation : pdm.getUniqueIDs().keySet()) {
                    Set<UniqueActivityID> set = pdm.getUniqueIDs().get(correlation);
                    long id = (Long)correlationMap.get(correlation);
                    session.addAnalysisMapping(id, set);
                }
            }
            correlationMap.clear();
            for (DeviceTL device : this.devices.values()) {
                device.setMinimumCompletionTime();
            }
            int droppedMarkers = this.addMarkersAndRanges(markers, markerDatas, false);
            if (droppedMarkers > 0) {
                this.openWarning(ViperMessages.DroppedMarkers_Label, String.valueOf(droppedMarkers) + " " + ViperMessages.DroppedMarkers_Message);
            }
            for (Timeline tl : this.allTimelines) {
                if (!tl.getKind().equals((Object)TimelineKind.MARKER)) continue;
                tl.processIntervalMins();
            }
            if (invalidRecords > 0) {
                this.droppedRecords += invalidRecords;
            }
            if (isLastTimelinePdm && this.droppedRecords > 0) {
                this.openWarning(ViperMessages.DroppedRecords_Label, "The start and end timestamps on " + this.droppedRecords + " kernels, memcpys, and other collected profile data are invalid. Those profiling records have been dropped and will not be displayed in the timeline");
            }
            if (droppedNames > 0) {
                this.openWarning(ViperMessages.DroppedNames_Label, String.valueOf(droppedNames) + " " + ViperMessages.DroppedNames_Message);
            }
            for (CuptiActivityModule module : modules) {
                this.addModule(module, pdm);
            }
            for (CuptiActivityFunction function : functions) {
                this.addFunction(function, pdm);
            }
            for (CuptiActivityInstructionCorrelation instructionCorrelation : instructionCorrelations) {
                this.addInstructionCorrelation(instructionCorrelation, pdm);
            }
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
    }

    public void initializeRefresh(int width, long start, long end) {
        for (Timeline timeline : this.allTimelines) {
            timeline.initializeTimelineWindow(width, start, end);
        }
    }

    public void refreshTimelines(Session session, int width, long start, long end) throws ViperException, InterruptedException {
        this.gridIdIntervalMap.clear();
        this.correlationsMap.clear();
        for (ProfileDataModel pdm : this.timelinePdms) {
            long earliest = session.getSessionStartTime(pdm);
            this.refreshPdm(pdm, session, width, start + earliest, end + earliest);
        }
        this.createAPIAssociations();
        this.connectParentChildKernels();
        for (Timeline tl : this.allTimelines) {
            tl.addAdditionalIntervals();
        }
    }

    private void connectParentChildKernels() {
        for (ITimelineInterval interval : this.gridIdIntervalMap.values()) {
            ITimelineInterval parent;
            TimelineIntervalHierarchy hier;
            long parentGridId;
            if (!(interval instanceof TimelineIntervalHierarchy) || (parentGridId = (hier = (TimelineIntervalHierarchy)interval).getParentGridId()) == 0L || (parent = this.gridIdIntervalMap.get(parentGridId)) == null || !(parent instanceof TimelineIntervalHierarchy)) continue;
            ((TimelineIntervalHierarchy)parent).addChild(hier);
        }
    }

    public void finalizeRefresh() {
        Timeline[] timelines;
        Timeline[] timelineArray = timelines = this.allTimelines.toArray(new Timeline[this.allTimelines.size()]);
        int n = timelines.length;
        int n2 = 0;
        while (n2 < n) {
            Timeline timeline = timelineArray[n2];
            timeline.finalizeTimelineWindow();
            ++n2;
        }
    }

    public ProfileDataModel getOriginalPdm(long newId) {
        if (this.multiProcessManager != null) {
            return this.multiProcessManager.getOriginalPdm(newId);
        }
        return this.timelinePdms.get(0);
    }

    public long getOriginalId(long newId) {
        if (this.multiProcessManager != null) {
            return this.multiProcessManager.getOriginalId(newId);
        }
        return newId;
    }

    public ICuptiActivity getActivity(long id) {
        if (id == 0L) {
            return null;
        }
        ProfileDataModel pdm = this.timelinePdms.get(0);
        long activityId = id;
        if (this.multiProcessManager != null) {
            pdm = this.multiProcessManager.getOriginalPdm(id);
            activityId = this.multiProcessManager.getOriginalId(id);
        }
        ICuptiActivity activity = pdm.getActivity(activityId);
        if (this.multiProcessManager != null && activity != null) {
            this.multiProcessManager.processActivity(activity, pdm);
        }
        return activity;
    }

    public ProfileDataModel getPdm(long id) {
        if (id == 0L) {
            return null;
        }
        if (this.multiProcessManager != null) {
            return this.multiProcessManager.getOriginalPdm(id);
        }
        return null;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    private ITimelineInterval loadIntervalFromActivity(ICuptiActivity activity, Timeline primaryTimeline, boolean useCache) {
        ITimelineInterval result;
        ITimelineInterval iTimelineInterval = result = useCache ? this.session.getLoadedInterval(activity.getID()) : null;
        if (result == null) {
            result = TimelineIntervalFactory.buildInterval(activity, null, null);
            if (result == null) {
                return null;
            }
            if (primaryTimeline != null) {
                result.setPrimaryTimeline(primaryTimeline);
                if (useCache) {
                    this.session.setLoadedInterval(result);
                }
            }
        }
        return result;
    }

    public ITimelineInterval loadIntervalFromId(long id, long auxId, long endId, boolean useCache) {
        ICuptiActivity endActivity;
        ITimelineInterval result;
        ITimelineInterval iTimelineInterval = result = useCache ? this.session.getLoadedInterval(id) : null;
        if (result != null) {
            return result;
        }
        ICuptiActivity activity = this.getActivity(id);
        if (activity == null) {
            return null;
        }
        ICuptiActivity auxActivity = this.getActivity(auxId);
        result = TimelineIntervalFactory.buildInterval(activity, auxActivity, endActivity = this.getActivity(endId));
        if (result == null) {
            ViperExceptionHandler.logError("Can't create interval");
            return null;
        }
        Timeline primaryTimeline = null;
        ArrayList<Timeline> timelines = null;
        try {
            timelines = this.createAndReturnTimelines(activity, null);
        }
        catch (ViperException viperException) {
            ViperExceptionHandler.logError("Can't find timeline for the interval");
        }
        if (timelines != null && timelines.size() > 0) {
            primaryTimeline = (Timeline)timelines.get(0);
        }
        if (primaryTimeline != null) {
            result.setPrimaryTimeline(primaryTimeline);
            if (useCache) {
                this.session.setLoadedInterval(result);
            }
        }
        return result;
    }

    private boolean addIntervalToTimelines(ITimelineInterval interval, List<Timeline> timelines) throws ViperException {
        boolean added = false;
        for (Timeline timeline : timelines) {
            if (!timeline.addInterval(interval, false)) continue;
            added = true;
        }
        return added;
    }

    private void addCorrelation(int correlationId, ITimelineInterval interval) {
        if (this.correlationsMap.containsKey(correlationId)) {
            this.correlationsMap.get(correlationId).add(interval);
        } else {
            ArrayList<ITimelineInterval> intervals = new ArrayList<ITimelineInterval>();
            intervals.add(interval);
            this.correlationsMap.put(correlationId, intervals);
        }
    }

    private void refreshPdm(ProfileDataModel pdm, Session session, int width, long start, long end) throws ViperException, InterruptedException {
        long hIterator = 0L;
        try {
            Map kindMap;
            ICuptiActivity activity;
            long hPdm = pdm.getNativeHandle();
            int version = NativeCupti.cuptiPDMGetVersion(hPdm);
            if (this.pdmVersion == -1) {
                this.pdmVersion = version;
            } else if (version != this.pdmVersion) {
                throw new ViperException("pdm version mismatch");
            }
            HashMap externalCorrelations = new HashMap();
            hIterator = pdm.getIteratorTypeMask(1L << CuptiActivityKind.CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION.getCode());
            block19: while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    pdm.deleteIterator(hIterator);
                    throw new InterruptedException();
                }
                activity = pdm.getNextActivity(hIterator);
                if (activity == null) break;
                if (!activity.isValid()) continue;
                switch (activity.getKind()) {
                    case CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION: {
                        CuptiActivityExternalCorrelation extCorrelation = (CuptiActivityExternalCorrelation)activity;
                        CuptiExternalCorrelationKind externalKind = CuptiExternalCorrelationKind.valueOf(extCorrelation.externalKind);
                        if (!externalCorrelations.containsKey((Object)externalKind)) {
                            externalCorrelations.put(externalKind, new HashMap());
                        }
                        if (!(kindMap = (Map)externalCorrelations.get((Object)externalKind)).containsKey(extCorrelation.externalId)) {
                            kindMap.put(extCorrelation.externalId, new HashSet());
                        }
                        ((Set)kindMap.get(extCorrelation.externalId)).add(extCorrelation.correlationId);
                        continue block19;
                    }
                }
            }
            pdm.deleteIterator(hIterator);
            if (session.isEnableTimeRange() && start < this.sessionStart + session.getTimelineStart()) {
                start = this.sessionStart + session.getTimelineStart();
            }
            if (session.isEnableTimeRange() && end > this.sessionStart + session.getTimelineEnd()) {
                end = this.sessionStart + session.getTimelineEnd();
            }
            if (start > end) {
                return;
            }
            hIterator = pdm.getIteratorTimeRange(start, end);
            block20: while (true) {
                ArrayList<Timeline> timelines;
                if (Thread.currentThread().isInterrupted()) {
                    pdm.deleteIterator(hIterator);
                    throw new InterruptedException();
                }
                activity = pdm.getNextActivity(hIterator);
                if (activity == null) break;
                if (!activity.isValid()) continue;
                if (this.multiProcessManager != null) {
                    this.multiProcessManager.processActivity(activity, pdm);
                }
                Object interval = null;
                if (activity.getKind() != CuptiActivityKind.CUPTI_ACTIVITY_KIND_UVM_COUNTER && activity.getKind() != CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER && activity.getKind() != CuptiActivityKind.CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE && (interval = this.loadIntervalFromActivity(activity, (timelines = this.createAndReturnTimelines(activity, null)).size() > 0 ? (Timeline)timelines.get(0) : null, true)) != null) {
                    if (!this.addIntervalToTimelines((ITimelineInterval)interval, timelines)) {
                        interval = null;
                    }
                    if (interval instanceof TimelineIntervalKernel) {
                        CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                        DeviceTL device = this.getDevice(kernel.deviceId, null, null, false);
                        ContextTL context = device.getContext(kernel.contextId, null, null);
                        TimelineIntervalKernel intervalKernel = (TimelineIntervalKernel)interval;
                        context.setMinimumCompletionTime(intervalKernel);
                    }
                }
                switch (activity.getKind()) {
                    case CUPTI_ACTIVITY_KIND_RUNTIME: {
                        CuptiActivityAPI runtime = (CuptiActivityAPI)activity;
                        if (runtime.correlationId == 0 || interval == null) continue block20;
                        this.addCorrelation(runtime.correlationId, (TimelineIntervalAPI)interval);
                        continue block20;
                    }
                    case CUPTI_ACTIVITY_KIND_DRIVER: {
                        CuptiActivityAPI driver = (CuptiActivityAPI)activity;
                        if (driver.correlationId == 0 || interval == null) continue block20;
                        this.addCorrelation(driver.correlationId, (TimelineIntervalAPI)interval);
                        continue block20;
                    }
                    case CUPTI_ACTIVITY_KIND_KERNEL: 
                    case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: 
                    case CUPTI_ACTIVITY_KIND_CDP_KERNEL: {
                        CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                        if (kernel.correlationId != 0 && interval != null) {
                            this.addCorrelation(kernel.correlationId, (ITimelineInterval)interval);
                        }
                        if (interval != null && kernel.gridId != 0L) {
                            this.gridIdIntervalMap.put(kernel.gridId, (ITimelineInterval)interval);
                        }
                        if (this.pdmVersion >= 4 || kernel.runtimeCorrelationId == 0) continue block20;
                        this.addCorrelation(kernel.runtimeCorrelationId, (ITimelineInterval)interval);
                        continue block20;
                    }
                    case CUPTI_ACTIVITY_KIND_MEMSET: {
                        CuptiActivityMemset memset = (CuptiActivityMemset)activity;
                        if (memset.correlationId != 0 && interval != null) {
                            this.addCorrelation(memset.correlationId, (ITimelineInterval)interval);
                        }
                        if (this.pdmVersion >= 4 || memset.runtimeCorrelationId == 0) continue block20;
                        this.addCorrelation(memset.runtimeCorrelationId, (ITimelineInterval)interval);
                        continue block20;
                    }
                    case CUPTI_ACTIVITY_KIND_MEMCPY: {
                        CuptiActivityMemcpy memcpy = (CuptiActivityMemcpy)activity;
                        TimelineIntervalKind kind = this.getIntervalKindFromActivity(memcpy);
                        if (kind == TimelineIntervalKind.UNKNOWN) continue block20;
                        if (memcpy.correlationId != 0 && interval != null) {
                            this.addCorrelation(memcpy.correlationId, (ITimelineInterval)interval);
                        }
                        if (this.pdmVersion >= 4 || memcpy.runtimeCorrelationId == 0) continue block20;
                        this.addCorrelation(memcpy.runtimeCorrelationId, (ITimelineInterval)interval);
                        continue block20;
                    }
                    case CUPTI_ACTIVITY_KIND_MEMCPY2: {
                        CuptiActivityMemcpyP2p memcpy2 = (CuptiActivityMemcpyP2p)activity;
                        if (memcpy2.correlationId == 0 || interval == null) continue block20;
                        this.addCorrelation(memcpy2.correlationId, (ITimelineInterval)interval);
                        continue block20;
                    }
                    case CUPTI_ACTIVITY_KIND_OPENACC_DATA: 
                    case CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH: 
                    case CUPTI_ACTIVITY_KIND_OPENACC_OTHER: {
                        Set correlatedIds;
                        CuptiActivityOpenAcc openacc = (CuptiActivityOpenAcc)activity;
                        kindMap = (Map)externalCorrelations.get((Object)CuptiExternalCorrelationKind.CUPTI_EXTERNAL_CORRELATION_KIND_OPENACC);
                        if (kindMap != null && (correlatedIds = (Set)kindMap.get(new Long(openacc.externalId))) != null) {
                            openacc.correlations.addAll(correlatedIds);
                        }
                        if (openacc.correlations.isEmpty() || interval == null) continue block20;
                        Iterator<Integer> iterator = openacc.correlations.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block20;
                            int cId = iterator.next();
                            this.addCorrelation(cId, (TimelineIntervalOpenAcc)interval);
                        }
                    }
                }
            }
            pdm.deleteIterator(hIterator);
            if (!session.isUVMSegmentEnabled()) {
                for (DeviceTL d : this.devices.values()) {
                    d.uvm.addIntervalsToAllTLs(false);
                }
                for (ProcessTL p : this.processes.values()) {
                    p.uvm.addIntervalsToAllTLs(false);
                }
            }
            LinkedList<CuptiActivityMarker> markers = new LinkedList<CuptiActivityMarker>();
            HashMap<Integer, CuptiActivityMarkerData> markerDatas = new HashMap<Integer, CuptiActivityMarkerData>();
            hIterator = pdm.getIteratorTypeMask(1L << CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER.getCode() | 1L << CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER_DATA.getCode());
            block24: while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    pdm.deleteIterator(hIterator);
                    throw new InterruptedException();
                }
                ICuptiActivity activity2 = pdm.getNextActivity(hIterator);
                if (activity2 == null) break;
                if (!activity2.isValid()) continue;
                if (this.multiProcessManager != null) {
                    this.multiProcessManager.processActivity(activity2, pdm);
                }
                switch (activity2.getKind()) {
                    case CUPTI_ACTIVITY_KIND_MARKER: {
                        CuptiActivityMarker marker = (CuptiActivityMarker)activity2;
                        markers.add(marker);
                        continue block24;
                    }
                    case CUPTI_ACTIVITY_KIND_MARKER_DATA: {
                        CuptiActivityMarkerData data = (CuptiActivityMarkerData)activity2;
                        markerDatas.put(data.id, data);
                        continue block24;
                    }
                }
            }
            pdm.deleteIterator(hIterator);
            this.addMarkersAndRanges(markers, markerDatas, true);
            this.parsePThreadData(pdm, session, 0L, start, end, true);
        }
        catch (CuptiException ce) {
            throw new ViperException(ce);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
    }

    private void openWarning(final String label, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), label, message);
            }
        });
    }

    private ProcessTL getProcess(int pid) {
        ProcessTL proc = this.processes.get(pid);
        if (proc == null) {
            proc = new ProcessTL(pid);
            this.processes.put(pid, proc);
        }
        return proc;
    }

    private void addModule(CuptiActivityModule module, ProfileDataModel pdm) {
        this.session.getCudaFunctionManager().addModule(module);
        pdm.modules.put(module.id, module);
    }

    private void addFunction(CuptiActivityFunction function, ProfileDataModel pdm) {
        CuptiActivityModule module = pdm.modules.get(function.moduleId);
        if (module != null) {
            CuptiActivityModule newModule = this.session.getCudaFunctionManager().getModule(module.cubinSize, module.cubin);
            function.moduleId = newModule.id;
        } else {
            ViperExceptionHandler.logError("can't find the module for the function");
        }
        this.session.getCudaFunctionManager().addFunction(function);
        pdm.functions.put(function.id, function);
    }

    private void addSourceLocator(CuptiActivitySourceLocator source, ProfileDataModel pdm) {
        if (source.id != 0) {
            pdm.sourceLocators.put(source.id, source);
        }
    }

    private void addInstructionCorrelation(CuptiActivityInstructionCorrelation instCorrelation, ProfileDataModel pdm) {
        CuptiActivityFunction function = pdm.functions.get(instCorrelation.functionId);
        if (function != null) {
            int functionId = this.session.getMainFunctionId(function, pdm);
            int sourceId = this.session.getMainSourceLocatorId(instCorrelation.sourceLocatorId, pdm);
            instCorrelation.functionId = functionId;
            instCorrelation.sourceLocatorId = sourceId;
            this.session.getCudaFunctionManager().addInstructionCorrelation(functionId, instCorrelation);
        } else {
            ViperExceptionHandler.logError("Can't find function");
        }
    }

    private DeviceTL getDevice(int id, CuptiActivityDevice activity, String customName, boolean overWrite) {
        DeviceTL device = this.devices.get(id);
        if (device == null) {
            device = new DeviceTL(activity);
            this.devices.put(id, device);
        }
        if (activity != null) {
            device.activity = activity;
            device.tl.setActivity(activity);
            device.tl.setName(activity.name);
        }
        device.setCustomName(customName, overWrite);
        return device;
    }

    private ContextTL getContext(int id, CuptiActivityContext activity, String customName) {
        DeviceTL device = this.getDevice(activity.deviceId, null, null, false);
        return device.getContext(id, activity, customName);
    }

    private TimelineIntervalKind getIntervalKindFromActivity(CuptiActivityMemcpy activity) throws ViperException {
        switch (activity.getCopyKind()) {
            case CUPTI_ACTIVITY_MEMCPY_KIND_DTOH: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_ATOH: {
                return TimelineIntervalKind.MEMCPY_DTOH;
            }
            case CUPTI_ACTIVITY_MEMCPY_KIND_HTOD: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_HTOA: {
                return TimelineIntervalKind.MEMCPY_HTOD;
            }
            case CUPTI_ACTIVITY_MEMCPY_KIND_ATOA: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_ATOD: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_DTOA: 
            case CUPTI_ACTIVITY_MEMCPY_KIND_DTOD: {
                return TimelineIntervalKind.MEMCPY_DTOD;
            }
            case CUPTI_ACTIVITY_MEMCPY_KIND_HTOH: {
                return TimelineIntervalKind.UNKNOWN;
            }
        }
        throw new ViperException("unexpected memcpy copy kind " + (Object)((Object)activity.getCopyKind()));
    }

    private void addUVMCounter(CuptiActivityUvmCounter activity) {
        for (int deviceId : activity.getDeviceIDList()) {
            DeviceTL device = this.getDevice(deviceId, null, null, false);
            device.addUVMCounter(activity);
        }
        if (activity.isCpu()) {
            this.addUvmCounterToProcess(activity);
        }
    }

    private void addUvmCounterToProcess(CuptiActivityUvmCounter activity) {
        ProcessTL process = this.getProcess(activity.processId);
        process.addUVMCounter(activity);
    }

    private void addUvmCounterToManager(CuptiActivityUvmCounter activity) {
        UvmManager uvmManager = this.session.getUvmManager();
        uvmManager.addCounter(activity.getUvmCounterKind(), activity.address, activity.value);
    }

    private void addMemoryActivityToManager(CuptiActivityMemory activity) {
        UvmManager uvmManager = this.session.getUvmManager();
        uvmManager.addMemoryActivity(activity);
    }

    private boolean setName(CuptiActivityName name) {
        switch (name.getObjectKind()) {
            case CUPTI_ACTIVITY_OBJECT_PROCESS: {
                ProcessTL process = this.getProcess(name.objectProcessId);
                if (process == null) {
                    return false;
                }
                process.tl.setCustomName(name.name);
                return true;
            }
            case CUPTI_ACTIVITY_OBJECT_THREAD: {
                ProcessTL process = this.getProcess(name.objectProcessId);
                if (process == null) {
                    return false;
                }
                ThreadTL thread = process.getThread(name.objectProcessId, name.objectThreadId);
                if (thread == null) {
                    return false;
                }
                thread.tl.setCustomName(name.name);
                return true;
            }
            case CUPTI_ACTIVITY_OBJECT_DEVICE: {
                DeviceTL device = this.getDevice(name.objectDeviceId, null, name.name, true);
                return device != null;
            }
            case CUPTI_ACTIVITY_OBJECT_CONTEXT: {
                DeviceTL device = this.getDevice(name.objectDeviceId, null, null, false);
                if (device == null) {
                    return false;
                }
                ContextTL context = device.getContext(name.objectContextId, null, null);
                if (context == null) {
                    return false;
                }
                context.setCustomName(name.name, true);
                return true;
            }
            case CUPTI_ACTIVITY_OBJECT_STREAM: {
                DeviceTL device = this.getDevice(name.objectDeviceId, null, null, false);
                if (device == null) {
                    return false;
                }
                ContextTL context = device.getContext(name.objectContextId, null, null);
                if (context == null) {
                    return false;
                }
                TimelineStream stream = context.getTimelineForStream(name.objectDeviceId, name.objectContextId, name.objectStreamId, name.name, true);
                return stream != null;
            }
        }
        return false;
    }

    private int addMarkersAndRanges(List<CuptiActivityMarker> markers, Map<Integer, CuptiActivityMarkerData> markerDatas, boolean addInterval) throws ViperException {
        int droppedMarkers = 0;
        HashMap<Integer, CuptiActivityMarker> idMarkerMap = new HashMap<Integer, CuptiActivityMarker>();
        for (CuptiActivityMarker marker : markers) {
            CuptiActivityMarker end;
            CuptiActivityMarker start;
            CuptiActivityMarker other;
            if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS.isSet(marker.flags)) {
                if (this.addMarker(marker, markerDatas.get(marker.id), addInterval)) continue;
                ++droppedMarkers;
                continue;
            }
            if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_START.isSet(marker.flags) || CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_END.isSet(marker.flags)) {
                if (!idMarkerMap.containsKey(marker.id)) {
                    idMarkerMap.put(marker.id, marker);
                    continue;
                }
                other = (CuptiActivityMarker)idMarkerMap.get(marker.id);
                idMarkerMap.remove(marker.id);
                if (marker.flags == other.flags) {
                    ++droppedMarkers;
                    continue;
                }
                start = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_START.isSet(marker.flags) ? marker : other;
                CuptiActivityMarker cuptiActivityMarker = end = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_END.isSet(marker.flags) ? marker : other;
                if (this.addRange(start, end, markerDatas.get(start.id), addInterval)) continue;
                ++droppedMarkers;
                continue;
            }
            if (!idMarkerMap.containsKey(marker.id)) {
                idMarkerMap.put(marker.id, marker);
                continue;
            }
            other = (CuptiActivityMarker)idMarkerMap.get(marker.id);
            idMarkerMap.remove(marker.id);
            if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS.isSet(marker.flags)) {
                idMarkerMap.put(marker.id, marker);
            }
            if (CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS.isSet(other.flags)) {
                idMarkerMap.remove(marker.id);
            }
            if (marker.flags == other.flags) {
                ++droppedMarkers;
                continue;
            }
            start = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE.isSet(other.flags) || CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS.isSet(other.flags) ? other : marker;
            CuptiActivityMarker cuptiActivityMarker = end = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED.isSet(marker.flags) || CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS.isSet(marker.flags) || CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE.isSet(marker.flags) ? marker : other;
            if (this.addRange(start, end, markerDatas.get(start.id), addInterval)) continue;
            ++droppedMarkers;
        }
        return droppedMarkers += idMarkerMap.size();
    }

    private boolean addMarker(CuptiActivityMarker marker, CuptiActivityMarkerData markerData, boolean addInterval) throws ViperException {
        switch (marker.getObjectKind()) {
            case CUPTI_ACTIVITY_OBJECT_THREAD: {
                ProcessTL process = this.getProcess(marker.objectProcessId);
                if (process == null) {
                    return false;
                }
                ThreadTL thread = process.getThread(marker.objectProcessId, marker.objectThreadId);
                if (thread == null) {
                    return false;
                }
                Timeline tl = thread.getTimelineForIntervalKind(TimelineIntervalKind.MARKER, true);
                boolean flag = false;
                String d = marker.getDomainName();
                if (tl != null) {
                    if (!tl.getChildren().isEmpty()) {
                        for (Timeline child : tl.getChildren()) {
                            if (!child.getName().equals(d)) continue;
                            flag = true;
                            ITimelineInterval m = TimelineIntervalFactory.buildInterval(marker, markerData, null);
                            if (!addInterval) {
                                child.addIntervalMin(m.getID(), m.getStart(), m.getEnd(), m.getExtendedEnd(), m.getKind());
                                tl.addIntervalMin(m.getID(), m.getStart(), m.getEnd(), m.getExtendedEnd(), m.getKind());
                                if (markerData == null) break;
                                this.session.setAuxId(m.getID(), markerData.getID());
                                break;
                            }
                            m.setPrimaryTimeline(child);
                            child.addInterval(m, false);
                            tl.addInterval(m, false);
                            break;
                        }
                    }
                    if (!flag) {
                        Timeline child;
                        child = new Timeline(d, TimelineKind.MARKER);
                        tl.appendChild(child);
                        this.allTimelines.add(child);
                        ITimelineInterval m = TimelineIntervalFactory.buildInterval(marker, markerData, null);
                        if (!addInterval) {
                            child.addIntervalMin(m.getID(), m.getStart(), m.getEnd(), m.getExtendedEnd(), m.getKind());
                            tl.addIntervalMin(m.getID(), m.getStart(), m.getEnd(), m.getExtendedEnd(), m.getKind());
                            if (markerData != null) {
                                this.session.setAuxId(m.getID(), markerData.getID());
                            }
                        } else {
                            m.setPrimaryTimeline(child);
                            child.addInterval(m, false);
                            tl.addInterval(m, false);
                        }
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean addRange(CuptiActivityMarker start, CuptiActivityMarker end, CuptiActivityMarkerData markerData, boolean addInterval) throws ViperException {
        if (start != null && end != null) {
            switch (start.getObjectKind()) {
                case CUPTI_ACTIVITY_OBJECT_THREAD: {
                    ProcessTL process = this.getProcess(start.objectProcessId);
                    if (process == null) {
                        return false;
                    }
                    ThreadTL thread = process.getThread(start.objectProcessId, start.objectThreadId);
                    if (thread == null) {
                        return false;
                    }
                    Timeline tl = thread.getTimelineForIntervalKind(TimelineIntervalKind.RANGE, true);
                    boolean flag = false;
                    String d = start.getDomainName();
                    if (tl != null) {
                        if (!tl.getChildren().isEmpty()) {
                            for (Timeline child : tl.getChildren()) {
                                if (!child.getName().equals(d)) continue;
                                flag = true;
                                ITimelineInterval m = TimelineIntervalFactory.buildInterval(start, markerData, end);
                                if (!addInterval) {
                                    child.addIntervalMin(m.getID(), m.getStart(), m.getEnd(), m.getExtendedEnd(), m.getKind());
                                    tl.addIntervalMin(m.getID(), m.getStart(), m.getEnd(), m.getExtendedEnd(), m.getKind());
                                    if (markerData != null) {
                                        this.session.setAuxId(m.getID(), markerData.getID());
                                    }
                                    this.session.setEndId(m.getID(), end.getID());
                                    break;
                                }
                                m.setPrimaryTimeline(child);
                                child.addInterval(m, false);
                                tl.addInterval(m, false);
                                break;
                            }
                        }
                        if (!flag) {
                            Timeline child;
                            child = new Timeline(d, TimelineKind.MARKER);
                            tl.appendChild(child);
                            this.allTimelines.add(child);
                            ITimelineInterval m = TimelineIntervalFactory.buildInterval(start, markerData, end);
                            if (!addInterval) {
                                child.addIntervalMin(m.getID(), m.getStart(), m.getEnd(), m.getExtendedEnd(), m.getKind());
                                tl.addIntervalMin(m.getID(), m.getStart(), m.getEnd(), m.getExtendedEnd(), m.getKind());
                                if (markerData != null) {
                                    this.session.setAuxId(m.getID(), markerData.getID());
                                }
                                this.session.setEndId(m.getID(), end.getID());
                            } else {
                                m.setPrimaryTimeline(child);
                                child.addInterval(m, false);
                                tl.addInterval(m, false);
                            }
                        }
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public boolean createTimelines(Session session) {
        for (ProcessTL process : this.processes.values()) {
            if (process.createTimelines(session)) continue;
            return false;
        }
        for (DeviceTL device : this.devices.values()) {
            if (device.createTimelines(session)) continue;
            return false;
        }
        return true;
    }

    private void createAPIAssociations() {
        IntervalComparator comparator = new IntervalComparator();
        for (int corrId : this.correlationsMap.keySet()) {
            List<ITimelineInterval> intervals = this.correlationsMap.get(corrId);
            Collections.sort(intervals, comparator);
            TimelineIntervalHierarchy lastInterval = null;
            for (ITimelineInterval interval : intervals) {
                TimelineIntervalAPI apiInterval;
                if (!(interval instanceof TimelineIntervalHierarchy)) continue;
                TimelineIntervalHierarchy hier = (TimelineIntervalHierarchy)interval;
                if (lastInterval != null) {
                    lastInterval.addChild(hier);
                }
                if (hier instanceof TimelineIntervalAPI && (apiInterval = (TimelineIntervalAPI)hier).getKind() == TimelineIntervalKind.RUNTIME) {
                    apiInterval.setCorrelationId(corrId);
                }
                lastInterval = hier;
            }
        }
    }

    private TimelineDevice getSessionDevice(Session session, int id, String customName) {
        List<Timeline> sessionDevices = session.getTimelines(TimelineKind.DEVICE);
        for (Timeline timeline : sessionDevices) {
            if (!(customName != null ? customName.equals(timeline.getCustomName()) : ((TimelineDevice)timeline).getId() == id)) continue;
            return (TimelineDevice)timeline;
        }
        return null;
    }

    private TimelineContext getSessionContext(Session session, TimelineDevice deviceTimeline, int id, String customName) {
        List<Timeline> sessionContexts = deviceTimeline.getDescendants(TimelineKind.CONTEXT);
        for (Timeline timeline : sessionContexts) {
            if (!(customName != null ? customName.equals(timeline.getCustomName()) : ((TimelineContext)timeline).getId() == id)) continue;
            return (TimelineContext)timeline;
        }
        return null;
    }

    private Timeline getSessionStream(Session session, TimelineContext sessionContext, ContextTL context, Timeline stream) {
        List<Timeline> sessionStreams = sessionContext.getDescendants(TimelineKind.STREAM);
        if (stream.getCustomName() != null) {
            String name = stream.getCustomName();
            for (Timeline timeline : sessionStreams) {
                if (timeline.getCustomName() == null || !timeline.getCustomName().equals(name)) continue;
                return timeline;
            }
        } else {
            StreamOrderComparator streamOrderComparator = new StreamOrderComparator();
            Timeline[] orderedSessionStreams = sessionStreams.toArray(new Timeline[0]);
            Arrays.sort(orderedSessionStreams, streamOrderComparator);
            Timeline[] orderedStreams = context.streamMap.values().toArray(new Timeline[0]);
            Arrays.sort(orderedStreams, streamOrderComparator);
            int i = 0;
            while (i < orderedStreams.length) {
                if (orderedStreams[i] == stream) {
                    return orderedSessionStreams[i];
                }
                ++i;
            }
        }
        return null;
    }

    public boolean merge(Session session, SessionFilter scope, boolean mergeEvents, boolean mergeMetrics, boolean mergeSourceLevelResults, ProfileDataModel pdm) {
        this.mergedPdms.add(pdm);
        if (scope == null) {
            return this.mergeTimelines(session, mergeEvents, mergeMetrics, mergeSourceLevelResults, pdm);
        }
        if (scope.isSingleKernelInstance()) {
            return this.mergeSingleKernel(session, scope, mergeEvents, mergeMetrics, mergeSourceLevelResults, pdm);
        }
        if (scope.isMultipleKernelsInstance()) {
            return this.mergeMultipleKernels(session, scope, mergeEvents, mergeMetrics, mergeSourceLevelResults, pdm);
        }
        return false;
    }

    private boolean mergeMultipleKernels(Session session, SessionFilter scope, boolean mergeEvents, boolean mergeMetrics, boolean mergeSourceLevelResults, ProfileDataModel pdm) {
        boolean completeMerge = true;
        HashMap<Timeline, List<Timeline>> contextStreamMap = new HashMap<Timeline, List<Timeline>>();
        for (DeviceTL device : this.devices.values()) {
            for (ContextTL context : device.contexts.values()) {
                ArrayList streamList = new ArrayList(context.streamMap.values());
                contextStreamMap.put(context.tl, streamList);
            }
        }
        for (DeviceTL device : this.devices.values()) {
            if (device.activity == null) continue;
            boolean hasContent = false;
            for (ContextTL context : device.contexts.values()) {
                if (context.isEmpty()) continue;
                hasContent = true;
                break;
            }
            if (!hasContent) continue;
            TimelineDevice sessionDevice = this.getSessionDevice(session, ((DeviceTL)device).activity.id, device.customName);
            if (sessionDevice == null) {
                completeMerge = false;
                continue;
            }
            for (ContextTL context : device.contexts.values()) {
                if (context.isEmpty()) continue;
                TimelineContext sessionContext = this.getSessionContext(session, sessionDevice, ((ContextTL)context).activity.contextId, context.customName);
                if (sessionContext == null) {
                    List<Timeline> sessionContexts = sessionDevice.getDescendants(TimelineKind.CONTEXT);
                    if (device.contexts.values().size() == 1 && sessionContexts.size() == 1) {
                        sessionContext = (TimelineContext)sessionContexts.get(0);
                    } else {
                        completeMerge = false;
                        continue;
                    }
                }
                for (Timeline stream : context.streamMap.values()) {
                    stream.processIntervalMins();
                }
                block6: for (Timeline stream : context.streamMap.values()) {
                    Timeline sessionStream = this.getSessionStream(session, sessionContext, context, stream);
                    if (sessionStream == null) {
                        completeMerge = false;
                        continue;
                    }
                    List<TimelineIntervalKernel> sessionKernels = scope.getMultipleKernelsInstance(session, sessionStream);
                    if (sessionKernels == null || sessionKernels.isEmpty()) {
                        completeMerge = false;
                        continue;
                    }
                    List<CuptiActivityKernel> kernelActivities = scope.getMultipleKernelActivities(pdm, contextStreamMap, stream);
                    int currentSessionIntervalIndex = 0;
                    for (CuptiActivityKernel activity : kernelActivities) {
                        TimelineIntervalKernel sessionKernelInterval = null;
                        if (currentSessionIntervalIndex < sessionKernels.size()) {
                            sessionKernelInterval = sessionKernels.get(currentSessionIntervalIndex);
                        }
                        if (activity == null || sessionKernelInterval == null) continue block6;
                        if (!activity.name.equals(sessionKernelInterval.getName())) {
                            completeMerge = false;
                            ++currentSessionIntervalIndex;
                            continue;
                        }
                        ITimelineInterval kernelInterval = this.loadIntervalFromId(activity.getID(), 0L, 0L, false);
                        Set<UniqueActivityID> set = pdm.getUniqueIDs().get(kernelInterval.getPrimaryCorrelationId());
                        if (set == null || set.isEmpty()) {
                            set = new HashSet<UniqueActivityID>();
                            set.add(new UniqueActivityID(pdm, 0L));
                        }
                        session.addAnalysisMapping(sessionKernelInterval.getID(), set);
                        session.loadInterval(sessionKernelInterval.getID(), true);
                        ++currentSessionIntervalIndex;
                    }
                }
            }
        }
        return completeMerge;
    }

    private boolean mergeSingleKernel(Session session, SessionFilter scope, boolean mergeEvents, boolean mergeMetrics, boolean mergeSourceLevelResults, ProfileDataModel pdm) {
        DeviceTL device;
        Timeline sessionKernelTimeline;
        Timeline sessionDeviceTimeline;
        boolean completeMerge = false;
        TimelineIntervalKernel sessionKernel = scope.getSingleKernelInstance(session);
        if (sessionKernel != null && (sessionDeviceTimeline = (sessionKernelTimeline = sessionKernel.getPrimaryTimeline()).getAncestor(TimelineKind.DEVICE)) != null && (device = this.devices.get(scope.getDeviceId())) != null) {
            List<Timeline> sessionContexts;
            ContextTL context = null;
            if (scope.getContextName() != null) {
                for (ContextTL ctx : device.contexts.values()) {
                    if (!scope.getContextName().equals(ctx.customName)) continue;
                    context = ctx;
                    break;
                }
            } else {
                context = (ContextTL)device.contexts.get(scope.getContextId());
            }
            if (context == null && device.contexts.size() == 1 && (sessionContexts = sessionDeviceTimeline.getDescendants(TimelineKind.CONTEXT)).size() == 1) {
                context = (ContextTL)device.contexts.get(0);
            }
            if (context != null) {
                TimelineStream stream = null;
                if (scope.getStreamName() != null) {
                    for (Timeline strm : context.streamMap.values()) {
                        if (!scope.getStreamName().equals(strm.getCustomName())) continue;
                        stream = (TimelineStream)strm;
                        break;
                    }
                } else {
                    stream = (TimelineStream)context.streamMap.get(scope.getStreamId());
                }
                if (stream != null) {
                    stream.processIntervalMins();
                    long kernel = this.getScopeKernel(scope, stream);
                    if (kernel > 0L) {
                        completeMerge = true;
                        ITimelineInterval kernelInterval = this.loadIntervalFromId(kernel, 0L, 0L, false);
                        Set<UniqueActivityID> set = pdm.getUniqueIDs().get(kernelInterval.getPrimaryCorrelationId());
                        if (set == null || set.isEmpty()) {
                            set = new HashSet<UniqueActivityID>();
                            set.add(new UniqueActivityID(pdm, 0L));
                        }
                        session.addAnalysisMapping(sessionKernel.getID(), set);
                        session.loadInterval(sessionKernel.getID(), true);
                    }
                }
            }
        }
        return completeMerge;
    }

    private long getScopeKernel(SessionFilter scope, TimelineStream stream) {
        if (stream != null) {
            if (this.eventDataState == EventDataState.EVENT_DATA_SINGLE && this.eventDataActivityId != 0L) {
                return this.eventDataActivityId;
            }
            if (this.kernelDataActivityId != 0L) {
                return this.kernelDataActivityId;
            }
        }
        return 0L;
    }

    private boolean mergeTimelines(Session session, boolean mergeEvents, boolean mergeMetrics, boolean mergeSourceLevelResults, ProfileDataModel pdm) {
        boolean completeMerge = true;
        for (DeviceTL device : this.devices.values()) {
            if (device.activity == null) continue;
            boolean hasContent = false;
            for (ContextTL context : device.contexts.values()) {
                if (context.isEmpty()) continue;
                hasContent = true;
                break;
            }
            if (!hasContent) continue;
            TimelineDevice sessionDevice = this.getSessionDevice(session, ((DeviceTL)device).activity.id, device.customName);
            if (sessionDevice == null) {
                completeMerge = false;
                continue;
            }
            for (ContextTL context : device.contexts.values()) {
                if (context.isEmpty()) continue;
                TimelineContext sessionContext = this.getSessionContext(session, sessionDevice, ((ContextTL)context).activity.contextId, context.customName);
                if (sessionContext == null) {
                    List<Timeline> sessionContexts = sessionDevice.getDescendants(TimelineKind.CONTEXT);
                    if (device.contexts.values().size() == 1 && sessionContexts.size() == 1) {
                        sessionContext = (TimelineContext)sessionContexts.get(0);
                    } else {
                        completeMerge = false;
                        continue;
                    }
                }
                for (Timeline stream : context.streamMap.values()) {
                    stream.processIntervalMins();
                }
                block4: for (Timeline stream : context.streamMap.values()) {
                    Timeline sessionStream = this.getSessionStream(session, sessionContext, context, stream);
                    if (sessionStream == null) {
                        completeMerge = false;
                        continue;
                    }
                    int currentIntervalIndex = 0;
                    int currentSessionIntervalIndex = 0;
                    while (true) {
                        ICuptiActivity activity = null;
                        ICuptiActivity sessionActivity = null;
                        while (currentIntervalIndex < stream.getIntervalIds().length) {
                            activity = this.getActivity(stream.getIntervalIds()[currentIntervalIndex]);
                            if (activity instanceof CuptiActivityKernel) break;
                            activity = null;
                            ++currentIntervalIndex;
                        }
                        while (currentSessionIntervalIndex < sessionStream.getIntervalIds().length) {
                            sessionActivity = session.getActivity(sessionStream.getIntervalIds()[currentSessionIntervalIndex]);
                            if (sessionActivity instanceof CuptiActivityKernel) break;
                            sessionActivity = null;
                            ++currentSessionIntervalIndex;
                        }
                        if (activity == null || sessionActivity == null) continue block4;
                        if (!((CuptiActivityKernel)activity).name.equals(((CuptiActivityKernel)sessionActivity).name)) {
                            completeMerge = false;
                            ++currentSessionIntervalIndex;
                            continue;
                        }
                        ITimelineInterval kernelInterval = this.loadIntervalFromId(stream.getIntervalIds()[currentIntervalIndex], 0L, 0L, false);
                        Set<UniqueActivityID> set = pdm.getUniqueIDs().get(kernelInterval.getPrimaryCorrelationId());
                        if (set == null || set.isEmpty()) {
                            set = new HashSet<UniqueActivityID>();
                            set.add(new UniqueActivityID(pdm, 0L));
                        }
                        session.addAnalysisMapping(sessionStream.getIntervalIds()[currentSessionIntervalIndex], set);
                        session.loadInterval(sessionStream.getIntervalIds()[currentSessionIntervalIndex], true);
                        ++currentIntervalIndex;
                        ++currentSessionIntervalIndex;
                    }
                }
            }
        }
        return completeMerge;
    }

    public boolean addNvlinkTimelines(Session session, TimelineFactory analysisTimelineFactory) {
        long earliestTimeDiff = analysisTimelineFactory.sessionStart - this.sessionStart;
        boolean hasNvlink = false;
        for (Map.Entry<Integer, DeviceTL> analysisDeviceEntry : analysisTimelineFactory.devices.entrySet()) {
            DeviceTL analysisDevice = analysisDeviceEntry.getValue();
            if (analysisDevice.nvlink.isEmpty()) continue;
            DeviceTL deviceFactory = this.getDevice(analysisDeviceEntry.getKey(), analysisDevice.activity, analysisDevice.customName, false);
            deviceFactory.nvlink.copyValues(analysisDevice.nvlink, earliestTimeDiff);
            deviceFactory.nvlink.createTimelines(session, deviceFactory.tl);
            if (this.getSessionDevice(session, ((DeviceTL)analysisDevice).activity.id, analysisDevice.customName) == null && !deviceFactory.tl.getChildren().isEmpty()) {
                session.addTopLevelTimeline(deviceFactory.tl, true);
            }
            hasNvlink = true;
        }
        return hasNvlink;
    }

    public void dispose() {
        for (ProfileDataModel pdm : this.timelinePdms) {
            pdm.dispose();
        }
        for (ProfileDataModel pdm : this.mergedPdms) {
            pdm.dispose();
        }
    }

    private class ContextTL {
        private CuptiActivityContext activity;
        private String customName;
        private TimelineContext tl;
        private final Map<TimelineKind, Timeline> timelineKindMap;
        private final Map<Integer, Timeline> streamMap;
        private final List<ITimelineInterval> kernelIntervals;
        private final Map<NodeIdentifier, TreeNode> allNodesMap = new HashMap<NodeIdentifier, TreeNode>();
        private final Map<Long, TreeNode> nonRootMap = new HashMap<Long, TreeNode>();
        private final Map<Long, Timeline> timelineMap = new HashMap<Long, Timeline>();
        private final Map<Integer, TimelineKernel> memsetTimelineMap = new HashMap<Integer, TimelineKernel>();
        private final Map<Long, Long> completionTime = new HashMap<Long, Long>();
        private Timeline defaultKernelTimeline = null;

        public ContextTL(CuptiActivityContext activity) {
            this.activity = activity;
            this.timelineKindMap = new HashMap<TimelineKind, Timeline>();
            this.kernelIntervals = new ArrayList<ITimelineInterval>();
            this.streamMap = new HashMap<Integer, Timeline>();
            this.tl = new TimelineContext(null);
            TimelineFactory.this.allTimelines.add(this.tl);
        }

        public void setCustomName(String customName, boolean overwrite) {
            if (customName != null && (overwrite || this.customName == null)) {
                this.customName = customName;
                this.tl.setCustomName(customName);
            }
        }

        public boolean isEmpty() {
            return this.timelineKindMap.isEmpty() && this.kernelIntervals.isEmpty() && this.streamMap.isEmpty();
        }

        protected TimelineStream getTimelineForStream(int deviceId, int contextId, int streamId, String customName, boolean create) {
            if (TimelineFactory.this.session.isTimelineDisabled(TimelineKind.STREAMS)) {
                return null;
            }
            Timeline tl = this.streamMap.get(streamId);
            if (create && tl == null) {
                tl = new TimelineStream(deviceId, contextId, streamId);
                this.streamMap.put(streamId, tl);
                TimelineFactory.this.allTimelines.add(tl);
            }
            if (customName != null && tl != null) {
                tl.setCustomName(customName);
            }
            return (TimelineStream)tl;
        }

        protected Timeline getTimelineForKind(TimelineKind kind, boolean create) {
            Timeline tl = this.timelineKindMap.get((Object)kind);
            if (create && tl == null) {
                if (TimelineKind.MEMCPY_DTOH.equals((Object)kind) || TimelineKind.MEMCPY_HTOD.equals((Object)kind) || TimelineKind.MEMCPY_DTOD.equals((Object)kind) || TimelineKind.MEMCPY_PTOP.equals((Object)kind)) {
                    tl = new TimelineMemcpy(this.getTimelineNameForKind(kind), kind);
                } else {
                    if (TimelineKind.STREAMS.equals((Object)kind) && TimelineFactory.this.session.isTimelineDisabled(TimelineKind.STREAMS)) {
                        return null;
                    }
                    tl = new Timeline(this.getTimelineNameForKind(kind), kind);
                }
                this.timelineKindMap.put(kind, tl);
                TimelineFactory.this.allTimelines.add(tl);
            }
            return tl;
        }

        protected String getTimelineNameForKind(TimelineKind kind) {
            if (TimelineKind.STREAMS.equals((Object)kind)) {
                return "Streams";
            }
            if (TimelineKind.KERNELS.equals((Object)kind)) {
                return "Compute";
            }
            if (TimelineKind.MEMCPY_DTOH.equals((Object)kind)) {
                return "MemCpy (DtoH)";
            }
            if (TimelineKind.MEMCPY_HTOD.equals((Object)kind)) {
                return "MemCpy (HtoD)";
            }
            if (TimelineKind.MEMCPY_DTOD.equals((Object)kind)) {
                return "MemCpy (DtoD)";
            }
            if (TimelineKind.MEMCPY_PTOP.equals((Object)kind)) {
                return "MemCpy (PtoP)";
            }
            if (TimelineKind.OPENACC.equals((Object)kind)) {
                return "OpenACC";
            }
            if (TimelineKind.PTHREAD.equals((Object)kind)) {
                return "PThread";
            }
            return "<unknown>";
        }

        public List<Timeline> getTimelinesForInterval(TimelineIntervalKind kind, int deviceId, int contextId, int streamId, String streamCustomName, boolean hasParent) throws ViperException {
            LinkedList<Timeline> timelines = new LinkedList<Timeline>();
            switch (kind) {
                case MEMSET: 
                case KERNEL: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.KERNELS, true);
                    timelines.add(tl);
                    break;
                }
                case MEMCPY_DTOH: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.MEMCPY_DTOH, true);
                    timelines.add(tl);
                    break;
                }
                case MEMCPY_HTOD: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.MEMCPY_HTOD, true);
                    timelines.add(tl);
                    break;
                }
                case MEMCPY_DTOD: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.MEMCPY_DTOD, true);
                    timelines.add(tl);
                    break;
                }
                case MEMCPY_PTOP: {
                    Timeline tl = this.getTimelineForKind(TimelineKind.MEMCPY_PTOP, true);
                    timelines.add(tl);
                    break;
                }
                default: {
                    throw new ViperException("Invalid interval kind for context timeline");
                }
            }
            if (streamId > -1 && !hasParent) {
                this.getTimelineForKind(TimelineKind.STREAMS, true);
                TimelineStream stl = this.getTimelineForStream(deviceId, contextId, streamId, streamCustomName, true);
                if (stl != null) {
                    timelines.add(stl);
                }
            }
            return timelines;
        }

        private void addKernelNode(long correlationId, long gridId, long parentGridId, long activityId, long start, long end, String name) {
            NodeIdentifier key = new NodeIdentifier(correlationId, gridId == 0L ? activityId : gridId);
            TreeNode node = this.allNodesMap.get(key);
            if (node == null) {
                node = new TreeNode(activityId, start, end, name);
                this.allNodesMap.put(key, node);
            } else {
                node.activityId = activityId;
                node.start = start;
                node.end = end;
                node.name = name;
            }
            if (parentGridId != 0L) {
                this.nonRootMap.put(key.gridId, node);
                TreeNode parent = null;
                for (NodeIdentifier nodeIdentifier : this.allNodesMap.keySet()) {
                    if (nodeIdentifier.gridId != parentGridId) continue;
                    parent = this.allNodesMap.get(nodeIdentifier);
                }
                if (parent == null) {
                    parent = new TreeNode(0L, 0L, 0L, null);
                    this.allNodesMap.put(new NodeIdentifier(correlationId, parentGridId), parent);
                }
                parent.children.add(node);
            }
        }

        protected boolean createTimelines(Session session, Timeline parent) {
            if (this.activity == null) {
                return true;
            }
            if (CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN.equals((Object)this.activity.getComputeKind())) {
                return false;
            }
            if (!this.isEmpty()) {
                Timeline comp;
                Timeline ptop;
                Timeline dtod;
                Timeline dtoh;
                parent.appendChild(this.tl);
                Timeline htod = this.getTimelineForKind(TimelineKind.MEMCPY_HTOD, false);
                if (htod != null) {
                    this.tl.appendChild(htod);
                }
                if ((dtoh = this.getTimelineForKind(TimelineKind.MEMCPY_DTOH, false)) != null) {
                    this.tl.appendChild(dtoh);
                }
                if ((dtod = this.getTimelineForKind(TimelineKind.MEMCPY_DTOD, false)) != null) {
                    this.tl.appendChild(dtod);
                }
                if ((ptop = this.getTimelineForKind(TimelineKind.MEMCPY_PTOP, false)) != null) {
                    this.tl.appendChild(ptop);
                }
                if ((comp = this.getTimelineForKind(TimelineKind.KERNELS, false)) != null) {
                    this.tl.appendChild(comp);
                }
                HashSet<TimelineKernel> rootTimelines = new HashSet<TimelineKernel>();
                Map<TimelineKernel, Map<String, TimelineKernel>> timelineTree = this.createTimelineTree(rootTimelines);
                TimelineKernel[] hostLaunchedKernels = new TimelineKernel[rootTimelines.size()];
                int kcnt = 0;
                for (TimelineKernel kernel : rootTimelines) {
                    hostLaunchedKernels[kcnt++] = kernel;
                    this.addChildTimelines(session, kernel, timelineTree);
                    kernel.setContainerState(ContainerState.CLOSED);
                }
                Arrays.sort(hostLaunchedKernels, new TimelineKernel.TotalExecutionTimeComparator());
                TimelineKernel[] timelineKernelArray = hostLaunchedKernels;
                int n = hostLaunchedKernels.length;
                int n2 = 0;
                while (n2 < n) {
                    TimelineKernel kernel;
                    kernel = timelineKernelArray[n2];
                    comp.appendChild(kernel);
                    ++n2;
                }
                TimelineKernel[] memsets = new TimelineKernel[this.memsetTimelineMap.size()];
                kcnt = 0;
                for (TimelineKernel memset : this.memsetTimelineMap.values()) {
                    memsets[kcnt++] = memset;
                }
                Arrays.sort(memsets, new TimelineKernel.TotalExecutionTimeComparator());
                TimelineKernel[] timelineKernelArray2 = memsets;
                int n3 = memsets.length;
                int n4 = 0;
                while (n4 < n3) {
                    TimelineKernel memset = timelineKernelArray2[n4];
                    comp.appendChild(memset);
                    ++n4;
                }
                Timeline streams = this.getTimelineForKind(TimelineKind.STREAMS, false);
                if (streams != null) {
                    this.tl.appendChild(streams);
                }
                Object[] streamIds = this.streamMap.keySet().toArray(new Integer[0]);
                Arrays.sort(streamIds);
                Object[] objectArray = streamIds;
                int n5 = streamIds.length;
                int n6 = 0;
                while (n6 < n5) {
                    Object streamId = objectArray[n6];
                    Timeline stream = this.streamMap.get(streamId);
                    if (stream != null) {
                        streams.appendChild(stream);
                    }
                    ++n6;
                }
            }
            return true;
        }

        private void addChildTimelines(Session session, TimelineKernel parent, Map<TimelineKernel, Map<String, TimelineKernel>> timelineTree) {
            Map<String, TimelineKernel> childTimelineNameMap = timelineTree.get(parent);
            if (childTimelineNameMap != null) {
                TimelineKernel[] childArray = new TimelineKernel[childTimelineNameMap.size()];
                int ccnt = 0;
                for (TimelineKernel child : childTimelineNameMap.values()) {
                    childArray[ccnt++] = child;
                    this.addChildTimelines(session, child, timelineTree);
                    child.setContainerState(ContainerState.CLOSED);
                }
                Arrays.sort(childArray, new TimelineKernel.TotalExecutionTimeComparator());
                TimelineKernel[] timelineKernelArray = childArray;
                int n = childArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TimelineKernel child;
                    child = timelineKernelArray[n2];
                    parent.appendChild(child);
                    ++n2;
                }
            }
        }

        private long setMinimumCompletionTime(TreeNode node) {
            long extendedEndTime = 0L;
            for (TreeNode child : node.children) {
                long childEndTime = this.setMinimumCompletionTime(child);
                if (extendedEndTime != 0L && extendedEndTime >= childEndTime) continue;
                extendedEndTime = childEndTime;
            }
            if (extendedEndTime == 0L) {
                extendedEndTime = node.end;
            } else {
                extendedEndTime = Math.max(extendedEndTime, node.end);
                this.completionTime.put(node.activityId, extendedEndTime);
            }
            return extendedEndTime;
        }

        public void setMinimumCompletionTime() {
            for (NodeIdentifier nodeIdentifier : this.allNodesMap.keySet()) {
                if (this.nonRootMap.containsKey(nodeIdentifier.gridId)) continue;
                TreeNode node = this.allNodesMap.get(nodeIdentifier);
                this.setMinimumCompletionTime(node);
            }
        }

        public void setMinimumCompletionTime(TimelineIntervalKernel interval) {
            Long extendedEnd = this.completionTime.get(interval.getID());
            if (extendedEnd != null) {
                interval.setMinimumCompletion(extendedEnd);
            }
        }

        private Map<TimelineKernel, Map<String, TimelineKernel>> createTimelineTree(Set<TimelineKernel> rootTimelines) {
            HashMap<String, TimelineKernel> rootNameMap = new HashMap<String, TimelineKernel>();
            HashMap<TimelineKernel, Map<String, TimelineKernel>> timelineTree = new HashMap<TimelineKernel, Map<String, TimelineKernel>>();
            for (NodeIdentifier nodeIdentifier : this.allNodesMap.keySet()) {
                if (this.nonRootMap.containsKey(nodeIdentifier.gridId)) continue;
                TreeNode node = this.allNodesMap.get(nodeIdentifier);
                TimelineKernel rootTimeline = (TimelineKernel)rootNameMap.get(node.name);
                if (rootTimeline == null) {
                    rootTimeline = new TimelineKernel(node.name);
                    TimelineFactory.this.allTimelines.add(rootTimeline);
                    rootNameMap.put(node.name, rootTimeline);
                    if (this.defaultKernelTimeline == null) {
                        this.defaultKernelTimeline = rootTimeline;
                    }
                }
                if (rootTimeline != this.defaultKernelTimeline) {
                    this.timelineMap.put(node.activityId, rootTimeline);
                }
                Long completionTime = this.completionTime.get(node.activityId);
                rootTimeline.addIntervalMin(node.activityId, node.start, node.end, completionTime == null ? node.end : completionTime, TimelineIntervalKind.KERNEL);
                if (node.children.isEmpty()) continue;
                this.createChildTimelines(node, rootTimeline, timelineTree);
            }
            this.allNodesMap.clear();
            this.nonRootMap.clear();
            rootTimelines.clear();
            rootTimelines.addAll(rootNameMap.values());
            return timelineTree;
        }

        private void createChildTimelines(TreeNode parent, TimelineKernel parentTimeline, Map<TimelineKernel, Map<String, TimelineKernel>> timelineTree) {
            List<TreeNode> children = parent.children;
            if (children == null || children.isEmpty()) {
                return;
            }
            Map<String, TimelineKernel> childTimelineNameMap = timelineTree.get(parentTimeline);
            if (childTimelineNameMap == null) {
                childTimelineNameMap = new HashMap<String, TimelineKernel>();
                timelineTree.put(parentTimeline, childTimelineNameMap);
            }
            for (TreeNode child : children) {
                TimelineKernel childTimeline = childTimelineNameMap.get(child.name);
                if (childTimeline == null) {
                    childTimeline = new TimelineKernel(child.name);
                    TimelineFactory.this.allTimelines.add(childTimeline);
                    parentTimeline.appendChild(childTimeline);
                    childTimelineNameMap.put(child.name, childTimeline);
                    if (this.defaultKernelTimeline == null) {
                        this.defaultKernelTimeline = childTimeline;
                    }
                }
                if (childTimeline != this.defaultKernelTimeline) {
                    this.timelineMap.put(child.activityId, childTimeline);
                }
                Long completionTime = this.completionTime.get(child.activityId);
                childTimeline.addIntervalMin(child.activityId, child.start, child.end, completionTime == null ? child.end : completionTime, TimelineIntervalKind.KERNEL);
                this.createChildTimelines(child, childTimeline, timelineTree);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextTL) {
                return this.activity.contextId == ((ContextTL)obj).activity.contextId;
            }
            return false;
        }

        private class NodeIdentifier {
            long correlationId;
            long gridId;

            NodeIdentifier(long correlationId, long gridId) {
                this.correlationId = correlationId;
                this.gridId = gridId;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof NodeIdentifier)) {
                    return false;
                }
                NodeIdentifier other = (NodeIdentifier)obj;
                return this.correlationId == other.correlationId && this.gridId == other.gridId;
            }
        }
    }

    private class DeviceTL {
        private CuptiActivityDevice activity;
        private String customName;
        private TimelineDevice tl;
        private final Map<Integer, ContextTL> contexts;
        private final UVMTL uvm;
        private final NvlinkTL nvlink;
        private final List<CuptiActivityDeviceAttribute> attributes;

        public DeviceTL(CuptiActivityDevice activity) {
            this.activity = activity;
            this.contexts = new HashMap<Integer, ContextTL>();
            this.attributes = new LinkedList<CuptiActivityDeviceAttribute>();
            this.uvm = new UVMTL();
            this.nvlink = new NvlinkTL();
            this.tl = new TimelineDevice(null);
            TimelineFactory.this.allTimelines.add(this.tl);
        }

        public void setCustomName(String customName, boolean overWrite) {
            if (customName != null && (overWrite || this.customName == null)) {
                this.customName = customName;
                this.tl.setCustomName(customName);
            }
        }

        protected ContextTL getContext(int id, CuptiActivityContext activity, String customName) {
            ContextTL context = this.contexts.get(id);
            if (context == null) {
                context = new ContextTL(activity);
                this.contexts.put(id, context);
            }
            if (activity != null) {
                context.activity = activity;
                context.tl.setActivity(activity);
            }
            if (customName != null) {
                context.setCustomName(customName, false);
            }
            return context;
        }

        protected void addNvlink(CuptiActivityMetric metric, Set<CuptiActivityNvLink> nvlinks, Set<CuptiActivityDevice> devices, TimelineIntervalKind intervalKind) {
            this.nvlink.setNvlinks(nvlinks);
            this.nvlink.setDevices(devices);
            this.nvlink.addNvlinkCounter(metric, this.activity.uuid, intervalKind);
        }

        public void addAttribute(CuptiActivityDeviceAttribute attr) {
            this.attributes.add(attr);
        }

        protected void addUVMCounter(CuptiActivityUvmCounter uvmCounter) {
            this.uvm.addUvmCounter(uvmCounter);
        }

        protected boolean createTimelines(Session session) {
            if (this.activity == null) {
                return false;
            }
            if (!(this.contexts.isEmpty() && this.uvm.isEmpty() && this.nvlink.isEmpty())) {
                this.uvm.createTimelines(session, this.tl);
                this.nvlink.createTimelines(session, this.tl);
                int failedContexts = 0;
                for (ContextTL context : this.contexts.values()) {
                    if (context.createTimelines(session, this.tl)) continue;
                    ++failedContexts;
                }
                if (failedContexts > 0) {
                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.UnsupportedContext_Label, String.valueOf(failedContexts) + " " + ViperMessages.UnsupportedContext_Message);
                }
                this.tl.addAttributes(this.attributes);
                if (!this.tl.getChildren().isEmpty()) {
                    session.addTopLevelTimeline(this.tl, false);
                }
            }
            return true;
        }

        public void setMinimumCompletionTime() {
            for (ContextTL context : this.contexts.values()) {
                context.setMinimumCompletionTime();
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof DeviceTL) {
                return this.activity.id == ((DeviceTL)obj).activity.id;
            }
            return false;
        }
    }

    private static enum EventDataState {
        EVENT_DATA_NONE,
        EVENT_DATA_SINGLE,
        EVENT_DATA_MULTIPLE;

    }

    class IntervalComparator
    implements Comparator<ITimelineInterval> {
        IntervalComparator() {
        }

        private int getTier(ITimelineInterval interval) {
            switch (interval.getKind()) {
                case OPENACC: {
                    return 0;
                }
                case RUNTIME: {
                    return 1;
                }
                case DRIVER: {
                    return 2;
                }
                case PTHREAD: {
                    return 3;
                }
                case MEMCPY_HTOD: 
                case MEMCPY_DTOH: 
                case MEMCPY_DTOD: 
                case MEMCPY_PTOP: 
                case MEMSET: 
                case KERNEL: {
                    return 4;
                }
            }
            return 99;
        }

        @Override
        public int compare(ITimelineInterval left, ITimelineInterval right) {
            int tierRight;
            int tierLeft = this.getTier(left);
            if (tierLeft < (tierRight = this.getTier(right))) {
                return -1;
            }
            if (tierLeft > tierRight) {
                return 1;
            }
            return 0;
        }
    }

    private class NvlinkTL {
        private Map<TimelineIntervalKind, Map<String, Map<Long, Long>>> nvlinkEntry = new HashMap<TimelineIntervalKind, Map<String, Map<Long, Long>>>();
        private Map<Integer, String> instanceDeviceNameMap = new HashMap<Integer, String>();
        private Map<String, TimelineNvlink> timelineMap = new TreeMap<String, TimelineNvlink>();
        private Map<String, Long> peakBandwidthMap = new TreeMap<String, Long>();
        private Set<CuptiActivityNvLink> nvlinks;
        private Set<CuptiActivityDevice> devices;

        private NvlinkTL() {
        }

        private String getDestinationName(int instance, byte[] uuid) {
            for (CuptiActivityNvLink nvlink : this.nvlinks) {
                int i;
                if (nvlink.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode() && Arrays.equals(uuid, nvlink.uuidDev0)) {
                    i = 0;
                    while (i < nvlink.physicalNvLinkCount) {
                        if (instance == nvlink.portDev0[i] && AnalysisResultNVLink.isDirectLink(nvlink.typeDev0, nvlink.typeDev1, nvlink.uuidDev0, nvlink.uuidDev1, this.nvlinks)) {
                            String deviceName = this.getDeviceName(nvlink.uuidDev1);
                            this.peakBandwidthMap.put(deviceName, nvlink.bandwidth);
                            return deviceName;
                        }
                        ++i;
                    }
                }
                if (nvlink.typeDev1 != CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode() || !Arrays.equals(uuid, nvlink.uuidDev1)) continue;
                i = 0;
                while (i < nvlink.physicalNvLinkCount) {
                    if (instance == nvlink.portDev1[i] && AnalysisResultNVLink.isDirectLink(nvlink.typeDev0, nvlink.typeDev1, nvlink.uuidDev0, nvlink.uuidDev1, this.nvlinks)) {
                        String deviceName = this.getDeviceName(nvlink.uuidDev0);
                        this.peakBandwidthMap.put(deviceName, nvlink.bandwidth);
                        return deviceName;
                    }
                    ++i;
                }
            }
            return null;
        }

        public void copyValues(NvlinkTL copyFrom, long earliestTimeDiff) {
            if (this.isEmpty()) {
                for (TimelineIntervalKind intervalKind : copyFrom.nvlinkEntry.keySet()) {
                    Map<String, Map<Long, Long>> deviceNameValueMapCopy = copyFrom.nvlinkEntry.get((Object)intervalKind);
                    HashMap deviceNameValueMap = new HashMap();
                    for (String timelineName : deviceNameValueMapCopy.keySet()) {
                        HashMap<Long, Long> entry = new HashMap<Long, Long>();
                        for (Long timestamp : deviceNameValueMapCopy.get(timelineName).keySet()) {
                            entry.put(timestamp - earliestTimeDiff, deviceNameValueMapCopy.get(timelineName).get(timestamp));
                        }
                        deviceNameValueMap.put(timelineName, entry);
                    }
                    this.nvlinkEntry.put(intervalKind, deviceNameValueMap);
                }
                this.instanceDeviceNameMap.putAll(copyFrom.instanceDeviceNameMap);
                this.peakBandwidthMap.putAll(copyFrom.peakBandwidthMap);
                this.nvlinks = new HashSet<CuptiActivityNvLink>(copyFrom.nvlinks);
                this.devices = new HashSet<CuptiActivityDevice>(copyFrom.devices);
            }
        }

        private TimelineNvlink getTimeline(String name) {
            if (!this.timelineMap.containsKey(name)) {
                TimelineNvlink nvlinkTL = new TimelineNvlink(name, TimelineKind.NVLINK_DEVICE);
                this.timelineMap.put(name, nvlinkTL);
                TimelineFactory.this.allTimelines.add(nvlinkTL);
            }
            return this.timelineMap.get(name);
        }

        private void addIntervalsToAllTLs(Session session) {
            for (TimelineIntervalKind intervalKind : this.nvlinkEntry.keySet()) {
                Map<String, Map<Long, Long>> deviceNameValueMap = this.nvlinkEntry.get((Object)intervalKind);
                for (String timelineName : deviceNameValueMap.keySet()) {
                    TimelineNvlink nvlinkTL = this.getTimeline(timelineName);
                    ArrayList<Map.Entry<Long, Long>> entryList = new ArrayList<Map.Entry<Long, Long>>(deviceNameValueMap.get(timelineName).entrySet());
                    Comparator<Map.Entry<Long, Long>> entryListComparator = new Comparator<Map.Entry<Long, Long>>(){

                        @Override
                        public int compare(Map.Entry<Long, Long> arg0, Map.Entry<Long, Long> arg1) {
                            return arg0.getKey().compareTo(arg1.getKey());
                        }
                    };
                    Map.Entry<Long, Long> startEntry = Collections.min(entryList, entryListComparator);
                    long startTime = startEntry.getKey();
                    long startValue = startEntry.getValue();
                    Map.Entry<Long, Long> endEntry = Collections.max(entryList, entryListComparator);
                    long endTime = endEntry.getKey();
                    long endValue = endEntry.getValue();
                    session.setLatestTime(endTime);
                    TimelineIntervalNvlink nvlinkInterval = new TimelineIntervalNvlink(intervalKind, startTime, endTime, startValue, endValue);
                    nvlinkInterval.setPrimaryTimeline(nvlinkTL);
                    nvlinkTL.addNvlinkInterval(nvlinkInterval);
                    boolean nonZeroFlag = startValue > 0L;
                    int i = 1;
                    while (i < entryList.size() - 1) {
                        Long value = (Long)((Map.Entry)entryList.get(i)).getValue();
                        Long timestamp = (Long)((Map.Entry)entryList.get(i)).getKey();
                        if (value == 0L) {
                            if (nonZeroFlag) {
                                nvlinkInterval.setTimestampValue(timestamp, value);
                                nonZeroFlag = false;
                            }
                        } else {
                            nvlinkInterval.setTimestampValue(timestamp, value);
                            if (!nonZeroFlag) {
                                Long prevTimestamp = (Long)((Map.Entry)entryList.get(i - 1)).getKey();
                                nvlinkInterval.setTimestampValue(prevTimestamp, 0L);
                                nonZeroFlag = true;
                            }
                        }
                        ++i;
                    }
                    nvlinkTL.setMaxValue(this.peakBandwidthMap.get(timelineName) * 1000L);
                    entryList.clear();
                }
            }
        }

        protected void createTimelines(Session session, TimelineDevice parent) {
            this.addIntervalsToAllTLs(session);
            if (!this.isEmpty()) {
                TimelineNvlink nvlinkParent = new TimelineNvlink("Nvlink", TimelineKind.NVLINK);
                TimelineFactory.this.allTimelines.add(nvlinkParent);
                for (TimelineNvlink nvlinkTL : this.timelineMap.values()) {
                    nvlinkParent.appendChild(nvlinkTL);
                }
                parent.appendChild(nvlinkParent);
            }
        }

        private String getDeviceName(byte[] uuid) {
            for (CuptiActivityDevice device : this.devices) {
                if (!Arrays.equals(device.uuid, uuid)) continue;
                return "[" + device.id + "] " + device.name;
            }
            return "CPU";
        }

        public void setNvlinks(Set<CuptiActivityNvLink> nvlinks) {
            if (this.nvlinks == null) {
                this.nvlinks = nvlinks;
            }
        }

        public void setDevices(Set<CuptiActivityDevice> devices) {
            if (this.devices == null) {
                this.devices = devices;
            }
        }

        public void addNvlinkCounter(CuptiActivityMetric metric, byte[] uuid, TimelineIntervalKind intervalKind) {
            String deviceName = "";
            deviceName = this.instanceDeviceNameMap.containsKey(metric.instance) ? this.instanceDeviceNameMap.get(metric.instance) : this.getDestinationName(metric.instance, uuid);
            if (deviceName != null) {
                this.instanceDeviceNameMap.put(metric.instance, deviceName);
                if (this.nvlinkEntry.containsKey((Object)intervalKind)) {
                    Map<Object, Object> timestampValueMap;
                    Map<String, Map<Long, Long>> deviceNameEntryMap = this.nvlinkEntry.get((Object)intervalKind);
                    if (deviceNameEntryMap.containsKey(deviceName)) {
                        timestampValueMap = deviceNameEntryMap.get(deviceName);
                    } else {
                        timestampValueMap = new TreeMap();
                        deviceNameEntryMap.put(deviceName, timestampValueMap);
                    }
                    if (timestampValueMap.containsKey(metric.timestamp)) {
                        Long value = (Long)timestampValueMap.get(metric.timestamp);
                        value = value + metric.longValue;
                    } else {
                        timestampValueMap.put(metric.timestamp, metric.longValue);
                    }
                } else {
                    TreeMap<Long, Long> timestampValueMap = new TreeMap<Long, Long>();
                    timestampValueMap.put(metric.timestamp, metric.longValue);
                    HashMap<String, TreeMap<Long, Long>> deviceNameEntryMap = new HashMap<String, TreeMap<Long, Long>>();
                    deviceNameEntryMap.put(deviceName, timestampValueMap);
                    this.nvlinkEntry.put(intervalKind, deviceNameEntryMap);
                }
            }
        }

        public boolean isEmpty() {
            return this.nvlinkEntry.isEmpty();
        }
    }

    private class ProcessTL {
        private final int pid;
        private TimelineProcess tl = null;
        private TimelineOverhead overheadTl = null;
        private UVMTL uvm = null;
        private final Map<Integer, ThreadTL> threads = new HashMap<Integer, ThreadTL>();

        public ProcessTL(int pid) {
            this.pid = pid;
            this.tl = new TimelineProcess(pid);
            this.uvm = new UVMTL();
            TimelineFactory.this.allTimelines.add(this.tl);
        }

        public void addUVMCounter(CuptiActivityUvmCounter activity) {
            this.uvm.addUvmCounter(activity);
        }

        protected ThreadTL getThread(int pid, int tid) {
            ThreadTL thd = this.threads.get(tid);
            if (thd == null) {
                thd = new ThreadTL(pid, tid);
                this.threads.put(tid, thd);
            }
            return thd;
        }

        protected Timeline getOverheadTimeline() {
            if (this.overheadTl == null) {
                this.overheadTl = new TimelineOverhead("Profiling Overhead", TimelineKind.OVERHEADS);
                TimelineFactory.this.allTimelines.add(this.overheadTl);
            }
            return this.overheadTl;
        }

        protected boolean createTimelines(Session session) {
            for (ThreadTL thread : this.threads.values()) {
                if (thread.createTimelines(session, this.tl)) continue;
                return false;
            }
            if (this.overheadTl != null) {
                this.tl.appendChild(this.overheadTl);
            }
            if (this.uvm != null) {
                this.uvm.createTimelines(session, this.tl);
            }
            if (!this.tl.getChildren().isEmpty()) {
                session.addTopLevelTimeline(this.tl, false);
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProcessTL) {
                return this.pid == ((ProcessTL)obj).pid;
            }
            return false;
        }
    }

    private class StreamOrderComparator
    implements Comparator<Timeline> {
        private StreamOrderComparator() {
        }

        @Override
        public int compare(Timeline o1, Timeline o2) {
            long start1 = 0L;
            long start2 = 0L;
            start1 = o1.getEarliestKernelStart();
            start2 = o2.getEarliestKernelStart();
            if (start1 == 0L && start2 == 0L) {
                return 0;
            }
            if (start1 == 0L) {
                return 1;
            }
            if (start2 == 0L) {
                return -1;
            }
            if (start1 < start2) {
                return -1;
            }
            if (start1 > start2) {
                return 1;
            }
            return 0;
        }
    }

    private class ThreadTL {
        private final int tid;
        private TimelineThread tl;
        private final Map<TimelineKind, Timeline> timelineMap;

        public ThreadTL(int pid, int tid) {
            this.tid = tid;
            this.timelineMap = new HashMap<TimelineKind, Timeline>();
            this.tl = new TimelineThread(pid, tid);
            TimelineFactory.this.allTimelines.add(this.tl);
        }

        public boolean isEmpty() {
            return this.timelineMap.isEmpty();
        }

        private String getTimelineNameForKind(TimelineKind kind) {
            if (TimelineKind.RUNTIME.equals((Object)kind)) {
                return "Runtime API";
            }
            if (TimelineKind.DRIVER.equals((Object)kind)) {
                return "Driver API";
            }
            if (TimelineKind.MARKER.equals((Object)kind)) {
                return "Markers and Ranges";
            }
            if (TimelineKind.OPENACC.equals((Object)kind)) {
                return "OpenACC";
            }
            if (TimelineKind.OPENMP.equals((Object)kind)) {
                return "OpenMP";
            }
            if (TimelineKind.PTHREAD.equals((Object)kind)) {
                return "PThread";
            }
            return "<unknown>";
        }

        public Timeline getTimelineForIntervalKind(TimelineIntervalKind intervalKind, boolean create) throws ViperException {
            switch (intervalKind) {
                case RUNTIME: {
                    return this.getTimelineForKind(TimelineKind.RUNTIME, create);
                }
                case DRIVER: {
                    return this.getTimelineForKind(TimelineKind.DRIVER, create);
                }
                case MARKER: 
                case RANGE: {
                    return this.getTimelineForKind(TimelineKind.MARKER, create);
                }
                case OPENACC: {
                    return this.getTimelineForKind(TimelineKind.OPENACC, create);
                }
                case PTHREAD: {
                    return this.getTimelineForKind(TimelineKind.PTHREAD, create);
                }
                case OPENMP: {
                    return this.getTimelineForKind(TimelineKind.OPENMP, create);
                }
            }
            throw new ViperException("Invalid interval kind for process timeline");
        }

        private Timeline getTimelineForKind(TimelineKind kind, boolean create) {
            Timeline tl = this.timelineMap.get((Object)kind);
            if (create && tl == null) {
                tl = new Timeline(this.getTimelineNameForKind(kind), kind);
                this.timelineMap.put(kind, tl);
                TimelineFactory.this.allTimelines.add(tl);
            }
            return tl;
        }

        protected boolean createTimelines(Session session, Timeline parent) {
            if (!this.isEmpty()) {
                Timeline marker;
                Timeline driver;
                Timeline runtime;
                Timeline openmp;
                Timeline openacc;
                parent.appendChild(this.tl);
                Timeline pthread = this.getTimelineForKind(TimelineKind.PTHREAD, false);
                if (pthread != null) {
                    this.tl.appendChild(pthread);
                }
                if ((openacc = this.getTimelineForKind(TimelineKind.OPENACC, false)) != null) {
                    this.tl.appendChild(openacc);
                }
                if ((openmp = this.getTimelineForKind(TimelineKind.OPENMP, false)) != null) {
                    this.tl.appendChild(openmp);
                }
                if ((runtime = this.getTimelineForKind(TimelineKind.RUNTIME, false)) != null) {
                    this.tl.appendChild(runtime);
                }
                if ((driver = this.getTimelineForKind(TimelineKind.DRIVER, false)) != null) {
                    this.tl.appendChild(driver);
                }
                if ((marker = this.getTimelineForKind(TimelineKind.MARKER, false)) != null) {
                    this.tl.appendChild(marker);
                }
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ThreadTL) {
                return this.tid == ((ThreadTL)obj).tid;
            }
            return false;
        }
    }

    private class TreeNode {
        public long activityId;
        public long start;
        public long end;
        public String name;
        public List<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode(long activityId, long start, long end, String name) {
            this.activityId = activityId;
            this.start = start;
            this.end = end;
            this.name = name;
        }
    }

    private class UVMTL {
        private Map<Integer, Map<CuptiActivityUvmCounterKind, List<CuptiActivityUvmCounter>>> uvmCounterMap;
        private Map<Integer, Map<CuptiActivityUvmCounterKind, List<TimelineIntervalUVM>>> uvmSegmentMap;
        private final Map<TimelineKind, TimelineUVM> timelineMap = new HashMap<TimelineKind, TimelineUVM>();

        public boolean isEmpty() {
            return this.timelineMap.isEmpty();
        }

        private TimelineUVM getTimelineForKind(TimelineKind timelineKind, boolean create) {
            TimelineUVM tl = this.timelineMap.get((Object)timelineKind);
            if (tl == null && create) {
                switch (timelineKind) {
                    case UVM_PAGE_FAULT: {
                        tl = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT.getName(), timelineKind, TimelineFactory.this.session.isUVMSegmentEnabled());
                        break;
                    }
                    case UVM_GPU_PAGE_FAULT: {
                        tl = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_GPU_PAGE_FAULT_COUNT.getName(), timelineKind, TimelineFactory.this.session.isUVMSegmentEnabled());
                        break;
                    }
                    case UVM_MEMCPY_HTOD: {
                        tl = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD.getName(), timelineKind, TimelineFactory.this.session.isUVMSegmentEnabled());
                        break;
                    }
                    case UVM_MEMCPY_DTOH: {
                        tl = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH.getName(), timelineKind, TimelineFactory.this.session.isUVMSegmentEnabled());
                        break;
                    }
                    case UVM_MEMCPY_DTOD: {
                        tl = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOD.getName(), timelineKind, TimelineFactory.this.session.isUVMSegmentEnabled());
                        break;
                    }
                    case UVM_THRASHING_THROTTLING: {
                        tl = new TimelineUVM(timelineKind.getName(), timelineKind, TimelineFactory.this.session.isUVMSegmentEnabled());
                        break;
                    }
                    case UVM_THRASHING: {
                        tl = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING.getName(), timelineKind, TimelineFactory.this.session.isUVMSegmentEnabled());
                        break;
                    }
                    case UVM_PAGE_THROTTLING: {
                        tl = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING.getName(), timelineKind, TimelineFactory.this.session.isUVMSegmentEnabled());
                        break;
                    }
                    case UVM_REMOTE_MAP: {
                        tl = new TimelineUVM(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP.getName(), timelineKind, TimelineFactory.this.session.isUVMSegmentEnabled());
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                this.timelineMap.put(timelineKind, tl);
                TimelineFactory.this.allTimelines.add(tl);
            }
            return tl;
        }

        private void addIntervalsToTL(TimelineKind timelineKind, boolean intervalMin) {
            TimelineUVM tl = this.getTimelineForKind(timelineKind, false);
            if (tl == null) {
                return;
            }
            ArrayList<CuptiActivityUvmCounterKind> uvmCounterKindList = new ArrayList<CuptiActivityUvmCounterKind>();
            switch (timelineKind) {
                case UVM_GPU_PAGE_FAULT: {
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_GPU_PAGE_FAULT_COUNT);
                    break;
                }
                case UVM_PAGE_FAULT: {
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT);
                    break;
                }
                case UVM_MEMCPY_HTOD: {
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD);
                    break;
                }
                case UVM_MEMCPY_DTOH: {
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH);
                    break;
                }
                case UVM_MEMCPY_DTOD: {
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOD);
                    break;
                }
                case UVM_THRASHING_THROTTLING: {
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING);
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING);
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP);
                    break;
                }
                case UVM_THRASHING: {
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING);
                    break;
                }
                case UVM_PAGE_THROTTLING: {
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING);
                    break;
                }
                case UVM_REMOTE_MAP: {
                    uvmCounterKindList.add(CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP);
                    break;
                }
                default: {
                    return;
                }
            }
            for (CuptiActivityUvmCounterKind uvmCounterKind : uvmCounterKindList) {
                if (this.uvmSegmentMap != null) {
                    this.addIntervalSegment(uvmCounterKind, tl);
                    continue;
                }
                if (this.uvmCounterMap == null) continue;
                this.addInterval(uvmCounterKind, tl, intervalMin);
            }
        }

        private void addInterval(CuptiActivityUvmCounterKind uvmCounterKind, TimelineUVM tl, boolean intervalMin) {
            for (Integer processId : this.uvmCounterMap.keySet()) {
                List<CuptiActivityUvmCounter> activityList = this.getCounterListForKind(uvmCounterKind, processId);
                if (activityList == null || activityList.isEmpty()) continue;
                if (activityList.get(0).isNew()) {
                    for (CuptiActivityUvmCounter activity : activityList) {
                        ITimelineInterval uvmInterval = TimelineFactory.this.loadIntervalFromActivity(activity, tl, true);
                        if (intervalMin) {
                            tl.addIntervalMin(uvmInterval.getID(), uvmInterval.getStart(), uvmInterval.getEnd(), uvmInterval.getExtendedEnd(), uvmInterval.getKind());
                            continue;
                        }
                        uvmInterval.setPrimaryTimeline(tl);
                        tl.addInterval(uvmInterval, false);
                    }
                    continue;
                }
                int i = 0;
                while (i < activityList.size() - 1) {
                    long value = activityList.get((int)(i + 1)).value - activityList.get((int)i).value;
                    if (value > 0L) {
                        if (intervalMin) {
                            TimelineFactory.this.session.setEndId(activityList.get(i).getID(), activityList.get(i + 1).getID());
                        }
                        ITimelineInterval uvmInterval = TimelineIntervalFactory.buildInterval(activityList.get(i), null, activityList.get(i + 1));
                        if (intervalMin) {
                            tl.addIntervalMin(uvmInterval.getID(), uvmInterval.getStart(), uvmInterval.getEnd(), uvmInterval.getExtendedEnd(), uvmInterval.getKind());
                        } else {
                            uvmInterval.setPrimaryTimeline(tl);
                            tl.addInterval(uvmInterval, false);
                        }
                    }
                    ++i;
                }
            }
        }

        private void addIntervalSegment(CuptiActivityUvmCounterKind uvmCounterKind, TimelineUVM tl) {
            for (Integer processId : this.uvmSegmentMap.keySet()) {
                List<TimelineIntervalUVM> listSegment = this.uvmSegmentMap.get(processId).get((Object)uvmCounterKind);
                if (listSegment == null) continue;
                int i = 0;
                while (i < listSegment.size()) {
                    TimelineIntervalUVM segment = listSegment.get(i);
                    if (segment.getKind() != null) {
                        segment.setPrimaryTimeline(tl);
                        tl.addUvmInterval(segment);
                    }
                    ++i;
                }
            }
        }

        private TimelineIntervalKind getUVMIntervalKind(CuptiActivityUvmCounterKind kind) {
            switch (kind) {
                case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD: {
                    return TimelineIntervalKind.UVM_MEMCPY_HTOD;
                }
                case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH: {
                    return TimelineIntervalKind.UVM_MEMCPY_DTOH;
                }
                case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOD: {
                    return TimelineIntervalKind.UVM_MEMCPY_DTOD;
                }
                case CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT: {
                    return TimelineIntervalKind.UVM_PAGE_FAULT;
                }
                case CUPTI_ACTIVITY_UVM_COUNTER_KIND_GPU_PAGE_FAULT_COUNT: {
                    return TimelineIntervalKind.UVM_GPU_PAGE_FAULT;
                }
                case CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING: {
                    return TimelineIntervalKind.UVM_PAGE_THROTTLING;
                }
                case CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING: {
                    return TimelineIntervalKind.UVM_THRASHING;
                }
                case CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP: {
                    return TimelineIntervalKind.UVM_REMOTE_MAP;
                }
            }
            return null;
        }

        private void addIntervalsToAllTLs(boolean intervalMin) {
            this.addIntervalsToTL(TimelineKind.UVM_MEMCPY_HTOD, intervalMin);
            this.addIntervalsToTL(TimelineKind.UVM_MEMCPY_DTOH, intervalMin);
            this.addIntervalsToTL(TimelineKind.UVM_MEMCPY_DTOD, intervalMin);
            this.addIntervalsToTL(TimelineKind.UVM_PAGE_FAULT, intervalMin);
            this.addIntervalsToTL(TimelineKind.UVM_GPU_PAGE_FAULT, intervalMin);
            this.addIntervalsToTL(TimelineKind.UVM_THRASHING_THROTTLING, intervalMin);
            this.addIntervalsToTL(TimelineKind.UVM_THRASHING, intervalMin);
            this.addIntervalsToTL(TimelineKind.UVM_PAGE_THROTTLING, intervalMin);
            this.addIntervalsToTL(TimelineKind.UVM_REMOTE_MAP, intervalMin);
        }

        private List<CuptiActivityUvmCounter> getCounterListForKind(CuptiActivityUvmCounterKind uvmCounterKind, int processId) {
            if (this.uvmCounterMap.containsKey(processId)) {
                List<CuptiActivityUvmCounter> uvmCounterListPerProcess = this.uvmCounterMap.get(processId).get((Object)uvmCounterKind);
                if (uvmCounterListPerProcess != null) {
                    Collections.sort(uvmCounterListPerProcess, new Comparator<CuptiActivityUvmCounter>(){

                        @Override
                        public int compare(CuptiActivityUvmCounter counter1, CuptiActivityUvmCounter counter2) {
                            if (counter1.timestamp > counter2.timestamp) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                }
                return uvmCounterListPerProcess;
            }
            return null;
        }

        public void addUvmCounter(CuptiActivityUvmCounter uvmCounter) {
            if (!uvmCounter.isNew() || !TimelineFactory.this.session.isUVMSegmentEnabled() || TimelineFactory.this.session.getNumSegmentsUVM() == 0) {
                this.addCounter(uvmCounter);
            } else {
                this.addSegment(uvmCounter);
            }
        }

        private void addSegment(CuptiActivityUvmCounter uvmCounter) {
            List<TimelineIntervalUVM> uvmSegmentList;
            Map<Object, Object> uvmSegmentKindMap;
            if (this.uvmSegmentMap == null) {
                this.uvmSegmentMap = new HashMap<Integer, Map<CuptiActivityUvmCounterKind, List<TimelineIntervalUVM>>>();
            }
            if (this.uvmSegmentMap.containsKey(uvmCounter.processId)) {
                uvmSegmentKindMap = this.uvmSegmentMap.get(uvmCounter.processId);
            } else {
                uvmSegmentKindMap = new HashMap();
                this.uvmSegmentMap.put(uvmCounter.processId, uvmSegmentKindMap);
            }
            if (uvmSegmentKindMap.containsKey((Object)uvmCounter.getUvmCounterKind())) {
                uvmSegmentList = (List)uvmSegmentKindMap.get((Object)uvmCounter.getUvmCounterKind());
            } else {
                long endTimestamp;
                long startTimestamp;
                uvmSegmentList = new ArrayList();
                uvmSegmentKindMap.put((Object)uvmCounter.getUvmCounterKind(), uvmSegmentList);
                ProfileDataModel pdm = TimelineFactory.this.getPdm(uvmCounter.getID());
                if (TimelineFactory.this.session.isNormalizeIndependently()) {
                    startTimestamp = TimelineFactory.this.session.getEarliestTime(pdm);
                    endTimestamp = TimelineFactory.this.session.getLatestTime(pdm);
                } else {
                    startTimestamp = TimelineFactory.this.sessionStart;
                    endTimestamp = TimelineFactory.this.sessionEnd;
                }
                long segmentSize = (endTimestamp - startTimestamp) / (long)TimelineFactory.this.session.getNumSegmentsUVM();
                long i = startTimestamp;
                while (i <= endTimestamp) {
                    TimelineIntervalUVM s = new TimelineIntervalUVM(i, i + segmentSize, uvmCounter.processId);
                    uvmSegmentList.add(s);
                    i += segmentSize;
                }
            }
            for (TimelineIntervalUVM segment : uvmSegmentList) {
                if (uvmCounter.start < segment.getStart() || uvmCounter.start >= segment.getEnd()) continue;
                segment.setIsSegmented(uvmCounter.isNew());
                if (segment.getID() == 0L) {
                    segment.setId(uvmCounter.getID());
                }
                if (segment.getKind() == null) {
                    segment.setKind(this.getUVMIntervalKind(uvmCounter.getUvmCounterKind()));
                }
                if (segment.getStartAddress() == -1L || uvmCounter.address < segment.getStartAddress()) {
                    segment.setStartAddress(uvmCounter.address);
                }
                if (uvmCounter.address > segment.getEndAddress()) {
                    segment.setEndAddress(uvmCounter.address);
                }
                segment.addCounterValue(uvmCounter.getValue());
                if (segment.getMinValue() == -1L || uvmCounter.value < segment.getMinValue()) {
                    segment.setMinValueActivity(uvmCounter);
                }
                if (uvmCounter.value > segment.getMaxValue()) {
                    segment.setMaxValueActivity(uvmCounter);
                }
                segment.incrementRecordCount();
                int kindCode = uvmCounter.getUvmCounterKind().getCode();
                if (kindCode == CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD.getCode() || kindCode == CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH.getCode() || kindCode == CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOD.getCode()) {
                    segment.addTotalTime(uvmCounter.end - uvmCounter.start);
                }
                if (kindCode == CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT.getCode() || kindCode == CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING.getCode()) break;
                segment.mergeOverlappTime(uvmCounter.start, uvmCounter.end);
                break;
            }
        }

        private void addCounter(CuptiActivityUvmCounter uvmCounter) {
            if (this.uvmCounterMap == null) {
                this.uvmCounterMap = new HashMap<Integer, Map<CuptiActivityUvmCounterKind, List<CuptiActivityUvmCounter>>>();
            }
            Map<Object, Object> uvmCounterKindMap = this.uvmCounterMap.containsKey(uvmCounter.processId) ? this.uvmCounterMap.get(uvmCounter.processId) : new HashMap();
            List<CuptiActivityUvmCounter> uvmCounterList = uvmCounterKindMap.containsKey((Object)uvmCounter.getUvmCounterKind()) ? (List)uvmCounterKindMap.get((Object)uvmCounter.getUvmCounterKind()) : new ArrayList<CuptiActivityUvmCounter>();
            uvmCounterList.add(uvmCounter);
            uvmCounterKindMap.put((Object)uvmCounter.getUvmCounterKind(), uvmCounterList);
            this.uvmCounterMap.put(uvmCounter.processId, uvmCounterKindMap);
        }

        protected boolean createTimelines(Session session, Timeline parent) {
            this.addIntervalsToAllTLs(true);
            if (!this.isEmpty()) {
                TimelineUVM parentTl;
                TimelineUVM uvm = new TimelineUVM("Unified Memory", TimelineKind.UVM, session.isUVMSegmentEnabled());
                TimelineFactory.this.allTimelines.add(uvm);
                TimelineUVM tl = this.timelineMap.get((Object)TimelineKind.UVM_MEMCPY_DTOH);
                if (tl != null) {
                    uvm.appendChild(tl);
                }
                if ((tl = this.timelineMap.get((Object)TimelineKind.UVM_GPU_PAGE_FAULT)) != null) {
                    uvm.appendChild(tl);
                }
                if ((tl = this.timelineMap.get((Object)TimelineKind.UVM_MEMCPY_HTOD)) != null) {
                    uvm.appendChild(tl);
                }
                if ((tl = this.timelineMap.get((Object)TimelineKind.UVM_MEMCPY_DTOD)) != null) {
                    uvm.appendChild(tl);
                }
                if ((tl = this.timelineMap.get((Object)TimelineKind.UVM_PAGE_FAULT)) != null) {
                    uvm.appendChild(tl);
                }
                if ((parentTl = this.timelineMap.get((Object)TimelineKind.UVM_THRASHING_THROTTLING)) != null) {
                    uvm.appendChild(parentTl);
                    tl = this.timelineMap.get((Object)TimelineKind.UVM_THRASHING);
                    if (tl != null) {
                        parentTl.appendChild(tl);
                    }
                    if ((tl = this.timelineMap.get((Object)TimelineKind.UVM_PAGE_THROTTLING)) != null) {
                        parentTl.appendChild(tl);
                    }
                    if ((tl = this.timelineMap.get((Object)TimelineKind.UVM_REMOTE_MAP)) != null) {
                        parentTl.appendChild(tl);
                    }
                    parentTl.setContainerState(ContainerState.CLOSED);
                }
                if (!uvm.getChildren().isEmpty()) {
                    parent.appendChild(uvm);
                    return true;
                }
            }
            return false;
        }
    }
}

