/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.MetricManager;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultInterval;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValuePercent;
import java.util.Set;
import org.eclipse.jface.action.Action;

public class AnalysisResultOccupancy
extends AnalysisResultInterval<Double> {
    private long totalKernelTime = 0L;

    public AnalysisResultOccupancy(Session session, AnalysisDescriptor desc) {
        super(session, desc);
    }

    public void setTotalKernelTime(long totalKernelTime) {
        this.totalKernelTime = totalKernelTime;
    }

    @Override
    public String getDetails(ResultOutput otpt) {
        if (this.totalKernelTime > 0L) {
            double occAvg = 0.0;
            long occTime = 0L;
            for (ITimelineInterval interval : this.intervals.keySet()) {
                Double occ = (Double)this.getData(interval);
                if (occ == null) continue;
                occAvg += occ.doubleValue();
                occTime += interval.getDuration();
            }
            ValuePercent occValue = new ValuePercent((occAvg /= (double)this.getIntervalCount()) * 100.0);
            double occTimeAvg = (double)occTime / (double)this.totalKernelTime;
            ValuePercent occTimeValue = new ValuePercent(occTimeAvg * 100.0);
            return String.valueOf(occValue.toString()) + " avg, for kernels accounting for " + occTimeValue.toString() + " of compute";
        }
        return null;
    }

    @Override
    public IValue getValue(ITimelineInterval interval) {
        Double occupancy = (Double)this.getData(interval);
        if (occupancy == null) {
            return null;
        }
        return new ValuePercent(occupancy * 100.0);
    }

    @Override
    public String getValueDescription(ITimelineInterval interval) {
        String metricName = "achieved_occupancy";
        Set<Metric> metrics = MetricManager.getMetrics(metricName);
        if (metrics.isEmpty()) {
            return null;
        }
        return metrics.iterator().next().getLongDesc();
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.OCCUPANCY);
            }
        };
    }
}

