/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperImages;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.model.Session;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

public enum TimelineKind {
    ROOT("All"),
    PROCESS("Process"),
    THREAD("Thread"),
    RUNTIME("Runtime API"),
    DRIVER("Driver API"),
    OVERHEADS("Profiling Overhead"),
    MARKER("Markers and Ranges"),
    OPENACC("OpenACC"),
    PTHREAD("Pthread"),
    OPENMP("OpenMP"),
    DEVICE("Device"),
    UVM("Unified Memory"),
    UVM_MEMCPY_HTOD("Data Migration (HtoD)"),
    UVM_MEMCPY_DTOH("Data Migration (DtoH)"),
    UVM_MEMCPY_DTOD("Data Migration (DtoD)"),
    UVM_PAGE_FAULT("CPU Page Faults"),
    UVM_GPU_PAGE_FAULT("GPU Page Faults"),
    UVM_THRASHING_THROTTLING("Thrashing-Throttling"),
    UVM_THRASHING("Thrashing"),
    UVM_PAGE_THROTTLING("Page Throttling"),
    UVM_REMOTE_MAP("Remote Map"),
    CONTEXT("Context"),
    MEMCPY_HTOD("MemCpy (HtoD)"),
    MEMCPY_DTOH("MemCpy (DtoH)"),
    MEMCPY_DTOD("MemCpy (DtoD)"),
    MEMCPY_PTOP("MemCpy (PtoP)"),
    KERNELS("Compute"),
    KERNEL,
    STREAMS("Streams"),
    STREAM,
    NVLINK("Nvlink"),
    NVLINK_DEVICE;

    private String name;
    private boolean enable;

    private TimelineKind() {
    }

    private TimelineKind(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Image getImage() {
        switch (this) {
            case UVM: 
            case UVM_MEMCPY_HTOD: 
            case UVM_MEMCPY_DTOH: 
            case UVM_MEMCPY_DTOD: 
            case UVM_PAGE_FAULT: 
            case UVM_GPU_PAGE_FAULT: 
            case UVM_THRASHING_THROTTLING: 
            case UVM_THRASHING: 
            case UVM_PAGE_THROTTLING: 
            case UVM_REMOTE_MAP: 
            case CONTEXT: 
            case MEMCPY_HTOD: 
            case MEMCPY_DTOH: 
            case MEMCPY_DTOD: 
            case MEMCPY_PTOP: {
                return ViperImages.get("icons/en/analysis_warn.gif");
            }
        }
        return null;
    }

    public String getTooltip() {
        switch (this) {
            case UVM: {
                return "If " + this.getName() + " is disabled, Unified Memory analysis will not work";
            }
            case UVM_MEMCPY_HTOD: 
            case UVM_MEMCPY_DTOH: 
            case UVM_MEMCPY_DTOD: 
            case UVM_PAGE_FAULT: 
            case UVM_GPU_PAGE_FAULT: 
            case UVM_THRASHING_THROTTLING: 
            case UVM_THRASHING: 
            case UVM_PAGE_THROTTLING: 
            case UVM_REMOTE_MAP: {
                return "If " + this.getName() + " is disabled, Unified Memory analysis will be incorrect";
            }
            case CONTEXT: {
                return "If " + this.getName() + " disabled, analyses will not work";
            }
            case MEMCPY_HTOD: 
            case MEMCPY_DTOH: 
            case MEMCPY_DTOD: 
            case MEMCPY_PTOP: {
                return "If " + this.getName() + " is disabled, \"Data Movement And Concurrency\" and kernel analysis will be incorrect";
            }
        }
        return null;
    }

    public static Object[] getRootTimeines() {
        return new TimelineKind[]{ROOT};
    }

    public Object getParents() {
        switch (this) {
            case PROCESS: 
            case DEVICE: {
                return ROOT;
            }
            case UVM_MEMCPY_HTOD: 
            case UVM_MEMCPY_DTOH: 
            case UVM_MEMCPY_DTOD: 
            case UVM_GPU_PAGE_FAULT: 
            case UVM_THRASHING_THROTTLING: {
                return UVM;
            }
            case THREAD: 
            case OVERHEADS: 
            case OPENACC: 
            case PTHREAD: 
            case UVM_PAGE_FAULT: {
                return PROCESS;
            }
            case UVM: 
            case CONTEXT: {
                return DEVICE;
            }
            case RUNTIME: 
            case DRIVER: 
            case MARKER: {
                return THREAD;
            }
            case MEMCPY_HTOD: 
            case MEMCPY_DTOH: 
            case MEMCPY_DTOD: 
            case MEMCPY_PTOP: 
            case STREAMS: {
                return CONTEXT;
            }
        }
        return null;
    }

    public Object[] getChildren() {
        switch (this) {
            case ROOT: {
                return new TimelineKind[]{PROCESS, DEVICE};
            }
            case PROCESS: {
                return new TimelineKind[]{THREAD, OVERHEADS, MARKER, OPENACC, PTHREAD, UVM_PAGE_FAULT};
            }
            case DEVICE: {
                return new TimelineKind[]{UVM, CONTEXT};
            }
            case UVM: {
                return new TimelineKind[]{UVM_MEMCPY_HTOD, UVM_MEMCPY_DTOH, UVM_MEMCPY_DTOD, UVM_GPU_PAGE_FAULT, UVM_THRASHING_THROTTLING};
            }
            case THREAD: {
                return new TimelineKind[]{RUNTIME, DRIVER};
            }
            case CONTEXT: {
                return new TimelineKind[]{MEMCPY_HTOD, MEMCPY_DTOH, MEMCPY_DTOD, MEMCPY_PTOP, STREAMS};
            }
        }
        return null;
    }

    public boolean isFilterable() {
        return this.equals((Object)UVM_MEMCPY_HTOD) || this.equals((Object)UVM_MEMCPY_DTOH) || this.equals((Object)UVM_MEMCPY_DTOD) || this.equals((Object)UVM_PAGE_FAULT) || this.equals((Object)UVM_GPU_PAGE_FAULT) || this.equals((Object)UVM_THRASHING_THROTTLING) || this.equals((Object)UVM_THRASHING) || this.equals((Object)UVM_REMOTE_MAP) || this.equals((Object)UVM_PAGE_THROTTLING) || this.equals((Object)MEMCPY_DTOH) || this.equals((Object)MEMCPY_HTOD) || this.equals((Object)MEMCPY_DTOD) || this.equals((Object)MEMCPY_PTOP) || this.equals((Object)KERNEL);
    }

    public boolean isUvmKind() {
        return this.equals((Object)UVM_MEMCPY_HTOD) || this.equals((Object)UVM_MEMCPY_DTOH) || this.equals((Object)UVM_MEMCPY_DTOD) || this.equals((Object)UVM_PAGE_FAULT) || this.equals((Object)UVM_GPU_PAGE_FAULT) || this.equals((Object)UVM_THRASHING_THROTTLING) || this.equals((Object)UVM_THRASHING) || this.equals((Object)UVM_REMOTE_MAP) || this.equals((Object)UVM_PAGE_THROTTLING);
    }

    public boolean isGhostWhenFiltered() {
        return !this.equals((Object)KERNELS);
    }

    public boolean isCPU() {
        return this.equals((Object)PROCESS) || this.equals((Object)THREAD) || this.equals((Object)RUNTIME) || this.equals((Object)DRIVER) || this.equals((Object)OVERHEADS) || this.equals((Object)MARKER) || this.equals((Object)OPENACC) || this.equals((Object)PTHREAD);
    }

    public boolean isGPU() {
        return !this.isCPU();
    }

    public boolean isAPI() {
        return this.equals((Object)RUNTIME) || this.equals((Object)DRIVER);
    }

    public boolean appendsToPDM() {
        return !this.equals((Object)KERNELS) && !this.equals((Object)STREAMS);
    }

    public boolean canReorder() {
        return !this.equals((Object)PROCESS) && !this.equals((Object)DEVICE);
    }

    public boolean supportsMultipleIntervalRows(boolean isSegmented) {
        return this.supportsEndSorting(isSegmented);
    }

    public boolean supportsStartSorting() {
        return true;
    }

    public boolean supportsEndSorting(boolean isSegmented) {
        if (isSegmented) {
            return false;
        }
        return this.equals((Object)KERNEL) || this.equals((Object)KERNELS) || this.equals((Object)OVERHEADS) || this.equals((Object)MARKER) || this.equals((Object)MEMCPY_PTOP) || this.equals((Object)MEMCPY_DTOD) || this.equals((Object)MEMCPY_DTOH) || this.equals((Object)MEMCPY_HTOD) || this.equals((Object)OPENACC) || this.equals((Object)PTHREAD) || this.equals((Object)UVM_MEMCPY_HTOD) || this.equals((Object)UVM_MEMCPY_DTOH) || this.equals((Object)UVM_MEMCPY_DTOD) || this.equals((Object)UVM_GPU_PAGE_FAULT) || this.equals((Object)UVM_THRASHING) || this.equals((Object)UVM_PAGE_THROTTLING) || this.equals((Object)UVM_REMOTE_MAP) || this.equals((Object)OPENMP);
    }

    public boolean usesExtendedEnd() {
        return this.equals((Object)KERNEL);
    }

    public EnumSet<CuptiActivityKind> getRequiredActivityKinds() {
        EnumSet<CuptiActivityKind> result = EnumSet.noneOf(CuptiActivityKind.class);
        switch (this) {
            case MARKER: 
            case UVM: 
            case UVM_MEMCPY_HTOD: 
            case UVM_MEMCPY_DTOH: 
            case UVM_MEMCPY_DTOD: 
            case UVM_PAGE_FAULT: 
            case UVM_GPU_PAGE_FAULT: 
            case UVM_THRASHING_THROTTLING: 
            case UVM_THRASHING: 
            case UVM_PAGE_THROTTLING: 
            case UVM_REMOTE_MAP: 
            case KERNEL: {
                return null;
            }
            case PROCESS: 
            case THREAD: 
            case CONTEXT: 
            case STREAMS: {
                break;
            }
            case DEVICE: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_ENVIRONMENT);
                break;
            }
            case RUNTIME: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_RUNTIME);
                break;
            }
            case DRIVER: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_DRIVER);
                break;
            }
            case OVERHEADS: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_OVERHEAD);
                break;
            }
            case MEMCPY_HTOD: 
            case MEMCPY_DTOH: 
            case MEMCPY_DTOD: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMCPY);
                break;
            }
            case MEMCPY_PTOP: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMCPY2);
                break;
            }
            case KERNELS: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_CDP_KERNEL);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_KERNEL);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMSET);
                break;
            }
            case STREAM: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMCPY);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMCPY2);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_KERNEL);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMSET);
                break;
            }
            case OPENACC: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_DATA);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_OTHER);
                break;
            }
            case NVLINK: 
            case NVLINK_DEVICE: {
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_NVLINK);
                result.add(CuptiActivityKind.CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE);
            }
        }
        return result;
    }

    private static void visitKind(CuptiActivityKind kind, List<CuptiActivityKind> list, EnumSet<CuptiActivityKind> set) {
        list.add(kind);
        set.add(kind);
    }

    public static List<CuptiActivityKind> getOptimalTraversingOrder(Session session) {
        ArrayList<CuptiActivityKind> result = new ArrayList<CuptiActivityKind>();
        EnumSet<CuptiActivityKind> added = EnumSet.noneOf(CuptiActivityKind.class);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_DRIVER, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_RUNTIME, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_OVERHEAD, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_ENVIRONMENT, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMCPY, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMCPY2, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_KERNEL, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMSET, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_CDP_KERNEL, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_DEVICE, result, added);
        TimelineKind.visitKind(CuptiActivityKind.CUPTI_ACTIVITY_KIND_NVLINK, result, added);
        CuptiActivityKind[] cuptiActivityKindArray = CuptiActivityKind.values();
        int n = cuptiActivityKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiActivityKind kind = cuptiActivityKindArray[n2];
            if (!added.contains((Object)kind) && !CuptiActivityKind.isFakeCuptiActivity(kind)) {
                TimelineKind.visitKind(kind, result, added);
            }
            ++n2;
        }
        TimelineKind.ignoreDisabledTimelines(result, session.getDisabledTimeline());
        return result;
    }

    private static void ignoreDisabledTimelines(List<CuptiActivityKind> activityKinds, Set<TimelineKind> tlKinds) {
        if (tlKinds == null) {
            return;
        }
        if (tlKinds.contains((Object)DRIVER)) {
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_DRIVER);
        } else if (tlKinds.contains((Object)RUNTIME)) {
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_RUNTIME);
        } else if (tlKinds.contains((Object)MARKER)) {
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER);
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER_DATA);
        } else if (tlKinds.contains((Object)KERNELS)) {
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_KERNEL);
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_CDP_KERNEL);
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMSET);
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL);
        } else if (tlKinds.contains((Object)OVERHEADS)) {
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_OVERHEAD);
        } else if (tlKinds.contains((Object)OPENACC)) {
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_DATA);
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH);
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_OTHER);
        } else if (tlKinds.contains((Object)MEMCPY_HTOD) && tlKinds.contains((Object)MEMCPY_DTOH) && tlKinds.contains((Object)MEMCPY_DTOD)) {
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMCPY);
        } else if (tlKinds.contains((Object)MEMCPY_PTOP)) {
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMCPY2);
        } else if (tlKinds.contains((Object)UVM_PAGE_FAULT) && tlKinds.contains((Object)UVM_GPU_PAGE_FAULT) && tlKinds.contains((Object)UVM_MEMCPY_HTOD) && tlKinds.contains((Object)UVM_MEMCPY_DTOH) && tlKinds.contains((Object)UVM_MEMCPY_DTOD) && tlKinds.contains((Object)UVM_THRASHING_THROTTLING)) {
            activityKinds.remove((Object)CuptiActivityKind.CUPTI_ACTIVITY_KIND_UVM_COUNTER);
        }
    }

    public void enableTimeline(boolean checked) {
        this.enable = checked;
    }

    public boolean isEnableTimeline() {
        return this.enable;
    }
}

