/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperColors;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ColorLegendControl
extends Composite {
    protected Label labelLegend;
    protected Map<Integer, Label> mapValueLabel = new TreeMap<Integer, Label>();
    private Map<Integer, Label> mapPercentageLabel = new TreeMap<Integer, Label>();

    public ColorLegendControl(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.setBackground(ColorConstants.white);
        this.createControl();
    }

    private void createControl() {
        this.labelLegend = new Label((Composite)this, 64);
        this.labelLegend.setText("Color legend");
        this.labelLegend.setBackground(ColorConstants.white);
        this.labelLegend.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        ViperColors.HeatMap[] heatMapArray = ViperColors.HeatMap.values();
        int n = heatMapArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViperColors.HeatMap element = heatMapArray[n2];
            Label label = new Label((Composite)this, 0);
            label.setText("              ");
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setBackground(element.getColor());
            label = new Label((Composite)this, 0);
            label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            label.setBackground(ColorConstants.white);
            this.mapPercentageLabel.put(element.getPercentValue(), label);
            label = new Label((Composite)this, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
            label.setBackground(ColorConstants.white);
            this.mapValueLabel.put(element.getPercentValue(), label);
            ++n2;
        }
        this.populatePercentageValues();
    }

    private void populatePercentageValues() {
        if (this.isPercentageAscending()) {
            int start = 0;
            for (Map.Entry<Integer, Label> entry : this.mapPercentageLabel.entrySet()) {
                entry.getValue().setText(String.valueOf(start) + " - " + entry.getKey() + " %");
                start = entry.getKey();
            }
        } else {
            int end = 100;
            for (Map.Entry<Integer, Label> entry : this.mapPercentageLabel.entrySet()) {
                int start = 100 - entry.getKey();
                entry.getValue().setText(String.valueOf(start) + " - " + end + " %");
                end = start;
            }
        }
        this.layout();
    }

    protected boolean isPercentageAscending() {
        return true;
    }
}

