/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViewUtils;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.SessionActionConstants;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.jni.CallTree;
import com.nvidia.viper.jni.CpuThread;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.CallTreeContentProvider;
import com.nvidia.viper.ui.CallTreeLabelProvider;
import com.nvidia.viper.ui.ContextManager;
import com.nvidia.viper.ui.SessionEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class CpuTreeView
extends ViewPart
implements ISelectionChangedListener,
TreeListener,
SelectionListener {
    public CpuThread sortingThread;
    public static final String ID = "com.nvidia.viper.ui.CpuTreeView";
    private TreeViewer tree;
    public static Session newSession;
    private ActivePartListener asListener = new ActivePartListener();
    private Session session;
    private Composite parent;
    private modes mode;
    private TreeOrientationAction topDownAction;
    private TreeOrientationAction bottomUpAction;
    private TreeOrientationAction codeAction;
    private ThreadSelectorDropDown threadDropDown;
    private CallTreeLabelProvider secondsLabelContentProvider = new CallTreeLabelProvider(CallTreeLabelProvider.columns.HITS);
    private CallTreeLabelProvider functionLabelContentProvider = new CallTreeLabelProvider(CallTreeLabelProvider.columns.EVENT_NAME);
    private CallTreeLabelProvider percentageLabelContentProvider = new CallTreeLabelProvider(CallTreeLabelProvider.columns.PERCENTAGE);
    private CallTreeLabelProvider scaleLabelContentProvider = new CallTreeLabelProvider(CallTreeLabelProvider.columns.V_SCALE);
    private CallTreeLabelProvider rangeLabelContentProvider = new CallTreeLabelProvider(CallTreeLabelProvider.columns.RANGE);
    private ScrolledForm form;
    private GridData treeLayout;

    public CpuTreeView() {
        this.mode = modes.BOTTOM_UP;
    }

    public TreeViewerColumn addColumn(CallTreeLabelProvider provider, CpuThread sortingThread) {
        TreeViewerColumn column = new TreeViewerColumn(this.tree, 16384);
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)provider);
        column.getColumn().setText(provider.getTitle());
        column.getColumn().setData((Object)sortingThread);
        column.getColumn().addSelectionListener((SelectionListener)this);
        column.getColumn().setAlignment(131072);
        return column;
    }

    public void createTreeView() {
        while (this.tree.getTree().getColumnCount() > 0) {
            this.tree.getTree().getColumns()[0].dispose();
        }
        this.tree.setContentProvider((IContentProvider)new CallTreeContentProvider());
        this.tree.getTree().addTreeListener((TreeListener)this);
        TreeViewerColumn column = this.addColumn(this.functionLabelContentProvider, null);
        column.getColumn().setWidth(400);
        column.getColumn().setResizable(true);
        this.session.getCpuTree(this.mode);
        this.addColumn(this.percentageLabelContentProvider, CallTree.getTotalThread());
        this.session.getCpuTree(this.mode);
        column = this.addColumn(this.secondsLabelContentProvider, CallTree.getTotalThread());
        column.getColumn().setWidth(600);
        this.tree.getTree().setLayoutData((Object)this.treeLayout);
        this.tree.getTree().setHeaderVisible(true);
        this.tree.getTree().setLinesVisible(true);
        this.tree.refresh();
    }

    public void createTableView() {
        while (this.tree.getTree().getColumnCount() > 0) {
            this.tree.getTree().getColumns()[0].dispose();
        }
        this.tree.setContentProvider((IContentProvider)new CallTreeContentProvider());
        TreeViewerColumn column = this.addColumn(this.functionLabelContentProvider, null);
        column.getColumn().setWidth(400);
        column.getColumn().setResizable(true);
        this.session.getCpuTree(this.mode);
        this.addColumn(this.percentageLabelContentProvider, CallTree.getTotalThread());
        this.session.getCpuTree(this.mode);
        TreeViewerColumn c2 = this.addColumn(this.rangeLabelContentProvider, CallTree.getMinThread());
        c2.getColumn().setWidth(600);
        TreeViewerColumn c1 = this.addColumn(this.scaleLabelContentProvider, CallTree.getMaxThread());
        this.session.getCpuTree(this.mode);
        c1.getColumn().setWidth(80);
        Iterator<CpuThread> it = this.session.iteratorAllThread();
        while (it.hasNext()) {
            CpuThread thread = it.next();
            if (thread.isStat()) continue;
            CallTreeLabelProvider label = new CallTreeLabelProvider(thread);
            column = this.addColumn(label, thread);
            column.getColumn().setWidth(25);
        }
        this.tree.getTree().setLayoutData((Object)this.treeLayout);
        this.tree.getTree().setHeaderVisible(true);
        this.tree.getTree().setLinesVisible(true);
        this.tree.refresh();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createScrolledForm(parent);
        GridLayout layout = new GridLayout();
        this.form.getBody().setLayout((Layout)layout);
        this.form.getBody().setLayout((Layout)new GridLayout(4, false));
        this.treeLayout = new GridData(4, 4, true, true);
        this.treeLayout.horizontalAlignment = 4;
        this.treeLayout.horizontalSpan = 3;
        this.threadDropDown = new ThreadSelectorDropDown(this.form.getBody());
        this.threadDropDown.getCombo().setText("(Thread)");
        this.threadDropDown.getCombo().setLayoutData((Object)new GridData(140, 30));
        this.threadDropDown.addSelectionChangedListener(this);
        Canvas scale = new Canvas(this.form.getBody(), 131072);
        scale.setLayoutData((Object)new GridData(200, 15));
        scale.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CallTreeLabelProvider.paintScale(e);
            }
        });
        Link more = new Link(this.form.getBody(), 131072);
        more.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        more.setText("<a>More...</a>");
        more.setBackground(this.form.getBackground());
        more.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViperHelp.displayHelp(ViperHelp.CPU_DETAILS_VIEW);
            }
        });
        this.handleNewActivePart((IWorkbenchPart)ContextManager.getSingleton().getActiveSessionEditor());
        ViperHelp.setContextHelp((Control)parent, ViperHelp.CPU_DETAILS_VIEW_CONTEXT_ID);
        this.createActions();
        this.createToolBar(parent);
        this.initializeToolBar();
        this.initializeMenu();
        this.tree = new TreeViewer(this.form.getBody(), 65542);
        this.tree.getTree().setLayoutData((Object)this.treeLayout);
        if (this.session == null) {
            this.tree.setContentProvider((IContentProvider)new CallTreeContentProvider());
        } else {
            this.createTreeView();
        }
        this.tree.setComparator((ViewerComparator)new CpuTreeComparator());
        this.tree.setExpandPreCheckFilters(true);
        ViewerFilter[] filters = new ViewerFilter[]{new NonZeroFilter()};
        this.tree.setFilters(filters);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tree, (int)1);
        this.tree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection select = (IStructuredSelection)event.getSelection();
                CallTree node = (CallTree)select.getFirstElement();
                if (node != null && node.getDisplayType() != CallTree.DISPLAY_TYPE.LIBRARY && CpuTreeView.this.session.getCpuSourceBaseDir() != null && node.getFileName().compareTo("Unknown Filename") != 0) {
                    ViewUtils.openSourceView(CpuTreeView.this.session, CpuTreeView.this.parent.getShell(), node.getRelativePath(), node.getFileName(), node.getLineNo());
                }
            }
        });
        new TreeViewerFocusCellManager(this.tree, new FocusCellHighlighter((ColumnViewer)this.tree){

            protected void focusCellChanged(ViewerCell newCell, ViewerCell oldCell) {
                CpuThread thread = null;
                if (oldCell != null) {
                    ((CallTreeLabelProvider)CpuTreeView.this.tree.getLabelProvider(oldCell.getColumnIndex())).deselectColumn();
                }
                if (newCell != null) {
                    CallTreeLabelProvider provider = (CallTreeLabelProvider)CpuTreeView.this.tree.getLabelProvider(newCell.getColumnIndex());
                    provider.selectColumn();
                    thread = provider.getThread();
                }
                if (CpuTreeView.this.session != null && CpuTreeView.this.session.getSamples() != null) {
                    CpuTreeView.this.session.getSamples().setSelectedThread(thread);
                }
                CpuTreeView.this.tree.getTree().redraw();
            }
        });
        this.expandTree();
    }

    private void createToolBar(Composite parent) {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.topDownAction);
        mgr.add((IAction)this.bottomUpAction);
        mgr.add((IAction)this.codeAction);
    }

    private void handleNewActivePart(IWorkbenchPart part) {
        Session newSession = null;
        if (part instanceof SessionEditor) {
            newSession = ((SessionEditor)part).getSession();
        } else if (part instanceof SourceSassEditor) {
            newSession = ((SourceSassEditor)part).getSession();
        } else if (part instanceof CpuTreeView) {
            newSession = ((CpuTreeView)part).session;
        }
        Session oldSession = this.session;
        if (newSession != null) {
            this.session = newSession;
            if (oldSession != null && oldSession.getCpuTree(this.mode) != null) {
                this.refreshView();
            }
        }
    }

    private void handleClosedActivePart(IWorkbenchPart part) {
        if (part instanceof SessionEditor) {
            this.session = null;
            this.refreshView();
        }
    }

    private void refreshView() {
        if (!this.tree.getTree().isDisposed()) {
            if (this.tree != null && this.tree.getControl() != null && this.session != null && this.session.getCpuTree(this.mode) != null) {
                this.tree.getTree().setVisible(false);
                if (this.session != null) {
                    this.sortingThread = this.session.getCurrentThread();
                    CallTree head = (CallTree)this.tree.getInput();
                    ArrayList<CpuThread> dropDownThreads = new ArrayList<CpuThread>();
                    dropDownThreads.add(this.threadDropDown.showAllThreads);
                    if (head != null) {
                        dropDownThreads.addAll(head.getActualThreads());
                    }
                    this.threadDropDown.setInput(dropDownThreads);
                    if (this.session.getCurrentThread() != null && dropDownThreads.contains(this.session.getCurrentThread())) {
                        this.threadDropDown.setSelection((ISelection)new StructuredSelection((Object)this.session.getCurrentThread()), true);
                    } else {
                        this.threadDropDown.setSelection((ISelection)new StructuredSelection((Object)this.threadDropDown.showAllThreads), true);
                    }
                    this.tree.setInput((Object)this.session.getCpuTree(this.mode).getFunctionShadow());
                }
                this.tree.refresh();
                this.expandTree();
            } else {
                this.tree.setInput(null);
                this.threadDropDown.setInput(null);
            }
            this.tree.getTree().setVisible(true);
            this.updateActionState();
        }
    }

    private void updateActionState() {
        this.topDownAction.setChecked(this.mode.equals((Object)modes.TOP_DOWN));
        this.bottomUpAction.setChecked(this.mode.equals((Object)modes.BOTTOM_UP));
        this.codeAction.setChecked(this.mode.equals((Object)modes.CODE_STRUCTURE));
    }

    private void createActions() {
        this.topDownAction = new TreeOrientationAction(modes.TOP_DOWN);
        this.bottomUpAction = new TreeOrientationAction(modes.BOTTOM_UP);
        this.codeAction = new TreeOrientationAction(modes.CODE_STRUCTURE);
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
        if (this.session != null && this.session.getCpuTree(this.mode) != null && this.tree.getSelection() == null) {
            StructuredSelection currentSelection = new StructuredSelection((Object)this.tree.getSelection());
            this.tree.setInput((Object)this.session.getCpuTree(this.mode).getFunctionShadow());
            this.tree.setSelection((ISelection)currentSelection);
            this.sortingThread = this.session.getCurrentThread();
            this.refreshView();
            this.expandTree();
            this.tree.expandToLevel((Object)currentSelection, -1);
        }
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.asListener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (this.session.getCpuTree(this.mode) != null) {
            CallTree c = this.session.getCpuTree(this.mode).getFunctionShadow();
            this.tree.setInput((Object)c);
            CpuThread thread = (CpuThread)selection.getFirstElement();
            c.setCurrentThread(thread);
            if (thread.isTotal()) {
                this.createTableView();
            } else {
                this.createTreeView();
            }
            this.sortingThread = thread;
            this.tree.refresh();
            this.expandTree();
        }
    }

    public void expandTree() {
        if (this.session != null) {
            TreePath[] expansionState = this.session.getCpuTreeState(this.mode);
            if (expansionState == null) {
                List<Object> expand = new ArrayList();
                CallTree cpuTree = this.session.getCpuTree(this.mode);
                if (cpuTree == null) {
                    return;
                }
                CallTree functionShadow = cpuTree.getFunctionShadow();
                if (functionShadow == null) {
                    return;
                }
                switch (this.mode) {
                    case TOP_DOWN: {
                        expand = functionShadow.getHotCalls();
                        break;
                    }
                    case BOTTOM_UP: {
                        break;
                    }
                    case CODE_STRUCTURE: {
                        expand = functionShadow.getLibraryAndFileNodes();
                    }
                }
                this.tree.setExpandedElements(expand.toArray());
                this.session.setCpuTreeState(this.mode, this.tree.getExpandedTreePaths());
            } else {
                this.tree.setExpandedTreePaths(expansionState);
            }
        }
    }

    public void openDefaultTree(CallTree tree, Session newSession) {
        this.session = newSession;
        this.topDownAction.setChecked(false);
        this.bottomUpAction.setChecked(true);
        this.codeAction.setChecked(false);
        this.tree.setInput((Object)tree.getFunctionShadow());
        this.refreshView();
        this.tree.refresh();
        this.expandTree();
    }

    public void treeCollapsed(TreeEvent e) {
        if (e.item instanceof TreeItem) {
            ((TreeItem)e.item).setExpanded(false);
        }
        this.session.setCpuTreeState(this.mode, this.tree.getExpandedTreePaths());
    }

    public void treeExpanded(TreeEvent e) {
        if (e.item instanceof TreeItem) {
            ((TreeItem)e.item).setExpanded(true);
        }
        this.session.setCpuTreeState(this.mode, this.tree.getExpandedTreePaths());
    }

    public void widgetSelected(SelectionEvent e) {
        this.sortingThread = (CpuThread)((TreeColumn)e.getSource()).getData();
        this.tree.getTree().redraw();
        this.tree.refresh();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class ActivePartListener
    implements IPartListener {
        private ActivePartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            CpuTreeView.this.handleNewActivePart(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            CpuTreeView.this.handleNewActivePart(part);
        }

        public void partOpened(IWorkbenchPart part) {
            CpuTreeView.this.handleNewActivePart(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            CpuTreeView.this.handleClosedActivePart(part);
        }
    }

    public class CpuTreeComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CallTree && e2 instanceof CallTree) {
                if (CpuTreeView.this.sortingThread == null) {
                    return ((CallTree)e1).getFunctionName().compareTo(((CallTree)e2).getFunctionName());
                }
                return ((CallTree)e2).getHits(CpuTreeView.this.sortingThread) - ((CallTree)e1).getHits(CpuTreeView.this.sortingThread);
            }
            return 0;
        }
    }

    public class NonZeroFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof CallTree) {
                return ((CallTree)element).getHits() > 0;
            }
            return false;
        }
    }

    public class ResolvedSymbolFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof CallTree) {
                return !((CallTree)element).getFunctionName().startsWith("???");
            }
            return false;
        }
    }

    public class ThreadSelectorDropDown
    extends ComboViewer {
        private CpuThread showAllThreads;
        LabelProvider labelProvider;

        public ThreadSelectorDropDown(Composite parent) {
            super(parent, 128);
            this.labelProvider = new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof CpuThread) {
                        if (((CpuThread)element).isTotal()) {
                            return "All threads";
                        }
                        return ((CpuThread)element).getTitle();
                    }
                    return null;
                }
            };
            this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.showAllThreads = CallTree.getTotalThread();
        }
    }

    private class TreeOrientationAction
    extends Action {
        private modes mode;

        public TreeOrientationAction(modes m) {
            super("", 8);
            this.mode = m;
            switch (this.mode) {
                case TOP_DOWN: {
                    this.setText(ViperMessages.CpuTreeTopDown_Label);
                    this.setImageDescriptor(ViperImages.DESC_CPUTREE_TOPDOWN);
                    this.setToolTipText(ViperMessages.CpuTreeTopDown_Tooltip);
                    this.setId("com.nvidia.viper.ui.cputreeview.topdown");
                    break;
                }
                case BOTTOM_UP: {
                    this.setText(ViperMessages.CpuTreeBottomUp_Label);
                    this.setImageDescriptor(ViperImages.DESC_CPUTREE_BOTTOMUP);
                    this.setToolTipText(ViperMessages.CpuTreeBottomUp_Tooltip);
                    this.setId(SessionActionConstants.CPUTREE_BOTTOMUP);
                    break;
                }
                case CODE_STRUCTURE: {
                    this.setText(ViperMessages.CpuTreeFlat_Label);
                    this.setImageDescriptor(ViperImages.DESC_CPUTREE_FLAT);
                    this.setToolTipText(ViperMessages.CpuTreeFlat_Tooltip);
                    this.setId(SessionActionConstants.CPUTREE_FLAT);
                }
            }
        }

        public void run() {
            CpuTreeView.this.mode = this.mode;
            if (CpuTreeView.this.session == null) {
                CpuTreeView.this.session = newSession;
            }
            if (CpuTreeView.this.session != null) {
                CpuTreeView.this.refreshView();
            }
        }
    }

    public static enum modes {
        CODE_STRUCTURE,
        TOP_DOWN,
        BOTTOM_UP;

    }
}

