#!/usr/bin/env python
# -*- coding:utf-8 -*-


##############################################################################
## license :
##============================================================================
##
## File :        DataBase.py
##
## Project :     TANGO
##
## $Author :      controls$
##
## $Revision :    $
##
## $Date :        $
##
## $HeadUrl :     $
##============================================================================
##            This file is generated by POGO
##    (Program Obviously used to Generate tango Object)
##
##        (c) - Software Engineering Group - ESRF
##############################################################################

"""This class manage the TANGO database."""

__all__ = ("DataBase", "DataBaseClass", "main")

__docformat__ = "restructuredtext"

import PyTango
import sys

# Add additional import
# ----- PROTECTED REGION ID(DataBase.additionnal_import) ENABLED START -----#
try:
    from __future__ import print_function
except ImportError:
    pass
# ----- PROTECTED REGION END -----#	//	DataBase.additionnal_import

##############################################################################
## Device States Description
##
## No states for this device
##############################################################################


class DataBase(PyTango.Device_4Impl):
    # --------- Add you global variables here --------------------------
    # ----- PROTECTED REGION ID(DataBase.global_variables) ENABLED START -----#

    # ----- PROTECTED REGION END -----#	//	DataBase.global_variables
    # ------------------------------------------------------------------
    #    Device constructor
    # ------------------------------------------------------------------
    def __init__(self, cl, name):
        PyTango.Device_4Impl.__init__(self, cl, name)
        self.debug_stream("In " + self.get_name() + ".__init__()")
        DataBase.init_device(self)

    # ------------------------------------------------------------------
    #    Device destructor
    # ------------------------------------------------------------------
    def delete_device(self):
        self.debug_stream("In " + self.get_name() + ".delete_device()")
        # ----- PROTECTED REGION ID(DataBase.delete_device) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.delete_device

    # ------------------------------------------------------------------
    #    Device initialization
    # ------------------------------------------------------------------
    def init_device(self):
        self.debug_stream("In " + self.get_name() + ".init_device()")
        self.get_device_properties(self.get_device_class())
        self.attr_StoredProcedureRelease_read = ""
        self.attr_Timing_average_read = [0.0]
        self.attr_Timing_minimum_read = [0.0]
        self.attr_Timing_maximum_read = [0.0]
        self.attr_Timing_calls_read = [0.0]
        self.attr_Timing_index_read = [""]
        self.attr_Timing_info_read = [""]
        # ----- PROTECTED REGION ID(DataBase.init_device) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.init_device

    # ------------------------------------------------------------------
    #    Always excuted hook method
    # ------------------------------------------------------------------
    def always_executed_hook(self):
        self.debug_stream("In " + self.get_name() + ".always_excuted_hook()")
        # ----- PROTECTED REGION ID(DataBase.always_executed_hook) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.always_executed_hook

    # ==================================================================
    #
    #    DataBase read/write attribute methods
    #
    # ==================================================================

    # ------------------------------------------------------------------
    #    Read StoredProcedureRelease attribute
    # ------------------------------------------------------------------
    def read_StoredProcedureRelease(self, attr):
        self.debug_stream("In " + self.get_name() + ".read_StoredProcedureRelease()")
        # ----- PROTECTED REGION ID(DataBase.StoredProcedureRelease_read) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.StoredProcedureRelease_read
        attr.set_value(self.attr_StoredProcedureRelease_read)

    # ------------------------------------------------------------------
    #    Read Timing_average attribute
    # ------------------------------------------------------------------
    def read_Timing_average(self, attr):
        self.debug_stream("In " + self.get_name() + ".read_Timing_average()")
        # ----- PROTECTED REGION ID(DataBase.Timing_average_read) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.Timing_average_read
        attr.set_value(self.attr_Timing_average_read)

    # ------------------------------------------------------------------
    #    Read Timing_minimum attribute
    # ------------------------------------------------------------------
    def read_Timing_minimum(self, attr):
        self.debug_stream("In " + self.get_name() + ".read_Timing_minimum()")
        # ----- PROTECTED REGION ID(DataBase.Timing_minimum_read) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.Timing_minimum_read
        attr.set_value(self.attr_Timing_minimum_read)

    # ------------------------------------------------------------------
    #    Read Timing_maximum attribute
    # ------------------------------------------------------------------
    def read_Timing_maximum(self, attr):
        self.debug_stream("In " + self.get_name() + ".read_Timing_maximum()")
        # ----- PROTECTED REGION ID(DataBase.Timing_maximum_read) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.Timing_maximum_read
        attr.set_value(self.attr_Timing_maximum_read)

    # ------------------------------------------------------------------
    #    Read Timing_calls attribute
    # ------------------------------------------------------------------
    def read_Timing_calls(self, attr):
        self.debug_stream("In " + self.get_name() + ".read_Timing_calls()")
        # ----- PROTECTED REGION ID(DataBase.Timing_calls_read) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.Timing_calls_read
        attr.set_value(self.attr_Timing_calls_read)

    # ------------------------------------------------------------------
    #    Read Timing_index attribute
    # ------------------------------------------------------------------
    def read_Timing_index(self, attr):
        self.debug_stream("In " + self.get_name() + ".read_Timing_index()")
        # ----- PROTECTED REGION ID(DataBase.Timing_index_read) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.Timing_index_read
        attr.set_value(self.attr_Timing_index_read)

    # ------------------------------------------------------------------
    #    Read Timing_info attribute
    # ------------------------------------------------------------------
    def read_Timing_info(self, attr):
        self.debug_stream("In " + self.get_name() + ".read_Timing_info()")
        # ----- PROTECTED REGION ID(DataBase.Timing_info_read) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.Timing_info_read
        attr.set_value(self.attr_Timing_info_read)

    # ------------------------------------------------------------------
    #    Read Attribute Hardware
    # ------------------------------------------------------------------
    def read_attr_hardware(self, data):
        self.debug_stream("In " + self.get_name() + ".read_attr_hardware()")
        # ----- PROTECTED REGION ID(DataBase.read_attr_hardware) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.read_attr_hardware

    # ==================================================================
    #
    #    DataBase command methods
    #
    # ==================================================================

    # ------------------------------------------------------------------
    #    DbAddDevice command:
    # ------------------------------------------------------------------
    def DbAddDevice(self, argin):
        """Add a Tango class device to a specific device server

        :param argin: Str[0] = Full device server process name
        Str[1] = Device name
        Str[2] = Tango class name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbAddDevice()")
        # ----- PROTECTED REGION ID(DataBase.DbAddDevice) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbAddDevice

    # ------------------------------------------------------------------
    #    DbAddServer command:
    # ------------------------------------------------------------------
    def DbAddServer(self, argin):
        """Create a device server process entry in database

        :param argin: Str[0] = Full device server name
        Str[1] = Device(s) name
        Str[2] = Tango class name
        Str[n] = Device name
        Str[n + 1] = Tango class name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbAddServer()")
        # ----- PROTECTED REGION ID(DataBase.DbAddServer) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbAddServer

    # ------------------------------------------------------------------
    #    DbDeleteAttributeAlias command:
    # ------------------------------------------------------------------
    def DbDeleteAttributeAlias(self, argin):
        """Delete an attribute alias.

        :param argin: Attriibute alias name.
        :type: PyTango.DevString
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteAttributeAlias()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteAttributeAlias) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteAttributeAlias

    # ------------------------------------------------------------------
    #    DbDeleteClassAttribute command:
    # ------------------------------------------------------------------
    def DbDeleteClassAttribute(self, argin):
        """delete a class attribute and all its properties from database

        :param argin: Str[0] = Tango class name
        Str[1] = Attribute name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteClassAttribute()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteClassAttribute) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteClassAttribute

    # ------------------------------------------------------------------
    #    DbDeleteClassAttributeProperty command:
    # ------------------------------------------------------------------
    def DbDeleteClassAttributeProperty(self, argin):
        """delete class attribute properties from database

        :param argin: Str[0] = Tango class name
        Str[1] = Attribute name
        Str[2] = Property name
        Str[n] = Property name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteClassAttributeProperty()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteClassAttributeProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteClassAttributeProperty

    # ------------------------------------------------------------------
    #    DbDeleteClassProperty command:
    # ------------------------------------------------------------------
    def DbDeleteClassProperty(self, argin):
        """Delete class properties from database

        :param argin: Str[0] = Tango class name
        Str[1] = Property name
        Str[n] = Property name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteClassProperty()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteClassProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteClassProperty

    # ------------------------------------------------------------------
    #    DbDeleteDevice command:
    # ------------------------------------------------------------------
    def DbDeleteDevice(self, argin):
        """Delete a devcie from database

        :param argin: device name
        :type: PyTango.DevString
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteDevice()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteDevice) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteDevice

    # ------------------------------------------------------------------
    #    DbDeleteDeviceAlias command:
    # ------------------------------------------------------------------
    def DbDeleteDeviceAlias(self, argin):
        """Delete a device alias.

        :param argin: device alias name
        :type: PyTango.DevString
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteDeviceAlias()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteDeviceAlias) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteDeviceAlias

    # ------------------------------------------------------------------
    #    DbDeleteDeviceAttribute command:
    # ------------------------------------------------------------------
    def DbDeleteDeviceAttribute(self, argin):
        """Delete  device attribute properties from database

        :param argin: Str[0] = Device name
        Str[1] = Attribute name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteDeviceAttribute()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteDeviceAttribute) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteDeviceAttribute

    # ------------------------------------------------------------------
    #    DbDeleteDeviceAttributeProperty command:
    # ------------------------------------------------------------------
    def DbDeleteDeviceAttributeProperty(self, argin):
        """delete a device attribute property from the database

        :param argin: Str[0] = Device name
        Str[1] = Attribute name
        Str[2] = Property name
        Str[n] = Property name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream(
            "In " + self.get_name() + ".DbDeleteDeviceAttributeProperty()"
        )
        # ----- PROTECTED REGION ID(DataBase.DbDeleteDeviceAttributeProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteDeviceAttributeProperty

    # ------------------------------------------------------------------
    #    DbDeleteDeviceProperty command:
    # ------------------------------------------------------------------
    def DbDeleteDeviceProperty(self, argin):
        """Delete device property(ies)

        :param argin: Str[0] = Device name
        Str[1] = Property name
        Str[n] = Property name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteDeviceProperty()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteDeviceProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteDeviceProperty

    # ------------------------------------------------------------------
    #    DbDeleteProperty command:
    # ------------------------------------------------------------------
    def DbDeleteProperty(self, argin):
        """Delete free property from database

        :param argin: Str[0]  = Object name
        Str[1] = Property name
        Str[n] = Property name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteProperty()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteProperty

    # ------------------------------------------------------------------
    #    DbDeleteServer command:
    # ------------------------------------------------------------------
    def DbDeleteServer(self, argin):
        """Delete server from the database but dont delete device properties

        :param argin: Device server name
        :type: PyTango.DevString
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteServer()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteServer) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteServer

    # ------------------------------------------------------------------
    #    DbDeleteServerInfo command:
    # ------------------------------------------------------------------
    def DbDeleteServerInfo(self, argin):
        """delete info related to a Tango devvice server process

        :param argin: Device server name
        :type: PyTango.DevString
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbDeleteServerInfo()")
        # ----- PROTECTED REGION ID(DataBase.DbDeleteServerInfo) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteServerInfo

    # ------------------------------------------------------------------
    #    DbExportDevice command:
    # ------------------------------------------------------------------
    def DbExportDevice(self, argin):
        """Export a device to the database

        :param argin: Str[0] = Device name
        Str[1] = CORBA IOR
        Str[2] = Device server process host name
        Str[3] = Device server process PID or string ``null``
        Str[4] = Device server process version
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbExportDevice()")
        # ----- PROTECTED REGION ID(DataBase.DbExportDevice) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbExportDevice

    # ------------------------------------------------------------------
    #    DbExportEvent command:
    # ------------------------------------------------------------------
    def DbExportEvent(self, argin):
        """Export Event channel to database

        :param argin: Str[0] = event channel name (or factory name)
        Str[1] = CORBA IOR
        Str[2] = Notifd host name
        Str[3] = Notifd pid
        Str[4] = Notifd version
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbExportEvent()")
        # ----- PROTECTED REGION ID(DataBase.DbExportEvent) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbExportEvent

    # ------------------------------------------------------------------
    #    DbGetAliasDevice command:
    # ------------------------------------------------------------------
    def DbGetAliasDevice(self, argin):
        """Get device name from its alias.

        :param argin: Alias name
        :type: PyTango.DevString
        :return: Device name
        :rtype: PyTango.DevString"""
        self.debug_stream("In " + self.get_name() + ".DbGetAliasDevice()")
        argout = ""
        # ----- PROTECTED REGION ID(DataBase.DbGetAliasDevice) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetAliasDevice
        return argout

    # ------------------------------------------------------------------
    #    DbGetAttributeAlias command:
    # ------------------------------------------------------------------
    def DbGetAttributeAlias(self, argin):
        """Get the attribute name for the given alias.
        If alias not found in database, returns an empty string.

        :param argin: The attribute alias name
        :type: PyTango.DevString
        :return: The attribute name (device/attribute)
        :rtype: PyTango.DevString"""
        self.debug_stream("In " + self.get_name() + ".DbGetAttributeAlias()")
        argout = ""
        # ----- PROTECTED REGION ID(DataBase.DbGetAttributeAlias) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetAttributeAlias
        return argout

    # ------------------------------------------------------------------
    #    DbGetAttributeAliasList command:
    # ------------------------------------------------------------------
    def DbGetAttributeAliasList(self, argin):
        """Get attribute alias list for a specified filter

        :param argin: attribute alias filter string (eg: att*)
        :type: PyTango.DevString
        :return: attribute aliases
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetAttributeAliasList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetAttributeAliasList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetAttributeAliasList
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassAttributeList command:
    # ------------------------------------------------------------------
    def DbGetClassAttributeList(self, argin):
        """Get attrilute list for a given Tango class with a specified filter

        :param argin: Str[0] = Tango class name
        Str[1] = Attribute name filter (eg: att*)
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Class attribute name
        Str[n] = Class attribute name
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetClassAttributeList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetClassAttributeList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassAttributeList
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassAttributeProperty command:
    # ------------------------------------------------------------------
    def DbGetClassAttributeProperty(self, argin):
        """Get Tango class property(ies) value

        :param argin: Str[0] = Tango class name
        Str[1] = Attribute name
        Str[n] = Attribute name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Tango class name
        Str[1] = Attribute property  number
        Str[2] = Attribute property 1 name
        Str[3] = Attribute property 1 value
        Str[n + 1] = Attribute property 2 name
        Str[n + 2] = Attribute property 2 value
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetClassAttributeProperty()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetClassAttributeProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassAttributeProperty
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassAttributeProperty2 command:
    # ------------------------------------------------------------------
    def DbGetClassAttributeProperty2(self, argin):
        """This command supports array property compared to the old command called
        DbGetClassAttributeProperty. The old command has not been deleted from the
        server for compatibility reasons.

        :param argin: Str[0] = Tango class name
        Str[1] = Attribute name
        Str[n] = Attribute name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Tango class name
        Str[1] = Attribute property  number
        Str[2] = Attribute property 1 name
        Str[3] = Attribute property 1 value number (array case)
        Str[4] = Attribute property 1 value
        Str[n] = Attribute property 1 value (array case)
        Str[n + 1] = Attribute property 2 name
        Str[n + 2] = Attribute property 2 value number (array case)
        Str[n + 3] = Attribute property 2 value
        Str[n + m] = Attribute property 2 value (array case)
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetClassAttributeProperty2()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetClassAttributeProperty2) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassAttributeProperty2
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassAttributePropertyHist command:
    # ------------------------------------------------------------------
    def DbGetClassAttributePropertyHist(self, argin):
        """Retrieve Tango class attribute property history

        :param argin: Str[0] = Tango class
        Str[1] = Attribute name
        Str[2] = Property name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Attribute name
        Str[1] = Property name
        Str[2] = date
        Str[3] = Property value number (array case)
        Str[4] = Property value 1
        Str[n] = Property value n
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream(
            "In " + self.get_name() + ".DbGetClassAttributePropertyHist()"
        )
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetClassAttributePropertyHist) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassAttributePropertyHist
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassForDevice command:
    # ------------------------------------------------------------------
    def DbGetClassForDevice(self, argin):
        """Get Tango class for the specified device.

        :param argin: Device name
        :type: PyTango.DevString
        :return: Device Tango class
        :rtype: PyTango.DevString"""
        self.debug_stream("In " + self.get_name() + ".DbGetClassForDevice()")
        argout = ""
        # ----- PROTECTED REGION ID(DataBase.DbGetClassForDevice) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassForDevice
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassInheritanceForDevice command:
    # ------------------------------------------------------------------
    def DbGetClassInheritanceForDevice(self, argin):
        """Get class inheritance for the specified device.

        :param argin: Device name
        :type: PyTango.DevString
        :return: Classes off the specified device.
        [0] - is the class of the device.
        [1] - is the class from the device class is inherited.
        ........and so on
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetClassInheritanceForDevice()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetClassInheritanceForDevice) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassInheritanceForDevice
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassList command:
    # ------------------------------------------------------------------
    def DbGetClassList(self, argin):
        """Get Tango class list with a specified filter

        :param argin: Filter
        :type: PyTango.DevString
        :return: Class list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetClassList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetClassList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassList
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassProperty command:
    # ------------------------------------------------------------------
    def DbGetClassProperty(self, argin):
        """

        :param argin: Str[0] = Tango class
        Str[1] = Property name
        Str[2] = Property name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Tango class
        Str[1] = Property number
        Str[2] = Property name
        Str[3] = Property value number (array case)
        Str[4] = Property value
        Str[n] = Propery value (array case)
        ....
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetClassProperty()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetClassProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassProperty
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassPropertyHist command:
    # ------------------------------------------------------------------
    def DbGetClassPropertyHist(self, argin):
        """Retrieve Tango class property history

        :param argin: Str[0] = Tango class
        Str[1] = Property name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Property name
        Str[1] = date
        Str[2] = Property value number (array case)
        Str[3] = Property value 1
        Str[n] = Property value n
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetClassPropertyHist()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetClassPropertyHist) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassPropertyHist
        return argout

    # ------------------------------------------------------------------
    #    DbGetClassPropertyList command:
    # ------------------------------------------------------------------
    def DbGetClassPropertyList(self, argin):
        """Get property list for a given Tango class with a specified filter

        :param argin: The filter
        :type: PyTango.DevString
        :return: Property name list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetClassPropertyList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetClassPropertyList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetClassPropertyList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceAlias command:
    # ------------------------------------------------------------------
    def DbGetDeviceAlias(self, argin):
        """Return alias for device name if found.

        :param argin: The device name
        :type: PyTango.DevString
        :return: The alias found
        :rtype: PyTango.DevString"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceAlias()")
        argout = ""
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceAlias) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceAlias
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceAliasList command:
    # ------------------------------------------------------------------
    def DbGetDeviceAliasList(self, argin):
        """Get device alias name with a specific filter

        :param argin: The filter
        :type: PyTango.DevString
        :return: Device alias list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceAliasList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceAliasList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceAliasList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceAttributeList command:
    # ------------------------------------------------------------------
    def DbGetDeviceAttributeList(self, argin):
        """Return list of attributes matching the wildcard
         for the specified device

        :param argin: Str[0] = Device name
        Str[1] = Wildcard
        :type: PyTango.DevVarStringArray
        :return: attribute name list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceAttributeList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceAttributeList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceAttributeList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceAttributeProperty command:
    # ------------------------------------------------------------------
    def DbGetDeviceAttributeProperty(self, argin):
        """Get device attribute property(ies) value

        :param argin: Str[0] = Device name
        Str[1] = Attribute name
        Str[n] = Attribute name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Device name
        Str[1] = Attribute property  number
        Str[2] = Attribute property 1 name
        Str[3] = Attribute property 1 value
        Str[n + 1] = Attribute property 2 name
        Str[n + 2] = Attribute property 2 value
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceAttributeProperty()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceAttributeProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceAttributeProperty
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceAttributeProperty2 command:
    # ------------------------------------------------------------------
    def DbGetDeviceAttributeProperty2(self, argin):
        """Retrieve device attribute properties. This command has the possibility to retrieve
        device attribute properties which are arrays. It is not possible with the old
        DbGetDeviceAttributeProperty command. Nevertheless, the old command has not been
        deleted for compatibility reason

        :param argin: Str[0] = Device name
        Str[1] = Attribute name
        Str[n] = Attribute name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Device name
        Str[1] = Attribute property  number
        Str[2] = Attribute property 1 name
        Str[3] = Attribute property 1 value number (array case)
        Str[4] = Attribute property 1 value
        Str[n] = Attribute property 1 value (array case)
        Str[n + 1] = Attribute property 2 name
        Str[n + 2] = Attribute property 2 value number (array case)
        Str[n + 3] = Attribute property 2 value
        Str[n + m] = Attribute property 2 value (array case)
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceAttributeProperty2()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceAttributeProperty2) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceAttributeProperty2
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceAttributePropertyHist command:
    # ------------------------------------------------------------------
    def DbGetDeviceAttributePropertyHist(self, argin):
        """Retrieve device attribute property history

        :param argin: Str[0] = Device name
        Str[1] = Attribute name
        Str[2] = Property name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Attribute name
        Str[1] = Property name
        Str[2] = date
        Str[3] = Property value number (array case)
        Str[4] = Property value 1
        Str[n] = Property value n
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream(
            "In " + self.get_name() + ".DbGetDeviceAttributePropertyHist()"
        )
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceAttributePropertyHist) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceAttributePropertyHist
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceClassList command:
    # ------------------------------------------------------------------
    def DbGetDeviceClassList(self, argin):
        """Get Tango classes/device list embedded in a specific device server

        :param argin: Device server process name
        :type: PyTango.DevString
        :return: Str[0] = Device name
        Str[1] = Tango class
        Str[n] = Device name
        Str[n + 1] = Tango class
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceClassList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceClassList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceClassList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceDomainList command:
    # ------------------------------------------------------------------
    def DbGetDeviceDomainList(self, argin):
        """Get list of device domain name matching the specified

        :param argin: The wildcard
        :type: PyTango.DevString
        :return: Device name domain list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceDomainList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceDomainList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceDomainList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceExportedList command:
    # ------------------------------------------------------------------
    def DbGetDeviceExportedList(self, argin):
        """Get a list of exported devices whose names satisfy the filter (wildcard is

        :param argin: filter
        :type: PyTango.DevString
        :return: list of exported devices
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceExportedList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceExportedList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceExportedList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceFamilyList command:
    # ------------------------------------------------------------------
    def DbGetDeviceFamilyList(self, argin):
        """Get a list of device name families for device name matching the
        specified wildcard

        :param argin: The wildcard
        :type: PyTango.DevString
        :return: Family list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceFamilyList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceFamilyList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceFamilyList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceInfo command:
    # ------------------------------------------------------------------
    def DbGetDeviceInfo(self, argin):
        """Returns info from DbImportDevice and started/stopped dates.

        :param argin: Device name
        :type: PyTango.DevString
        :return: Str[0] = Device name
        Str[1] = CORBA IOR
        Str[2] = Device version
        Str[3] = Device Server name
        Str[4] = Device Server process host name
        Str[5] = Started date (or ? if not set)
        Str[6] = Stopped date (or ? if not set)
        Str[7] = Device class

        Lg[0] = Device exported flag
        Lg[1] = Device Server process PID (or -1 if not set)
        :rtype: PyTango.DevVarLongStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceInfo()")
        argout = [0], [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceInfo) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceInfo
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceList command:
    # ------------------------------------------------------------------
    def DbGetDeviceList(self, argin):
        """Get a list of devices for specified server and class.

        :param argin: argin[0] : server name
        argin[1] : class name
        :type: PyTango.DevVarStringArray
        :return: The list of devices for specified server and class.
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceWideList command:
    # ------------------------------------------------------------------
    def DbGetDeviceWideList(self, argin):
        """Get a list of devices whose names satisfy the filter.

        :param argin: filter
        :type: PyTango.DevString
        :return: list of exported devices
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceWideList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceWideList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceWideList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceMemberList command:
    # ------------------------------------------------------------------
    def DbGetDeviceMemberList(self, argin):
        """Get a list of device name members for device name matching the
        specified filter

        :param argin: The filter
        :type: PyTango.DevString
        :return: Device names member list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceMemberList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceMemberList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceMemberList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceProperty command:
    # ------------------------------------------------------------------
    def DbGetDeviceProperty(self, argin):
        """

        :param argin: Str[0] = Device name
        Str[1] = Property name
        Str[n] = Property name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Device name
        Str[1] = Property number
        Str[2] = Property name
        Str[3] = Property value number (array case)
        Str[4] = Property value 1
        Str[n] = Property value n (array case)
        Str[n + 1] = Property name
        Str[n + 2] = Property value number (array case)
        Str[n + 3] = Property value 1
        Str[n + m] = Property value m
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceProperty()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceProperty
        return argout

    # ------------------------------------------------------------------
    #    DbGetDevicePropertyHist command:
    # ------------------------------------------------------------------
    def DbGetDevicePropertyHist(self, argin):
        """Retrieve device  property history

        :param argin: Str[0] = Device name
        Str[2] = Property name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Property name
        Str[1] = date
        Str[2] = Property value number (array case)
        Str[3] = Property value 1
        Str[n] = Property value n
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDevicePropertyHist()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDevicePropertyHist) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDevicePropertyHist
        return argout

    # ------------------------------------------------------------------
    #    DbGetDevicePropertyList command:
    # ------------------------------------------------------------------
    def DbGetDevicePropertyList(self, argin):
        """Get property list belonging to the specified device and with
        name matching the specified filter

        :param argin: Str[0] = device name
        Str[1] = Filter
        :type: PyTango.DevVarStringArray
        :return: Property name list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDevicePropertyList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDevicePropertyList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDevicePropertyList
        return argout

    # ------------------------------------------------------------------
    #    DbGetDeviceServerClassList command:
    # ------------------------------------------------------------------
    def DbGetDeviceServerClassList(self, argin):
        """Get list of Tango classes for a device server

        :param argin: device server process name
        :type: PyTango.DevString
        :return: list of classes for this device server
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDeviceServerClassList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDeviceServerClassList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDeviceServerClassList
        return argout

    # ------------------------------------------------------------------
    #    DbGetExportdDeviceListForClass command:
    # ------------------------------------------------------------------
    def DbGetExportdDeviceListForClass(self, argin):
        """Query the database for device exported for the specified class.

        :param argin: Class name
        :type: PyTango.DevString
        :return: Device exported list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetExportdDeviceListForClass()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetExportdDeviceListForClass) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetExportdDeviceListForClass
        return argout

    # ------------------------------------------------------------------
    #    DbGetHostList command:
    # ------------------------------------------------------------------
    def DbGetHostList(self, argin):
        """Get host list with name matching the specified filter

        :param argin: The filter
        :type: PyTango.DevString
        :return: Host name list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetHostList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetHostList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetHostList
        return argout

    # ------------------------------------------------------------------
    #    DbGetHostServerList command:
    # ------------------------------------------------------------------
    def DbGetHostServerList(self, argin):
        """Get list of device server process name running on host with name matching
        the specified filter

        :param argin: The filter
        :type: PyTango.DevString
        :return: Device server process name list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetHostServerList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetHostServerList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetHostServerList
        return argout

    # ------------------------------------------------------------------
    #    DbGetHostServersInfo command:
    # ------------------------------------------------------------------
    def DbGetHostServersInfo(self, argin):
        """Get info about all servers running on specified host, name, mode and level

        :param argin: Host name
        :type: PyTango.DevString
        :return: Server info for all servers running on specified host
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetHostServersInfo()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetHostServersInfo) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetHostServersInfo
        return argout

    # ------------------------------------------------------------------
    #    DbGetInstanceNameList command:
    # ------------------------------------------------------------------
    def DbGetInstanceNameList(self, argin):
        """Returns the instance names found for specified server.

        :param argin: Server name
        :type: PyTango.DevString
        :return: The instance names found for specified server.
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetInstanceNameList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetInstanceNameList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetInstanceNameList
        return argout

    # ------------------------------------------------------------------
    #    DbGetObjectList command:
    # ------------------------------------------------------------------
    def DbGetObjectList(self, argin):
        """Get list of free object defined in database with name
        matching the specified filter

        :param argin: The filter
        :type: PyTango.DevString
        :return: Object name list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetObjectList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetObjectList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetObjectList
        return argout

    # ------------------------------------------------------------------
    #    DbGetProperty command:
    # ------------------------------------------------------------------
    def DbGetProperty(self, argin):
        """Get free object property

        :param argin: Str[0] = Object name
        Str[1] = Property name
        Str[n] = Property name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Object name
        Str[1] = Property number
        Str[2] = Property name
        Str[3] = Property value number (array case)
        Str[4] = Property value 1
        Str[n] = Property value n (array case)
        Str[n + 1] = Property name
        Str[n + 2] = Property value number (array case)
        Str[n + 3] = Property value 1
        Str[n + m] = Property value m
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetProperty()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetProperty
        return argout

    # ------------------------------------------------------------------
    #    DbGetPropertyHist command:
    # ------------------------------------------------------------------
    def DbGetPropertyHist(self, argin):
        """Retrieve object  property history

        :param argin: Str[0] = Object name
        Str[2] = Property name
        :type: PyTango.DevVarStringArray
        :return: Str[0] = Property name
        Str[1] = date
        Str[2] = Property value number (array case)
        Str[3] = Property value 1
        Str[n] = Property value n
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetPropertyHist()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetPropertyHist) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetPropertyHist
        return argout

    # ------------------------------------------------------------------
    #    DbGetPropertyList command:
    # ------------------------------------------------------------------
    def DbGetPropertyList(self, argin):
        """Get list of property defined for a free object and matching the
        specified filter

        :param argin: Str[0] = Object name
        Str[1] = filter
        :type: PyTango.DevVarStringArray
        :return: Property name list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetPropertyList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetPropertyList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetPropertyList
        return argout

    # ------------------------------------------------------------------
    #    DbGetServerInfo command:
    # ------------------------------------------------------------------
    def DbGetServerInfo(self, argin):
        """Get info about host, mode and level for specified server

        :param argin: server name
        :type: PyTango.DevString
        :return: server info
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetServerInfo()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetServerInfo) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetServerInfo
        return argout

    # ------------------------------------------------------------------
    #    DbGetServerList command:
    # ------------------------------------------------------------------
    def DbGetServerList(self, argin):
        """Get list of device server process defined in database
        with name matching the specified filter

        :param argin: The filter
        :type: PyTango.DevString
        :return: Device server process name list
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetServerList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetServerList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetServerList
        return argout

    # ------------------------------------------------------------------
    #    DbGetServerNameList command:
    # ------------------------------------------------------------------
    def DbGetServerNameList(self, argin):
        """Returns the list of server names found for the wildcard specified.
        It returns only the server executable name without instance name as DbGetServerList.

        :param argin: wildcard for server names.
        :type: PyTango.DevString
        :return: server names found.
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetServerNameList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetServerNameList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetServerNameList
        return argout

    # ------------------------------------------------------------------
    #    DbImportDevice command:
    # ------------------------------------------------------------------
    def DbImportDevice(self, argin):
        """Import a device from the database

        :param argin: Device name (or alias)
        :type: PyTango.DevString
        :return: Str[0] = device name
        Str[1] = CORBA IOR
        Str[2] = device version
        Str[3] = device server process name
        Str[4] = host name
        Str[5] = Tango class name

        Lg[0] = Exported flag
        Lg[1] = Device server process PID
        :rtype: PyTango.DevVarLongStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbImportDevice()")
        argout = [0], [""]
        # ----- PROTECTED REGION ID(DataBase.DbImportDevice) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbImportDevice
        return argout

    # ------------------------------------------------------------------
    #    DbImportEvent command:
    # ------------------------------------------------------------------
    def DbImportEvent(self, argin):
        """Get event channel info from database

        :param argin: name of event channel or factory
        :type: PyTango.DevString
        :return: export information e.g. IOR
        :rtype: PyTango.DevVarLongStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbImportEvent()")
        argout = [0], [""]
        # ----- PROTECTED REGION ID(DataBase.DbImportEvent) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbImportEvent
        return argout

    # ------------------------------------------------------------------
    #    DbInfo command:
    # ------------------------------------------------------------------
    def DbInfo(self):
        """Get miscellaneous numbers on information
        stored in database

        :param :
        :type: PyTango.DevVoid
        :return: Miscellaneous info like:
        - Device defined in database
        - Device marked as exported in database
        - Device server process defined in database
        - Device server process marked as exported in database
        - Device properties defined in database
        - Class properties defined in database
        - Device attribute properties defined in database
        - Class attribute properties defined in database
        - Object properties defined in database
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbInfo()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbInfo) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbInfo
        return argout

    # ------------------------------------------------------------------
    #    DbPutAttributeAlias command:
    # ------------------------------------------------------------------
    def DbPutAttributeAlias(self, argin):
        """Define an alias for an attribute

        :param argin: Str[0] = attribute name
        Str[1] = attribute alias
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutAttributeAlias()")
        # ----- PROTECTED REGION ID(DataBase.DbPutAttributeAlias) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutAttributeAlias

    # ------------------------------------------------------------------
    #    DbPutClassAttributeProperty command:
    # ------------------------------------------------------------------
    def DbPutClassAttributeProperty(self, argin):
        """Create/Update class attribute property(ies) in database

        :param argin: Str[0] = Tango class name
        Str[1] = Attribute number
        Str[2] = Attribute name
        Str[3] = Property number
        Str[4] = Property name
        Str[5] = Property value
        .....
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutClassAttributeProperty()")
        # ----- PROTECTED REGION ID(DataBase.DbPutClassAttributeProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutClassAttributeProperty

    # ------------------------------------------------------------------
    #    DbPutClassAttributeProperty2 command:
    # ------------------------------------------------------------------
    def DbPutClassAttributeProperty2(self, argin):
        """This command adds support for array properties compared to the previous one
        called DbPutClassAttributeProperty. The old comman is still there for compatibility reason

        :param argin: Str[0] = Tango class name
        Str[1] = Attribute number
        Str[2] = Attribute name
        Str[3] = Property number
        Str[4] = Property name
        Str[5] = Property value number (array case)
        Str[5] = Property value 1
        Str[n] = Property value n (array case)
        .....
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutClassAttributeProperty2()")
        # ----- PROTECTED REGION ID(DataBase.DbPutClassAttributeProperty2) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutClassAttributeProperty2

    # ------------------------------------------------------------------
    #    DbPutClassProperty command:
    # ------------------------------------------------------------------
    def DbPutClassProperty(self, argin):
        """Create / Update class property(ies)

        :param argin: Str[0] = Tango class name
        Str[1] = Property number
        Str[2] = Property name
        Str[3] = Property value number
        Str[4] = Property value 1
        Str[n] = Property value n
        ....
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutClassProperty()")
        # ----- PROTECTED REGION ID(DataBase.DbPutClassProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutClassProperty

    # ------------------------------------------------------------------
    #    DbPutDeviceAlias command:
    # ------------------------------------------------------------------
    def DbPutDeviceAlias(self, argin):
        """Define alias for  a given device name

        :param argin: Str[0] = device name
        Str[1] = alias name
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutDeviceAlias()")
        # ----- PROTECTED REGION ID(DataBase.DbPutDeviceAlias) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutDeviceAlias

    # ------------------------------------------------------------------
    #    DbPutDeviceAttributeProperty command:
    # ------------------------------------------------------------------
    def DbPutDeviceAttributeProperty(self, argin):
        """Create/Update device attribute property(ies) in database

        :param argin: Str[0] = Device name
        Str[1] = Attribute number
        Str[2] = Attribute name
        Str[3] = Property number
        Str[4] = Property name
        Str[5] = Property value
        .....
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutDeviceAttributeProperty()")
        # ----- PROTECTED REGION ID(DataBase.DbPutDeviceAttributeProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutDeviceAttributeProperty

    # ------------------------------------------------------------------
    #    DbPutDeviceAttributeProperty2 command:
    # ------------------------------------------------------------------
    def DbPutDeviceAttributeProperty2(self, argin):
        """Put device attribute property. This command adds the possibility to have attribute property
        which are arrays. Not possible with the old DbPutDeviceAttributeProperty command.
        This old command is not deleted for compatibility reasons.

        :param argin: Str[0] = Device name
        Str[1] = Attribute number
        Str[2] = Attribute name
        Str[3] = Property number
        Str[4] = Property name
        Str[5] = Property value number (array case)
        Str[5] = Property value 1
        Str[n] = Property value n (array case)
        .....
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutDeviceAttributeProperty2()")
        # ----- PROTECTED REGION ID(DataBase.DbPutDeviceAttributeProperty2) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutDeviceAttributeProperty2

    # ------------------------------------------------------------------
    #    DbPutDeviceProperty command:
    # ------------------------------------------------------------------
    def DbPutDeviceProperty(self, argin):
        """Create / Update device property(ies)

        :param argin: Str[0] = Tango device name
        Str[1] = Property number
        Str[2] = Property name
        Str[3] = Property value number
        Str[4] = Property value 1
        Str[n] = Property value n
        ....
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutDeviceProperty()")
        # ----- PROTECTED REGION ID(DataBase.DbPutDeviceProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutDeviceProperty

    # ------------------------------------------------------------------
    #    DbPutProperty command:
    # ------------------------------------------------------------------
    def DbPutProperty(self, argin):
        """Create / Update free object property(ies)

        :param argin: Str[0] = Object name
        Str[1] = Property number
        Str[2] = Property name
        Str[3] = Property value number
        Str[4] = Property value 1
        Str[n] = Property value n
        ....
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutProperty()")
        # ----- PROTECTED REGION ID(DataBase.DbPutProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutProperty

    # ------------------------------------------------------------------
    #    DbPutServerInfo command:
    # ------------------------------------------------------------------
    def DbPutServerInfo(self, argin):
        """Update server info including host, mode and level

        :param argin: server info
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbPutServerInfo()")
        # ----- PROTECTED REGION ID(DataBase.DbPutServerInfo) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbPutServerInfo

    # ------------------------------------------------------------------
    #    DbUnExportDevice command:
    # ------------------------------------------------------------------
    def DbUnExportDevice(self, argin):
        """Mark a device as non exported in database

        :param argin: Device name
        :type: PyTango.DevString
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbUnExportDevice()")
        # ----- PROTECTED REGION ID(DataBase.DbUnExportDevice) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbUnExportDevice

    # ------------------------------------------------------------------
    #    DbUnExportEvent command:
    # ------------------------------------------------------------------
    def DbUnExportEvent(self, argin):
        """Mark one event channel as non exported in database

        :param argin: name of event channel or factory to unexport
        :type: PyTango.DevString
        :return: none
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbUnExportEvent()")
        # ----- PROTECTED REGION ID(DataBase.DbUnExportEvent) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbUnExportEvent

    # ------------------------------------------------------------------
    #    DbUnExportServer command:
    # ------------------------------------------------------------------
    def DbUnExportServer(self, argin):
        """Mark all devices belonging to a specified device server
        process as non exported

        :param argin: Device server name (executable/instance)
        :type: PyTango.DevString
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".DbUnExportServer()")
        # ----- PROTECTED REGION ID(DataBase.DbUnExportServer) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbUnExportServer

    # ------------------------------------------------------------------
    #    ResetTimingValues command:
    # ------------------------------------------------------------------
    def ResetTimingValues(self):
        """Reset the timing attribute values.

        :param :
        :type: PyTango.DevVoid
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream("In " + self.get_name() + ".ResetTimingValues()")
        # ----- PROTECTED REGION ID(DataBase.ResetTimingValues) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.ResetTimingValues

    # ------------------------------------------------------------------
    #    DbGetDataForServerCache command:
    # ------------------------------------------------------------------
    def DbGetDataForServerCache(self, argin):
        """This command returns all the data needed by a device server process during its
        startup sequence. The aim of this command is to minimize database access during
        device server startup sequence.

        :param argin: Elt[0] = DS name (exec_name/inst_name), Elt[1] = Host name
        :type: PyTango.DevVarStringArray
        :return: All the data needed by the device server during its startup sequence. Precise list depend on the device server
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetDataForServerCache()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetDataForServerCache) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetDataForServerCache
        return argout

    # ------------------------------------------------------------------
    #    DbDeleteAllDeviceAttributeProperty command:
    # ------------------------------------------------------------------
    def DbDeleteAllDeviceAttributeProperty(self, argin):
        """Delete all attribute properties for the specified device attribute(s)

        :param argin: str[0] = device name
        Str[1]...str[n] = attribute name(s)
        :type: PyTango.DevVarStringArray
        :return:
        :rtype: PyTango.DevVoid"""
        self.debug_stream(
            "In " + self.get_name() + ".DbDeleteAllDeviceAttributeProperty()"
        )
        # ----- PROTECTED REGION ID(DataBase.DbDeleteAllDeviceAttributeProperty) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbDeleteAllDeviceAttributeProperty

    # ------------------------------------------------------------------
    #    DbMySqlSelect command:
    # ------------------------------------------------------------------
    def DbMySqlSelect(self, argin):
        """This is a very low level command.
        It executes the specified  SELECT command on TANGO database and returns its result without filter.

        :param argin: MySql Select command
        :type: PyTango.DevString
        :return: MySql Select command result
         - svalues : select results
         - lvalue[n] : =0 if svalue[n] is null else =1
         (last lvalue -1) is number of rows, (last lvalue) is number of fields
        :rtype: PyTango.DevVarLongStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbMySqlSelect()")
        argout = [0], [""]
        # ----- PROTECTED REGION ID(DataBase.DbMySqlSelect) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbMySqlSelect
        return argout

    # ------------------------------------------------------------------
    #    DbGetCSDbServerList command:
    # ------------------------------------------------------------------
    def DbGetCSDbServerList(self):
        """Get a list of host:port for all database server defined in the control system

        :param :
        :type: PyTango.DevVoid
        :return: List of host:port with one element for each database server
        :rtype: PyTango.DevVarStringArray"""
        self.debug_stream("In " + self.get_name() + ".DbGetCSDbServerList()")
        argout = [""]
        # ----- PROTECTED REGION ID(DataBase.DbGetCSDbServerList) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetCSDbServerList
        return argout

    # ------------------------------------------------------------------
    #    DbGetAttributeAlias2 command:
    # ------------------------------------------------------------------
    def DbGetAttributeAlias2(self, argin):
        """Get the attribute alias from the attribute name.
        Returns one empty string if nothing found in database

        :param argin: The attribute name (dev_name/att_name)
        :type: PyTango.DevString
        :return: The attribute alias name (or empty string)
        :rtype: PyTango.DevString"""
        self.debug_stream("In " + self.get_name() + ".DbGetAttributeAlias2()")
        argout = ""
        # ----- PROTECTED REGION ID(DataBase.DbGetAttributeAlias2) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetAttributeAlias2
        return argout

    # ------------------------------------------------------------------
    #    DbGetAliasAttribute command:
    # ------------------------------------------------------------------
    def DbGetAliasAttribute(self, argin):
        """Get the attribute name from the given alias.
        If the given alias is not found in database, returns an empty string

        :param argin: The attribute alias
        :type: PyTango.DevString
        :return: The attribute name (dev_name/att_name)
        :rtype: PyTango.DevString"""
        self.debug_stream("In " + self.get_name() + ".DbGetAliasAttribute()")
        argout = ""
        # ----- PROTECTED REGION ID(DataBase.DbGetAliasAttribute) ENABLED START -----#

        # ----- PROTECTED REGION END -----#	//	DataBase.DbGetAliasAttribute
        return argout


# ==================================================================
#
#    DataBaseClass class definition
#
# ==================================================================
class DataBaseClass(PyTango.DeviceClass):
    #    Class Properties
    class_property_list = {}

    #    Device Properties
    device_property_list = {}

    #    Command definitions
    cmd_list = {
        "DbAddDevice": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Full device server process name\nStr[1] = Device name\nStr[2] = Tango class name",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbAddServer": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Full device server name\nStr[1] = Device(s) name\nStr[2] = Tango class name\nStr[n] = Device name\nStr[n + 1] = Tango class name",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteAttributeAlias": [
            [PyTango.DevString, "Attriibute alias name."],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteClassAttribute": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Attribute name",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteClassAttributeProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Attribute name\nStr[2] = Property name\nStr[n] = Property name",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteClassProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Property name\nStr[n] = Property name",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteDevice": [
            [PyTango.DevString, "device name"],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteDeviceAlias": [
            [PyTango.DevString, "device alias name"],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteDeviceAttribute": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Attribute name",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteDeviceAttributeProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Attribute name\nStr[2] = Property name\nStr[n] = Property name",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteDeviceProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Property name\nStr[n] = Property name",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0]  = Object name\nStr[1] = Property name\nStr[n] = Property name",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteServer": [
            [PyTango.DevString, "Device server name"],
            [PyTango.DevVoid, "none"],
        ],
        "DbDeleteServerInfo": [
            [PyTango.DevString, "Device server name"],
            [PyTango.DevVoid, "none"],
        ],
        "DbExportDevice": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = CORBA IOR\nStr[2] = Device server process host name\nStr[3] = Device server process PID or string ``null``\nStr[4] = Device server process version",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbExportEvent": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = event channel name (or factory name)\nStr[1] = CORBA IOR\nStr[2] = Notifd host name\nStr[3] = Notifd pid\nStr[4] = Notifd version",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbGetAliasDevice": [
            [PyTango.DevString, "Alias name"],
            [PyTango.DevString, "Device name"],
        ],
        "DbGetAttributeAlias": [
            [PyTango.DevString, "The attribute alias name"],
            [PyTango.DevString, "The attribute name (device/attribute)"],
        ],
        "DbGetAttributeAliasList": [
            [PyTango.DevString, "attribute alias filter string (eg: att*)"],
            [PyTango.DevVarStringArray, "attribute aliases"],
        ],
        "DbGetClassAttributeList": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Attribute name filter (eg: att*)",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Class attribute name\nStr[n] = Class attribute name",
            ],
        ],
        "DbGetClassAttributeProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Attribute name\nStr[n] = Attribute name",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Attribute property  number\nStr[2] = Attribute property 1 name\nStr[3] = Attribute property 1 value\nStr[n + 1] = Attribute property 2 name\nStr[n + 2] = Attribute property 2 value",
            ],
        ],
        "DbGetClassAttributeProperty2": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Attribute name\nStr[n] = Attribute name",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Attribute property  number\nStr[2] = Attribute property 1 name\nStr[3] = Attribute property 1 value number (array case)\nStr[4] = Attribute property 1 value\nStr[n] = Attribute property 1 value (array case)\nStr[n + 1] = Attribute property 2 name\nStr[n + 2] = Attribute property 2 value number (array case)\nStr[n + 3] = Attribute property 2 value\nStr[n + m] = Attribute property 2 value (array case)",
            ],
        ],
        "DbGetClassAttributePropertyHist": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class\nStr[1] = Attribute name\nStr[2] = Property name",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Attribute name\nStr[1] = Property name\nStr[2] = date\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n",
            ],
        ],
        "DbGetClassForDevice": [
            [PyTango.DevString, "Device name"],
            [PyTango.DevString, "Device Tango class"],
        ],
        "DbGetClassInheritanceForDevice": [
            [PyTango.DevString, "Device name"],
            [
                PyTango.DevVarStringArray,
                "Classes off the specified device.\n[0] - is the class of the device.\n[1] - is the class from the device class is inherited.\n........and so on",
            ],
        ],
        "DbGetClassList": [
            [PyTango.DevString, "Filter"],
            [PyTango.DevVarStringArray, "Class list"],
        ],
        "DbGetClassProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class\nStr[1] = Property name\nStr[2] = Property name",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number (array case)\nStr[4] = Property value\nStr[n] = Propery value (array case)\n....",
            ],
        ],
        "DbGetClassPropertyHist": [
            [PyTango.DevVarStringArray, "Str[0] = Tango class\nStr[1] = Property name"],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Property name\nStr[1] = date\nStr[2] = Property value number (array case)\nStr[3] = Property value 1\nStr[n] = Property value n",
            ],
        ],
        "DbGetClassPropertyList": [
            [PyTango.DevString, "The filter"],
            [PyTango.DevVarStringArray, "Property name list"],
        ],
        "DbGetDeviceAlias": [
            [PyTango.DevString, "The device name"],
            [PyTango.DevString, "The alias found"],
        ],
        "DbGetDeviceAliasList": [
            [PyTango.DevString, "The filter"],
            [PyTango.DevVarStringArray, "Device alias list"],
        ],
        "DbGetDeviceAttributeList": [
            [PyTango.DevVarStringArray, "Str[0] = Device name\nStr[1] = Wildcard"],
            [PyTango.DevVarStringArray, "attribute name list"],
        ],
        "DbGetDeviceAttributeProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Attribute name\nStr[n] = Attribute name",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Attribute property  number\nStr[2] = Attribute property 1 name\nStr[3] = Attribute property 1 value\nStr[n + 1] = Attribute property 2 name\nStr[n + 2] = Attribute property 2 value",
            ],
        ],
        "DbGetDeviceAttributeProperty2": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Attribute name\nStr[n] = Attribute name",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Attribute property  number\nStr[2] = Attribute property 1 name\nStr[3] = Attribute property 1 value number (array case)\nStr[4] = Attribute property 1 value\nStr[n] = Attribute property 1 value (array case)\nStr[n + 1] = Attribute property 2 name\nStr[n + 2] = Attribute property 2 value number (array case)\nStr[n + 3] = Attribute property 2 value\nStr[n + m] = Attribute property 2 value (array case)",
            ],
        ],
        "DbGetDeviceAttributePropertyHist": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Attribute name\nStr[2] = Property name",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Attribute name\nStr[1] = Property name\nStr[2] = date\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n",
            ],
        ],
        "DbGetDeviceClassList": [
            [PyTango.DevString, "Device server process name"],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Tango class\nStr[n] = Device name\nStr[n + 1] = Tango class",
            ],
        ],
        "DbGetDeviceDomainList": [
            [PyTango.DevString, "The wildcard"],
            [PyTango.DevVarStringArray, "Device name domain list"],
        ],
        "DbGetDeviceExportedList": [
            [PyTango.DevString, "filter"],
            [PyTango.DevVarStringArray, "list of exported devices"],
        ],
        "DbGetDeviceFamilyList": [
            [PyTango.DevString, "The wildcard"],
            [PyTango.DevVarStringArray, "Family list"],
        ],
        "DbGetDeviceInfo": [
            [PyTango.DevString, "Device name"],
            [
                PyTango.DevVarLongStringArray,
                "Str[0] = Device name\nStr[1] = CORBA IOR\nStr[2] = Device version\nStr[3] = Device Server name\nStr[4] = Device Server process host name\nStr[5] = Started date (or ? if not set)\nStr[6] = Stopped date (or ? if not set)\nStr[7] = Device class\n\nLg[0] = Device exported flag\nLg[1] = Device Server process PID (or -1 if not set)",
            ],
        ],
        "DbGetDeviceList": [
            [
                PyTango.DevVarStringArray,
                "argin[0] : server name\nargin[1] : class name",
            ],
            [
                PyTango.DevVarStringArray,
                "The list of devices for specified server and class.",
            ],
        ],
        "DbGetDeviceWideList": [
            [PyTango.DevString, "filter"],
            [PyTango.DevVarStringArray, "list of exported devices"],
        ],
        "DbGetDeviceMemberList": [
            [PyTango.DevString, "The filter"],
            [PyTango.DevVarStringArray, "Device names member list"],
        ],
        "DbGetDeviceProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Property name\nStr[n] = Property name",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n (array case)\nStr[n + 1] = Property name\nStr[n + 2] = Property value number (array case)\nStr[n + 3] = Property value 1\nStr[n + m] = Property value m",
            ],
        ],
        "DbGetDevicePropertyHist": [
            [PyTango.DevVarStringArray, "Str[0] = Device name\nStr[2] = Property name"],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Property name\nStr[1] = date\nStr[2] = Property value number (array case)\nStr[3] = Property value 1\nStr[n] = Property value n",
            ],
        ],
        "DbGetDevicePropertyList": [
            [PyTango.DevVarStringArray, "Str[0] = device name\nStr[1] = Filter"],
            [PyTango.DevVarStringArray, "Property name list"],
        ],
        "DbGetDeviceServerClassList": [
            [PyTango.DevString, "device server process name"],
            [PyTango.DevVarStringArray, "list of classes for this device server"],
        ],
        "DbGetExportdDeviceListForClass": [
            [PyTango.DevString, "Class name"],
            [PyTango.DevVarStringArray, "Device exported list"],
        ],
        "DbGetHostList": [
            [PyTango.DevString, "The filter"],
            [PyTango.DevVarStringArray, "Host name list"],
        ],
        "DbGetHostServerList": [
            [PyTango.DevString, "The filter"],
            [PyTango.DevVarStringArray, "Device server process name list"],
        ],
        "DbGetHostServersInfo": [
            [PyTango.DevString, "Host name"],
            [
                PyTango.DevVarStringArray,
                "Server info for all servers running on specified host",
            ],
        ],
        "DbGetInstanceNameList": [
            [PyTango.DevString, "Server name"],
            [
                PyTango.DevVarStringArray,
                "The instance names found for specified server.",
            ],
        ],
        "DbGetObjectList": [
            [PyTango.DevString, "The filter"],
            [PyTango.DevVarStringArray, "Object name list"],
        ],
        "DbGetProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Object name\nStr[1] = Property name\nStr[n] = Property name",
            ],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Object name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number (array case)\nStr[4] = Property value 1\nStr[n] = Property value n (array case)\nStr[n + 1] = Property name\nStr[n + 2] = Property value number (array case)\nStr[n + 3] = Property value 1\nStr[n + m] = Property value m",
            ],
        ],
        "DbGetPropertyHist": [
            [PyTango.DevVarStringArray, "Str[0] = Object name\nStr[2] = Property name"],
            [
                PyTango.DevVarStringArray,
                "Str[0] = Property name\nStr[1] = date\nStr[2] = Property value number (array case)\nStr[3] = Property value 1\nStr[n] = Property value n",
            ],
        ],
        "DbGetPropertyList": [
            [PyTango.DevVarStringArray, "Str[0] = Object name\nStr[1] = filter"],
            [PyTango.DevVarStringArray, "Property name list"],
        ],
        "DbGetServerInfo": [
            [PyTango.DevString, "server name"],
            [PyTango.DevVarStringArray, "server info"],
        ],
        "DbGetServerList": [
            [PyTango.DevString, "The filter"],
            [PyTango.DevVarStringArray, "Device server process name list"],
        ],
        "DbGetServerNameList": [
            [PyTango.DevString, "wildcard for server names."],
            [PyTango.DevVarStringArray, "server names found."],
        ],
        "DbImportDevice": [
            [PyTango.DevString, "Device name (or alias)"],
            [
                PyTango.DevVarLongStringArray,
                "Str[0] = device name\nStr[1] = CORBA IOR\nStr[2] = device version\nStr[3] = device server process name\nStr[4] = host name\nStr[5] = Tango class name\n\nLg[0] = Exported flag\nLg[1] = Device server process PID",
            ],
        ],
        "DbImportEvent": [
            [PyTango.DevString, "name of event channel or factory"],
            [PyTango.DevVarLongStringArray, "export information e.g. IOR"],
        ],
        "DbInfo": [
            [PyTango.DevVoid, "none"],
            [
                PyTango.DevVarStringArray,
                "Miscellaneous info like:\n- Device defined in database\n- Device marked as exported in database\n- Device server process defined in database\n- Device server process marked as exported in database\n- Device properties defined in database\n- Class properties defined in database\n- Device attribute properties defined in database\n- Class attribute properties defined in database\n- Object properties defined in database",
            ],
        ],
        "DbPutAttributeAlias": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = attribute name\nStr[1] = attribute alias",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbPutClassAttributeProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Attribute number\nStr[2] = Attribute name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value\n.....",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbPutClassAttributeProperty2": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Attribute number\nStr[2] = Attribute name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value number (array case)\nStr[5] = Property value 1\nStr[n] = Property value n (array case)\n.....",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbPutClassProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango class name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number\nStr[4] = Property value 1\nStr[n] = Property value n\n....",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbPutDeviceAlias": [
            [PyTango.DevVarStringArray, "Str[0] = device name\nStr[1] = alias name"],
            [PyTango.DevVoid, "none"],
        ],
        "DbPutDeviceAttributeProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Attribute number\nStr[2] = Attribute name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value\n.....",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbPutDeviceAttributeProperty2": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Device name\nStr[1] = Attribute number\nStr[2] = Attribute name\nStr[3] = Property number\nStr[4] = Property name\nStr[5] = Property value number (array case)\nStr[5] = Property value 1\nStr[n] = Property value n (array case)\n.....",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbPutDeviceProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Tango device name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number\nStr[4] = Property value 1\nStr[n] = Property value n\n....",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbPutProperty": [
            [
                PyTango.DevVarStringArray,
                "Str[0] = Object name\nStr[1] = Property number\nStr[2] = Property name\nStr[3] = Property value number\nStr[4] = Property value 1\nStr[n] = Property value n\n....",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbPutServerInfo": [
            [PyTango.DevVarStringArray, "server info"],
            [PyTango.DevVoid, "none"],
        ],
        "DbUnExportDevice": [
            [PyTango.DevString, "Device name"],
            [PyTango.DevVoid, "none"],
        ],
        "DbUnExportEvent": [
            [PyTango.DevString, "name of event channel or factory to unexport"],
            [PyTango.DevVoid, "none"],
        ],
        "DbUnExportServer": [
            [PyTango.DevString, "Device server name (executable/instance)"],
            [PyTango.DevVoid, "none"],
        ],
        "ResetTimingValues": [[PyTango.DevVoid, "none"], [PyTango.DevVoid, "none"]],
        "DbGetDataForServerCache": [
            [
                PyTango.DevVarStringArray,
                "Elt[0] = DS name (exec_name/inst_name), Elt[1] = Host name",
            ],
            [
                PyTango.DevVarStringArray,
                "All the data needed by the device server during its startup sequence. Precise list depend on the device server",
            ],
        ],
        "DbDeleteAllDeviceAttributeProperty": [
            [
                PyTango.DevVarStringArray,
                "str[0] = device name\nStr[1]...str[n] = attribute name(s)",
            ],
            [PyTango.DevVoid, "none"],
        ],
        "DbMySqlSelect": [
            [PyTango.DevString, "MySql Select command"],
            [
                PyTango.DevVarLongStringArray,
                "MySql Select command result\n - svalues : select results\n - lvalue[n] : =0 if svalue[n] is null else =1\n (last lvalue -1) is number of rows, (last lvalue) is number of fields",
            ],
        ],
        "DbGetCSDbServerList": [
            [PyTango.DevVoid, "none"],
            [
                PyTango.DevVarStringArray,
                "List of host:port with one element for each database server",
            ],
        ],
        "DbGetAttributeAlias2": [
            [PyTango.DevString, "The attribute name (dev_name/att_name)"],
            [PyTango.DevString, "The attribute alias name (or empty string)"],
        ],
        "DbGetAliasAttribute": [
            [PyTango.DevString, "The attribute alias"],
            [PyTango.DevString, "The attribute name (dev_name/att_name)"],
        ],
    }

    #    Attribute definitions
    attr_list = {
        "StoredProcedureRelease": [[PyTango.DevString, PyTango.SCALAR, PyTango.READ]],
        "Timing_average": [[PyTango.DevDouble, PyTango.SPECTRUM, PyTango.READ, 64]],
        "Timing_minimum": [[PyTango.DevDouble, PyTango.SPECTRUM, PyTango.READ, 64]],
        "Timing_maximum": [[PyTango.DevDouble, PyTango.SPECTRUM, PyTango.READ, 64]],
        "Timing_calls": [[PyTango.DevDouble, PyTango.SPECTRUM, PyTango.READ, 64]],
        "Timing_index": [[PyTango.DevString, PyTango.SPECTRUM, PyTango.READ, 64]],
        "Timing_info": [[PyTango.DevString, PyTango.SPECTRUM, PyTango.READ, 64]],
    }

    # ------------------------------------------------------------------
    #    DataBaseClass Constructor
    # ------------------------------------------------------------------
    def __init__(self, name):
        PyTango.DeviceClass.__init__(self, name)
        self.set_type(name)
        print("In DataBase Class  constructor")


# ==================================================================
#
#    DataBase class main method
#
# ==================================================================
def main():
    try:
        py = PyTango.Util(sys.argv)
        py.add_class(DataBaseClass, DataBase, "DataBase")

        U = PyTango.Util.instance()
        U.server_init()
        U.server_run()

    except PyTango.DevFailed as e:
        print("-------> Received a DevFailed exception:", e)
    except Exception as e:
        print("-------> An unforeseen exception occured....", e)


if __name__ == "__main__":
    main()
