# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datamigration.aio import DataMigrationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataMigrationManagementFilesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataMigrationManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_files_list(self, resource_group):
        response = self.client.files.list(
            group_name="str",
            service_name="str",
            project_name="str",
            api_version="2025-06-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_files_get(self, resource_group):
        response = await self.client.files.get(
            group_name="str",
            service_name="str",
            project_name="str",
            file_name="str",
            api_version="2025-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_files_create_or_update(self, resource_group):
        response = await self.client.files.create_or_update(
            group_name="str",
            service_name="str",
            project_name="str",
            file_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "extension": "str",
                    "filePath": "str",
                    "lastModified": "2020-02-20 00:00:00",
                    "mediaType": "str",
                    "size": 0,
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_files_delete(self, resource_group):
        response = await self.client.files.delete(
            group_name="str",
            service_name="str",
            project_name="str",
            file_name="str",
            api_version="2025-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_files_update(self, resource_group):
        response = await self.client.files.update(
            group_name="str",
            service_name="str",
            project_name="str",
            file_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "extension": "str",
                    "filePath": "str",
                    "lastModified": "2020-02-20 00:00:00",
                    "mediaType": "str",
                    "size": 0,
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_files_read(self, resource_group):
        response = await self.client.files.read(
            group_name="str",
            service_name="str",
            project_name="str",
            file_name="str",
            api_version="2025-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_files_read_write(self, resource_group):
        response = await self.client.files.read_write(
            group_name="str",
            service_name="str",
            project_name="str",
            file_name="str",
            api_version="2025-06-30",
        )

        # please add some check logic here by yourself
        # ...
