% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel.R
\name{theme_excel_new}
\alias{theme_excel_new}
\title{ggplot theme similar to current Excel plot defaults}
\usage{
theme_excel_new(base_size = 9, base_family = "sans")
}
\arguments{
\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}
}
\value{
An object of class \code{\link[ggplot2]{theme}()}.
}
\description{
Theme for ggplot2 that is similar to the default style of charts in
current versions of Microsoft Excel.
}
\examples{
library("ggplot2")

p <- ggplot(mtcars) +
  geom_point(aes(x = wt, y = mpg, colour = factor(gear))) +
  facet_wrap(~am)
p + theme_excel_new() + scale_colour_excel_new()
}
\seealso{
Other themes excel: 
\code{\link{theme_excel}()}
}
\concept{themes excel}
