% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotl-package.R
\docType{package}
\name{rotl}
\alias{rotl-package}
\alias{rotl}
\title{An Interface to the Open Tree of Life API}
\description{
The Open Tree of Life is an NSF funded project that is generating
an online, comprehensive phylogenetic tree for 1.8 million
species. \code{rotl} provides an interface that allows you to
query and retrieve the parts of the tree of life that is of
interest to you.
}
\details{
\code{rotl} provides function to most of the end points the API
provides. The documentation of the API is available at:
\url{https://github.com/OpenTreeOfLife/opentree/wiki/Open-Tree-of-Life-APIs}
}
\section{Customizing API calls}{


    All functions that use API end points can take 2 arguments to
    customize the API call and are passed as \code{...} arguments.

    \describe{

    \item{ \code{otl_v}}{This argument controls which version
    of the API your call is using. The default value for this
    argument is a call to the non-exported function
    \code{otl_version()} which returns the current version of the
    Open Tree of Life APIs (v2).}

    \item{ \code{dev_url}}{This argument controls whether to use
    the development version of the API. By default, \code{dev_url}
    is set to \code{FALSE}, using \code{dev_url = TRUE} in your
    function calls will use the development version.}

    }

    For example, to use the development version of the API, you
    could use: \code{tnrs_match_names("anas", dev_url=TRUE)}

    Additional arguments can also be passed to the
    \code{\link[httr]{GET}} and \code{\link[httr]{POST}} methods.
}

\section{Acknowledgments}{


    This package was started during the Open Tree of Life Hackathon
    organized by the OpenTree of Life, the NESCent Hackathon
    Interoperability Phylogenetic group, and Arbor.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/rotl/}
  \item \url{https://github.com/ropensci/rotl}
  \item Report bugs at \url{https://github.com/ropensci/rotl/issues}
}

}
\author{
\strong{Maintainer}: Francois Michonneau \email{francois.michonneau@gmail.com} (\href{https://orcid.org/0000-0002-9092-966X}{ORCID})

Authors:
\itemize{
  \item Joseph Brown (\href{https://orcid.org/0000-0002-3835-8062}{ORCID})
  \item David Winter (\href{https://orcid.org/0000-0002-6165-0029}{ORCID})
}

Other contributors:
\itemize{
  \item Scott Chamberlain (\href{https://orcid.org/0000-0003-1444-9135}{ORCID}) [reviewer]
}

}
