% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{getMutatedPositions}
\alias{getMutatedPositions}
\title{Find the location of mutations in a sequence}
\usage{
getMutatedPositions(
  samples,
  germlines,
  ignored_regex = "[\\\\.N-]",
  match_instead = FALSE
)
}
\arguments{
\item{samples}{vector of strings representing aligned sequences}

\item{germlines}{vector of strings representing aligned sequences
to which \code{samples} will be compared. If only
one string is submitted, it will be used for all
\code{samples}.}

\item{ignored_regex}{regular expression indicating what characters
should be ignored (such as gaps and N nucleotides).}

\item{match_instead}{if \code{TRUE}, the function returns the positions
that are the same instead of those that are
different.}
}
\value{
A list of the nucleotide positions of any differences between the
          input vectors.
}
\description{
\code{getMutatedPositions} takes two vectors of aligned sequences and
compares pairs of sequences. It returns a list of the nucleotide positions of
any differences.
}
\examples{
# Create strings to act as a sample sequences and a reference sequence
seqs <- c("----GATA", "GAGAGAGA", "TANA")
ref <- "GATAGATA"

# Find the differences between the two
getMutatedPositions(seqs, ref)

}
