% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visGetUtils.R
\name{visGetViewPosition}
\alias{visGetViewPosition}
\title{Function to get current view position, with shiny only.}
\usage{
visGetViewPosition(graph, input = paste0(graph$id, "_viewPosition"))
}
\arguments{
\item{graph}{: a \code{ \link[visNetwork]{visNetworkProxy}}  object}

\item{input}{: name of shiny input created. Default to paste0(graph$id, "_viewPosition")}
}
\description{
Function to get current view position, with shiny only. Returns the current central focus point of the view.
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}

}
\references{
See online documentation \url{https://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link[visNetwork]{visNodes} for nodes options,  \link[visNetwork]{visEdges} for edges options,  \link[visNetwork]{visGroups} for groups options, 
\link[visNetwork]{visLegend} for adding legend,  \link[visNetwork]{visOptions} for custom option,  \link[visNetwork]{visLayout} &  \link[visNetwork]{visHierarchicalLayout} for layout, 
\link[visNetwork]{visPhysics} for control physics,  \link[visNetwork]{visInteraction} for interaction,  \link[visNetwork]{visNetworkProxy} &  \link[visNetwork]{visFocus} &  \link[visNetwork]{visFit} for animation within shiny,
\link[visNetwork]{visDocumentation},  \link[visNetwork]{visEvents},  \link[visNetwork]{visConfigure} ...
}
