% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascat.runAscat.R
\name{ascat.runAscat}
\alias{ascat.runAscat}
\title{ascat.runAscat}
\usage{
ascat.runAscat(
  ASCATobj,
  gamma = 0.55,
  pdfPlot = FALSE,
  y_limit = 5,
  circos = NA,
  min_ploidy = 1.5,
  max_ploidy = 5.5,
  min_purity = 0.1,
  max_purity = 1.05,
  rho_manual = NA,
  psi_manual = NA,
  img.dir = ".",
  img.prefix = "",
  write_segments = FALSE
)
}
\arguments{
\item{ASCATobj}{an ASCAT object from ascat.aspcf}

\item{gamma}{technology parameter, compaction of Log R profiles (expected decrease in case of deletion in diploid sample, 100\% aberrant cells; 1 in ideal case, 0.55 of Illumina 109K arrays)}

\item{pdfPlot}{Optional flag if nonrounded plots and ASCAT profile in pdf format are desired. Default=F}

\item{y_limit}{Optional parameter determining the size of the y axis in the nonrounded plot and ASCAT profile. Default=5}

\item{circos}{Optional file to output the non-rounded values in Circos track format. Default=NA}

\item{min_ploidy}{optional numerical parameter determining the minimum boundary of the ploidy solution search space (expert parameter, don't adapt unless you know what you're doing). Default=1.5}

\item{max_ploidy}{optional numerical parameter determining the maximum boundary of the ploidy solution search space (expert parameter, don't adapt unless you know what you're doing). Default=5.5}

\item{min_purity}{optional numerical parameter determining the minimum boundary of the purity solution search space (expert parameter, don't adapt unless you know what you're doing). Default=0.1}

\item{max_purity}{optional numerical parameter determining the maximum boundary of the purity solution search space (expert parameter, don't adapt unless you know what you're doing). Default=1.05}

\item{rho_manual}{optional argument to override ASCAT optimization and supply rho parameter (expert parameter, don't adapt unless you know what you're doing).}

\item{psi_manual}{optional argument to override ASCAT optimization and supply psi parameter (expert parameter, don't adapt unless you know what you're doing).}

\item{img.dir}{directory in which figures will be written}

\item{img.prefix}{prefix for figure names}

\item{write_segments}{Optional flag to output segments in text files (.segments_raw.txt and .segments.txt under img.dir). Default=F}
}
\value{
an ASCAT output object, containing:\cr
1. nA: copy number of the A allele\cr
2. nB: copy number of the B allele\cr
3. purity: the tumour purity of all arrays\cr
4. aberrantcellfraction: the aberrant cell fraction (=tumour purity) of all arrays\cr
5. ploidy: the ploidy of all arrays\cr
6. failedarrays: arrays on which ASCAT analysis failed\cr
7. nonaberrantarrays: arrays on which ASCAT analysis indicates that they show virtually no aberrations\cr
8. segments: an array containing the copy number segments of each sample (not including failed arrays)\cr
9. segments_raw: an array containing the copy number segments of each sample without any rounding applied\cr
10. distance_matrix: distances for a range of ploidy and tumor percentage values
}
\description{
ASCAT main function, calculating the allele-specific copy numbers
}
\details{
Note: for copy number only probes, nA contains the copy number value and nB = 0.
}
