# Summary

[Introduction](intro.md)

* [Meet Safe and Unsafe](meet-safe-and-unsafe.md)
  * [How Safe and Unsafe Interact](safe-unsafe-meaning.md)
  * [What Unsafe Can Do](what-unsafe-does.md)
  * [Working with Unsafe](working-with-unsafe.md)
* [Data Layout](data.md)
  * [repr(Rust)](repr-rust.md)
  * [Exotically Sized Types](exotic-sizes.md)
  * [Other reprs](other-reprs.md)
* [Ownership](ownership.md)
  * [References](references.md)
  * [Aliasing](aliasing.md)
  * [Lifetimes](lifetimes.md)
  * [Limits of Lifetimes](lifetime-mismatch.md)
  * [Lifetime Elision](lifetime-elision.md)
  * [Unbounded Lifetimes](unbounded-lifetimes.md)
  * [Higher-Rank Trait Bounds](hrtb.md)
  * [Subtyping and Variance](subtyping.md)
  * [Drop Check](dropck.md)
  * [PhantomData](phantom-data.md)
  * [Splitting Borrows](borrow-splitting.md)
* [Type Conversions](conversions.md)
  * [Coercions](coercions.md)
  * [The Dot Operator](dot-operator.md)
  * [Casts](casts.md)
  * [Transmutes](transmutes.md)
* [Uninitialized Memory](uninitialized.md)
  * [Checked](checked-uninit.md)
  * [Drop Flags](drop-flags.md)
  * [Unchecked](unchecked-uninit.md)
* [Ownership Based Resource Management](obrm.md)
  * [Constructors](constructors.md)
  * [Destructors](destructors.md)
  * [Leaking](leaking.md)
* [Unwinding](unwinding.md)
  * [Exception Safety](exception-safety.md)
  * [Poisoning](poisoning.md)
* [Concurrency](concurrency.md)
  * [Races](races.md)
  * [Send and Sync](send-and-sync.md)
  * [Atomics](atomics.md)
* [Implementing Vec](./vec/vec.md)
  * [Layout](./vec/vec-layout.md)
  * [Allocating](./vec/vec-alloc.md)
  * [Push and Pop](./vec/vec-push-pop.md)
  * [Deallocating](./vec/vec-dealloc.md)
  * [Deref](./vec/vec-deref.md)
  * [Insert and Remove](./vec/vec-insert-remove.md)
  * [IntoIter](./vec/vec-into-iter.md)
  * [RawVec](./vec/vec-raw.md)
  * [Drain](./vec/vec-drain.md)
  * [Handling Zero-Sized Types](./vec/vec-zsts.md)
  * [Final Code](./vec/vec-final.md)
* [Implementing Arc and Mutex](./arc-mutex/arc-and-mutex.md)
  * [Arc](./arc-mutex/arc.md)
    * [Layout](./arc-mutex/arc-layout.md)
    * [Base Code](./arc-mutex/arc-base.md)
    * [Cloning](./arc-mutex/arc-clone.md)
    * [Dropping](./arc-mutex/arc-drop.md)
    * [Final Code](./arc-mutex/arc-final.md)
* [FFI](ffi.md)
* [Beneath `std`](beneath-std.md)
  * [#[panic_handler]](panic-handler.md)
